/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import ghidra.app.nav.Navigatable;
import ghidra.app.util.viewer.field.AnnotatedStringHandler;
import ghidra.app.util.viewer.field.AnnotationException;
import ghidra.app.util.viewer.field.InvalidAnnotatedStringHandler;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.util.classfinder.ClassSearcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Annotation {
    private static final Pattern QUOTATION_PATTERN = Pattern.compile("(?<!\\\\)[\"](.*?)(?<!\\\\)[\"]");
    private static Map<String, AnnotatedStringHandler> ANNOTATED_STRING_MAP;
    private String annotationText;
    private String[] annotationParts;
    private AnnotatedStringHandler annotatedStringHandler;
    private AttributedString displayString;

    private static Map<String, AnnotatedStringHandler> getAnnotatedStringHandlerMap() {
        if (ANNOTATED_STRING_MAP == null) {
            ANNOTATED_STRING_MAP = Annotation.createAnnotatedStringHandlerMap();
        }
        return ANNOTATED_STRING_MAP;
    }

    private static Map<String, AnnotatedStringHandler> createAnnotatedStringHandlerMap() {
        HashMap<String, AnnotatedStringHandler> map = new HashMap<String, AnnotatedStringHandler>();
        Set instances = ClassSearcher.getInstances(AnnotatedStringHandler.class);
        for (AnnotatedStringHandler instance : instances) {
            String[] supportedAnnotations;
            for (String supportedAnnotation : supportedAnnotations = instance.getSupportedAnnotations()) {
                map.put(supportedAnnotation, instance);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public Annotation(String annotationText, AttributedString prototypeString, Program program) {
        this.annotationText = annotationText;
        this.annotationParts = this.parseAnnotationText(annotationText);
        this.annotatedStringHandler = this.getHandler(this.annotationParts);
        try {
            this.displayString = this.annotatedStringHandler.createAnnotatedString(prototypeString, this.annotationParts, program);
        }
        catch (AnnotationException ae) {
            this.annotatedStringHandler = new InvalidAnnotatedStringHandler("Annotation Exception: " + ae.getMessage());
            this.displayString = this.annotatedStringHandler.createAnnotatedString(prototypeString, this.annotationParts, program);
        }
    }

    private AnnotatedStringHandler getHandler(String[] annotationPieces) {
        if (annotationPieces.length <= 1) {
            return new InvalidAnnotatedStringHandler("Invalid annotation format. Expected at least two strings.");
        }
        String keyword = annotationPieces[0];
        AnnotatedStringHandler handler = Annotation.getAnnotatedStringHandlerMap().get(keyword);
        if (handler == null) {
            return new InvalidAnnotatedStringHandler("Invalid annotation keyword: " + keyword);
        }
        return handler;
    }

    String[] getAnnotationParts() {
        return this.annotationParts;
    }

    AnnotatedStringHandler getHandler() {
        return this.annotatedStringHandler;
    }

    public AttributedString getDisplayString() {
        return this.displayString;
    }

    public boolean handleMouseClick(Navigatable sourceNavigatable, ServiceProvider serviceProvider) {
        return this.annotatedStringHandler.handleMouseClick(this.annotationParts, sourceNavigatable, serviceProvider);
    }

    private String[] parseAnnotationText(String theAnnotationText) {
        StringBuffer buffer = new StringBuffer(theAnnotationText);
        buffer.delete(0, 2);
        buffer.deleteCharAt(buffer.length() - 1);
        int unqouotedOffset = 0;
        ArrayList<String> tokens = new ArrayList<String>();
        Matcher matcher = QUOTATION_PATTERN.matcher(buffer.toString());
        while (matcher.find()) {
            int quoteStart = matcher.start();
            String contentBeforeQuote = buffer.substring(unqouotedOffset, quoteStart);
            this.grabTokens(tokens, contentBeforeQuote);
            unqouotedOffset = matcher.end();
            String quotedContent = matcher.group(1);
            tokens.add(quotedContent);
        }
        if (unqouotedOffset < buffer.length()) {
            String remainingString = buffer.substring(unqouotedOffset);
            this.grabTokens(tokens, remainingString);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private void grabTokens(List<String> tokenContainer, String content) {
        String[] strings;
        for (String string : strings = content.split("\\s")) {
            if (string.length() <= 0) continue;
            tokenContainer.add(string);
        }
    }

    public String getAnnotationText() {
        return this.annotationText;
    }

    public static AnnotatedStringHandler[] getAnnotatedStringHandlers() {
        HashSet<AnnotatedStringHandler> annotations = new HashSet<AnnotatedStringHandler>(Annotation.getAnnotatedStringHandlerMap().values());
        AnnotatedStringHandler[] retVal = new AnnotatedStringHandler[annotations.size()];
        annotations.toArray(retVal);
        return retVal;
    }

    static Set<String> getAnnotationNames() {
        return Collections.unmodifiableSet(Annotation.getAnnotatedStringHandlerMap().keySet());
    }
}

