/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DyldCacheSlideInfo3
extends DyldCacheSlideInfoCommon {
    private int page_size;
    private int page_starts_count;
    private long auth_value_add;
    private short[] page_starts;

    public int getPageSize() {
        return this.page_size;
    }

    public int getPageStartsCount() {
        return this.page_starts_count;
    }

    public long getAuthValueAdd() {
        return this.auth_value_add;
    }

    public short[] getPageStarts() {
        return this.page_starts;
    }

    public DyldCacheSlideInfo3(BinaryReader reader) throws IOException {
        super(reader);
        this.page_size = reader.readNextInt();
        this.page_starts_count = reader.readNextInt();
        this.auth_value_add = reader.readNextLong();
        this.page_starts = reader.readNextShortArray(this.page_starts_count);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_slide_info3", 0);
        struct.add(DWORD, "version", "");
        struct.add(DWORD, "page_size", "");
        struct.add(DWORD, "page_starts_count", "");
        struct.add(QWORD, "auth_value_add", "");
        struct.add((DataType)new ArrayDataType(WORD, this.page_starts_count, 1), "page_starts", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

