/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DyldCacheSlideInfo1
extends DyldCacheSlideInfoCommon {
    private int toc_offset;
    private int toc_count;
    private int entries_offset;
    private int entries_count;
    private int entries_size;

    public int getTocOffset() {
        return this.toc_offset;
    }

    public int getTocCount() {
        return this.toc_count;
    }

    public int getEntriesOffset() {
        return this.entries_offset;
    }

    public int getEntriesCount() {
        return this.entries_count;
    }

    public int getEntriesSize() {
        return this.entries_size;
    }

    public DyldCacheSlideInfo1(BinaryReader reader) throws IOException {
        super(reader);
        this.toc_offset = reader.readNextInt();
        this.toc_count = reader.readNextInt();
        this.entries_offset = reader.readNextInt();
        this.entries_count = reader.readNextInt();
        this.entries_size = reader.readNextInt();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_slide_info", 0);
        struct.add(DWORD, "version", "");
        struct.add(DWORD, "toc_offset", "");
        struct.add(DWORD, "toc_count", "");
        struct.add(DWORD, "entries_offset", "");
        struct.add(DWORD, "entries_count", "");
        struct.add(DWORD, "entries_size", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

