/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff.archive;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.coff.archive.CoffArchiveMemberHeader;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class FirstLinkerMember
implements StructConverter {
    private int numberOfSymbols;
    private int[] offsets;
    private List<String> stringTable = new ArrayList<String>();
    private long _fileOffset;
    private List<Integer> stringLengths = new ArrayList<Integer>();

    public FirstLinkerMember(BinaryReader reader, CoffArchiveMemberHeader header, boolean skip) throws IOException {
        this._fileOffset = reader.getPointerIndex();
        boolean isLittleEndian = reader.isLittleEndian();
        reader.setLittleEndian(false);
        this.numberOfSymbols = this.readNumberOfSymbols(reader);
        if (skip) {
            reader.setPointerIndex(reader.getPointerIndex() + (long)(this.numberOfSymbols * 4));
        } else {
            this.offsets = reader.readNextIntArray(this.numberOfSymbols);
        }
        if (skip) {
            for (int i = 0; i < this.numberOfSymbols; ++i) {
                String string = reader.readNextAsciiString();
                this.stringLengths.add(string.length() + 1);
            }
        } else {
            this.stringTable = new ArrayList<String>(this.numberOfSymbols);
            for (int i = 0; i < this.numberOfSymbols; ++i) {
                String string = reader.readNextAsciiString();
                this.stringTable.add(string);
                this.stringLengths.add(string.length() + 1);
            }
        }
        reader.setLittleEndian(isLittleEndian);
        reader.setPointerIndex(this._fileOffset + header.getSize());
    }

    private int readNumberOfSymbols(BinaryReader reader) throws IOException {
        if (reader.isLittleEndian()) {
            BigEndianDataConverter dc = BigEndianDataConverter.INSTANCE;
            byte[] bytes = reader.readNextByteArray(4);
            return dc.getInt(bytes);
        }
        return reader.readNextInt();
    }

    public long getFileOffset() {
        return this._fileOffset;
    }

    public int getNumberOfSymbols() {
        return this.numberOfSymbols;
    }

    public int[] getOffsets() {
        if (this.offsets == null) {
            throw new RuntimeException("FirstLinkerMember::getOffsets() has been skipped.");
        }
        return this.offsets;
    }

    public List<String> getStringTable() {
        if (this.stringTable.isEmpty()) {
            throw new RuntimeException("FirstLinkerMember::getStringTable() has been skipped.");
        }
        return new ArrayList<String>(this.stringTable);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = StructConverterUtil.parseName(FirstLinkerMember.class);
        StructureDataType struct = new StructureDataType(name + "_" + this.numberOfSymbols, 0);
        struct.add(DWORD, "numberOfSymbols", null);
        struct.add((DataType)new ArrayDataType(DWORD, this.numberOfSymbols, DWORD.getLength()), "offsets", null);
        for (int i = 0; i < this.stringLengths.size(); ++i) {
            Integer length = this.stringLengths.get(i);
            struct.add(STRING, length.intValue(), "string[" + i + "]", null);
        }
        return struct;
    }
}

