/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.filechooser.GhidraFileChooserPanel;
import docking.widgets.label.GLabel;
import ghidra.app.script.GhidraState;
import ghidra.app.util.AddressInput;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GatherParamPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int STRING = 0;
    public static final int FILE = 1;
    public static final int DIRECTORY = 2;
    public static final int ADDRESS = 3;
    public static final int INTEGER = 4;
    public static final int LANGUAGE = 5;
    private GhidraState state;
    private HashMap<String, ParamComponent> parameters;
    private boolean shown;

    public GatherParamPanel(GhidraState state) {
        this.state = state;
        this.setLayout(new GridLayout(0, 2));
        this.parameters = new HashMap();
        this.shown = false;
    }

    public ParamComponent getParameter(String key) {
        return this.parameters.get(key);
    }

    public void clearParameters() {
        this.parameters.clear();
        this.removeAll();
    }

    public void addParameterRegardless(String key, String label, int type, Object defaultValue) {
        JComponent displayComponent = null;
        if (type == 1 || type == 2) {
            String titleString = null;
            titleString = type == 2 ? "SELECT DIRECTORY" : "SELECT FILE";
            GhidraFileChooserPanel panel = new GhidraFileChooserPanel(titleString, "Recipe.fileChooser", "", true, 0);
            if (type == 2) {
                panel.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
            }
            panel.setFileName(defaultValue.toString());
            this.parameters.put(key, new ParamComponent((Component)panel, type));
            displayComponent = panel;
        } else if (type == 3) {
            AddressInput addressInput = new AddressInput();
            if (this.state.getCurrentProgram() != null) {
                addressInput.setAddressFactory(this.state.getCurrentProgram().getAddressFactory());
            }
            addressInput.selectDefaultAddressSpace();
            addressInput.select();
            if (defaultValue != null) {
                addressInput.setValue(defaultValue.toString());
            }
            displayComponent = addressInput;
            this.parameters.put(key, new ParamComponent(displayComponent, type));
        } else {
            JTextField textField = new JTextField();
            if (defaultValue != null) {
                textField.setText(defaultValue.toString());
            }
            displayComponent = textField;
            this.parameters.put(key, new ParamComponent(displayComponent, type));
        }
        this.add((Component)new GLabel(label));
        this.add(displayComponent);
        this.shown = false;
    }

    public void addParameter(String key, String label, int type, Object defaultValue) {
        if (this.parameters.containsKey(key) || this.state.getEnvironmentVar(key) != null) {
            return;
        }
        this.addParameterRegardless(key, label, type, defaultValue);
    }

    public void setParamsInState() {
        block5: for (String string2 : this.parameters.keySet()) {
            String key = string2.toString();
            ParamComponent pc = this.parameters.get(key);
            switch (pc.getType()) {
                case 3: {
                    AddressInput addressInput;
                    if (this.state.getCurrentProgram() != null) {
                        addressInput = (AddressInput)pc.getDisplayComponent();
                        this.state.addEnvironmentVar(key, addressInput.getAddress());
                        continue block5;
                    }
                    addressInput = (AddressInput)pc.getDisplayComponent();
                    this.state.addEnvironmentVar(key, addressInput.getValue().toString());
                    continue block5;
                }
                case 1: 
                case 2: {
                    GhidraFileChooserPanel gfcp = (GhidraFileChooserPanel)pc.getDisplayComponent();
                    this.state.addEnvironmentVar(key, new File(gfcp.getFileName()));
                    continue block5;
                }
                case 4: {
                    JTextField iTextField = (JTextField)pc.getDisplayComponent();
                    int val = Integer.parseInt(iTextField.getText());
                    this.state.addEnvironmentVar(key, val);
                    continue block5;
                }
            }
            JTextField textField = (JTextField)pc.getDisplayComponent();
            this.state.addEnvironmentVar(key, textField.getText());
        }
    }

    public void currentProgramChanged() {
        for (String string2 : this.parameters.keySet()) {
            String key = string2.toString();
            ParamComponent pc = this.parameters.get(key);
            switch (pc.getType()) {
                case 3: {
                    AddressInput addressInput = (AddressInput)pc.getDisplayComponent();
                    addressInput.setAddressFactory(this.state.getCurrentProgram().getAddressFactory());
                    addressInput.selectDefaultAddressSpace();
                    addressInput.select();
                    if (!this.panelShown()) break;
                    this.state.addEnvironmentVar(key, addressInput.getAddress());
                }
            }
        }
    }

    public boolean panelShown() {
        return this.shown;
    }

    public void setShown(boolean shown) {
        this.shown = shown;
    }

    public class ParamComponent {
        private int type;
        private Component displayComponent;

        public ParamComponent(Component displayComponent, int type) {
            this.displayComponent = displayComponent;
            this.type = type;
        }

        public Component getDisplayComponent() {
            return this.displayComponent;
        }

        public int getType() {
            return this.type;
        }
    }
}

