/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.tree;

import docking.widgets.checkbox.GCheckBox;
import ghidra.app.merge.ProgramMultiUserMergeManager;
import ghidra.app.merge.tree.NameConflictsPanel;
import ghidra.app.merge.tree.NamePanel;
import ghidra.app.merge.tree.TreeChangePanel;
import ghidra.app.merge.util.ConflictCountPanel;
import ghidra.program.model.listing.Program;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ProgramTreeMergePanel
extends JPanel {
    private TreeChangePanel panelOne;
    private TreeChangePanel panelTwo;
    private CardLayout cardLayout;
    private JPanel conflictPanel;
    private NamePanel namePanel;
    private NameConflictsPanel conflictsPanel;
    private ConflictCountPanel countPanel;
    private JPanel currentPanel;
    private int totalConflicts;
    private ProgramMultiUserMergeManager mergeManager;
    private static final String USE_FOR_ALL_CHECKBOX = "UseForAllConflictCheckBox";
    private JCheckBox useForAllCB;
    static final String KEEP_OTHER_BUTTON_NAME = "Latest";
    static final String KEEP_PRIVATE_BUTTON_NAME = "Checked Out";
    static final String ADD_NEW_BUTTON_NAME = "Add New";
    static final String RENAME_PRIVATE_BUTTON_NAME = "Rename My";
    static final String ORIGINAL_BUTTON_NAME = "Original";

    ProgramTreeMergePanel(ProgramMultiUserMergeManager mergeManager, int totalConflicts) {
        this.mergeManager = mergeManager;
        this.totalConflicts = totalConflicts;
        this.create();
    }

    void setConflictInfo(String panelID, int conflictIndex, Program resultProgram, String name1, String name2, String origName, boolean name1Changed, boolean structure1Changed, boolean name2Changed, boolean structure2Changed) {
        this.mergeManager.clearStatusText();
        this.mergeManager.setApplyEnabled(true);
        this.panelOne.setStates(name1, name1Changed, structure1Changed);
        this.panelTwo.setStates(name2, name2Changed, structure2Changed);
        this.setUseForAll(false);
        this.cardLayout.show(this.conflictPanel, panelID);
        if (panelID == "Name Panel") {
            this.currentPanel = this.namePanel;
            this.namePanel.setNames(name1, name2, origName);
        } else {
            this.currentPanel = this.conflictsPanel;
            this.conflictsPanel.setNames(resultProgram, name1, name2, origName, !structure1Changed && !structure2Changed);
        }
        this.countPanel.updateCount(conflictIndex, this.totalConflicts);
    }

    int getSelectedOption() {
        if (this.currentPanel == this.namePanel) {
            return this.namePanel.getSelectedOption();
        }
        return this.conflictsPanel.getSelectedOption();
    }

    private void create() {
        this.countPanel = new ConflictCountPanel();
        this.panelOne = new TreeChangePanel("Latest Version");
        this.panelTwo = new TreeChangePanel("Current Checked Out Version");
        this.conflictPanel = this.createConflictPanel();
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BoxLayout(treePanel, 0));
        treePanel.add(this.panelOne);
        treePanel.add(Box.createHorizontalStrut(10));
        treePanel.add(this.panelTwo);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.countPanel);
        this.add(Box.createVerticalStrut(10));
        this.add(treePanel);
        this.add(Box.createVerticalStrut(10));
        this.add(this.conflictPanel);
        this.add(Box.createVerticalStrut(5));
        JPanel useForAllPanel = new JPanel();
        useForAllPanel.add(this.createUseForAllCheckBox());
        this.add(useForAllPanel);
    }

    private JPanel createConflictPanel() {
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ProgramTreeMergePanel.this.mergeManager.clearStatusText();
                ProgramTreeMergePanel.this.mergeManager.setApplyEnabled(true);
            }
        };
        this.cardLayout = new CardLayout();
        JPanel panel = new JPanel(this.cardLayout);
        this.namePanel = new NamePanel(changeListener);
        this.conflictsPanel = new NameConflictsPanel(changeListener);
        panel.add((Component)this.namePanel, "Name Panel");
        panel.add((Component)this.conflictsPanel, "Name/Content Conflicts Panel");
        Dimension d = panel.getPreferredSize();
        panel.setPreferredSize(new Dimension(400, d.height));
        return panel;
    }

    private JCheckBox createUseForAllCheckBox() {
        this.useForAllCB = new GCheckBox(this.getUseAllString(""));
        this.useForAllCB.setName(USE_FOR_ALL_CHECKBOX);
        return this.useForAllCB;
    }

    private String getUseAllString(String conflictDescription) {
        return "Use the selected option for resolving all remaining 'Program Tree' conflicts" + conflictDescription + ".";
    }

    void setConflictDetails(String conflictDescription) {
        this.useForAllCB.setText(this.getUseAllString(conflictDescription));
    }

    void setUseForAll(boolean useForAll) {
        this.useForAllCB.setSelected(useForAll);
    }

    boolean getUseForAll() {
        return this.useForAllCB.isSelected();
    }
}

