/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Buffer;
import db.Field;
import ghidra.util.exception.AssertException;
import java.io.IOException;

public class LongField
extends Field {
    private long value;

    public LongField() {
    }

    public LongField(long l) {
        this.value = l;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    @Override
    public void setLongValue(long value) {
        this.value = value;
    }

    @Override
    int length() {
        return 8;
    }

    @Override
    int write(Buffer buf, int offset) throws IOException {
        return buf.putLong(offset, this.value);
    }

    @Override
    int read(Buffer buf, int offset) throws IOException {
        this.value = buf.getLong(offset);
        return offset + 8;
    }

    @Override
    int readLength(Buffer buf, int offset) throws IOException {
        return 8;
    }

    @Override
    protected byte getFieldType() {
        return 3;
    }

    public String toString() {
        return "LongField: " + Long.toString(this.value);
    }

    @Override
    public String getValueAsString() {
        return Long.toHexString(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LongField)) {
            return false;
        }
        return ((LongField)obj).value == this.value;
    }

    @Override
    public int compareTo(Field o) {
        LongField f = (LongField)o;
        if (this.value == f.value) {
            return 0;
        }
        if (this.value < f.value) {
            return -1;
        }
        return 1;
    }

    @Override
    public Field newField(Field fieldValue) {
        if (fieldValue.isVariableLength()) {
            throw new AssertException();
        }
        return new LongField(fieldValue.getLongValue());
    }

    @Override
    public Field newField() {
        return new LongField();
    }

    @Override
    public byte[] getBinaryData() {
        return new byte[]{(byte)(this.value >> 56), (byte)(this.value >> 48), (byte)(this.value >> 40), (byte)(this.value >> 32), (byte)(this.value >> 24), (byte)(this.value >> 16), (byte)(this.value >> 8), (byte)this.value};
    }

    @Override
    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }
}

