/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Buffer;
import db.Field;
import ghidra.util.exception.AssertException;
import java.io.IOException;

public class BooleanField
extends Field {
    private byte value;

    public BooleanField() {
    }

    public BooleanField(boolean b) {
        this.value = b ? (byte)1 : 0;
    }

    @Override
    public boolean getBooleanValue() {
        return this.value != 0;
    }

    @Override
    public void setBooleanValue(boolean b) {
        this.value = b ? (byte)1 : 0;
    }

    @Override
    int length() {
        return 1;
    }

    @Override
    int write(Buffer buf, int offset) throws IOException {
        return buf.putByte(offset, this.value);
    }

    @Override
    int read(Buffer buf, int offset) throws IOException {
        this.value = buf.getByte(offset);
        return offset + 1;
    }

    @Override
    int readLength(Buffer buf, int offset) throws IOException {
        return 1;
    }

    @Override
    protected byte getFieldType() {
        return 6;
    }

    public String toString() {
        return "BooleanField: " + Boolean.toString(this.getBooleanValue());
    }

    @Override
    public String getValueAsString() {
        return Boolean.toString(this.getBooleanValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BooleanField)) {
            return false;
        }
        BooleanField otherField = (BooleanField)obj;
        return otherField.value == this.value;
    }

    @Override
    public int compareTo(Field o) {
        BooleanField f = (BooleanField)o;
        if (this.value == f.value) {
            return 0;
        }
        if (this.value < f.value) {
            return -1;
        }
        return 1;
    }

    @Override
    public Field newField(Field fieldValue) {
        if (fieldValue.isVariableLength()) {
            throw new AssertException();
        }
        return new BooleanField(fieldValue.getLongValue() != 0L);
    }

    @Override
    public Field newField() {
        return new BooleanField();
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    @Override
    public byte[] getBinaryData() {
        return new byte[]{this.value};
    }

    @Override
    public int hashCode() {
        return this.value;
    }
}

