/*
 * Decompiled with CFR 0.152.
 */
package help.validator;

import ghidra.util.exception.AssertException;
import help.HelpBuildUtils;
import help.validator.AnchorManager;
import help.validator.TagProcessor;
import help.validator.location.HelpModuleLocation;
import help.validator.model.HREF;
import help.validator.model.IMG;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class ReferenceTagProcessor
extends TagProcessor {
    private static final String EOL = System.getProperty("line.separator");
    private static final String STYLESHEET_FILENAME = "Frontpage.css";
    private static final String STYLESHEET_PATHNAME = "shared/Frontpage.css";
    private Path htmlFile;
    private Set<Path> styleSheets = new HashSet<Path>();
    private String title;
    private boolean readingTitle = false;
    private final StringBuffer errors = new StringBuffer();
    private final Path defaultStyleSheet;
    private final AnchorManager anchorManager;
    private final HelpModuleLocation help;
    private int errorCount;

    public ReferenceTagProcessor(HelpModuleLocation help, AnchorManager anchorManager) {
        this.help = help;
        this.anchorManager = anchorManager;
        Path helpPath = help.getHelpLocation();
        FileSystem fs = helpPath.getFileSystem();
        Path relativeSSPath = fs.getPath(STYLESHEET_PATHNAME, new String[0]);
        this.defaultStyleSheet = helpPath.resolve(relativeSSPath);
        if (Files.notExists(helpPath, new LinkOption[0])) {
            throw new AssertException("Cannot find expected stylesheet: " + this.defaultStyleSheet);
        }
    }

    @Override
    public boolean isTagSupported(String tagType) {
        if (tagType == null) {
            return false;
        }
        return "a".equals(tagType = tagType.toLowerCase()) || "img".equals(tagType) || "title".equals(tagType) || "/title".equals(tagType) || "link".equals(tagType);
    }

    @Override
    public void processTag(String tagType, LinkedHashMap<String, String> tagAttributes, Path file, int lineNum) throws IOException {
        if ("a".equals(tagType = tagType.toLowerCase())) {
            if (tagAttributes.containsKey("href")) {
                try {
                    this.anchorManager.addAnchorRef(new HREF(this.help, file, tagAttributes.get("href"), lineNum));
                }
                catch (URISyntaxException e) {
                    ++this.errorCount;
                    this.errors.append("Malformed Anchor Tag at (line " + lineNum + "): " + this.htmlFile + EOL);
                }
            } else if (tagAttributes.containsKey("name")) {
                this.anchorManager.addAnchor(file, tagAttributes.get("name"), lineNum);
            } else {
                ++this.errorCount;
                this.errors.append("Bad Anchor Tag - unexpected attribtute (line " + lineNum + "): " + this.htmlFile + EOL);
            }
        } else if ("img".equals(tagType)) {
            if (tagAttributes.containsKey("src")) {
                try {
                    this.anchorManager.addImageRef(new IMG(this.help, file, tagAttributes.get("src"), lineNum));
                }
                catch (URISyntaxException e) {
                    ++this.errorCount;
                    this.errors.append("Malformed IMG Tag at (line " + lineNum + "): " + this.htmlFile + EOL);
                }
            } else {
                ++this.errorCount;
                this.errors.append("Bad IMG Tag - unexpected attribtute (line " + lineNum + "): " + this.htmlFile + EOL);
            }
        } else if ("link".equals(tagType)) {
            String href;
            String rel = tagAttributes.get("rel");
            if (rel != null && "stylesheet".equals(rel.toLowerCase()) && (href = tagAttributes.get("href")) != null) {
                Path css = HelpBuildUtils.getFile(this.htmlFile, href);
                css = css.normalize();
                this.styleSheets.add(css);
            }
        } else if ("title".equals(tagType)) {
            this.readingTitle = true;
        } else if ("/title".equals(tagType)) {
            this.readingTitle = false;
        }
    }

    @Override
    public String processText(String text) {
        if (this.readingTitle && (text = text.trim()).length() != 0) {
            this.title = this.title == null ? text : this.title + " " + text;
        }
        return text;
    }

    @Override
    public void startOfFile(Path localFile) {
        this.htmlFile = localFile;
        this.title = null;
        this.styleSheets.clear();
    }

    @Override
    public void endOfFile() {
        if (this.title == null) {
            ++this.errorCount;
            this.errors.append("Missing TITLE in: " + this.htmlFile + EOL);
        }
        if (this.styleSheets.isEmpty()) {
            ++this.errorCount;
            this.errors.append("Missing Stylesheet in: " + this.htmlFile + EOL);
        }
        boolean hasDefaultStyleSheet = false;
        for (Path ss : this.styleSheets) {
            if (!this.defaultStyleSheet.equals(ss)) continue;
            hasDefaultStyleSheet = true;
            break;
        }
        if (!hasDefaultStyleSheet) {
            ++this.errorCount;
            this.errors.append("Incorrect stylesheet defined - none match " + this.defaultStyleSheet + " in file " + this.htmlFile + EOL);
        }
    }

    public String getErrorText() {
        return this.errors.toString();
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }
}

