/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.filterrows;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.filterrows.FilterRowsData;
import org.pentaho.di.trans.steps.filterrows.FilterRowsMeta;
import org.pentaho.di.trans.steps.filterrows.Messages;

public class FilterRows
extends BaseStep
implements StepInterface {
    private FilterRowsMeta meta;
    private FilterRowsData data;

    public FilterRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized boolean keepRow(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        try {
            return this.meta.getCondition().evaluate(rowMeta, row);
        }
        catch (Exception e) {
            String message = Messages.getString("FilterRows.Exception.UnexpectedErrorFoundInEvaluationFuction");
            this.logError(message);
            this.logError(Messages.getString("FilterRows.Log.ErrorOccurredForRow") + rowMeta.getString(row));
            this.logError(Const.getStackTracker((Throwable)e));
            throw new KettleException(message, (Throwable)e);
        }
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (FilterRowsMeta)smi;
        this.data = (FilterRowsData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.getInputRowMeta(), this.getStepname(), null, null, this);
            if (this.data.chosesTargetSteps) {
                this.data.trueRowSet = this.findOutputRowSet(this.getStepname(), this.getCopy(), this.meta.getSendTrueStepname(), 0);
                if (this.data.trueRowSet == null) {
                    throw new KettleException(Messages.getString("FilterRows.Log.TargetStepInvalid", this.meta.getSendTrueStepname()));
                }
                this.data.falseRowSet = this.findOutputRowSet(this.getStepname(), this.getCopy(), this.meta.getSendFalseStepname(), 0);
                if (this.data.falseRowSet == null) {
                    throw new KettleException(Messages.getString("FilterRows.Log.TargetStepInvalid", this.meta.getSendFalseStepname()));
                }
            }
        }
        boolean keep = this.keepRow(this.getInputRowMeta(), r);
        if (!this.data.chosesTargetSteps) {
            if (keep) {
                this.putRow(this.data.outputRowMeta, r);
            }
        } else if (keep) {
            if (this.log.isRowLevel()) {
                this.logRowlevel("Sending row to true  :" + this.meta.getSendTrueStepname() + " : " + this.getInputRowMeta().getString(r));
            }
            this.putRowTo(this.data.outputRowMeta, r, this.data.trueRowSet);
        } else {
            if (this.log.isRowLevel()) {
                this.logRowlevel("Sending row to false :" + this.meta.getSendFalseStepname() + " : " + this.getInputRowMeta().getString(r));
            }
            this.putRowTo(this.data.outputRowMeta, r, this.data.falseRowSet);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(Messages.getString("FilterRows.Log.LineNumber") + this.getLinesRead());
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (FilterRowsMeta)smi;
        this.data = (FilterRowsData)sdi;
        if (super.init(smi, sdi)) {
            if (this.meta.getSendTrueStepname() != null ^ this.meta.getSendFalseStepname() != null) {
                this.logError(Messages.getString("FilterRows.Log.BothTrueAndFalseNeeded"));
            } else {
                this.data.chosesTargetSteps = this.meta.getSendTrueStepname() != null && this.meta.getSendFalseStepname() != null;
                return true;
            }
        }
        return false;
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

