/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class MegastekProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_GPRMC = new PatternBuilder().text("$GPRMC,").number("(dd)(dd)(dd).(ddd),").expression("([AV]),").number("(d+)(dd.d+),([NS]),").number("(d+)(dd.d+),([EW]),").number("(d+.d+)?,").number("(d+.d+)?,").number("(dd)(dd)(dd)").any().compile();
    private static final Pattern PATTERN_SIMPLE = new PatternBuilder().expression("[FL],").expression("([^,]*),").number("imei:(d+),").number("(d+/?d*)?,").number("(d+.d+)?,").number("Battery=(d+)%,,?").number("(d)?,").number("(d+)?,").number("(d+)?,").number("(xxxx),").number("(xxxx);").any().compile();
    private static final Pattern PATTERN_ALTERNATIVE = new PatternBuilder().number("(d+),").number("(d+),").number("(xxxx),").number("(xxxx),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(?:(d+),)?").number("(d.?d*),").groupBegin().number("(d.dd),").number("(d.dd),").groupEnd("?").expression("([^;]+);").any().compile();
    private static final Pattern PATTERN_NEW = new PatternBuilder().number("dddd").optional().text("$MGV").number("ddd,").number("(d+),").expression("[^,]*,").expression("([RS]),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").expression("([AV]),").number("(d+)(dd.d+),([NS]),").number("(d+)(dd.d+),([EW]),").number("dd,").number("(dd),").number("dd,").number("(d+.d+)?,").number("(d+.d+)?,").number("(d+.d+)?,").number("(-?d+.d+)?,").number("(d+.d+)?,").number("(d+)?,").number("(d+)?,").number("(xxxx)?,").number("(x+)?,").number("(d+)?,").groupBegin().number("([01]{4})?,").number("([01]{4})?,").number("(d+)?,").number("(d+)?,").number("(d+)?,").or().number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").groupEnd().groupBegin().number("(-?d+.?d*)").or().text(" ").groupEnd("?").text(",").groupBegin().number("(-?d+.?d*)").or().text(" ").groupEnd("?").text(",").number("(d+)?,").number("([01])(d)?").optional().expression("[^,]*,").number("(d+)?,").expression("([^,]*)[,;]").any().compile();

    public MegastekProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private boolean parseLocation(String location, Position position) {
        Parser parser = new Parser(PATTERN_GPRMC, location);
        if (!parser.matches()) {
            return false;
        }
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setTime(dateBuilder.getDate());
        return true;
    }

    private Position decodeOld(Channel channel, SocketAddress remoteAddress, String sentence) {
        String status;
        String location;
        String id;
        int endIndex;
        int beginIndex;
        boolean simple;
        boolean bl = simple = sentence.charAt(3) == ',' || sentence.charAt(6) == ',';
        if (simple) {
            beginIndex = sentence.indexOf(44) + 1;
            endIndex = sentence.indexOf(44, beginIndex);
            id = sentence.substring(beginIndex, endIndex);
            beginIndex = endIndex + 1;
            endIndex = (endIndex = sentence.indexOf(42, beginIndex)) != -1 ? (endIndex += 3) : sentence.length();
            location = sentence.substring(beginIndex, endIndex);
            beginIndex = endIndex + 1;
            if (beginIndex > sentence.length()) {
                beginIndex = endIndex;
            }
            status = sentence.substring(beginIndex);
        } else {
            beginIndex = 3;
            endIndex = beginIndex + 16;
            id = sentence.substring(beginIndex, endIndex).trim();
            beginIndex = endIndex + 2;
            if ((endIndex = sentence.indexOf(42, beginIndex) + 3) < 0) {
                return null;
            }
            location = sentence.substring(beginIndex, endIndex);
            beginIndex = endIndex + 1;
            status = sentence.substring(beginIndex);
        }
        Position position = new Position(this.getProtocolName());
        if (!this.parseLocation(location, position)) {
            return null;
        }
        if (simple) {
            Parser parser = new Parser(PATTERN_SIMPLE, status);
            if (parser.matches()) {
                position.set("alarm", this.decodeAlarm(parser.next()));
                DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next(), id);
                if (deviceSession == null) {
                    return null;
                }
                position.setDeviceId(deviceSession.getDeviceId());
                String sat = parser.next();
                if (sat.contains("/")) {
                    position.set("sat", Integer.parseInt(sat.split("/")[0]));
                    position.set("satVisible", Integer.parseInt(sat.split("/")[1]));
                } else {
                    position.set("sat", Integer.parseInt(sat));
                }
                position.setAltitude(parser.nextDouble(0.0));
                position.set("batteryLevel", parser.nextDouble(0.0));
                String charger = parser.next();
                if (charger != null) {
                    position.set("charge", Integer.parseInt(charger) == 1);
                }
                if (parser.hasNext(4)) {
                    position.setNetwork(new Network(CellTower.from(parser.nextInt(0), parser.nextInt(0), parser.nextHexInt(0), parser.nextHexInt(0))));
                }
            } else {
                DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
                if (deviceSession == null) {
                    return null;
                }
                position.setDeviceId(deviceSession.getDeviceId());
            }
        } else {
            Parser parser = new Parser(PATTERN_ALTERNATIVE, status);
            if (parser.matches()) {
                DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
                if (deviceSession == null) {
                    return null;
                }
                position.setDeviceId(deviceSession.getDeviceId());
                position.setNetwork(new Network(CellTower.from(parser.nextInt(0), parser.nextInt(0), parser.nextHexInt(0), parser.nextHexInt(0), parser.nextInt(0))));
                position.set("batteryLevel", parser.nextDouble());
                position.set("flags", parser.next());
                position.set("input", parser.next());
                position.set("output", parser.next());
                position.set("adc1", parser.next());
                position.set("adc2", parser.next());
                position.set("adc3", parser.next());
                position.set("alarm", this.decodeAlarm(parser.next()));
            }
        }
        return position;
    }

    private Position decodeNew(Channel channel, SocketAddress remoteAddress, String sentence) {
        String battery;
        int i;
        Parser parser = new Parser(PATTERN_NEW, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        if (parser.next().equals("S")) {
            position.set("archive", true);
        }
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.set("sat", parser.nextInt(0));
        position.set("hdop", parser.nextDouble(0.0));
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        position.setAltitude(parser.nextDouble(0.0));
        if (parser.hasNext()) {
            position.set("odometer", parser.nextDouble(0.0) * 1000.0);
        }
        if (parser.hasNext(5)) {
            int mcc = parser.nextInt();
            int mnc = parser.nextInt();
            Integer lac = parser.nextHexInt();
            Integer cid = parser.nextHexInt();
            Integer rssi = parser.nextInt();
            if (lac != null && cid != null) {
                CellTower tower = CellTower.from(mcc, mnc, lac, cid.intValue());
                if (rssi != null) {
                    tower.setSignalStrength(rssi);
                }
                position.setNetwork(new Network(tower));
            }
        }
        if (parser.hasNext(5)) {
            position.set("input", parser.nextBinInt(0));
            position.set("output", parser.nextBinInt(0));
            for (i = 1; i <= 3; ++i) {
                position.set("adc" + i, parser.nextInt(0));
            }
        }
        if (parser.hasNext(5)) {
            position.set("heartRate", parser.nextInt());
            position.set("steps", parser.nextInt());
            position.set("activityTime", parser.nextInt());
            position.set("lightSleepTime", parser.nextInt());
            position.set("deepSleepTime", parser.nextInt());
        }
        for (i = 1; i <= 2; ++i) {
            String adc = parser.next();
            if (adc == null) continue;
            position.set("temp" + i, Double.parseDouble(adc));
        }
        position.set("driverUniqueId", parser.next());
        if (parser.hasNext()) {
            position.set("charge", parser.nextInt() > 0);
        }
        if (parser.hasNext()) {
            position.set("belt", parser.nextInt());
        }
        if ((battery = parser.next()) != null) {
            position.set("battery", Integer.parseInt(battery));
        }
        position.set("alarm", this.decodeAlarm(parser.next()));
        return position;
    }

    private String decodeAlarm(String value) {
        if ((value = value.toLowerCase()).startsWith("geo")) {
            if (value.endsWith("in")) {
                return "geofenceEnter";
            }
            if (value.endsWith("out")) {
                return "geofenceExit";
            }
        }
        switch (value) {
            case "pw on": 
            case "poweron": {
                return "powerOn";
            }
            case "poweroff": {
                return "powerOff";
            }
            case "sos": 
            case "help": {
                return "sos";
            }
            case "over speed": 
            case "overspeed": {
                return "overspeed";
            }
            case "lowspeed": {
                return "lowspeed";
            }
            case "low battery": 
            case "lowbattery": {
                return "lowBattery";
            }
            case "low extern voltage": {
                return "lowPower";
            }
            case "gps cut": {
                return "gpsAntennaCut";
            }
            case "vib": {
                return "vibration";
            }
            case "move in": {
                return "geofenceEnter";
            }
            case "move out": {
                return "geofenceExit";
            }
            case "corner": {
                return "hardCornering";
            }
            case "fatigue": {
                return "fatigueDriving";
            }
            case "psd": {
                return "powerCut";
            }
            case "psr": {
                return "powerRestored";
            }
            case "hit": {
                return "vibration";
            }
            case "belt on": 
            case "belton": {
                return "lock";
            }
            case "belt off": 
            case "beltoff": {
                return "unlock";
            }
            case "error": {
                return "fault";
            }
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.contains("$MG")) {
            return this.decodeNew(channel, remoteAddress, sentence);
        }
        return this.decodeOld(channel, remoteAddress, sentence);
    }
}

