/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class LaipacProtocolDecoder
extends BaseProtocolDecoder {
    public static final String DEFAULT_DEVICE_PASSWORD = "00000000";
    private static final Pattern PATTERN_EAVSYS = new PatternBuilder().text("$EAVSYS,").expression("([^,]+),").expression("([0-9]+),").expression("(\\+?[0-9]+)?,").expression("(?:[^,]*),").expression("([^,]*)?").text("*").number("(xx)").compile();
    private static final Pattern PATTERN_AVRMC = new PatternBuilder().text("$AVRMC,").expression("([^,]+),").number("(dd)(dd)(dd),").expression("([AVRPavrp]),").number("(dd)(dd.d+),").expression("([NS]),").number("(ddd)(dd.d+),").number("([EW]),").number("(d+.d+),").number("(d+.d+),").number("(dd)(dd)(dd),").expression("([0-9A-Za-z]),").expression("([\\d.]+),").number("(d+),").number("(d),").number("(d+),").number("(d+)").number(",(xxxx|x)").number("(xxxx),").number("(ddd|d)").number("(ddd)").optional(4).expression(",([^*]*)").optional(1).text("*").number("(xx)").compile();

    public LaipacProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(String event) {
        switch (event) {
            case "Z": {
                return "lowBattery";
            }
            case "Y": {
                return "tow";
            }
            case "X": {
                return "geofenceEnter";
            }
            case "T": {
                return "tampering";
            }
            case "H": {
                return "powerOff";
            }
            case "8": {
                return "vibration";
            }
            case "7": 
            case "4": {
                return "geofenceExit";
            }
            case "6": {
                return "overspeed";
            }
            case "5": {
                return "powerCut";
            }
            case "3": {
                return "sos";
            }
        }
        return null;
    }

    private String decodeEvent(String event, Position position) {
        char inputStatus;
        if (event.length() == 1 && (inputStatus = event.charAt(0)) >= 'A' && inputStatus <= 'D') {
            int inputStatusInt = inputStatus - 65;
            position.set("in1", inputStatusInt & 1);
            position.set("in2", inputStatusInt & 2);
            return null;
        }
        return event;
    }

    private void sendEventResponse(String event, String devicePassword, Channel channel, SocketAddress remoteAddress) {
        String responseCode = null;
        switch (event) {
            case "3": {
                responseCode = "d";
                break;
            }
            case "S": 
            case "T": {
                responseCode = "t";
                break;
            }
            case "X": 
            case "4": {
                responseCode = "x";
                break;
            }
            case "Y": {
                responseCode = "y";
                break;
            }
            case "Z": {
                responseCode = "z";
                break;
            }
        }
        if (responseCode != null) {
            String response = "$AVCFG," + devicePassword + "," + responseCode;
            response = response + Checksum.nmea(response.substring(1)) + "\r\n";
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private void sendAcknowledge(String status, String event, String checksum, Channel channel, SocketAddress remoteAddress) {
        if (Character.isLowerCase(status.charAt(0))) {
            String response = "$EAVACK," + event + "," + checksum;
            response = response + Checksum.nmea(response.substring(1)) + "\r\n";
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    protected Object decodeEavsys(String sentence, Channel channel, SocketAddress remoteAddress) {
        Parser parser = new Parser(PATTERN_EAVSYS, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        position.set("iccid", parser.next());
        position.set("phone", parser.next());
        position.set("versionFw", parser.next());
        return position;
    }

    protected Object decodeAvrmc(String sentence, Channel channel, SocketAddress remoteAddress) {
        Parser parser = new Parser(PATTERN_AVRMC, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        String status = parser.next();
        String upperCaseStatus = status.toUpperCase();
        position.setValid(upperCaseStatus.equals("A") || upperCaseStatus.equals("R") || upperCaseStatus.equals("P"));
        position.set("status", status);
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setTime(dateBuilder.getDate());
        String event = parser.next();
        position.set("alarm", this.decodeAlarm(event));
        position.set("event", this.decodeEvent(event, position));
        position.set("battery", Double.parseDouble(parser.next().replaceAll("\\.", "")) * 0.001);
        position.set("odometer", parser.nextDouble() * 1000.0);
        position.set("gps", parser.nextInt());
        position.set("adc1", parser.nextDouble() * 0.001);
        position.set("adc2", parser.nextDouble() * 0.001);
        Integer lac = parser.nextHexInt();
        Integer cid = parser.nextHexInt();
        Integer mcc = parser.nextInt();
        Integer mnc = parser.nextInt();
        if (lac != null && cid != null && mcc != null && mnc != null) {
            position.setNetwork(new Network(CellTower.from(mcc, mnc, lac, cid.intValue())));
        }
        parser.next();
        String checksum = parser.next();
        if (channel != null) {
            this.sendAcknowledge(status, event, checksum, channel, remoteAddress);
            String devicePassword = Context.getIdentityManager().getDevicePassword(deviceSession.getDeviceId(), this.getProtocolName(), DEFAULT_DEVICE_PASSWORD);
            this.sendEventResponse(event, devicePassword, channel, remoteAddress);
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.startsWith("$ECHK")) {
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(sentence + "\r\n", remoteAddress));
            }
        } else {
            if (sentence.startsWith("$EAVSYS")) {
                return this.decodeEavsys(sentence, channel, remoteAddress);
            }
            if (sentence.startsWith("$AVRMC")) {
                return this.decodeAvrmc(sentence, channel, remoteAddress);
            }
        }
        return null;
    }
}

