/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.config.Keys;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.NotificationFormatter;
import org.traccar.notification.NotificationMessage;
import org.traccar.notificators.Notificator;

public class NotificatorTelegram
extends Notificator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificatorTelegram.class);
    private final String urlSendText = String.format("https://api.telegram.org/bot%s/sendMessage", Context.getConfig().getString(Keys.NOTIFICATOR_TELEGRAM_KEY));
    private final String urlSendLocation = String.format("https://api.telegram.org/bot%s/sendLocation", Context.getConfig().getString(Keys.NOTIFICATOR_TELEGRAM_KEY));
    private final String chatId = Context.getConfig().getString(Keys.NOTIFICATOR_TELEGRAM_CHAT_ID);
    private final boolean sendLocation = Context.getConfig().getBoolean(Keys.NOTIFICATOR_TELEGRAM_SEND_LOCATION);

    private void executeRequest(String url, Object message) {
        Context.getClient().target(url).request().async().post(Entity.json((Object)message), (InvocationCallback)new InvocationCallback<Object>(){

            public void completed(Object o) {
            }

            public void failed(Throwable throwable) {
                LOGGER.warn("Telegram API error", throwable);
            }
        });
    }

    private LocationMessage createLocationMessage(String messageChatId, Position position) {
        LocationMessage locationMessage = new LocationMessage();
        locationMessage.chatId = messageChatId;
        locationMessage.latitude = position.getLatitude();
        locationMessage.longitude = position.getLongitude();
        locationMessage.bearing = (int)Math.ceil(position.getCourse());
        locationMessage.accuracy = position.getAccuracy();
        return locationMessage;
    }

    @Override
    public void sendSync(long userId, Event event, Position position) {
        User user = Context.getPermissionsManager().getUser(userId);
        NotificationMessage shortMessage = NotificationFormatter.formatMessage(userId, event, position, "short");
        TextMessage message = new TextMessage();
        message.chatId = user.getString("telegramChatId");
        if (message.chatId == null) {
            message.chatId = this.chatId;
        }
        message.text = shortMessage.getBody();
        this.executeRequest(this.urlSendText, message);
        if (this.sendLocation && position != null) {
            this.executeRequest(this.urlSendLocation, this.createLocationMessage(message.chatId, position));
        }
    }

    @Override
    public void sendAsync(long userId, Event event, Position position) {
        this.sendSync(userId, event, position);
    }

    public static class LocationMessage {
        @JsonProperty(value="chat_id")
        private String chatId;
        @JsonProperty(value="latitude")
        private double latitude;
        @JsonProperty(value="longitude")
        private double longitude;
        @JsonProperty(value="horizontal_accuracy")
        private double accuracy;
        @JsonProperty(value="bearing")
        private int bearing;
    }

    public static class TextMessage {
        @JsonProperty(value="chat_id")
        private String chatId;
        @JsonProperty(value="text")
        private String text;
        @JsonProperty(value="parse_mode")
        private String parseMode = "html";
    }
}

