/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr353.JSR353Module;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.ext.ContextResolver;
import org.apache.velocity.app.VelocityEngine;
import org.eclipse.jetty.util.URIUtil;
import org.traccar.Main;
import org.traccar.ServerManager;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.AttributesManager;
import org.traccar.database.BaseObjectManager;
import org.traccar.database.CalendarManager;
import org.traccar.database.CommandsManager;
import org.traccar.database.ConnectionManager;
import org.traccar.database.DataManager;
import org.traccar.database.DeviceManager;
import org.traccar.database.DriversManager;
import org.traccar.database.GeofenceManager;
import org.traccar.database.GroupsManager;
import org.traccar.database.IdentityManager;
import org.traccar.database.LdapProvider;
import org.traccar.database.MailManager;
import org.traccar.database.MaintenancesManager;
import org.traccar.database.MediaManager;
import org.traccar.database.NotificationManager;
import org.traccar.database.OrderManager;
import org.traccar.database.PermissionsManager;
import org.traccar.database.UsersManager;
import org.traccar.geocoder.Geocoder;
import org.traccar.helper.Log;
import org.traccar.helper.SanitizerModule;
import org.traccar.model.Attribute;
import org.traccar.model.BaseModel;
import org.traccar.model.Calendar;
import org.traccar.model.Command;
import org.traccar.model.Device;
import org.traccar.model.Driver;
import org.traccar.model.Geofence;
import org.traccar.model.Group;
import org.traccar.model.Maintenance;
import org.traccar.model.Notification;
import org.traccar.model.Order;
import org.traccar.model.User;
import org.traccar.notification.EventForwarder;
import org.traccar.notification.NotificatorManager;
import org.traccar.reports.model.TripsConfig;
import org.traccar.schedule.ScheduleManager;
import org.traccar.sms.HttpSmsClient;
import org.traccar.sms.SmsManager;
import org.traccar.sms.SnsSmsClient;
import org.traccar.web.WebServer;

public final class Context {
    private static Config config;
    private static ObjectMapper objectMapper;
    private static IdentityManager identityManager;
    private static DataManager dataManager;
    private static LdapProvider ldapProvider;
    private static MailManager mailManager;
    private static MediaManager mediaManager;
    private static UsersManager usersManager;
    private static GroupsManager groupsManager;
    private static DeviceManager deviceManager;
    private static ConnectionManager connectionManager;
    private static PermissionsManager permissionsManager;
    private static WebServer webServer;
    private static ServerManager serverManager;
    private static ScheduleManager scheduleManager;
    private static GeofenceManager geofenceManager;
    private static CalendarManager calendarManager;
    private static NotificationManager notificationManager;
    private static NotificatorManager notificatorManager;
    private static VelocityEngine velocityEngine;
    private static Client client;
    private static EventForwarder eventForwarder;
    private static AttributesManager attributesManager;
    private static DriversManager driversManager;
    private static CommandsManager commandsManager;
    private static MaintenancesManager maintenancesManager;
    private static OrderManager orderManager;
    private static SmsManager smsManager;
    private static TripsConfig tripsConfig;

    private Context() {
    }

    public static Config getConfig() {
        return config;
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static IdentityManager getIdentityManager() {
        return identityManager;
    }

    public static DataManager getDataManager() {
        return dataManager;
    }

    public static LdapProvider getLdapProvider() {
        return ldapProvider;
    }

    public static MailManager getMailManager() {
        return mailManager;
    }

    public static MediaManager getMediaManager() {
        return mediaManager;
    }

    public static UsersManager getUsersManager() {
        return usersManager;
    }

    public static GroupsManager getGroupsManager() {
        return groupsManager;
    }

    public static DeviceManager getDeviceManager() {
        return deviceManager;
    }

    public static ConnectionManager getConnectionManager() {
        return connectionManager;
    }

    public static PermissionsManager getPermissionsManager() {
        return permissionsManager;
    }

    public static Geocoder getGeocoder() {
        return Main.getInjector() != null ? (Geocoder)Main.getInjector().getInstance(Geocoder.class) : null;
    }

    public static WebServer getWebServer() {
        return webServer;
    }

    public static ServerManager getServerManager() {
        return serverManager;
    }

    public static ScheduleManager getScheduleManager() {
        return scheduleManager;
    }

    public static GeofenceManager getGeofenceManager() {
        return geofenceManager;
    }

    public static CalendarManager getCalendarManager() {
        return calendarManager;
    }

    public static NotificationManager getNotificationManager() {
        return notificationManager;
    }

    public static NotificatorManager getNotificatorManager() {
        return notificatorManager;
    }

    public static VelocityEngine getVelocityEngine() {
        return velocityEngine;
    }

    public static Client getClient() {
        return client;
    }

    public static EventForwarder getEventForwarder() {
        return eventForwarder;
    }

    public static AttributesManager getAttributesManager() {
        return attributesManager;
    }

    public static DriversManager getDriversManager() {
        return driversManager;
    }

    public static CommandsManager getCommandsManager() {
        return commandsManager;
    }

    public static MaintenancesManager getMaintenancesManager() {
        return maintenancesManager;
    }

    public static OrderManager getOrderManager() {
        return orderManager;
    }

    public static SmsManager getSmsManager() {
        return smsManager;
    }

    public static TripsConfig getTripsConfig() {
        return tripsConfig;
    }

    public static TripsConfig initTripsConfig() {
        return new TripsConfig(config.getLong(Keys.REPORT_TRIP_MINIMAL_TRIP_DISTANCE), config.getLong(Keys.REPORT_TRIP_MINIMAL_TRIP_DURATION) * 1000L, config.getLong(Keys.REPORT_TRIP_MINIMAL_PARKING_DURATION) * 1000L, config.getLong(Keys.REPORT_TRIP_MINIMAL_NO_DATA_DURATION) * 1000L, config.getBoolean(Keys.REPORT_TRIP_USE_IGNITION), config.getBoolean(Keys.EVENT_MOTION_PROCESS_INVALID_POSITIONS), config.getDouble(Keys.EVENT_MOTION_SPEED_THRESHOLD));
    }

    public static void init(String configFile) throws Exception {
        try {
            config = new Config(configFile);
            Log.setupLogger(config);
        }
        catch (Exception e) {
            config = new Config();
            Log.setupDefaultLogger();
            throw e;
        }
        objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new SanitizerModule());
        objectMapper.registerModule((Module)new JSR353Module());
        objectMapper.setConfig(objectMapper.getSerializationConfig().without(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS));
        client = (Client)ClientBuilder.newClient().register((Object)new ObjectMapperContextResolver());
        if (config.hasKey(Keys.DATABASE_URL)) {
            dataManager = new DataManager(config);
        }
        if (config.hasKey(Keys.LDAP_URL)) {
            ldapProvider = new LdapProvider(config);
        }
        mailManager = new MailManager();
        mediaManager = new MediaManager(config.getString(Keys.MEDIA_PATH));
        if (dataManager != null) {
            usersManager = new UsersManager(dataManager);
            groupsManager = new GroupsManager(dataManager);
            deviceManager = new DeviceManager(dataManager);
        }
        identityManager = deviceManager;
        if (config.hasKey(Keys.WEB_PORT)) {
            webServer = new WebServer(config);
        }
        permissionsManager = new PermissionsManager(dataManager, usersManager);
        connectionManager = new ConnectionManager();
        tripsConfig = Context.initTripsConfig();
        if (config.hasKey(Keys.SMS_HTTP_URL)) {
            smsManager = new HttpSmsClient();
        } else if (config.hasKey(Keys.SMS_AWS_REGION)) {
            smsManager = new SnsSmsClient();
        }
        Context.initEventsModule();
        serverManager = new ServerManager();
        scheduleManager = new ScheduleManager();
        if (config.hasKey(Keys.EVENT_FORWARD_URL)) {
            eventForwarder = new EventForwarder();
        }
        attributesManager = new AttributesManager(dataManager);
        driversManager = new DriversManager(dataManager);
        commandsManager = new CommandsManager(dataManager, config.getBoolean(Keys.COMMANDS_QUEUEING));
        orderManager = new OrderManager(dataManager);
    }

    private static void initEventsModule() {
        String address;
        geofenceManager = new GeofenceManager(dataManager);
        calendarManager = new CalendarManager(dataManager);
        maintenancesManager = new MaintenancesManager(dataManager);
        notificationManager = new NotificationManager(dataManager);
        notificatorManager = new NotificatorManager();
        Properties velocityProperties = new Properties();
        velocityProperties.setProperty("file.resource.loader.path", Context.getConfig().getString("templates.rootPath", "templates") + "/");
        velocityProperties.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogChute");
        try {
            address = config.getString(Keys.WEB_ADDRESS, InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            address = "localhost";
        }
        String webUrl = URIUtil.newURI((String)"http", (String)address, (int)config.getInteger(Keys.WEB_PORT), (String)"", (String)"");
        webUrl = Context.getConfig().getString("web.url", webUrl);
        velocityProperties.setProperty("web.url", webUrl);
        velocityEngine = new VelocityEngine();
        velocityEngine.init(velocityProperties);
    }

    public static void init(IdentityManager testIdentityManager, MediaManager testMediaManager) {
        config = new Config();
        objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JSR353Module());
        client = (Client)ClientBuilder.newClient().register((Object)new ObjectMapperContextResolver());
        identityManager = testIdentityManager;
        mediaManager = testMediaManager;
    }

    public static <T extends BaseModel> BaseObjectManager<T> getManager(Class<T> clazz) {
        if (clazz.equals(Device.class)) {
            return deviceManager;
        }
        if (clazz.equals(Group.class)) {
            return groupsManager;
        }
        if (clazz.equals(User.class)) {
            return usersManager;
        }
        if (clazz.equals(Calendar.class)) {
            return calendarManager;
        }
        if (clazz.equals(Attribute.class)) {
            return attributesManager;
        }
        if (clazz.equals(Geofence.class)) {
            return geofenceManager;
        }
        if (clazz.equals(Driver.class)) {
            return driversManager;
        }
        if (clazz.equals(Command.class)) {
            return commandsManager;
        }
        if (clazz.equals(Maintenance.class)) {
            return maintenancesManager;
        }
        if (clazz.equals(Notification.class)) {
            return notificationManager;
        }
        if (clazz.equals(Order.class)) {
            return orderManager;
        }
        return null;
    }

    static {
        client = ClientBuilder.newClient();
    }

    private static class ObjectMapperContextResolver
    implements ContextResolver<ObjectMapper> {
        private ObjectMapperContextResolver() {
        }

        public ObjectMapper getContext(Class<?> clazz) {
            return objectMapper;
        }
    }
}

