/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.biginteger;

import de.rub.nds.modifiablevariable.VariableModification;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Random;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"summand", "modificationFilter", "postModification"})
public class BigIntegerAddModification
extends VariableModification<BigInteger> {
    private static final int MAX_ADD_LENGTH = 8;
    private BigInteger summand;

    public BigIntegerAddModification() {
    }

    public BigIntegerAddModification(BigInteger bi) {
        this.summand = bi;
    }

    @Override
    protected BigInteger modifyImplementationHook(BigInteger input) {
        return input == null ? this.summand : input.add(this.summand);
    }

    public BigInteger getSummand() {
        return this.summand;
    }

    public void setSummand(BigInteger summand) {
        this.summand = summand;
    }

    @Override
    public VariableModification<BigInteger> getModifiedCopy() {
        return new BigIntegerAddModification(this.summand.add(new BigInteger(8, new Random())));
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.summand);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntegerAddModification other = (BigIntegerAddModification)obj;
        return Objects.equals(this.summand, other.summand);
    }
}

