/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkXYColorEXT;

public class VkHdrMetadataEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DISPLAYPRIMARYRED;
    public static final int DISPLAYPRIMARYGREEN;
    public static final int DISPLAYPRIMARYBLUE;
    public static final int WHITEPOINT;
    public static final int MAXLUMINANCE;
    public static final int MINLUMINANCE;
    public static final int MAXCONTENTLIGHTLEVEL;
    public static final int MAXFRAMEAVERAGELIGHTLEVEL;

    public VkHdrMetadataEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkHdrMetadataEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkHdrMetadataEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkHdrMetadataEXT.npNext(this.address());
    }

    public VkXYColorEXT displayPrimaryRed() {
        return VkHdrMetadataEXT.ndisplayPrimaryRed(this.address());
    }

    public VkXYColorEXT displayPrimaryGreen() {
        return VkHdrMetadataEXT.ndisplayPrimaryGreen(this.address());
    }

    public VkXYColorEXT displayPrimaryBlue() {
        return VkHdrMetadataEXT.ndisplayPrimaryBlue(this.address());
    }

    public VkXYColorEXT whitePoint() {
        return VkHdrMetadataEXT.nwhitePoint(this.address());
    }

    public float maxLuminance() {
        return VkHdrMetadataEXT.nmaxLuminance(this.address());
    }

    public float minLuminance() {
        return VkHdrMetadataEXT.nminLuminance(this.address());
    }

    public float maxContentLightLevel() {
        return VkHdrMetadataEXT.nmaxContentLightLevel(this.address());
    }

    public float maxFrameAverageLightLevel() {
        return VkHdrMetadataEXT.nmaxFrameAverageLightLevel(this.address());
    }

    public VkHdrMetadataEXT sType(@NativeType(value="VkStructureType") int value) {
        VkHdrMetadataEXT.nsType(this.address(), value);
        return this;
    }

    public VkHdrMetadataEXT pNext(@NativeType(value="void const *") long value) {
        VkHdrMetadataEXT.npNext(this.address(), value);
        return this;
    }

    public VkHdrMetadataEXT displayPrimaryRed(VkXYColorEXT value) {
        VkHdrMetadataEXT.ndisplayPrimaryRed(this.address(), value);
        return this;
    }

    public VkHdrMetadataEXT displayPrimaryRed(Consumer<VkXYColorEXT> consumer) {
        consumer.accept(this.displayPrimaryRed());
        return this;
    }

    public VkHdrMetadataEXT displayPrimaryGreen(VkXYColorEXT value) {
        VkHdrMetadataEXT.ndisplayPrimaryGreen(this.address(), value);
        return this;
    }

    public VkHdrMetadataEXT displayPrimaryGreen(Consumer<VkXYColorEXT> consumer) {
        consumer.accept(this.displayPrimaryGreen());
        return this;
    }

    public VkHdrMetadataEXT displayPrimaryBlue(VkXYColorEXT value) {
        VkHdrMetadataEXT.ndisplayPrimaryBlue(this.address(), value);
        return this;
    }

    public VkHdrMetadataEXT displayPrimaryBlue(Consumer<VkXYColorEXT> consumer) {
        consumer.accept(this.displayPrimaryBlue());
        return this;
    }

    public VkHdrMetadataEXT whitePoint(VkXYColorEXT value) {
        VkHdrMetadataEXT.nwhitePoint(this.address(), value);
        return this;
    }

    public VkHdrMetadataEXT whitePoint(Consumer<VkXYColorEXT> consumer) {
        consumer.accept(this.whitePoint());
        return this;
    }

    public VkHdrMetadataEXT maxLuminance(float value) {
        VkHdrMetadataEXT.nmaxLuminance(this.address(), value);
        return this;
    }

    public VkHdrMetadataEXT minLuminance(float value) {
        VkHdrMetadataEXT.nminLuminance(this.address(), value);
        return this;
    }

    public VkHdrMetadataEXT maxContentLightLevel(float value) {
        VkHdrMetadataEXT.nmaxContentLightLevel(this.address(), value);
        return this;
    }

    public VkHdrMetadataEXT maxFrameAverageLightLevel(float value) {
        VkHdrMetadataEXT.nmaxFrameAverageLightLevel(this.address(), value);
        return this;
    }

    public VkHdrMetadataEXT set(int sType, long pNext, VkXYColorEXT displayPrimaryRed, VkXYColorEXT displayPrimaryGreen, VkXYColorEXT displayPrimaryBlue, VkXYColorEXT whitePoint, float maxLuminance, float minLuminance, float maxContentLightLevel, float maxFrameAverageLightLevel) {
        this.sType(sType);
        this.pNext(pNext);
        this.displayPrimaryRed(displayPrimaryRed);
        this.displayPrimaryGreen(displayPrimaryGreen);
        this.displayPrimaryBlue(displayPrimaryBlue);
        this.whitePoint(whitePoint);
        this.maxLuminance(maxLuminance);
        this.minLuminance(minLuminance);
        this.maxContentLightLevel(maxContentLightLevel);
        this.maxFrameAverageLightLevel(maxFrameAverageLightLevel);
        return this;
    }

    public VkHdrMetadataEXT set(VkHdrMetadataEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkHdrMetadataEXT malloc() {
        return (VkHdrMetadataEXT)VkHdrMetadataEXT.wrap(VkHdrMetadataEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkHdrMetadataEXT calloc() {
        return (VkHdrMetadataEXT)VkHdrMetadataEXT.wrap(VkHdrMetadataEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkHdrMetadataEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkHdrMetadataEXT)VkHdrMetadataEXT.wrap(VkHdrMetadataEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkHdrMetadataEXT create(long address) {
        return (VkHdrMetadataEXT)VkHdrMetadataEXT.wrap(VkHdrMetadataEXT.class, (long)address);
    }

    @Nullable
    public static VkHdrMetadataEXT createSafe(long address) {
        return address == 0L ? null : (VkHdrMetadataEXT)VkHdrMetadataEXT.wrap(VkHdrMetadataEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkHdrMetadataEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkHdrMetadataEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkHdrMetadataEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkHdrMetadataEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkHdrMetadataEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkHdrMetadataEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkHdrMetadataEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkHdrMetadataEXT mallocStack() {
        return VkHdrMetadataEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkHdrMetadataEXT callocStack() {
        return VkHdrMetadataEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkHdrMetadataEXT mallocStack(MemoryStack stack) {
        return (VkHdrMetadataEXT)VkHdrMetadataEXT.wrap(VkHdrMetadataEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkHdrMetadataEXT callocStack(MemoryStack stack) {
        return (VkHdrMetadataEXT)VkHdrMetadataEXT.wrap(VkHdrMetadataEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkHdrMetadataEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkHdrMetadataEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkHdrMetadataEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkHdrMetadataEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static VkXYColorEXT ndisplayPrimaryRed(long struct) {
        return VkXYColorEXT.create(struct + (long)DISPLAYPRIMARYRED);
    }

    public static VkXYColorEXT ndisplayPrimaryGreen(long struct) {
        return VkXYColorEXT.create(struct + (long)DISPLAYPRIMARYGREEN);
    }

    public static VkXYColorEXT ndisplayPrimaryBlue(long struct) {
        return VkXYColorEXT.create(struct + (long)DISPLAYPRIMARYBLUE);
    }

    public static VkXYColorEXT nwhitePoint(long struct) {
        return VkXYColorEXT.create(struct + (long)WHITEPOINT);
    }

    public static float nmaxLuminance(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MAXLUMINANCE);
    }

    public static float nminLuminance(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MINLUMINANCE);
    }

    public static float nmaxContentLightLevel(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MAXCONTENTLIGHTLEVEL);
    }

    public static float nmaxFrameAverageLightLevel(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MAXFRAMEAVERAGELIGHTLEVEL);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ndisplayPrimaryRed(long struct, VkXYColorEXT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DISPLAYPRIMARYRED), (long)VkXYColorEXT.SIZEOF);
    }

    public static void ndisplayPrimaryGreen(long struct, VkXYColorEXT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DISPLAYPRIMARYGREEN), (long)VkXYColorEXT.SIZEOF);
    }

    public static void ndisplayPrimaryBlue(long struct, VkXYColorEXT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DISPLAYPRIMARYBLUE), (long)VkXYColorEXT.SIZEOF);
    }

    public static void nwhitePoint(long struct, VkXYColorEXT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)WHITEPOINT), (long)VkXYColorEXT.SIZEOF);
    }

    public static void nmaxLuminance(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MAXLUMINANCE, value);
    }

    public static void nminLuminance(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MINLUMINANCE, value);
    }

    public static void nmaxContentLightLevel(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MAXCONTENTLIGHTLEVEL, value);
    }

    public static void nmaxFrameAverageLightLevel(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MAXFRAMEAVERAGELIGHTLEVEL, value);
    }

    static {
        Struct.Layout layout = VkHdrMetadataEXT.__struct((Struct.Member[])new Struct.Member[]{VkHdrMetadataEXT.__member((int)4), VkHdrMetadataEXT.__member((int)POINTER_SIZE), VkHdrMetadataEXT.__member((int)VkXYColorEXT.SIZEOF, (int)VkXYColorEXT.ALIGNOF), VkHdrMetadataEXT.__member((int)VkXYColorEXT.SIZEOF, (int)VkXYColorEXT.ALIGNOF), VkHdrMetadataEXT.__member((int)VkXYColorEXT.SIZEOF, (int)VkXYColorEXT.ALIGNOF), VkHdrMetadataEXT.__member((int)VkXYColorEXT.SIZEOF, (int)VkXYColorEXT.ALIGNOF), VkHdrMetadataEXT.__member((int)4), VkHdrMetadataEXT.__member((int)4), VkHdrMetadataEXT.__member((int)4), VkHdrMetadataEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DISPLAYPRIMARYRED = layout.offsetof(2);
        DISPLAYPRIMARYGREEN = layout.offsetof(3);
        DISPLAYPRIMARYBLUE = layout.offsetof(4);
        WHITEPOINT = layout.offsetof(5);
        MAXLUMINANCE = layout.offsetof(6);
        MINLUMINANCE = layout.offsetof(7);
        MAXCONTENTLIGHTLEVEL = layout.offsetof(8);
        MAXFRAMEAVERAGELIGHTLEVEL = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkHdrMetadataEXT, Buffer>
    implements NativeResource {
        private static final VkHdrMetadataEXT ELEMENT_FACTORY = VkHdrMetadataEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkHdrMetadataEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkHdrMetadataEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkHdrMetadataEXT.npNext(this.address());
        }

        public VkXYColorEXT displayPrimaryRed() {
            return VkHdrMetadataEXT.ndisplayPrimaryRed(this.address());
        }

        public VkXYColorEXT displayPrimaryGreen() {
            return VkHdrMetadataEXT.ndisplayPrimaryGreen(this.address());
        }

        public VkXYColorEXT displayPrimaryBlue() {
            return VkHdrMetadataEXT.ndisplayPrimaryBlue(this.address());
        }

        public VkXYColorEXT whitePoint() {
            return VkHdrMetadataEXT.nwhitePoint(this.address());
        }

        public float maxLuminance() {
            return VkHdrMetadataEXT.nmaxLuminance(this.address());
        }

        public float minLuminance() {
            return VkHdrMetadataEXT.nminLuminance(this.address());
        }

        public float maxContentLightLevel() {
            return VkHdrMetadataEXT.nmaxContentLightLevel(this.address());
        }

        public float maxFrameAverageLightLevel() {
            return VkHdrMetadataEXT.nmaxFrameAverageLightLevel(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkHdrMetadataEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkHdrMetadataEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer displayPrimaryRed(VkXYColorEXT value) {
            VkHdrMetadataEXT.ndisplayPrimaryRed(this.address(), value);
            return this;
        }

        public Buffer displayPrimaryRed(Consumer<VkXYColorEXT> consumer) {
            consumer.accept(this.displayPrimaryRed());
            return this;
        }

        public Buffer displayPrimaryGreen(VkXYColorEXT value) {
            VkHdrMetadataEXT.ndisplayPrimaryGreen(this.address(), value);
            return this;
        }

        public Buffer displayPrimaryGreen(Consumer<VkXYColorEXT> consumer) {
            consumer.accept(this.displayPrimaryGreen());
            return this;
        }

        public Buffer displayPrimaryBlue(VkXYColorEXT value) {
            VkHdrMetadataEXT.ndisplayPrimaryBlue(this.address(), value);
            return this;
        }

        public Buffer displayPrimaryBlue(Consumer<VkXYColorEXT> consumer) {
            consumer.accept(this.displayPrimaryBlue());
            return this;
        }

        public Buffer whitePoint(VkXYColorEXT value) {
            VkHdrMetadataEXT.nwhitePoint(this.address(), value);
            return this;
        }

        public Buffer whitePoint(Consumer<VkXYColorEXT> consumer) {
            consumer.accept(this.whitePoint());
            return this;
        }

        public Buffer maxLuminance(float value) {
            VkHdrMetadataEXT.nmaxLuminance(this.address(), value);
            return this;
        }

        public Buffer minLuminance(float value) {
            VkHdrMetadataEXT.nminLuminance(this.address(), value);
            return this;
        }

        public Buffer maxContentLightLevel(float value) {
            VkHdrMetadataEXT.nmaxContentLightLevel(this.address(), value);
            return this;
        }

        public Buffer maxFrameAverageLightLevel(float value) {
            VkHdrMetadataEXT.nmaxFrameAverageLightLevel(this.address(), value);
            return this;
        }
    }
}

