/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaBudget
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BLOCKBYTES;
    public static final int ALLOCATIONBYTES;
    public static final int USAGE;
    public static final int BUDGET;

    public VmaBudget(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaBudget.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long blockBytes() {
        return VmaBudget.nblockBytes(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long allocationBytes() {
        return VmaBudget.nallocationBytes(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long usage() {
        return VmaBudget.nusage(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long budget() {
        return VmaBudget.nbudget(this.address());
    }

    public static VmaBudget malloc() {
        return (VmaBudget)VmaBudget.wrap(VmaBudget.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VmaBudget calloc() {
        return (VmaBudget)VmaBudget.wrap(VmaBudget.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VmaBudget create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VmaBudget)VmaBudget.wrap(VmaBudget.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VmaBudget create(long address) {
        return (VmaBudget)VmaBudget.wrap(VmaBudget.class, (long)address);
    }

    @Nullable
    public static VmaBudget createSafe(long address) {
        return address == 0L ? null : (VmaBudget)VmaBudget.wrap(VmaBudget.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VmaBudget.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VmaBudget.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VmaBudget.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaBudget.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VmaBudget.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VmaBudget.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VmaBudget.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VmaBudget mallocStack() {
        return VmaBudget.mallocStack(MemoryStack.stackGet());
    }

    public static VmaBudget callocStack() {
        return VmaBudget.callocStack(MemoryStack.stackGet());
    }

    public static VmaBudget mallocStack(MemoryStack stack) {
        return (VmaBudget)VmaBudget.wrap(VmaBudget.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaBudget callocStack(MemoryStack stack) {
        return (VmaBudget)VmaBudget.wrap(VmaBudget.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VmaBudget.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VmaBudget.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VmaBudget.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VmaBudget.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nblockBytes(long struct) {
        return UNSAFE.getLong(null, struct + (long)BLOCKBYTES);
    }

    public static long nallocationBytes(long struct) {
        return UNSAFE.getLong(null, struct + (long)ALLOCATIONBYTES);
    }

    public static long nusage(long struct) {
        return UNSAFE.getLong(null, struct + (long)USAGE);
    }

    public static long nbudget(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUDGET);
    }

    static {
        Struct.Layout layout = VmaBudget.__struct((Struct.Member[])new Struct.Member[]{VmaBudget.__member((int)8), VmaBudget.__member((int)8), VmaBudget.__member((int)8), VmaBudget.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BLOCKBYTES = layout.offsetof(0);
        ALLOCATIONBYTES = layout.offsetof(1);
        USAGE = layout.offsetof(2);
        BUDGET = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VmaBudget, Buffer>
    implements NativeResource {
        private static final VmaBudget ELEMENT_FACTORY = VmaBudget.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VmaBudget getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long blockBytes() {
            return VmaBudget.nblockBytes(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long allocationBytes() {
            return VmaBudget.nallocationBytes(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long usage() {
            return VmaBudget.nusage(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long budget() {
            return VmaBudget.nbudget(this.address());
        }
    }
}

