"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var picked_shapes_1 = require("./picked_shapes");
function getCurrentPointerPosition(state) {
    return state.interactions.pointer.current.position;
}
exports.getTooltipAnchorSelector = re_reselect_1.default([picked_shapes_1.getPickedShapes, compute_chart_dimensions_1.computeChartDimensionsSelector, getCurrentPointerPosition], function (shapes, chartDimensions, position) {
    if (Array.isArray(shapes) && shapes.length > 0) {
        var firstShape = shapes[0];
        return {
            isRotated: false,
            x1: firstShape.x + chartDimensions.left + firstShape.width / 2,
            y1: firstShape.y - chartDimensions.top + firstShape.height,
        };
    }
    return {
        isRotated: false,
        x1: position.x,
        y1: position.y,
    };
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_tooltip_anchor.js.map