/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import com.android.dex.ClassData;
import com.android.dex.Code;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.JumpInfo;
import jadx.core.dex.attributes.nodes.LineAttrNode;
import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.GotoNode;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnDecoder;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.SwitchNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.GenericInfo;
import jadx.core.dex.nodes.ICodeNode;
import jadx.core.dex.nodes.ILoadable;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.nodes.parser.SignatureParser;
import jadx.core.dex.regions.Region;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.TryCatchBlock;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodNode
extends LineAttrNode
implements ILoadable,
ICodeNode {
    private static final Logger LOG = LoggerFactory.getLogger(MethodNode.class);
    private final MethodInfo mthInfo;
    private final ClassNode parentClass;
    private AccessInfo accFlags;
    private final ClassData.Method methodData;
    private final boolean methodIsVirtual;
    private boolean noCode;
    private int regsCount;
    private int codeSize;
    private int debugInfoOffset;
    private boolean loaded;
    private ArgType retType;
    private List<ArgType> argTypes;
    private List<GenericInfo> generics;
    private RegisterArg thisArg;
    private List<RegisterArg> argsList;
    private InsnNode[] instructions;
    private List<BlockNode> blocks;
    private BlockNode enterBlock;
    private List<BlockNode> exitBlocks;
    private List<SSAVar> sVars;
    private List<ExceptionHandler> exceptionHandlers;
    private List<LoopInfo> loops;
    private Region region;

    public MethodNode(ClassNode classNode, ClassData.Method mthData, boolean isVirtual) {
        this.mthInfo = MethodInfo.fromDex(classNode.dex(), mthData.getMethodIndex());
        this.parentClass = classNode;
        this.accFlags = new AccessInfo(mthData.getAccessFlags(), AccessInfo.AFType.METHOD);
        this.noCode = mthData.getCodeOffset() == 0;
        this.methodData = this.noCode ? null : mthData;
        this.methodIsVirtual = isVirtual;
        this.unload();
    }

    @Override
    public void unload() {
        this.loaded = false;
        if (this.noCode) {
            return;
        }
        this.thisArg = null;
        this.argsList = null;
        this.sVars = Collections.emptyList();
        this.instructions = null;
        this.blocks = null;
        this.enterBlock = null;
        this.exitBlocks = null;
        this.region = null;
        this.exceptionHandlers = Collections.emptyList();
        this.loops = Collections.emptyList();
        this.unloadAttributes();
    }

    @Override
    public void load() throws DecodeException {
        if (this.loaded) {
            return;
        }
        try {
            this.loaded = true;
            if (this.noCode) {
                this.regsCount = 0;
                this.codeSize = 0;
                this.initArguments(this.argTypes);
                return;
            }
            DexNode dex = this.parentClass.dex();
            Code mthCode = dex.readCode(this.methodData);
            this.regsCount = mthCode.getRegistersSize();
            this.initArguments(this.argTypes);
            InsnDecoder decoder = new InsnDecoder(this);
            decoder.decodeInsns(mthCode);
            this.instructions = decoder.process();
            this.codeSize = this.instructions.length;
            MethodNode.initTryCatches(this, mthCode, this.instructions);
            MethodNode.initJumps(this.instructions);
            this.debugInfoOffset = mthCode.getDebugInfoOffset();
        }
        catch (Exception e) {
            if (!this.noCode) {
                this.unload();
                this.noCode = true;
                this.load();
                this.noCode = false;
            }
            throw new DecodeException(this, "Load method exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void checkInstructions() {
        ArrayList<RegisterArg> list = new ArrayList<RegisterArg>();
        for (InsnNode insnNode : this.instructions) {
            if (insnNode == null) continue;
            list.clear();
            RegisterArg resultArg = insnNode.getResult();
            if (resultArg != null) {
                list.add(resultArg);
            }
            insnNode.getRegisterArgs(list);
            for (RegisterArg arg : list) {
                if (arg.getRegNum() < this.regsCount) continue;
                throw new JadxRuntimeException("Incorrect register number in instruction: " + insnNode + ", expected to be less than " + this.regsCount);
            }
        }
    }

    public void initMethodTypes() {
        List<ArgType> types = this.parseSignature();
        if (types == null) {
            this.retType = this.mthInfo.getReturnType();
            this.argTypes = this.mthInfo.getArgumentsTypes();
        } else {
            this.argTypes = types;
        }
    }

    @Nullable
    private List<ArgType> parseSignature() {
        SignatureParser sp = SignatureParser.fromNode(this);
        if (sp == null) {
            return null;
        }
        try {
            this.generics = sp.consumeGenericMap();
            List<ArgType> argsTypes = sp.consumeMethodArgs();
            this.retType = sp.consumeType();
            List<ArgType> mthArgs = this.mthInfo.getArgumentsTypes();
            if (argsTypes.size() != mthArgs.size()) {
                if (argsTypes.isEmpty()) {
                    return null;
                }
                if (!this.tryFixArgsCounts(argsTypes, mthArgs)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Incorrect method signature, types: ({}), method: {}", (Object)Utils.listToString(argsTypes), (Object)this);
                    }
                    return null;
                }
            }
            return argsTypes;
        }
        catch (Exception e) {
            this.addWarningComment("Failed to parse method signature: " + sp.getSignature(), e);
            return null;
        }
    }

    private boolean tryFixArgsCounts(List<ArgType> argsTypes, List<ArgType> mthArgs) {
        if (!this.mthInfo.isConstructor()) {
            return false;
        }
        if (this.getParentClass().getAccessFlags().isEnum()) {
            if (mthArgs.size() >= 2) {
                argsTypes.add(0, mthArgs.get(0));
                argsTypes.add(1, mthArgs.get(1));
            }
        } else if (!mthArgs.isEmpty()) {
            argsTypes.add(0, mthArgs.get(0));
        }
        return argsTypes.size() == mthArgs.size();
    }

    private void initArguments(List<ArgType> args) {
        int pos;
        if (this.noCode) {
            pos = 1;
        } else {
            pos = this.regsCount;
            for (ArgType arg : args) {
                pos -= arg.getRegCount();
            }
        }
        if (this.accFlags.isStatic()) {
            this.thisArg = null;
        } else {
            RegisterArg arg = InsnArg.reg(pos - 1, this.parentClass.getClassInfo().getType());
            arg.add(AFlag.THIS);
            arg.add(AFlag.IMMUTABLE_TYPE);
            this.thisArg = arg;
        }
        if (args.isEmpty()) {
            this.argsList = Collections.emptyList();
            return;
        }
        this.argsList = new ArrayList<RegisterArg>(args.size());
        for (ArgType argType : args) {
            RegisterArg regArg = InsnArg.reg(pos, argType);
            regArg.add(AFlag.METHOD_ARGUMENT);
            regArg.add(AFlag.IMMUTABLE_TYPE);
            this.argsList.add(regArg);
            pos += argType.getRegCount();
        }
    }

    @NotNull
    public List<ArgType> getArgTypes() {
        if (this.argTypes == null) {
            throw new JadxRuntimeException("Method types not initialized: " + this);
        }
        return this.argTypes;
    }

    public List<RegisterArg> getArgRegs() {
        if (this.argsList == null) {
            throw new JadxRuntimeException("Method args not loaded: " + this + ", class status: " + (Object)((Object)this.parentClass.getTopParentClass().getState()));
        }
        return this.argsList;
    }

    public List<RegisterArg> getAllArgRegs() {
        List<RegisterArg> argRegs = this.getArgRegs();
        if (this.thisArg != null) {
            ArrayList<RegisterArg> list = new ArrayList<RegisterArg>(argRegs.size() + 1);
            list.add(this.thisArg);
            list.addAll(argRegs);
            return list;
        }
        return argRegs;
    }

    @Nullable
    public RegisterArg getThisArg() {
        return this.thisArg;
    }

    public void skipFirstArgument() {
        this.add(AFlag.SKIP_FIRST_ARG);
    }

    public ArgType getReturnType() {
        return this.retType;
    }

    public List<GenericInfo> getGenerics() {
        return this.generics;
    }

    private static void initTryCatches(MethodNode mth, Code mthCode, InsnNode[] insnByOffset) {
        Code.CatchHandler[] catchBlocks = mthCode.getCatchHandlers();
        Code.Try[] tries = mthCode.getTries();
        if (catchBlocks.length == 0 && tries.length == 0) {
            return;
        }
        int handlersCount = 0;
        HashSet<Integer> addrs = new HashSet<Integer>();
        ArrayList<TryCatchBlock> catches = new ArrayList<TryCatchBlock>(catchBlocks.length);
        for (Code.CatchHandler handler : catchBlocks) {
            TryCatchBlock tcBlock = new TryCatchBlock();
            catches.add(tcBlock);
            int[] handlerAddrArr = handler.getAddresses();
            for (int i = 0; i < handlerAddrArr.length; ++i) {
                int addr = handlerAddrArr[i];
                ClassInfo type = ClassInfo.fromDex(mth.dex(), handler.getTypeIndexes()[i]);
                tcBlock.addHandler(mth, addr, type);
                addrs.add(addr);
                ++handlersCount;
            }
            int addr = handler.getCatchAllAddress();
            if (addr < 0) continue;
            tcBlock.addHandler(mth, addr, null);
            addrs.add(addr);
            ++handlersCount;
        }
        if (handlersCount > 0 && handlersCount != addrs.size()) {
            for (TryCatchBlock outerTry : catches) {
                for (TryCatchBlock innerTry : catches) {
                    if (outerTry == innerTry || !innerTry.containsAllHandlers(outerTry)) continue;
                    innerTry.removeSameHandlers(outerTry);
                }
            }
        }
        addrs.clear();
        for (TryCatchBlock ct : catches) {
            for (ExceptionHandler eh : ct.getHandlers()) {
                int addr = eh.getHandleOffset();
                ExcHandlerAttr ehAttr = new ExcHandlerAttr(ct, eh);
                insnByOffset[addr].addAttr(ehAttr);
            }
        }
        for (Code.Try aTry : tries) {
            int catchNum = aTry.getCatchHandlerIndex();
            TryCatchBlock catchBlock = (TryCatchBlock)catches.get(catchNum);
            int offset = aTry.getStartAddress();
            int end = offset + aTry.getInstructionCount() - 1;
            boolean tryBlockStarted = false;
            InsnNode insn = null;
            while (offset <= end && offset >= 0) {
                insn = insnByOffset[offset];
                if (insn != null && insn.getType() != InsnType.NOP) {
                    if (tryBlockStarted) {
                        catchBlock.addInsn(insn);
                    } else if (insn.canThrowException()) {
                        insn.add(AFlag.TRY_ENTER);
                        catchBlock.addInsn(insn);
                        tryBlockStarted = true;
                    }
                }
                offset = InsnDecoder.getNextInsnOffset(insnByOffset, offset);
            }
            if (!tryBlockStarted || insn == null) continue;
            insn.add(AFlag.TRY_LEAVE);
        }
    }

    private static void initJumps(InsnNode[] insnByOffset) {
        block5: for (int offset = 0; offset < insnByOffset.length; ++offset) {
            InsnNode insn = insnByOffset[offset];
            if (insn == null) continue;
            switch (insn.getType()) {
                case SWITCH: {
                    SwitchNode sw = (SwitchNode)insn;
                    for (int target : sw.getTargets()) {
                        MethodNode.addJump(insnByOffset, offset, target);
                    }
                    int nextInsnOffset = InsnDecoder.getNextInsnOffset(insnByOffset, offset);
                    if (nextInsnOffset == -1) continue block5;
                    MethodNode.addJump(insnByOffset, offset, nextInsnOffset);
                    continue block5;
                }
                case IF: {
                    int next = InsnDecoder.getNextInsnOffset(insnByOffset, offset);
                    if (next != -1) {
                        MethodNode.addJump(insnByOffset, offset, next);
                    }
                    MethodNode.addJump(insnByOffset, offset, ((IfNode)insn).getTarget());
                    continue block5;
                }
                case GOTO: {
                    MethodNode.addJump(insnByOffset, offset, ((GotoNode)insn).getTarget());
                    continue block5;
                }
            }
        }
    }

    private static void addJump(InsnNode[] insnByOffset, int offset, int target) {
        insnByOffset[target].addAttr(AType.JUMP, new JumpInfo(offset, target));
    }

    public String getName() {
        return this.mthInfo.getName();
    }

    public String getAlias() {
        return this.mthInfo.getAlias();
    }

    public ClassNode getParentClass() {
        return this.parentClass;
    }

    public boolean isNoCode() {
        return this.noCode;
    }

    public int getCodeSize() {
        return this.codeSize;
    }

    public InsnNode[] getInstructions() {
        return this.instructions;
    }

    public void unloadInsnArr() {
        this.instructions = null;
    }

    public void initBasicBlocks() {
        this.blocks = new ArrayList<BlockNode>();
        this.exitBlocks = new ArrayList<BlockNode>(1);
    }

    public void finishBasicBlocks() {
        this.blocks = Utils.lockList(this.blocks);
        this.exitBlocks = Utils.lockList(this.exitBlocks);
        this.loops = Utils.lockList(this.loops);
        this.blocks.forEach(BlockNode::lock);
    }

    public List<BlockNode> getBasicBlocks() {
        return this.blocks;
    }

    public BlockNode getEnterBlock() {
        return this.enterBlock;
    }

    public void setEnterBlock(BlockNode enterBlock) {
        this.enterBlock = enterBlock;
    }

    public List<BlockNode> getExitBlocks() {
        return this.exitBlocks;
    }

    public void addExitBlock(BlockNode exitBlock) {
        this.exitBlocks.add(exitBlock);
    }

    public void registerLoop(LoopInfo loop) {
        if (this.loops.isEmpty()) {
            this.loops = new ArrayList<LoopInfo>(5);
        }
        loop.setId(this.loops.size());
        this.loops.add(loop);
    }

    @Nullable
    public LoopInfo getLoopForBlock(BlockNode block) {
        if (this.loops.isEmpty()) {
            return null;
        }
        for (LoopInfo loop : this.loops) {
            if (!loop.getLoopBlocks().contains(block)) continue;
            return loop;
        }
        return null;
    }

    public List<LoopInfo> getAllLoopsForBlock(BlockNode block) {
        if (this.loops.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LoopInfo> list = new ArrayList<LoopInfo>(this.loops.size());
        for (LoopInfo loop : this.loops) {
            if (!loop.getLoopBlocks().contains(block)) continue;
            list.add(loop);
        }
        return list;
    }

    public int getLoopsCount() {
        return this.loops.size();
    }

    public Iterable<LoopInfo> getLoops() {
        return this.loops;
    }

    public ExceptionHandler addExceptionHandler(ExceptionHandler handler) {
        if (this.exceptionHandlers.isEmpty()) {
            this.exceptionHandlers = new ArrayList<ExceptionHandler>(2);
        } else {
            for (ExceptionHandler h : this.exceptionHandlers) {
                if (h.equals(handler)) {
                    return h;
                }
                if (h.getHandleOffset() != handler.getHandleOffset()) continue;
                if (h.getTryBlock() == handler.getTryBlock()) {
                    for (ClassInfo catchType : handler.getCatchTypes()) {
                        h.addCatchType(catchType);
                    }
                }
                return h;
            }
        }
        this.exceptionHandlers.add(handler);
        return handler;
    }

    public boolean clearExceptionHandlers() {
        return this.exceptionHandlers.removeIf(ExceptionHandler::isRemoved);
    }

    public Iterable<ExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public boolean isNoExceptionHandlers() {
        return this.exceptionHandlers.isEmpty();
    }

    public int getExceptionHandlersCount() {
        return this.exceptionHandlers.size();
    }

    public boolean isArgsOverload() {
        int argsCount = this.mthInfo.getArgumentsTypes().size();
        if (argsCount == 0) {
            return false;
        }
        String name = this.getName();
        for (MethodNode method : this.parentClass.getMethods()) {
            MethodInfo otherMthInfo = method.mthInfo;
            if (this == method || otherMthInfo.getArgumentsTypes().size() != argsCount || !otherMthInfo.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isConstructor() {
        return this.accFlags.isConstructor() && this.mthInfo.isConstructor();
    }

    public boolean isDefaultConstructor() {
        if (this.isConstructor()) {
            int defaultArgCount = 0;
            if (this.parentClass.getClassInfo().isInner() && !this.parentClass.getAccessFlags().isStatic()) {
                ClassNode outerCls = this.parentClass.getParentClass();
                if (this.argsList != null && !this.argsList.isEmpty() && this.argsList.get(0).getInitType().equals(outerCls.getClassInfo().getType())) {
                    defaultArgCount = 1;
                }
            }
            return this.argsList == null || this.argsList.size() == defaultArgCount;
        }
        return false;
    }

    public boolean isVirtual() {
        return this.methodIsVirtual;
    }

    public int getRegsCount() {
        return this.regsCount;
    }

    public int getDebugInfoOffset() {
        return this.debugInfoOffset;
    }

    public SSAVar makeNewSVar(int regNum, @NotNull RegisterArg assignArg) {
        return this.makeNewSVar(regNum, this.getNextSVarVersion(regNum), assignArg);
    }

    public SSAVar makeNewSVar(int regNum, int version, @NotNull RegisterArg assignArg) {
        SSAVar var = new SSAVar(regNum, version, assignArg);
        if (this.sVars.isEmpty()) {
            this.sVars = new ArrayList<SSAVar>();
        }
        this.sVars.add(var);
        return var;
    }

    public int getNextSVarVersion(int regNum) {
        int v = -1;
        for (SSAVar sVar : this.sVars) {
            if (sVar.getRegNum() != regNum) continue;
            v = Math.max(v, sVar.getVersion());
        }
        return ++v;
    }

    public void removeSVar(SSAVar var) {
        this.sVars.remove(var);
    }

    public List<SSAVar> getSVars() {
        return this.sVars;
    }

    @Override
    public AccessInfo getAccessFlags() {
        return this.accFlags;
    }

    @Override
    public void setAccessFlags(AccessInfo newAccessFlags) {
        this.accFlags = newAccessFlags;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    @Override
    public DexNode dex() {
        return this.parentClass.dex();
    }

    @Override
    public RootNode root() {
        return this.dex().root();
    }

    @Override
    public String typeName() {
        return "method";
    }

    public void addWarn(String warnStr) {
        ErrorsCounter.methodWarn(this, warnStr);
    }

    public void addWarningComment(String warn) {
        this.addWarningComment(warn, null);
    }

    public void addWarningComment(String warn, @Nullable Throwable exc) {
        String commentStr = "JADX WARN: " + warn;
        this.addAttr(AType.COMMENTS, commentStr);
        if (exc != null) {
            LOG.warn("{} in {}", new Object[]{warn, this, exc});
        } else {
            LOG.warn("{} in {}", (Object)warn, (Object)this);
        }
    }

    public void addComment(String commentStr) {
        this.addAttr(AType.COMMENTS, commentStr);
        LOG.info("{} in {}", (Object)commentStr, (Object)this);
    }

    public void addError(String errStr, Throwable e) {
        ErrorsCounter.methodError(this, errStr, e);
    }

    public MethodInfo getMethodInfo() {
        return this.mthInfo;
    }

    public long getMethodCodeOffset() {
        return this.noCode ? 0L : (long)this.methodData.getCodeOffset();
    }

    public long countInsns() {
        if (this.instructions != null) {
            return this.instructions.length;
        }
        if (this.blocks != null) {
            return this.blocks.stream().mapToLong(block -> block.getInstructions().size()).sum();
        }
        return -1L;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public int hashCode() {
        return this.mthInfo.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodNode other = (MethodNode)obj;
        return this.mthInfo.equals(other.mthInfo);
    }

    public String toString() {
        return this.parentClass + "." + this.mthInfo.getName() + '(' + Utils.listToString(this.mthInfo.getArgumentsTypes()) + "):" + this.retType;
    }
}

