/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.dex.instructions.ConstStringNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class InsnWrapArg
extends InsnArg {
    private final InsnNode wrappedInsn;

    InsnWrapArg(@NotNull InsnNode insn) {
        RegisterArg result = insn.getResult();
        this.type = result != null ? result.getType() : ArgType.UNKNOWN;
        this.wrappedInsn = insn;
    }

    public InsnNode getWrapInsn() {
        return this.wrappedInsn;
    }

    @Override
    public void setParentInsn(InsnNode parentInsn) {
        if (parentInsn == this.wrappedInsn) {
            throw new JadxRuntimeException("Can't wrap instruction info itself: " + parentInsn);
        }
        this.parentInsn = parentInsn;
    }

    @Override
    public InsnArg duplicate() {
        InsnWrapArg copy = new InsnWrapArg(this.wrappedInsn.copy());
        copy.setType(this.type);
        return this.copyCommonParams(copy);
    }

    @Override
    public boolean isInsnWrap() {
        return true;
    }

    public int hashCode() {
        return this.wrappedInsn.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InsnWrapArg)) {
            return false;
        }
        InsnWrapArg that = (InsnWrapArg)o;
        InsnNode thisInsn = this.wrappedInsn;
        InsnNode thatInsn = that.wrappedInsn;
        if (!thisInsn.isSame(thatInsn)) {
            return false;
        }
        int count = thisInsn.getArgsCount();
        for (int i = 0; i < count; ++i) {
            if (thisInsn.getArg(i).equals(thatInsn.getArg(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.wrappedInsn.getType() == InsnType.CONST_STR && Objects.equals(this.type, ArgType.STRING)) {
            return "(\"" + ((ConstStringNode)this.wrappedInsn).getString() + "\")";
        }
        return "(wrap: " + this.type + " : " + this.wrappedInsn + ')';
    }
}

