"""Generated message classes for cloudbuild version v2.

Creates and manages builds on Google Cloud Platform.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudbuild'


class ApprovalConfig(_messages.Message):
  r"""ApprovalConfig describes configuration for manual approval of a build.

  Fields:
    approvalRequired: Whether or not approval is needed. If this is set on a
      build, it will become pending when created, and will need to be
      explicitly approved to start.
  """

  approvalRequired = _messages.BooleanField(1)


class ApprovalResult(_messages.Message):
  r"""ApprovalResult describes the decision and associated metadata of a
  manual approval of a build.

  Enums:
    DecisionValueValuesEnum: Required. The decision of this manual approval.

  Fields:
    approvalTime: Output only. The time when the approval decision was made.
    approverAccount: Output only. Email of the user that called the
      ApproveBuild API to approve or reject a build at the time that the API
      was called.
    comment: Optional. An optional comment for this manual approval result.
    decision: Required. The decision of this manual approval.
    url: Optional. An optional URL tied to this manual approval result. This
      field is essentially the same as comment, except that it will be
      rendered by the UI differently. An example use case is a link to an
      external job that approved this Build.
  """

  class DecisionValueValuesEnum(_messages.Enum):
    r"""Required. The decision of this manual approval.

    Values:
      DECISION_UNSPECIFIED: Default enum type. This should not be used.
      APPROVED: Build is approved.
      REJECTED: Build is rejected.
    """
    DECISION_UNSPECIFIED = 0
    APPROVED = 1
    REJECTED = 2

  approvalTime = _messages.StringField(1)
  approverAccount = _messages.StringField(2)
  comment = _messages.StringField(3)
  decision = _messages.EnumField('DecisionValueValuesEnum', 4)
  url = _messages.StringField(5)


class ArtifactObjects(_messages.Message):
  r"""Files in the workspace to upload to Cloud Storage upon successful
  completion of all build steps.

  Fields:
    location: Cloud Storage bucket and optional object path, in the form
      "gs://bucket/path/to/somewhere/". (see [Bucket Name
      Requirements](https://cloud.google.com/storage/docs/bucket-
      naming#requirements)). Files in the workspace matching any path pattern
      will be uploaded to Cloud Storage with this location as a prefix.
    paths: Path globs used to match files in the build's workspace.
    timing: Output only. Stores timing information for pushing all artifact
      objects.
  """

  location = _messages.StringField(1)
  paths = _messages.StringField(2, repeated=True)
  timing = _messages.MessageField('TimeSpan', 3)


class ArtifactResult(_messages.Message):
  r"""An artifact that was uploaded during a build. This is a single record in
  the artifact manifest JSON file.

  Fields:
    fileHash: The file hash of the artifact.
    location: The path of an artifact in a Google Cloud Storage bucket, with
      the generation number. For example,
      `gs://mybucket/path/to/output.jar#generation`.
  """

  fileHash = _messages.MessageField('FileHashes', 1, repeated=True)
  location = _messages.StringField(2)


class Artifacts(_messages.Message):
  r"""Artifacts produced by a build that should be uploaded upon successful
  completion of all build steps.

  Fields:
    images: A list of images to be pushed upon the successful completion of
      all build steps. The images will be pushed using the builder service
      account's credentials. The digests of the pushed images will be stored
      in the Build resource's results field. If any of the images fail to be
      pushed, the build is marked FAILURE.
    objects: A list of objects to be uploaded to Cloud Storage upon successful
      completion of all build steps. Files in the workspace matching specified
      paths globs will be uploaded to the specified Cloud Storage location
      using the builder service account's credentials. The location and
      generation of the uploaded objects will be stored in the Build
      resource's results field. If any objects fail to be pushed, the build is
      marked FAILURE.
  """

  images = _messages.StringField(1, repeated=True)
  objects = _messages.MessageField('ArtifactObjects', 2)


class BatchCreateBitbucketServerConnectedRepositoriesResponse(_messages.Message):
  r"""Response of BatchCreateBitbucketServerConnectedRepositories RPC method
  including all successfully connected Bitbucket Server repositories.

  Fields:
    bitbucketServerConnectedRepositories: The connected Bitbucket Server
      repositories.
  """

  bitbucketServerConnectedRepositories = _messages.MessageField('BitbucketServerConnectedRepository', 1, repeated=True)


class BatchCreateBitbucketServerConnectedRepositoriesResponseMetadata(_messages.Message):
  r"""Metadata for `BatchCreateBitbucketServerConnectedRepositories`
  operation.

  Fields:
    completeTime: Time the operation was completed.
    config: The name of the `BitbucketServerConfig` that added connected
      repositories. Format: `projects/{project}/locations/{location}/bitbucket
      ServerConfigs/{config}`
    createTime: Time the operation was created.
  """

  completeTime = _messages.StringField(1)
  config = _messages.StringField(2)
  createTime = _messages.StringField(3)


class BitbucketServerConnectedRepository(_messages.Message):
  r"""/ BitbucketServerConnectedRepository represents a connected Bitbucket
  Server / repository.

  Fields:
    parent: The name of the `BitbucketServerConfig` that added connected
      repository. Format: `projects/{project}/locations/{location}/bitbucketSe
      rverConfigs/{config}`
    repo: The Bitbucket Server repositories to connect.
    status: Output only. The status of the repo connection request.
  """

  parent = _messages.StringField(1)
  repo = _messages.MessageField('BitbucketServerRepositoryId', 2)
  status = _messages.MessageField('Status', 3)


class BitbucketServerRepositoryId(_messages.Message):
  r"""BitbucketServerRepositoryId identifies a specific repository hosted on a
  Bitbucket Server.

  Fields:
    projectKey: Required. Identifier for the project storing the repository.
    repoSlug: Required. Identifier for the repository.
    webhookId: Output only. The ID of the webhook that was created for
      receiving events from this repo. We only create and manage a single
      webhook for each repo.
  """

  projectKey = _messages.StringField(1)
  repoSlug = _messages.StringField(2)
  webhookId = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class Build(_messages.Message):
  r"""A build resource in the Cloud Build API. At a high level, a `Build`
  describes where to find source code, how to build it (for example, the
  builder image to run on the source), and where to store the built artifacts.
  Fields can include the following variables, which will be expanded when the
  build is created: - $PROJECT_ID: the project ID of the build. -
  $PROJECT_NUMBER: the project number of the build. - $LOCATION: the
  location/region of the build. - $BUILD_ID: the autogenerated ID of the
  build. - $REPO_NAME: the source repository name specified by RepoSource. -
  $BRANCH_NAME: the branch name specified by RepoSource. - $TAG_NAME: the tag
  name specified by RepoSource. - $REVISION_ID or $COMMIT_SHA: the commit SHA
  specified by RepoSource or resolved from the specified branch or tag. -
  $SHORT_SHA: first 7 characters of $REVISION_ID or $COMMIT_SHA.

  Enums:
    StatusValueValuesEnum: Output only. Status of the build.

  Messages:
    SubstitutionsValue: Substitutions data for `Build` resource.
    TimingValue: Output only. Stores timing information for phases of the
      build. Valid keys are: * BUILD: time to execute all build steps. * PUSH:
      time to push all specified images. * FETCHSOURCE: time to fetch source.
      * SETUPBUILD: time to set up build. If the build does not specify source
      or images, these keys will not be included.

  Fields:
    approval: Output only. Describes this build's approval configuration,
      status, and result.
    artifacts: Artifacts produced by the build that should be uploaded upon
      successful completion of all build steps.
    availableSecrets: Secrets and secret environment variables.
    buildTriggerId: Output only. The ID of the `BuildTrigger` that triggered
      this build, if it was triggered automatically.
    createTime: Output only. Time at which the request to create the build was
      received.
    failureInfo: Output only. Contains information about the build when
      status=FAILURE.
    finishTime: Output only. Time at which execution of the build was
      finished. The difference between finish_time and start_time is the
      duration of the build's execution.
    id: Output only. Unique identifier of the build.
    images: A list of images to be pushed upon the successful completion of
      all build steps. The images are pushed using the builder service
      account's credentials. The digests of the pushed images will be stored
      in the `Build` resource's results field. If any of the images fail to be
      pushed, the build status is marked `FAILURE`.
    logUrl: Output only. URL to logs for this build in Google Cloud Console.
    logsBucket: Google Cloud Storage bucket where logs should be written (see
      [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-
      naming#requirements)). Logs file names will be of the format
      `${logs_bucket}/log-${build_id}.txt`.
    name: Output only. The 'Build' name with format:
      `projects/{project}/locations/{location}/builds/{build}`, where {build}
      is a unique identifier generated by the service.
    options: Special options for this build.
    projectId: Output only. ID of the project.
    queueTtl: TTL in queue for this build. If provided and the build is
      enqueued longer than this value, the build will expire and the build
      status will be `EXPIRED`. The TTL starts ticking from create_time.
    results: Output only. Results of the build.
    secrets: Secrets to decrypt using Cloud Key Management Service. Note:
      Secret Manager is the recommended technique for managing sensitive data
      with Cloud Build. Use `available_secrets` to configure builds to access
      secrets from Secret Manager. For instructions, see:
      https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
    serviceAccount: IAM service account whose credentials will be used at
      build runtime. Must be of the format
      `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. ACCOUNT can be email
      address or uniqueId of the service account.
    source: The location of the source files to build.
    sourceProvenance: Output only. A permanent fixed identifier for source.
    startTime: Output only. Time at which execution of the build was started.
    status: Output only. Status of the build.
    statusDetail: Output only. Customer-readable message about the current
      status.
    steps: Required. The operations to be performed on the workspace.
    substitutions: Substitutions data for `Build` resource.
    tags: Tags for annotation of a `Build`. These are not docker tags.
    timeout: Amount of time that this build should be allowed to run, to
      second granularity. If this amount of time elapses, work on the build
      will cease and the build status will be `TIMEOUT`. `timeout` starts
      ticking from `startTime`. Default time is ten minutes.
    timing: Output only. Stores timing information for phases of the build.
      Valid keys are: * BUILD: time to execute all build steps. * PUSH: time
      to push all specified images. * FETCHSOURCE: time to fetch source. *
      SETUPBUILD: time to set up build. If the build does not specify source
      or images, these keys will not be included.
    warnings: Output only. Non-fatal problems encountered during the execution
      of the build.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Output only. Status of the build.

    Values:
      STATUS_UNKNOWN: Status of the build is unknown.
      PENDING: Build has been created and is pending execution and queuing. It
        has not been queued.
      QUEUED: Build or step is queued; work has not yet begun.
      WORKING: Build or step is being executed.
      SUCCESS: Build or step finished successfully.
      FAILURE: Build or step failed to complete successfully.
      INTERNAL_ERROR: Build or step failed due to an internal cause.
      TIMEOUT: Build or step took longer than was allowed.
      CANCELLED: Build or step was canceled by a user.
      EXPIRED: Build was enqueued for longer than the value of `queue_ttl`.
    """
    STATUS_UNKNOWN = 0
    PENDING = 1
    QUEUED = 2
    WORKING = 3
    SUCCESS = 4
    FAILURE = 5
    INTERNAL_ERROR = 6
    TIMEOUT = 7
    CANCELLED = 8
    EXPIRED = 9

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SubstitutionsValue(_messages.Message):
    r"""Substitutions data for `Build` resource.

    Messages:
      AdditionalProperty: An additional property for a SubstitutionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type SubstitutionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SubstitutionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TimingValue(_messages.Message):
    r"""Output only. Stores timing information for phases of the build. Valid
    keys are: * BUILD: time to execute all build steps. * PUSH: time to push
    all specified images. * FETCHSOURCE: time to fetch source. * SETUPBUILD:
    time to set up build. If the build does not specify source or images,
    these keys will not be included.

    Messages:
      AdditionalProperty: An additional property for a TimingValue object.

    Fields:
      additionalProperties: Additional properties of type TimingValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TimingValue object.

      Fields:
        key: Name of the additional property.
        value: A TimeSpan attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('TimeSpan', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  approval = _messages.MessageField('BuildApproval', 1)
  artifacts = _messages.MessageField('Artifacts', 2)
  availableSecrets = _messages.MessageField('Secrets', 3)
  buildTriggerId = _messages.StringField(4)
  createTime = _messages.StringField(5)
  failureInfo = _messages.MessageField('FailureInfo', 6)
  finishTime = _messages.StringField(7)
  id = _messages.StringField(8)
  images = _messages.StringField(9, repeated=True)
  logUrl = _messages.StringField(10)
  logsBucket = _messages.StringField(11)
  name = _messages.StringField(12)
  options = _messages.MessageField('BuildOptions', 13)
  projectId = _messages.StringField(14)
  queueTtl = _messages.StringField(15)
  results = _messages.MessageField('Results', 16)
  secrets = _messages.MessageField('Secret', 17, repeated=True)
  serviceAccount = _messages.StringField(18)
  source = _messages.MessageField('Source', 19)
  sourceProvenance = _messages.MessageField('SourceProvenance', 20)
  startTime = _messages.StringField(21)
  status = _messages.EnumField('StatusValueValuesEnum', 22)
  statusDetail = _messages.StringField(23)
  steps = _messages.MessageField('BuildStep', 24, repeated=True)
  substitutions = _messages.MessageField('SubstitutionsValue', 25)
  tags = _messages.StringField(26, repeated=True)
  timeout = _messages.StringField(27)
  timing = _messages.MessageField('TimingValue', 28)
  warnings = _messages.MessageField('Warning', 29, repeated=True)


class BuildApproval(_messages.Message):
  r"""BuildApproval describes a build's approval configuration, state, and
  result.

  Enums:
    StateValueValuesEnum: Output only. The state of this build's approval.

  Fields:
    config: Output only. Configuration for manual approval of this build.
    result: Output only. Result of manual approval for this Build.
    state: Output only. The state of this build's approval.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of this build's approval.

    Values:
      STATE_UNSPECIFIED: Default enum type. This should not be used.
      PENDING: Build approval is pending.
      APPROVED: Build approval has been approved.
      REJECTED: Build approval has been rejected.
      CANCELLED: Build was cancelled while it was still pending approval.
    """
    STATE_UNSPECIFIED = 0
    PENDING = 1
    APPROVED = 2
    REJECTED = 3
    CANCELLED = 4

  config = _messages.MessageField('ApprovalConfig', 1)
  result = _messages.MessageField('ApprovalResult', 2)
  state = _messages.EnumField('StateValueValuesEnum', 3)


class BuildOperationMetadata(_messages.Message):
  r"""Metadata for build operations.

  Fields:
    build: The build that the operation is tracking.
  """

  build = _messages.MessageField('Build', 1)


class BuildOptions(_messages.Message):
  r"""Optional arguments to enable specific features of builds.

  Enums:
    LogStreamingOptionValueValuesEnum: Option to define build log streaming
      behavior to Google Cloud Storage.
    LoggingValueValuesEnum: Option to specify the logging mode, which
      determines if and where build logs are stored.
    MachineTypeValueValuesEnum: Compute Engine machine type on which to run
      the build.
    RequestedVerifyOptionValueValuesEnum: Requested verifiability options.
    SourceProvenanceHashValueListEntryValuesEnum:
    SubstitutionOptionValueValuesEnum: Option to specify behavior when there
      is an error in the substitution checks. NOTE: this is always set to
      ALLOW_LOOSE for triggered builds and cannot be overridden in the build
      configuration file.

  Fields:
    diskSizeGb: Requested disk size for the VM that runs the build. Note that
      this is *NOT* "disk free"; some of the space will be used by the
      operating system and build utilities. Also note that this is the minimum
      disk size that will be allocated for the build -- the build may run with
      a larger disk than requested. At present, the maximum disk size is
      1000GB; builds that request more than the maximum are rejected with an
      error.
    dynamicSubstitutions: Option to specify whether or not to apply bash style
      string operations to the substitutions. NOTE: this is always enabled for
      triggered builds and cannot be overridden in the build configuration
      file.
    env: A list of global environment variable definitions that will exist for
      all build steps in this build. If a variable is defined in both globally
      and in a build step, the variable will use the build step value. The
      elements are of the form "KEY=VALUE" for the environment variable "KEY"
      being given the value "VALUE".
    logStreamingOption: Option to define build log streaming behavior to
      Google Cloud Storage.
    logging: Option to specify the logging mode, which determines if and where
      build logs are stored.
    machineType: Compute Engine machine type on which to run the build.
    pool: Optional. Specification for execution on a `WorkerPool`. See
      [running builds in a private
      pool](https://cloud.google.com/build/docs/private-pools/run-builds-in-
      private-pool) for more information.
    requestedVerifyOption: Requested verifiability options.
    secretEnv: A list of global environment variables, which are encrypted
      using a Cloud Key Management Service crypto key. These values must be
      specified in the build's `Secret`. These variables will be available to
      all build steps in this build.
    sourceProvenanceHash: Requested hash for SourceProvenance.
    substitutionOption: Option to specify behavior when there is an error in
      the substitution checks. NOTE: this is always set to ALLOW_LOOSE for
      triggered builds and cannot be overridden in the build configuration
      file.
    volumes: Global list of volumes to mount for ALL build steps Each volume
      is created as an empty volume prior to starting the build process. Upon
      completion of the build, volumes and their contents are discarded.
      Global volume names and paths cannot conflict with the volumes defined a
      build step. Using a global volume in a build with only one step is not
      valid as it is indicative of a build request with an incorrect
      configuration.
    workerPool: This field deprecated; please use `pool.name` instead.
  """

  class LogStreamingOptionValueValuesEnum(_messages.Enum):
    r"""Option to define build log streaming behavior to Google Cloud Storage.

    Values:
      STREAM_DEFAULT: Service may automatically determine build log streaming
        behavior.
      STREAM_ON: Build logs should be streamed to Google Cloud Storage.
      STREAM_OFF: Build logs should not be streamed to Google Cloud Storage;
        they will be written when the build is completed.
    """
    STREAM_DEFAULT = 0
    STREAM_ON = 1
    STREAM_OFF = 2

  class LoggingValueValuesEnum(_messages.Enum):
    r"""Option to specify the logging mode, which determines if and where
    build logs are stored.

    Values:
      LOGGING_UNSPECIFIED: The service determines the logging mode. The
        default is `LEGACY`. Do not rely on the default logging behavior as it
        may change in the future.
      LEGACY: Build logs are stored in Cloud Logging and Cloud Storage.
      GCS_ONLY: Build logs are stored in Cloud Storage.
      STACKDRIVER_ONLY: This option is the same as CLOUD_LOGGING_ONLY.
      CLOUD_LOGGING_ONLY: Build logs are stored in Cloud Logging. Selecting
        this option will not allow [logs
        streaming](https://cloud.google.com/sdk/gcloud/reference/builds/log).
      NONE: Turn off all logging. No build logs will be captured.
    """
    LOGGING_UNSPECIFIED = 0
    LEGACY = 1
    GCS_ONLY = 2
    STACKDRIVER_ONLY = 3
    CLOUD_LOGGING_ONLY = 4
    NONE = 5

  class MachineTypeValueValuesEnum(_messages.Enum):
    r"""Compute Engine machine type on which to run the build.

    Values:
      UNSPECIFIED: Standard machine type.
      N1_HIGHCPU_8: Highcpu machine with 8 CPUs.
      N1_HIGHCPU_32: Highcpu machine with 32 CPUs.
      E2_HIGHCPU_8: Highcpu e2 machine with 8 CPUs.
      E2_HIGHCPU_32: Highcpu e2 machine with 32 CPUs.
    """
    UNSPECIFIED = 0
    N1_HIGHCPU_8 = 1
    N1_HIGHCPU_32 = 2
    E2_HIGHCPU_8 = 3
    E2_HIGHCPU_32 = 4

  class RequestedVerifyOptionValueValuesEnum(_messages.Enum):
    r"""Requested verifiability options.

    Values:
      NOT_VERIFIED: Not a verifiable build. (default)
      VERIFIED: Verified build.
    """
    NOT_VERIFIED = 0
    VERIFIED = 1

  class SourceProvenanceHashValueListEntryValuesEnum(_messages.Enum):
    r"""SourceProvenanceHashValueListEntryValuesEnum enum type.

    Values:
      NONE: No hash requested.
      SHA256: Use a sha256 hash.
      MD5: Use a md5 hash.
    """
    NONE = 0
    SHA256 = 1
    MD5 = 2

  class SubstitutionOptionValueValuesEnum(_messages.Enum):
    r"""Option to specify behavior when there is an error in the substitution
    checks. NOTE: this is always set to ALLOW_LOOSE for triggered builds and
    cannot be overridden in the build configuration file.

    Values:
      MUST_MATCH: Fails the build if error in substitutions checks, like
        missing a substitution in the template or in the map.
      ALLOW_LOOSE: Do not fail the build if error in substitutions checks.
    """
    MUST_MATCH = 0
    ALLOW_LOOSE = 1

  diskSizeGb = _messages.IntegerField(1)
  dynamicSubstitutions = _messages.BooleanField(2)
  env = _messages.StringField(3, repeated=True)
  logStreamingOption = _messages.EnumField('LogStreamingOptionValueValuesEnum', 4)
  logging = _messages.EnumField('LoggingValueValuesEnum', 5)
  machineType = _messages.EnumField('MachineTypeValueValuesEnum', 6)
  pool = _messages.MessageField('PoolOption', 7)
  requestedVerifyOption = _messages.EnumField('RequestedVerifyOptionValueValuesEnum', 8)
  secretEnv = _messages.StringField(9, repeated=True)
  sourceProvenanceHash = _messages.EnumField('SourceProvenanceHashValueListEntryValuesEnum', 10, repeated=True)
  substitutionOption = _messages.EnumField('SubstitutionOptionValueValuesEnum', 11)
  volumes = _messages.MessageField('Volume', 12, repeated=True)
  workerPool = _messages.StringField(13)


class BuildStep(_messages.Message):
  r"""A step in the build pipeline.

  Enums:
    StatusValueValuesEnum: Output only. Status of the build step. At this
      time, build step status is only updated on build completion; step status
      is not updated in real-time as the build progresses.

  Fields:
    args: A list of arguments that will be presented to the step when it is
      started. If the image used to run the step's container has an
      entrypoint, the `args` are used as arguments to that entrypoint. If the
      image does not define an entrypoint, the first element in args is used
      as the entrypoint, and the remainder will be used as arguments.
    dir: Working directory to use when running this step's container. If this
      value is a relative path, it is relative to the build's working
      directory. If this value is absolute, it may be outside the build's
      working directory, in which case the contents of the path may not be
      persisted across build step executions, unless a `volume` for that path
      is specified. If the build specifies a `RepoSource` with `dir` and a
      step with a `dir`, which specifies an absolute path, the `RepoSource`
      `dir` is ignored for the step's execution.
    entrypoint: Entrypoint to be used instead of the build step image's
      default entrypoint. If unset, the image's default entrypoint is used.
    env: A list of environment variable definitions to be used when running a
      step. The elements are of the form "KEY=VALUE" for the environment
      variable "KEY" being given the value "VALUE".
    id: Unique identifier for this build step, used in `wait_for` to reference
      this build step as a dependency.
    name: Required. The name of the container image that will run this
      particular build step. If the image is available in the host's Docker
      daemon's cache, it will be run directly. If not, the host will attempt
      to pull the image first, using the builder service account's credentials
      if necessary. The Docker daemon's cache will already have the latest
      versions of all of the officially supported build steps
      ([https://github.com/GoogleCloudPlatform/cloud-
      builders](https://github.com/GoogleCloudPlatform/cloud-builders)). The
      Docker daemon will also have cached many of the layers for some popular
      images, like "ubuntu", "debian", but they will be refreshed at the time
      you attempt to use them. If you built an image in a previous build step,
      it will be stored in the host's Docker daemon's cache and is available
      to use as the name for a later build step.
    pullTiming: Output only. Stores timing information for pulling this build
      step's builder image only.
    script: A shell script to be executed in the step. When script is
      provided, the user cannot specify the entrypoint or args.
    secretEnv: A list of environment variables which are encrypted using a
      Cloud Key Management Service crypto key. These values must be specified
      in the build's `Secret`.
    status: Output only. Status of the build step. At this time, build step
      status is only updated on build completion; step status is not updated
      in real-time as the build progresses.
    timeout: Time limit for executing this build step. If not defined, the
      step has no time limit and will be allowed to continue to run until
      either it completes or the build itself times out.
    timing: Output only. Stores timing information for executing this build
      step.
    volumes: List of volumes to mount into the build step. Each volume is
      created as an empty volume prior to execution of the build step. Upon
      completion of the build, volumes and their contents are discarded. Using
      a named volume in only one step is not valid as it is indicative of a
      build request with an incorrect configuration.
    waitFor: The ID(s) of the step(s) that this build step depends on. This
      build step will not start until all the build steps in `wait_for` have
      completed successfully. If `wait_for` is empty, this build step will
      start when all previous build steps in the `Build.Steps` list have
      completed successfully.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Output only. Status of the build step. At this time, build step status
    is only updated on build completion; step status is not updated in real-
    time as the build progresses.

    Values:
      STATUS_UNKNOWN: Status of the build is unknown.
      PENDING: Build has been created and is pending execution and queuing. It
        has not been queued.
      QUEUED: Build or step is queued; work has not yet begun.
      WORKING: Build or step is being executed.
      SUCCESS: Build or step finished successfully.
      FAILURE: Build or step failed to complete successfully.
      INTERNAL_ERROR: Build or step failed due to an internal cause.
      TIMEOUT: Build or step took longer than was allowed.
      CANCELLED: Build or step was canceled by a user.
      EXPIRED: Build was enqueued for longer than the value of `queue_ttl`.
    """
    STATUS_UNKNOWN = 0
    PENDING = 1
    QUEUED = 2
    WORKING = 3
    SUCCESS = 4
    FAILURE = 5
    INTERNAL_ERROR = 6
    TIMEOUT = 7
    CANCELLED = 8
    EXPIRED = 9

  args = _messages.StringField(1, repeated=True)
  dir = _messages.StringField(2)
  entrypoint = _messages.StringField(3)
  env = _messages.StringField(4, repeated=True)
  id = _messages.StringField(5)
  name = _messages.StringField(6)
  pullTiming = _messages.MessageField('TimeSpan', 7)
  script = _messages.StringField(8)
  secretEnv = _messages.StringField(9, repeated=True)
  status = _messages.EnumField('StatusValueValuesEnum', 10)
  timeout = _messages.StringField(11)
  timing = _messages.MessageField('TimeSpan', 12)
  volumes = _messages.MessageField('Volume', 13, repeated=True)
  waitFor = _messages.StringField(14, repeated=True)


class BuiltImage(_messages.Message):
  r"""An image built by the pipeline.

  Fields:
    digest: Docker Registry 2.0 digest.
    name: Name used to push the container image to Google Container Registry,
      as presented to `docker push`.
    pushTiming: Output only. Stores timing information for pushing the
      specified image.
  """

  digest = _messages.StringField(1)
  name = _messages.StringField(2)
  pushTiming = _messages.MessageField('TimeSpan', 3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudbuildProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudbuildProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CloudbuildProjectsLocationsPipelineRunsCreateRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsPipelineRunsCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    pipelineRun: A PipelineRun resource to be passed as the request body.
    pipelineRunId: Required. The ID to use for the PipelineRun, which will
      become the final component of the PipelineRun's resource name. Names
      must be unique per-project per-location. This value should be 4-63
      characters, and valid characters are /a-z-/.
    validateOnly: Optional. When true, the query is validated only, but not
      executed.
  """

  parent = _messages.StringField(1, required=True)
  pipelineRun = _messages.MessageField('PipelineRun', 2)
  pipelineRunId = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class CloudbuildProjectsLocationsPipelineRunsGetRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsPipelineRunsGetRequest object.

  Fields:
    name: Required. The name of the PipelineRun to retrieve. Format:
      projects/{project}/locations/{location}/pipelineRuns/{pipelineRun}
  """

  name = _messages.StringField(1, required=True)


class CloudbuildProjectsLocationsPipelineRunsListRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsPipelineRunsListRequest object.

  Fields:
    filter: Filter for the results.
    pageSize: Number of results to return in the list.
    pageToken: Page start.
    parent: Required. The parent, which owns this collection of PipelineRuns.
      Format: projects/{project}/locations/{location}
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class CloudbuildProjectsLocationsPipelineRunsPatchRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsPipelineRunsPatchRequest object.

  Fields:
    allowMissing: Optional. If set to true, and the PipelineRun is not found,
      a new PipelineRun will be created. In this situation, `update_mask` is
      ignored.
    name: Output only. The `PipelineRun` name with format
      `projects/{project}/locations/{location}/pipelineRuns/{pipeline_run}`
    pipelineRun: A PipelineRun resource to be passed as the request body.
    updateMask: Required. The list of fields to be updated.
    validateOnly: Optional. When true, the query is validated only, but not
      executed.
  """

  allowMissing = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  pipelineRun = _messages.MessageField('PipelineRun', 3)
  updateMask = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class CloudbuildProjectsLocationsResultsGetRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsResultsGetRequest object.

  Fields:
    name: Required. The name of the Result to retrieve. Format:
      projects/{project}/locations/{location}/results/{result}
  """

  name = _messages.StringField(1, required=True)


class CloudbuildProjectsLocationsResultsListRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsResultsListRequest object.

  Fields:
    filter: Filter for the Records.
    pageSize: Size of the page to return.
    pageToken: Page start.
    parent: Required. The parent, which owns this collection of Results.
      Format: projects/{project}/locations/{location}/
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class CloudbuildProjectsLocationsResultsRecordsGetRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsResultsRecordsGetRequest object.

  Fields:
    name: Required. The name of the Record to retrieve. Format:
      projects/{project}/locations/{location}/results/{result}/records/{record
      }
  """

  name = _messages.StringField(1, required=True)


class CloudbuildProjectsLocationsResultsRecordsListRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsResultsRecordsListRequest object.

  Fields:
    filter: Filter for the Records.
    pageSize: Size of the page to return.
    pageToken: Page start.
    parent: Required. The parent, which owns this collection of Records.
      Format: projects/{project}/locations/{location}/results/{result}/
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class CloudbuildProjectsLocationsTaskRunsCreateRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsTaskRunsCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    taskRun: A TaskRun resource to be passed as the request body.
    taskRunId: Required. The ID to use for the TaskRun, which will become the
      final component of the TaskRun's resource name. Names must be unique
      per-project per-location. This value should be 4-63 characters, and
      valid characters are /a-z-/.
    validateOnly: Optional. When true, the query is validated only, but not
      executed.
  """

  parent = _messages.StringField(1, required=True)
  taskRun = _messages.MessageField('TaskRun', 2)
  taskRunId = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class CloudbuildProjectsLocationsTaskRunsGetRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsTaskRunsGetRequest object.

  Fields:
    name: Required. The name of the TaskRun to retrieve. Format:
      projects/{project}/locations/{location}/taskRuns/{taskRun}
  """

  name = _messages.StringField(1, required=True)


class CloudbuildProjectsLocationsTaskRunsListRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsTaskRunsListRequest object.

  Fields:
    filter: Filter for the results.
    pageSize: Number of results to return in the list.
    pageToken: Page start.
    parent: Required. The parent, which owns this collection of TaskRuns.
      Format: projects/{project}/locations/{location}
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class CloudbuildProjectsLocationsTaskRunsPatchRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsTaskRunsPatchRequest object.

  Fields:
    allowMissing: Optional. If set to true, and the TaskRun is not found, a
      new TaskRun will be created. In this situation, `update_mask` is
      ignored.
    name: Output only. The 'TaskRun' name with format:
      `projects/{project}/locations/{location}/taskRuns/{task_run}`
    taskRun: A TaskRun resource to be passed as the request body.
    updateMask: Required. The list of fields to be updated.
    validateOnly: Optional. When true, the query is validated only, but not
      executed.
  """

  allowMissing = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  taskRun = _messages.MessageField('TaskRun', 3)
  updateMask = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class CloudbuildProjectsLocationsWorkflowsCreateRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsWorkflowsCreateRequest object.

  Fields:
    parent: Required. Format: `projects/{project}/locations/{location}`
    validateOnly: When true, the query is validated only, but not executed.
    workflow: A Workflow resource to be passed as the request body.
    workflowId: Required. The ID to use for the Workflow, which will become
      the final component of the Workflow's resource name.
  """

  parent = _messages.StringField(1, required=True)
  validateOnly = _messages.BooleanField(2)
  workflow = _messages.MessageField('Workflow', 3)
  workflowId = _messages.StringField(4)


class CloudbuildProjectsLocationsWorkflowsDeleteRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsWorkflowsDeleteRequest object.

  Fields:
    etag: The etag of the workflow. If this is provided, it must match the
      server's etag.
    name: Required. Format:
      `projects/{project}/locations/{location}/workflow/{workflow}`
    validateOnly: When true, the query is validated only, but not executed.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class CloudbuildProjectsLocationsWorkflowsGetRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsWorkflowsGetRequest object.

  Fields:
    name: Required. Format:
      `projects/{project}/locations/{location}/workflow/{workflow}`
  """

  name = _messages.StringField(1, required=True)


class CloudbuildProjectsLocationsWorkflowsListRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsWorkflowsListRequest object.

  Fields:
    filter: Filter for the results.
    orderBy: The order to sort results by.
    pageSize: Number of results to return in the list.
    pageToken: Page start.
    parent: Required. Format: `projects/{project}/locations/{location}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudbuildProjectsLocationsWorkflowsPatchRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsWorkflowsPatchRequest object.

  Fields:
    allowMissing: If set to true, and the workflow is not found, a new
      workflow will be created. In this situation, `update_mask` is ignored.
    name: Output only. Format:
      `projects/{project}/locations/{location}/workflows/{workflow}`
    updateMask: The list of fields to be updated.
    validateOnly: When true, the query is validated only, but not executed.
    workflow: A Workflow resource to be passed as the request body.
  """

  allowMissing = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)
  workflow = _messages.MessageField('Workflow', 5)


class CloudbuildProjectsLocationsWorkflowsRunRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsWorkflowsRunRequest object.

  Fields:
    name: Required. Format:
      `projects/{project}/locations/{location}/workflow/{workflow}`
    runWorkflowRequest: A RunWorkflowRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  runWorkflowRequest = _messages.MessageField('RunWorkflowRequest', 2)


class Condition(_messages.Message):
  r"""Conditions defines a readiness condition for a Knative resource.

  Enums:
    SeverityValueValuesEnum: Severity with which to treat failures of this
      type of condition.
    StatusValueValuesEnum: Status of the condition.

  Fields:
    lastTransitionTime: LastTransitionTime is the last time the condition
      transitioned from one status to another.
    message: A human readable message indicating details about the transition.
    reason: The reason for the condition's last transition.
    severity: Severity with which to treat failures of this type of condition.
    status: Status of the condition.
    type: Type of condition.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Severity with which to treat failures of this type of condition.

    Values:
      SEVERITY_UNSPECIFIED: Default enum type; should not be used.
      WARNING: Severity is warning.
      INFO: Severity is informational only.
    """
    SEVERITY_UNSPECIFIED = 0
    WARNING = 1
    INFO = 2

  class StatusValueValuesEnum(_messages.Enum):
    r"""Status of the condition.

    Values:
      UNKNOWN: Default enum type indicating execution is still ongoing.
      TRUE: Success
      FALSE: Failure
    """
    UNKNOWN = 0
    TRUE = 1
    FALSE = 2

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  severity = _messages.EnumField('SeverityValueValuesEnum', 4)
  status = _messages.EnumField('StatusValueValuesEnum', 5)
  type = _messages.StringField(6)


class ContainerStateRunning(_messages.Message):
  r"""ContainerStateWaiting is a running state of a container.

  Fields:
    startedAt: Time at which the container was last (re-)started.
  """

  startedAt = _messages.StringField(1)


class ContainerStateTerminated(_messages.Message):
  r"""ContainerStateWaiting is a terminated state of a container.

  Fields:
    exitCode: Exit status from the last termination of the container.
    finishedAt: Time at which the container last terminated
    message: Message regarding the last termination of the container
    reason: Reason from the last termination of the container
    startedAt: Time at which previous execution of the container started
  """

  exitCode = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  finishedAt = _messages.StringField(2)
  message = _messages.StringField(3)
  reason = _messages.StringField(4)
  startedAt = _messages.StringField(5)


class ContainerStateWaiting(_messages.Message):
  r"""ContainerStateWaiting is a waiting state of a container.

  Fields:
    message: Message regarding why the container is not yet running.
    reason: Reason the container is not yet running.
  """

  message = _messages.StringField(1)
  reason = _messages.StringField(2)


class CreateBitbucketServerConfigOperationMetadata(_messages.Message):
  r"""Metadata for `CreateBitbucketServerConfig` operation.

  Fields:
    bitbucketServerConfig: The resource name of the BitbucketServerConfig to
      be created. Format:
      `projects/{project}/locations/{location}/bitbucketServerConfigs/{id}`.
    completeTime: Time the operation was completed.
    createTime: Time the operation was created.
  """

  bitbucketServerConfig = _messages.StringField(1)
  completeTime = _messages.StringField(2)
  createTime = _messages.StringField(3)


class CreateGitHubEnterpriseConfigOperationMetadata(_messages.Message):
  r"""Metadata for `CreateGithubEnterpriseConfig` operation.

  Fields:
    completeTime: Time the operation was completed.
    createTime: Time the operation was created.
    githubEnterpriseConfig: The resource name of the GitHubEnterprise to be
      created. Format:
      `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`.
  """

  completeTime = _messages.StringField(1)
  createTime = _messages.StringField(2)
  githubEnterpriseConfig = _messages.StringField(3)


class CreateGitLabConfigOperationMetadata(_messages.Message):
  r"""Metadata for `CreateGitLabConfig` operation.

  Fields:
    completeTime: Time the operation was completed.
    createTime: Time the operation was created.
    gitlabConfig: The resource name of the GitLabConfig to be created. Format:
      `projects/{project}/locations/{location}/gitlabConfigs/{id}`.
  """

  completeTime = _messages.StringField(1)
  createTime = _messages.StringField(2)
  gitlabConfig = _messages.StringField(3)


class CreateWorkerPoolOperationMetadata(_messages.Message):
  r"""Metadata for the `CreateWorkerPool` operation.

  Fields:
    completeTime: Time the operation was completed.
    createTime: Time the operation was created.
    workerPool: The resource name of the `WorkerPool` to create. Format:
      `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
  """

  completeTime = _messages.StringField(1)
  createTime = _messages.StringField(2)
  workerPool = _messages.StringField(3)


class DeleteBitbucketServerConfigOperationMetadata(_messages.Message):
  r"""Metadata for `DeleteBitbucketServerConfig` operation.

  Fields:
    bitbucketServerConfig: The resource name of the BitbucketServerConfig to
      be deleted. Format:
      `projects/{project}/locations/{location}/bitbucketServerConfigs/{id}`.
    completeTime: Time the operation was completed.
    createTime: Time the operation was created.
  """

  bitbucketServerConfig = _messages.StringField(1)
  completeTime = _messages.StringField(2)
  createTime = _messages.StringField(3)


class DeleteGitHubEnterpriseConfigOperationMetadata(_messages.Message):
  r"""Metadata for `DeleteGitHubEnterpriseConfig` operation.

  Fields:
    completeTime: Time the operation was completed.
    createTime: Time the operation was created.
    githubEnterpriseConfig: The resource name of the GitHubEnterprise to be
      deleted. Format:
      `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`.
  """

  completeTime = _messages.StringField(1)
  createTime = _messages.StringField(2)
  githubEnterpriseConfig = _messages.StringField(3)


class DeleteGitLabConfigOperationMetadata(_messages.Message):
  r"""Metadata for `DeleteGitLabConfig` operation.

  Fields:
    completeTime: Time the operation was completed.
    createTime: Time the operation was created.
    gitlabConfig: The resource name of the GitLabConfig to be created. Format:
      `projects/{project}/locations/{location}/gitlabConfigs/{id}`.
  """

  completeTime = _messages.StringField(1)
  createTime = _messages.StringField(2)
  gitlabConfig = _messages.StringField(3)


class DeleteWorkerPoolOperationMetadata(_messages.Message):
  r"""Metadata for the `DeleteWorkerPool` operation.

  Fields:
    completeTime: Time the operation was completed.
    createTime: Time the operation was created.
    workerPool: The resource name of the `WorkerPool` being deleted. Format:
      `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
  """

  completeTime = _messages.StringField(1)
  createTime = _messages.StringField(2)
  workerPool = _messages.StringField(3)


class EmbeddedTask(_messages.Message):
  r"""EmbeddedTask defines a Task that is embedded in a Pipeline.

  Messages:
    AnnotationsValue: User annotations. See
      https://google.aip.dev/128#annotations
    LabelsValue: Map of key-value pairs of user-defined labels.

  Fields:
    annotations: User annotations. See https://google.aip.dev/128#annotations
    labels: Map of key-value pairs of user-defined labels.
    taskSpec: Spec to instantiate this TaskRun.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""User annotations. See https://google.aip.dev/128#annotations

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Map of key-value pairs of user-defined labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  labels = _messages.MessageField('LabelsValue', 2)
  taskSpec = _messages.MessageField('TaskSpec', 3)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class EmptyDir(_messages.Message):
  r"""Represents an empty directory"""


class EmptyDirVolumeSource(_messages.Message):
  r"""Represents an empty Volume source."""


class EnvVar(_messages.Message):
  r"""Environment variable.

  Fields:
    name: Name of the environment variable.
    value: Value of the environment variable.
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class ExecutionEnvironment(_messages.Message):
  r"""Contains the workerpool.

  Fields:
    workerPool: Required. The workerpool used to run the PipelineRun.
  """

  workerPool = _messages.StringField(1)


class FailureInfo(_messages.Message):
  r"""A fatal problem encountered during the execution of the build.

  Enums:
    TypeValueValuesEnum: The name of the failure.

  Fields:
    detail: Explains the failure issue in more detail using hard-coded text.
    type: The name of the failure.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The name of the failure.

    Values:
      FAILURE_TYPE_UNSPECIFIED: Type unspecified
      PUSH_FAILED: Unable to push the image to the repository.
      PUSH_IMAGE_NOT_FOUND: Final image not found.
      PUSH_NOT_AUTHORIZED: Unauthorized push of the final image.
      LOGGING_FAILURE: Backend logging failures. Should retry.
      USER_BUILD_STEP: A build step has failed.
      FETCH_SOURCE_FAILED: The source fetching has failed.
    """
    FAILURE_TYPE_UNSPECIFIED = 0
    PUSH_FAILED = 1
    PUSH_IMAGE_NOT_FOUND = 2
    PUSH_NOT_AUTHORIZED = 3
    LOGGING_FAILURE = 4
    USER_BUILD_STEP = 5
    FETCH_SOURCE_FAILED = 6

  detail = _messages.StringField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class FileHashes(_messages.Message):
  r"""Container message for hashes of byte content of files, used in
  SourceProvenance messages to verify integrity of source input to the build.

  Fields:
    fileHash: Collection of file hashes.
  """

  fileHash = _messages.MessageField('Hash', 1, repeated=True)


class GCEPersistentDiskVolumeSource(_messages.Message):
  r"""Represents a Compute Engine Disk resource that is attached to a
  kubelet's host machine and then exposed to the pod. More info:
  https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

  Fields:
    fsType: Filesystem type of the volume that you want to mount.
    partition: The partition in the volume that you want to mount. If omitted,
      the default is to mount by volume name.
    pdName: Unique name of the PD resource in Compute Engine. Used to identify
      the disk.
    readOnly: ReadOnly here will force the ReadOnly setting in VolumeMounts.
      Defaults to false.
  """

  fsType = _messages.StringField(1)
  partition = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pdName = _messages.StringField(3)
  readOnly = _messages.BooleanField(4)


class GoogleDevtoolsCloudbuildV2OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class GoogleDevtoolsCloudbuildV2SecretManagerSecret(_messages.Message):
  r"""Pairs a secret environment variable with a SecretVersion in Secret
  Manager.

  Fields:
    env: Environment variable name to associate with the secret.
    secretVersion: Resource name of the SecretVersion. In format:
      projects/*/secrets/*/versions/*
  """

  env = _messages.StringField(1)
  secretVersion = _messages.StringField(2)


class HTTPDelivery(_messages.Message):
  r"""HTTPDelivery is the delivery configuration for an HTTP notification.

  Fields:
    uri: The URI to which JSON-containing HTTP POST requests should be sent.
  """

  uri = _messages.StringField(1)


class Hash(_messages.Message):
  r"""Container message for hash values.

  Enums:
    TypeValueValuesEnum: The type of hash that was performed.

  Fields:
    type: The type of hash that was performed.
    value: The hash value.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of hash that was performed.

    Values:
      NONE: No hash requested.
      SHA256: Use a sha256 hash.
      MD5: Use a md5 hash.
    """
    NONE = 0
    SHA256 = 1
    MD5 = 2

  type = _messages.EnumField('TypeValueValuesEnum', 1)
  value = _messages.BytesField(2)


class InlineSecret(_messages.Message):
  r"""Pairs a set of secret environment variables mapped to encrypted values
  with the Cloud KMS key to use to decrypt the value.

  Messages:
    EnvMapValue: Map of environment variable name to its encrypted value.
      Secret environment variables must be unique across all of a build's
      secrets, and must be used by at least one build step. Values can be at
      most 64 KB in size. There can be at most 100 secret values across all of
      a build's secrets.

  Fields:
    envMap: Map of environment variable name to its encrypted value. Secret
      environment variables must be unique across all of a build's secrets,
      and must be used by at least one build step. Values can be at most 64 KB
      in size. There can be at most 100 secret values across all of a build's
      secrets.
    kmsKeyName: Resource name of Cloud KMS crypto key to decrypt the encrypted
      value. In format: projects/*/locations/*/keyRings/*/cryptoKeys/*
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EnvMapValue(_messages.Message):
    r"""Map of environment variable name to its encrypted value. Secret
    environment variables must be unique across all of a build's secrets, and
    must be used by at least one build step. Values can be at most 64 KB in
    size. There can be at most 100 secret values across all of a build's
    secrets.

    Messages:
      AdditionalProperty: An additional property for a EnvMapValue object.

    Fields:
      additionalProperties: Additional properties of type EnvMapValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a EnvMapValue object.

      Fields:
        key: Name of the additional property.
        value: A byte attribute.
      """

      key = _messages.StringField(1)
      value = _messages.BytesField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  envMap = _messages.MessageField('EnvMapValue', 1)
  kmsKeyName = _messages.StringField(2)


class JsonAny(_messages.Message):
  r"""JSON serialized data.

  Fields:
    type: Identifier of underlying data. e.g.
      `cloudbuild.googleapis.com/PipelineRun`
    value: JSON-serialized data of above type.
  """

  type = _messages.StringField(1)
  value = _messages.BytesField(2)


class ListPipelineRunsResponse(_messages.Message):
  r"""Message for response to listing PipelineRuns

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    pipelineRuns: The list of PipelineRun
  """

  nextPageToken = _messages.StringField(1)
  pipelineRuns = _messages.MessageField('PipelineRun', 2, repeated=True)


class ListRecordsResponse(_messages.Message):
  r"""Message for response to listing Records.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    records: The list of Records.
  """

  nextPageToken = _messages.StringField(1)
  records = _messages.MessageField('Record', 2, repeated=True)


class ListResultsResponse(_messages.Message):
  r"""Message for response to listing Results.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    results: The list of Results.
  """

  nextPageToken = _messages.StringField(1)
  results = _messages.MessageField('Result', 2, repeated=True)


class ListTaskRunsResponse(_messages.Message):
  r"""Message for response to listing TaskRuns

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    taskRuns: The list of TaskRun
  """

  nextPageToken = _messages.StringField(1)
  taskRuns = _messages.MessageField('TaskRun', 2, repeated=True)


class ListWorkflowsResponse(_messages.Message):
  r"""Message for response to listing Workflows.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    workflows: The list of Workflows.
  """

  nextPageToken = _messages.StringField(1)
  workflows = _messages.MessageField('Workflow', 2, repeated=True)


class Notification(_messages.Message):
  r"""Notification is the container which holds the data that is relevant to
  this particular notification.

  Messages:
    StructDeliveryValue: Escape hatch for users to supply custom delivery
      configs.

  Fields:
    filter: The filter string to use for notification filtering. Currently,
      this is assumed to be a CEL program. See
      https://opensource.google/projects/cel for more.
    httpDelivery: Configuration for HTTP delivery.
    slackDelivery: Configuration for Slack delivery.
    smtpDelivery: Configuration for SMTP (email) delivery.
    structDelivery: Escape hatch for users to supply custom delivery configs.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class StructDeliveryValue(_messages.Message):
    r"""Escape hatch for users to supply custom delivery configs.

    Messages:
      AdditionalProperty: An additional property for a StructDeliveryValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a StructDeliveryValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  filter = _messages.StringField(1)
  httpDelivery = _messages.MessageField('HTTPDelivery', 2)
  slackDelivery = _messages.MessageField('SlackDelivery', 3)
  smtpDelivery = _messages.MessageField('SMTPDelivery', 4)
  structDelivery = _messages.MessageField('StructDeliveryValue', 5)


class NotifierConfig(_messages.Message):
  r"""NotifierConfig is the top-level configuration message.

  Fields:
    apiVersion: The API version of this configuration format.
    kind: The type of notifier to use (e.g. SMTPNotifier).
    metadata: Metadata for referring to/handling/deploying this notifier.
    spec: The actual configuration for this notifier.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('NotifierMetadata', 3)
  spec = _messages.MessageField('NotifierSpec', 4)


class NotifierMetadata(_messages.Message):
  r"""NotifierMetadata contains the data which can be used to reference or
  describe this notifier.

  Fields:
    name: The human-readable and user-given name for the notifier. For
      example: "repo-merge-email-notifier".
    notifier: The string representing the name and version of notifier to
      deploy. Expected to be of the form of "/:". For example: "gcr.io/my-
      project/notifiers/smtp:1.2.34".
  """

  name = _messages.StringField(1)
  notifier = _messages.StringField(2)


class NotifierSecret(_messages.Message):
  r"""NotifierSecret is the container that maps a secret name (reference) to
  its Google Cloud Secret Manager resource path.

  Fields:
    name: Name is the local name of the secret, such as the verbatim string
      "my-smtp-password".
    value: Value is interpreted to be a resource path for fetching the actual
      (versioned) secret data for this secret. For example, this would be a
      Google Cloud Secret Manager secret version resource path like:
      "projects/my-project/secrets/my-secret/versions/latest".
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class NotifierSecretRef(_messages.Message):
  r"""NotifierSecretRef contains the reference to a secret stored in the
  corresponding NotifierSpec.

  Fields:
    secretRef: The value of `secret_ref` should be a `name` that is registered
      in a `Secret` in the `secrets` list of the `Spec`.
  """

  secretRef = _messages.StringField(1)


class NotifierSpec(_messages.Message):
  r"""NotifierSpec is the configuration container for notifications.

  Fields:
    notification: The configuration of this particular notifier.
    secrets: Configurations for secret resources used by this particular
      notifier.
  """

  notification = _messages.MessageField('Notification', 1)
  secrets = _messages.MessageField('NotifierSecret', 2, repeated=True)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    cancelRequested: Output only. Identifies whether the user has requested
      cancellation of the operation. Operations that have been cancelled
      successfully have Operation.error value with a google.rpc.Status.code of
      1, corresponding to `Code.CANCELLED`.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    statusDetail: Output only. Human-readable status of the operation, if any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  cancelRequested = _messages.BooleanField(2)
  createTime = _messages.StringField(3)
  endTime = _messages.StringField(4)
  statusDetail = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Param(_messages.Message):
  r"""Param defined with name and value. PipelineRef can be used to refer to a
  specific instance of a Pipeline.

  Fields:
    name: Name of the parameter.
    value: Value of the parameter.
  """

  name = _messages.StringField(1)
  value = _messages.MessageField('ParamValue', 2)


class ParamSpec(_messages.Message):
  r"""ParamSpec defines parameters needed beyond typed inputs (such as
  resources). Parameter values are provided by users as inputs on a TaskRun or
  PipelineRun.

  Enums:
    TypeValueValuesEnum: Type of ParamSpec

  Fields:
    default: The default value a parameter takes if no input value is supplied
    description: Description of the ParamSpec
    name: Name of the ParamSpec
    type: Type of ParamSpec
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of ParamSpec

    Values:
      TYPE_UNSPECIFIED: Default enum type; should not be used.
      STRING: Default
      ARRAY: Arrary type.
    """
    TYPE_UNSPECIFIED = 0
    STRING = 1
    ARRAY = 2

  default = _messages.MessageField('ParamValue', 1)
  description = _messages.StringField(2)
  name = _messages.StringField(3)
  type = _messages.EnumField('TypeValueValuesEnum', 4)


class ParamValue(_messages.Message):
  r"""Parameter value.

  Enums:
    TypeValueValuesEnum: Type of parameter.

  Fields:
    arrayVal: Value of the parameter if type is array.
    stringVal: Value of the parameter if type is string.
    type: Type of parameter.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of parameter.

    Values:
      TYPE_UNSPECIFIED: Default enum type; should not be used.
      STRING: Default
      ARRAY: Array type
    """
    TYPE_UNSPECIFIED = 0
    STRING = 1
    ARRAY = 2

  arrayVal = _messages.StringField(1, repeated=True)
  stringVal = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class PersistentVolumeClaim(_messages.Message):
  r"""PersistentVolumeClaim is a user's request for and claim to a persistent
  volume

  Fields:
    spec: Spec defines the desired characteristics of a volume requested by a
      pod author.
  """

  spec = _messages.MessageField('PersistentVolumeClaimSpec', 1)


class PersistentVolumeClaimSpec(_messages.Message):
  r"""PersistentVolumeClaimSpec describes the common attributes of storage
  devices and allows a Source for provider-specific attributes.

  Enums:
    AccessModesValueListEntryValuesEnum:

  Fields:
    accessModes: Desired access modes the volume should have.
    resources: The minimum resources the volume should have.
  """

  class AccessModesValueListEntryValuesEnum(_messages.Enum):
    r"""AccessModesValueListEntryValuesEnum enum type.

    Values:
      PERSISTENT_VOLUME_ACCESS_MODE_UNSPECIFIED: Default enum type; should not
        be used.
      READ_WRITE_ONCE: can be mounted in read/write mode to exactly 1 host
      READ_ONLY_MANY: can be mounted in read-only mode to many hosts
      READ_WRITE_MANY: can be mounted in read/write mode to many hosts
    """
    PERSISTENT_VOLUME_ACCESS_MODE_UNSPECIFIED = 0
    READ_WRITE_ONCE = 1
    READ_ONLY_MANY = 2
    READ_WRITE_MANY = 3

  accessModes = _messages.EnumField('AccessModesValueListEntryValuesEnum', 1, repeated=True)
  resources = _messages.MessageField('ResourceRequirements', 2)


class PipelineRef(_messages.Message):
  r"""PipelineRef can be used to refer to a specific instance of a Pipeline.

  Fields:
    bundle: Bundle url reference to a Tekton Bundle.
    name: Name of the Pipeline.
  """

  bundle = _messages.StringField(1)
  name = _messages.StringField(2)


class PipelineRun(_messages.Message):
  r"""Message describing PipelineRun object

  Enums:
    PipelineRunStatusValueValuesEnum: Status of the PipelineRun.

  Messages:
    AnnotationsValue: User annotations. See
      https://google.aip.dev/128#annotations
    LabelsValue: Map of key-value pairs of user-defined labels.

  Fields:
    annotations: User annotations. See https://google.aip.dev/128#annotations
    completionTime: Output only. Time the pipeline completed.
    conditions: Output only. Kubernetes Conditions convention for PipelineRun
      status and error.
    createTime: Output only. Time at which the request to create the
      `PipelineRun` was received.
    etag: Needed for declarative-friendly resources.
    labels: Map of key-value pairs of user-defined labels.
    name: Output only. The `PipelineRun` name with format
      `projects/{project}/locations/{location}/pipelineRuns/{pipeline_run}`
    params: Params is a list of parameter names and values.
    pipelineRef: PipelineRef refer to a specific instance of a Pipeline.
    pipelineRunStatus: Status of the PipelineRun.
    pipelineSpec: PipelineSpec defines the desired state of Pipeline.
    serviceAccount: Service account used in the Pipeline.
    startTime: Output only. Time the pipeline is actually started.
    taskRuns: Output only. List of TaskRuns and their status.
    timeout: Time after which the Pipeline times out.
    uid: Output only. A unique identifier for the `PipelineRun`.
    updateTime: Output only. Time at which the request to update the
      `PipelineRun` was received.
    workerPool: Output only. The WorkerPool used to run this PipelineRun.
    workflow: Output only. The Workflow used to create this PipelineRun.
    workspaces: Workspaces is a list of WorkspaceBindings from volumes to
      workspaces.
  """

  class PipelineRunStatusValueValuesEnum(_messages.Enum):
    r"""Status of the PipelineRun.

    Values:
      PIPELINE_RUN_STATUS_UNSPECIFIED: Default enum type; should not be used.
      PIPELINE_RUN_CANCELLED: Cancelled status.
    """
    PIPELINE_RUN_STATUS_UNSPECIFIED = 0
    PIPELINE_RUN_CANCELLED = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""User annotations. See https://google.aip.dev/128#annotations

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Map of key-value pairs of user-defined labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  completionTime = _messages.StringField(2)
  conditions = _messages.MessageField('Condition', 3, repeated=True)
  createTime = _messages.StringField(4)
  etag = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  params = _messages.MessageField('Param', 8, repeated=True)
  pipelineRef = _messages.MessageField('PipelineRef', 9)
  pipelineRunStatus = _messages.EnumField('PipelineRunStatusValueValuesEnum', 10)
  pipelineSpec = _messages.MessageField('PipelineSpec', 11)
  serviceAccount = _messages.StringField(12)
  startTime = _messages.StringField(13)
  taskRuns = _messages.MessageField('PipelineRunTaskRunStatus', 14, repeated=True)
  timeout = _messages.StringField(15)
  uid = _messages.StringField(16)
  updateTime = _messages.StringField(17)
  workerPool = _messages.StringField(18)
  workflow = _messages.StringField(19)
  workspaces = _messages.MessageField('WorkspaceBinding', 20, repeated=True)


class PipelineRunTaskRunStatus(_messages.Message):
  r"""PipelineRunTaskRunStatus contains the name of the PipelineTask for this
  TaskRun and the TaskRun's Status.

  Fields:
    pipelineTaskName: Name of the pipeline task.
    status: Status of the task run.
  """

  pipelineTaskName = _messages.StringField(1)
  status = _messages.MessageField('TaskRunStatus', 2)


class PipelineSpec(_messages.Message):
  r"""PipelineSpec defines the desired state of Pipeline.

  Fields:
    finallyTasks: List of Tasks that execute just before leaving the Pipeline
      i.e. either after all Tasks are finished executing successfully or after
      a failure which would result in ending the Pipeline.
    params: List of parameters.
    tasks: List of Tasks that execute when this Pipeline is run.
    workspaces: Workspaces declares a set of named workspaces that are
      expected to be provided by a PipelineRun.
  """

  finallyTasks = _messages.MessageField('PipelineTask', 1, repeated=True)
  params = _messages.MessageField('ParamSpec', 2, repeated=True)
  tasks = _messages.MessageField('PipelineTask', 3, repeated=True)
  workspaces = _messages.MessageField('PipelineWorkspaceDeclaration', 4, repeated=True)


class PipelineTask(_messages.Message):
  r"""PipelineTask defines a task in a Pipeline.

  Fields:
    name: Name of the task.
    params: Params is a list of parameter names and values.
    taskRef: Reference to a specific instance of a task.
    taskSpec: Spec to instantiate this TaskRun.
    whenExpressions: Conditions that need to be true for the task to run.
    workspaces: Workspaces maps workspaces from the pipeline spec to the
      workspaces declared in the Task.
  """

  name = _messages.StringField(1)
  params = _messages.MessageField('Param', 2, repeated=True)
  taskRef = _messages.MessageField('TaskRef', 3)
  taskSpec = _messages.MessageField('EmbeddedTask', 4)
  whenExpressions = _messages.MessageField('WhenExpression', 5, repeated=True)
  workspaces = _messages.MessageField('WorkspacePipelineTaskBinding', 6, repeated=True)


class PipelineWorkspaceDeclaration(_messages.Message):
  r"""Workspaces declares a set of named workspaces that are expected to be
  provided by a PipelineRun.

  Fields:
    description: Description is a human readable string describing how the
      workspace will be used in the Pipeline.
    name: Name is the name of a workspace to be provided by a PipelineRun.
    optional: Optional marks a Workspace as not being required in
      PipelineRuns. By default this field is false and so declared workspaces
      are required.
  """

  description = _messages.StringField(1)
  name = _messages.StringField(2)
  optional = _messages.BooleanField(3)


class PoolOption(_messages.Message):
  r"""Details about how a build should be executed on a `WorkerPool`. See
  [running builds in a private
  pool](https://cloud.google.com/build/docs/private-pools/run-builds-in-
  private-pool) for more information.

  Fields:
    name: The `WorkerPool` resource to execute the build on. You must have
      `cloudbuild.workerpools.use` on the project hosting the WorkerPool.
      Format
      projects/{project}/locations/{location}/workerPools/{workerPoolId}
  """

  name = _messages.StringField(1)


class ProcessAppManifestCallbackOperationMetadata(_messages.Message):
  r"""Metadata for `ProcessAppManifestCallback` operation.

  Fields:
    completeTime: Time the operation was completed.
    createTime: Time the operation was created.
    githubEnterpriseConfig: The resource name of the GitHubEnterprise to be
      created. Format:
      `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`.
  """

  completeTime = _messages.StringField(1)
  createTime = _messages.StringField(2)
  githubEnterpriseConfig = _messages.StringField(3)


class Record(_messages.Message):
  r"""Record belonging to a Result.

  Fields:
    createTime: Output only. Server assigned timestamp for when the record was
      created.
    data: Output only. JSON serialized Record data.
    name: Output only. The name of Record.
    uid: Output only. Server assigned uid.
    updateTime: Output only. Server assigned timestamp for when the record was
      updated.
  """

  createTime = _messages.StringField(1)
  data = _messages.MessageField('JsonAny', 2)
  name = _messages.StringField(3)
  uid = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class RecordSummary(_messages.Message):
  r"""Summary of the underlying Record.

  Messages:
    RecordDataValue: Output only. Key-value pairs representing underlying
      record data, e.g. "status", "SUCCESS"

  Fields:
    createTime: Output only. The time the Record was created.
    record: Output only. Summarized record.
    recordData: Output only. Key-value pairs representing underlying record
      data, e.g. "status", "SUCCESS"
    type: Output only. Identifier of underlying data. e.g.
      `cloudbuild.googleapis.com/PipelineRun`
    updateTime: Output only. The time the Record was updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RecordDataValue(_messages.Message):
    r"""Output only. Key-value pairs representing underlying record data, e.g.
    "status", "SUCCESS"

    Messages:
      AdditionalProperty: An additional property for a RecordDataValue object.

    Fields:
      additionalProperties: Additional properties of type RecordDataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RecordDataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  record = _messages.StringField(2)
  recordData = _messages.MessageField('RecordDataValue', 3)
  type = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class RepoSource(_messages.Message):
  r"""Location of the source in a Google Cloud Source Repository.

  Messages:
    SubstitutionsValue: Substitutions to use in a triggered build. Should only
      be used with RunBuildTrigger

  Fields:
    branchName: Regex matching branches to build. The syntax of the regular
      expressions accepted is the syntax accepted by RE2 and described at
      https://github.com/google/re2/wiki/Syntax
    commitSha: Explicit commit SHA to build.
    dir: Directory, relative to the source root, in which to run the build.
      This must be a relative path. If a step's `dir` is specified and is an
      absolute path, this value is ignored for that step's execution.
    invertRegex: Only trigger a build if the revision regex does NOT match the
      revision regex.
    projectId: ID of the project that owns the Cloud Source Repository. If
      omitted, the project ID requesting the build is assumed.
    repoName: Name of the Cloud Source Repository.
    substitutions: Substitutions to use in a triggered build. Should only be
      used with RunBuildTrigger
    tagName: Regex matching tags to build. The syntax of the regular
      expressions accepted is the syntax accepted by RE2 and described at
      https://github.com/google/re2/wiki/Syntax
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SubstitutionsValue(_messages.Message):
    r"""Substitutions to use in a triggered build. Should only be used with
    RunBuildTrigger

    Messages:
      AdditionalProperty: An additional property for a SubstitutionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type SubstitutionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SubstitutionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  branchName = _messages.StringField(1)
  commitSha = _messages.StringField(2)
  dir = _messages.StringField(3)
  invertRegex = _messages.BooleanField(4)
  projectId = _messages.StringField(5)
  repoName = _messages.StringField(6)
  substitutions = _messages.MessageField('SubstitutionsValue', 7)
  tagName = _messages.StringField(8)


class ResourceRequirements(_messages.Message):
  r"""Compute resource requirements.

  Messages:
    LimitsValue: The maximum amount of compute resources allowed.
    RequestsValue: The minimum amount of compute resources needed.

  Fields:
    limits: The maximum amount of compute resources allowed.
    requests: The minimum amount of compute resources needed.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LimitsValue(_messages.Message):
    r"""The maximum amount of compute resources allowed.

    Messages:
      AdditionalProperty: An additional property for a LimitsValue object.

    Fields:
      additionalProperties: Additional properties of type LimitsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LimitsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RequestsValue(_messages.Message):
    r"""The minimum amount of compute resources needed.

    Messages:
      AdditionalProperty: An additional property for a RequestsValue object.

    Fields:
      additionalProperties: Additional properties of type RequestsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RequestsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  limits = _messages.MessageField('LimitsValue', 1)
  requests = _messages.MessageField('RequestsValue', 2)


class Result(_messages.Message):
  r"""Result of a single event/execution.

  Fields:
    createTime: Output only. Server assigned timestamp for when the result was
      created.
    name: Output only. The name of Result.
    recordSummaries: Output only. Summary of the underlying Record. GCB only
      returns a summary for the primary Record, e.g. a PipelineRun but not its
      TaskRuns.
    uid: Output only. Server assigned uid.
    updateTime: Output only. Server assigned timestamp for when the result was
      updated.
  """

  createTime = _messages.StringField(1)
  name = _messages.StringField(2)
  recordSummaries = _messages.MessageField('RecordSummary', 3, repeated=True)
  uid = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class Results(_messages.Message):
  r"""Artifacts created by the build pipeline.

  Fields:
    artifactManifest: Path to the artifact manifest. Only populated when
      artifacts are uploaded.
    artifactTiming: Time to push all non-container artifacts.
    buildStepImages: List of build step digests, in the order corresponding to
      build step indices.
    buildStepOutputs: List of build step outputs, produced by builder images,
      in the order corresponding to build step indices. [Cloud
      Builders](https://cloud.google.com/cloud-build/docs/cloud-builders) can
      produce this output by writing to `$BUILDER_OUTPUT/output`. Only the
      first 4KB of data is stored.
    images: Container images that were built as a part of the build.
    numArtifacts: Number of artifacts uploaded. Only populated when artifacts
      are uploaded.
  """

  artifactManifest = _messages.StringField(1)
  artifactTiming = _messages.MessageField('TimeSpan', 2)
  buildStepImages = _messages.StringField(3, repeated=True)
  buildStepOutputs = _messages.BytesField(4, repeated=True)
  images = _messages.MessageField('BuiltImage', 5, repeated=True)
  numArtifacts = _messages.IntegerField(6)


class RunWorkflowCustomOperationMetadata(_messages.Message):
  r"""Represents the custom metadata of the RunWorkflow long-running
  operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    pipelineRunId: Output only. ID of the pipeline run created by RunWorkflow.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  pipelineRunId = _messages.StringField(4)
  requestedCancellation = _messages.BooleanField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class RunWorkflowRequest(_messages.Message):
  r"""Message for running a Workflow.

  Fields:
    etag: Needed for declarative-friendly resources.
    params: Run-time params.
    validateOnly: When true, the query is validated only, but not executed.
  """

  etag = _messages.StringField(1)
  params = _messages.MessageField('Param', 2, repeated=True)
  validateOnly = _messages.BooleanField(3)


class SMTPDelivery(_messages.Message):
  r"""SMTPDelivery is the delivery configuration for an SMTP (email)
  notification.

  Fields:
    fromAddress: This is the SMTP account/email that appears in the `From:` of
      the email. If empty, it is assumed to be sender.
    password: The SMTP sender's password.
    port: The SMTP port of the server.
    recipientAddresses: This is the list of addresses to which we send the
      email (i.e. in the `To:` of the email).
    senderAddress: This is the SMTP account/email that is used to send the
      message.
    server: The address of the SMTP server.
  """

  fromAddress = _messages.StringField(1)
  password = _messages.MessageField('NotifierSecretRef', 2)
  port = _messages.StringField(3)
  recipientAddresses = _messages.StringField(4, repeated=True)
  senderAddress = _messages.StringField(5)
  server = _messages.StringField(6)


class Secret(_messages.Message):
  r"""Pairs a set of secret environment variables containing encrypted values
  with the Cloud KMS key to use to decrypt the value. Note: Use `kmsKeyName`
  with `available_secrets` instead of using `kmsKeyName` with `secret`. For
  instructions see: https://cloud.google.com/cloud-build/docs/securing-
  builds/use-encrypted-credentials.

  Messages:
    SecretEnvValue: Map of environment variable name to its encrypted value.
      Secret environment variables must be unique across all of a build's
      secrets, and must be used by at least one build step. Values can be at
      most 64 KB in size. There can be at most 100 secret values across all of
      a build's secrets.

  Fields:
    kmsKeyName: Cloud KMS key name to use to decrypt these envs.
    secretEnv: Map of environment variable name to its encrypted value. Secret
      environment variables must be unique across all of a build's secrets,
      and must be used by at least one build step. Values can be at most 64 KB
      in size. There can be at most 100 secret values across all of a build's
      secrets.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SecretEnvValue(_messages.Message):
    r"""Map of environment variable name to its encrypted value. Secret
    environment variables must be unique across all of a build's secrets, and
    must be used by at least one build step. Values can be at most 64 KB in
    size. There can be at most 100 secret values across all of a build's
    secrets.

    Messages:
      AdditionalProperty: An additional property for a SecretEnvValue object.

    Fields:
      additionalProperties: Additional properties of type SecretEnvValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SecretEnvValue object.

      Fields:
        key: Name of the additional property.
        value: A byte attribute.
      """

      key = _messages.StringField(1)
      value = _messages.BytesField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  kmsKeyName = _messages.StringField(1)
  secretEnv = _messages.MessageField('SecretEnvValue', 2)


class SecretManagerSecret(_messages.Message):
  r"""Pairs a secret environment variable with a SecretVersion in Secret
  Manager.

  Fields:
    env: Environment variable name to associate with the secret. Secret
      environment variables must be unique across all of a build's secrets,
      and must be used by at least one build step.
    versionName: Resource name of the SecretVersion. In format:
      projects/*/secrets/*/versions/*
  """

  env = _messages.StringField(1)
  versionName = _messages.StringField(2)


class Secrets(_messages.Message):
  r"""Secrets and secret environment variables.

  Fields:
    inline: Secrets encrypted with KMS key and the associated secret
      environment variable.
    secretManager: Secrets in Secret Manager and associated secret environment
      variable.
  """

  inline = _messages.MessageField('InlineSecret', 1, repeated=True)
  secretManager = _messages.MessageField('SecretManagerSecret', 2, repeated=True)


class SecurityContext(_messages.Message):
  r"""Security options the container should be run with.

  Fields:
    privileged: Run container in privileged mode.
  """

  privileged = _messages.BooleanField(1)


class Sidecar(_messages.Message):
  r"""Sidecars run alongside the Task's step containers.

  Fields:
    args: Arguments to the entrypoint.
    command: Entrypoint array.
    env: List of environment variables to set in the container.
    image: Docker image name.
    name: Name of the Sidecar.
    script: The contents of an executable file to execute.
    securityContext: Security options the container should be run with.
    volumeMounts: Pod volumes to mount into the container's filesystem.
    workingDir: Container's working directory.
  """

  args = _messages.StringField(1, repeated=True)
  command = _messages.StringField(2, repeated=True)
  env = _messages.MessageField('EnvVar', 3, repeated=True)
  image = _messages.StringField(4)
  name = _messages.StringField(5)
  script = _messages.StringField(6)
  securityContext = _messages.MessageField('SecurityContext', 7)
  volumeMounts = _messages.MessageField('VolumeMount', 8, repeated=True)
  workingDir = _messages.StringField(9)


class SidecarState(_messages.Message):
  r"""The state of a sidecar.

  Fields:
    containerName: Name of the container.
    imageId: ID of the image.
    name: Name of the Sidecar.
    running: Details about a running container.
    terminated: Details about a terminated container.
    waiting: Details about a waiting container.
  """

  containerName = _messages.StringField(1)
  imageId = _messages.StringField(2)
  name = _messages.StringField(3)
  running = _messages.MessageField('ContainerStateRunning', 4)
  terminated = _messages.MessageField('ContainerStateTerminated', 5)
  waiting = _messages.MessageField('ContainerStateWaiting', 6)


class SlackDelivery(_messages.Message):
  r"""SlackDelivery is the delivery configuration for delivering Slack
  messages via webhooks. See Slack webhook documentation at:
  https://api.slack.com/messaging/webhooks.

  Fields:
    webhookUri: The secret reference for the Slack webhook URI for sending
      messages to a channel.
  """

  webhookUri = _messages.MessageField('NotifierSecretRef', 1)


class Source(_messages.Message):
  r"""Location of the source in a supported storage service.

  Fields:
    repoSource: If provided, get the source from this location in a Cloud
      Source Repository.
    storageSource: If provided, get the source from this location in Google
      Cloud Storage.
    storageSourceManifest: If provided, get the source from this manifest in
      Google Cloud Storage. This feature is in Preview; see description
      [here](https://github.com/GoogleCloudPlatform/cloud-
      builders/tree/master/gcs-fetcher).
  """

  repoSource = _messages.MessageField('RepoSource', 1)
  storageSource = _messages.MessageField('StorageSource', 2)
  storageSourceManifest = _messages.MessageField('StorageSourceManifest', 3)


class SourceProvenance(_messages.Message):
  r"""Provenance of the source. Ways to find the original source, or verify
  that some source was used for this build.

  Messages:
    FileHashesValue: Output only. Hash(es) of the build source, which can be
      used to verify that the original source integrity was maintained in the
      build. Note that `FileHashes` will only be populated if `BuildOptions`
      has requested a `SourceProvenanceHash`. The keys to this map are file
      paths used as build source and the values contain the hash values for
      those files. If the build source came in a single package such as a
      gzipped tarfile (`.tar.gz`), the `FileHash` will be for the single path
      to that file.

  Fields:
    fileHashes: Output only. Hash(es) of the build source, which can be used
      to verify that the original source integrity was maintained in the
      build. Note that `FileHashes` will only be populated if `BuildOptions`
      has requested a `SourceProvenanceHash`. The keys to this map are file
      paths used as build source and the values contain the hash values for
      those files. If the build source came in a single package such as a
      gzipped tarfile (`.tar.gz`), the `FileHash` will be for the single path
      to that file.
    resolvedRepoSource: A copy of the build's `source.repo_source`, if exists,
      with any revisions resolved.
    resolvedStorageSource: A copy of the build's `source.storage_source`, if
      exists, with any generations resolved.
    resolvedStorageSourceManifest: A copy of the build's
      `source.storage_source_manifest`, if exists, with any revisions
      resolved. This feature is in Preview.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FileHashesValue(_messages.Message):
    r"""Output only. Hash(es) of the build source, which can be used to verify
    that the original source integrity was maintained in the build. Note that
    `FileHashes` will only be populated if `BuildOptions` has requested a
    `SourceProvenanceHash`. The keys to this map are file paths used as build
    source and the values contain the hash values for those files. If the
    build source came in a single package such as a gzipped tarfile
    (`.tar.gz`), the `FileHash` will be for the single path to that file.

    Messages:
      AdditionalProperty: An additional property for a FileHashesValue object.

    Fields:
      additionalProperties: Additional properties of type FileHashesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FileHashesValue object.

      Fields:
        key: Name of the additional property.
        value: A FileHashes attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('FileHashes', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  fileHashes = _messages.MessageField('FileHashesValue', 1)
  resolvedRepoSource = _messages.MessageField('RepoSource', 2)
  resolvedStorageSource = _messages.MessageField('StorageSource', 3)
  resolvedStorageSourceManifest = _messages.MessageField('StorageSourceManifest', 4)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Step(_messages.Message):
  r"""Step embeds the Container type, which allows it to include fields not
  provided by Container.

  Fields:
    args: Arguments to the entrypoint.
    command: Entrypoint array.
    env: List of environment variables to set in the container.
    image: Docker image name.
    name: Name of the container specified as a DNS_LABEL.
    script: The contents of an executable file to execute.
    volumeMounts: Pod volumes to mount into the container's filesystem.
    workingDir: Container's working directory.
  """

  args = _messages.StringField(1, repeated=True)
  command = _messages.StringField(2, repeated=True)
  env = _messages.MessageField('EnvVar', 3, repeated=True)
  image = _messages.StringField(4)
  name = _messages.StringField(5)
  script = _messages.StringField(6)
  volumeMounts = _messages.MessageField('VolumeMount', 7, repeated=True)
  workingDir = _messages.StringField(8)


class StepState(_messages.Message):
  r"""StepState reports the results of running a step in a Task.

  Fields:
    imageId: Image ID of the StepState.
    name: Name of the StepState.
    running: Details about a running container
    terminated: Details about a terminated container
    waiting: Details about a waiting container
  """

  imageId = _messages.StringField(1)
  name = _messages.StringField(2)
  running = _messages.MessageField('ContainerStateRunning', 3)
  terminated = _messages.MessageField('ContainerStateTerminated', 4)
  waiting = _messages.MessageField('ContainerStateWaiting', 5)


class StorageSource(_messages.Message):
  r"""Location of the source in an archive file in Google Cloud Storage.

  Fields:
    bucket: Google Cloud Storage bucket containing the source (see [Bucket
      Name Requirements](https://cloud.google.com/storage/docs/bucket-
      naming#requirements)).
    generation: Google Cloud Storage generation for the object. If the
      generation is omitted, the latest generation will be used.
    object: Google Cloud Storage object containing the source. This object
      must be a zipped (`.zip`) or gzipped archive file (`.tar.gz`) containing
      source to build.
  """

  bucket = _messages.StringField(1)
  generation = _messages.IntegerField(2)
  object = _messages.StringField(3)


class StorageSourceManifest(_messages.Message):
  r"""Location of the source manifest in Google Cloud Storage. This feature is
  in Preview; see description
  [here](https://github.com/GoogleCloudPlatform/cloud-
  builders/tree/master/gcs-fetcher).

  Fields:
    bucket: Google Cloud Storage bucket containing the source manifest (see
      [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-
      naming#requirements)).
    generation: Google Cloud Storage generation for the object. If the
      generation is omitted, the latest generation will be used.
    object: Google Cloud Storage object containing the source manifest. This
      object must be a JSON file.
  """

  bucket = _messages.StringField(1)
  generation = _messages.IntegerField(2)
  object = _messages.StringField(3)


class TaskRef(_messages.Message):
  r"""TaskRef can be used to refer to a specific instance of a task.
  PipelineRef can be used to refer to a specific instance of a Pipeline.

  Fields:
    bundle: Bundle url reference to a Tekton Bundle.
    name: Name of the task.
  """

  bundle = _messages.StringField(1)
  name = _messages.StringField(2)


class TaskResult(_messages.Message):
  r"""TaskResult used to describe the results of a task.

  Fields:
    description: Description of the result.
    name: Name of the result.
  """

  description = _messages.StringField(1)
  name = _messages.StringField(2)


class TaskRun(_messages.Message):
  r"""Message describing TaskRun object

  Enums:
    TaskRunStatusValueValuesEnum: Status of the TaskRun.

  Messages:
    AnnotationsValue: User annotations. See
      https://google.aip.dev/128#annotations
    LabelsValue: Map of key-value pairs of user-defined labels.

  Fields:
    annotations: User annotations. See https://google.aip.dev/128#annotations
    completionTime: Output only. Time the task completed.
    conditions: Output only. Kubernetes Conditions convention for PipelineRun
      status and error.
    createTime: Output only. Time at which the request to create the `TaskRun`
      was received.
    etag: Needed for declarative-friendly resources.
    labels: Map of key-value pairs of user-defined labels.
    name: Output only. The 'TaskRun' name with format:
      `projects/{project}/locations/{location}/taskRuns/{task_run}`
    params: Params is a list of parameter names and values.
    serviceAccount: Required. Service account used in the task.
    sidecars: Output only. State of each Sidecar in the TaskSpec.
    startTime: Output only. Time the task is actually started.
    steps: Output only. Steps describes the state of each build step
      container.
    taskRef: TaskRef refer to a specific instance of a task.
    taskRunResults: Output only. List of results written out by the task's
      containers
    taskRunStatus: Status of the TaskRun.
    taskSpec: TaskSpec contains the Spec to instantiate a TaskRun.
    timeout: Time after which the task times out.
    uid: Output only. A unique identifier for the `TaskRun`.
    updateTime: Output only. Time at which the request to update the `TaskRun`
      was received.
    workerPool: Output only. The WorkerPool used to run this TaskRun.
    workspaces: Workspaces is a list of WorkspaceBindings from volumes to
      workspaces.
  """

  class TaskRunStatusValueValuesEnum(_messages.Enum):
    r"""Status of the TaskRun.

    Values:
      TASK_RUN_STATUS_UNSPECIFIED: Default enum type; should not be used.
      TASK_RUN_CANCELLED: Cancelled status.
    """
    TASK_RUN_STATUS_UNSPECIFIED = 0
    TASK_RUN_CANCELLED = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""User annotations. See https://google.aip.dev/128#annotations

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Map of key-value pairs of user-defined labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  completionTime = _messages.StringField(2)
  conditions = _messages.MessageField('Condition', 3, repeated=True)
  createTime = _messages.StringField(4)
  etag = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  params = _messages.MessageField('Param', 8, repeated=True)
  serviceAccount = _messages.StringField(9)
  sidecars = _messages.MessageField('SidecarState', 10, repeated=True)
  startTime = _messages.StringField(11)
  steps = _messages.MessageField('StepState', 12, repeated=True)
  taskRef = _messages.MessageField('TaskRef', 13)
  taskRunResults = _messages.MessageField('TaskRunResult', 14, repeated=True)
  taskRunStatus = _messages.EnumField('TaskRunStatusValueValuesEnum', 15)
  taskSpec = _messages.MessageField('TaskSpec', 16)
  timeout = _messages.StringField(17)
  uid = _messages.StringField(18)
  updateTime = _messages.StringField(19)
  workerPool = _messages.StringField(20)
  workspaces = _messages.MessageField('WorkspaceBinding', 21, repeated=True)


class TaskRunResult(_messages.Message):
  r"""TaskRunResult used to describe the results of a task

  Fields:
    name: Name of the TaskRun
    value: Value of the result
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class TaskRunStatus(_messages.Message):
  r"""TaskRunStatus defines the status of TaskRun

  Fields:
    completionTime: Output only. Time the task completed.
    conditions: Output only. Kubernetes Conditions convention for PipelineRun
      status and error.
    sidecars: Output only. State of each Sidecar.
    startTime: Output only. Time the task is actually started.
    steps: Output only. Steps describes the state of each build step
      container.
    taskRunResults: Output only. List of results written out by the task's
      containers
    taskSpec: Spec for the task.
  """

  completionTime = _messages.StringField(1)
  conditions = _messages.MessageField('Condition', 2, repeated=True)
  sidecars = _messages.MessageField('SidecarState', 3, repeated=True)
  startTime = _messages.StringField(4)
  steps = _messages.MessageField('StepState', 5, repeated=True)
  taskRunResults = _messages.MessageField('TaskRunResult', 6, repeated=True)
  taskSpec = _messages.MessageField('TaskSpec', 7)


class TaskSpec(_messages.Message):
  r"""TaskSpec contains the Spec to instantiate a TaskRun.

  Fields:
    description: Description of the task.
    params: List of parameters.
    results: Values that this Task can output.
    sidecars: Sidecars that run alongside the Task's step containers.
    steps: Steps of the task.
    volumes: A collection of volumes that are available to mount into steps.
    workspaces: The volumes that this Task requires.
  """

  description = _messages.StringField(1)
  params = _messages.MessageField('ParamSpec', 2, repeated=True)
  results = _messages.MessageField('TaskResult', 3, repeated=True)
  sidecars = _messages.MessageField('Sidecar', 4, repeated=True)
  steps = _messages.MessageField('Step', 5, repeated=True)
  volumes = _messages.MessageField('VolumeSource', 6, repeated=True)
  workspaces = _messages.MessageField('WorkspaceDeclaration', 7, repeated=True)


class TimeSpan(_messages.Message):
  r"""Start and end times for a build execution phase.

  Fields:
    endTime: End of time span.
    startTime: Start of time span.
  """

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class UpdateBitbucketServerConfigOperationMetadata(_messages.Message):
  r"""Metadata for `UpdateBitbucketServerConfig` operation.

  Fields:
    bitbucketServerConfig: The resource name of the BitbucketServerConfig to
      be updated. Format:
      `projects/{project}/locations/{location}/bitbucketServerConfigs/{id}`.
    completeTime: Time the operation was completed.
    createTime: Time the operation was created.
  """

  bitbucketServerConfig = _messages.StringField(1)
  completeTime = _messages.StringField(2)
  createTime = _messages.StringField(3)


class UpdateGitHubEnterpriseConfigOperationMetadata(_messages.Message):
  r"""Metadata for `UpdateGitHubEnterpriseConfig` operation.

  Fields:
    completeTime: Time the operation was completed.
    createTime: Time the operation was created.
    githubEnterpriseConfig: The resource name of the GitHubEnterprise to be
      updated. Format:
      `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`.
  """

  completeTime = _messages.StringField(1)
  createTime = _messages.StringField(2)
  githubEnterpriseConfig = _messages.StringField(3)


class UpdateGitLabConfigOperationMetadata(_messages.Message):
  r"""Metadata for `UpdateGitLabConfig` operation.

  Fields:
    completeTime: Time the operation was completed.
    createTime: Time the operation was created.
    gitlabConfig: The resource name of the GitLabConfig to be created. Format:
      `projects/{project}/locations/{location}/gitlabConfigs/{id}`.
  """

  completeTime = _messages.StringField(1)
  createTime = _messages.StringField(2)
  gitlabConfig = _messages.StringField(3)


class UpdateWorkerPoolOperationMetadata(_messages.Message):
  r"""Metadata for the `UpdateWorkerPool` operation.

  Fields:
    completeTime: Time the operation was completed.
    createTime: Time the operation was created.
    workerPool: The resource name of the `WorkerPool` being updated. Format:
      `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
  """

  completeTime = _messages.StringField(1)
  createTime = _messages.StringField(2)
  workerPool = _messages.StringField(3)


class Volume(_messages.Message):
  r"""Volume describes a Docker container volume which is mounted into build
  steps in order to persist files across build step execution.

  Fields:
    name: Name of the volume to mount. Volume names must be unique per build
      step and must be valid names for Docker volumes. Each named volume must
      be used by at least two build steps.
    path: Path at which to mount the volume. Paths must be absolute and cannot
      conflict with other volume paths on the same build step or with certain
      reserved volume paths.
  """

  name = _messages.StringField(1)
  path = _messages.StringField(2)


class VolumeMount(_messages.Message):
  r"""Pod volumes to mount into the container's filesystem.

  Fields:
    mountPath: Path within the container at which the volume should be
      mounted. Must not contain ':'.
    name: Name of the volume.
    readOnly: Mounted read-only if true, read-write otherwise (false or
      unspecified).
    subPath: Path within the volume from which the container's volume should
      be mounted. Defaults to "" (volume's root).
    subPathExpr: Expanded path within the volume from which the container's
      volume should be mounted. Behaves similarly to SubPath but environment
      variable references $(VAR_NAME) are expanded using the container's
      environment. Defaults to "" (volume's root).
  """

  mountPath = _messages.StringField(1)
  name = _messages.StringField(2)
  readOnly = _messages.BooleanField(3)
  subPath = _messages.StringField(4)
  subPathExpr = _messages.StringField(5)


class VolumeSource(_messages.Message):
  r"""Volumes available to mount.

  Fields:
    emptyDir: A temporary directory that shares a pod's lifetime.
    gcePersistentDisk: a Compute Engine Disk resource that is attached to a
      kubelet's host machine and then exposed to the pod.
    name: Name of the Volume. Must be a DNS_LABEL and unique within the pod.
      More info: https://kubernetes.io/docs/concepts/overview/working-with-
      objects/names/#names
  """

  emptyDir = _messages.MessageField('EmptyDirVolumeSource', 1)
  gcePersistentDisk = _messages.MessageField('GCEPersistentDiskVolumeSource', 2)
  name = _messages.StringField(3)


class Warning(_messages.Message):
  r"""A non-fatal problem encountered during the execution of the build.

  Enums:
    PriorityValueValuesEnum: The priority for this warning.

  Fields:
    priority: The priority for this warning.
    text: Explanation of the warning generated.
  """

  class PriorityValueValuesEnum(_messages.Enum):
    r"""The priority for this warning.

    Values:
      PRIORITY_UNSPECIFIED: Should not be used.
      INFO: e.g. deprecation warnings and alternative feature highlights.
      WARNING: e.g. automated detection of possible issues with the build.
      ALERT: e.g. alerts that a feature used in the build is pending removal
    """
    PRIORITY_UNSPECIFIED = 0
    INFO = 1
    WARNING = 2
    ALERT = 3

  priority = _messages.EnumField('PriorityValueValuesEnum', 1)
  text = _messages.StringField(2)


class WhenExpression(_messages.Message):
  r"""Conditions that need to be true for the task to run.

  Enums:
    ExpressionOperatorValueValuesEnum: Operator that represents an Input's
      relationship to the values

  Fields:
    expressionOperator: Operator that represents an Input's relationship to
      the values
    input: Input is the string for guard checking which can be a static input
      or an output from a parent Task.
    values: Values is an array of strings, which is compared against the
      input, for guard checking.
  """

  class ExpressionOperatorValueValuesEnum(_messages.Enum):
    r"""Operator that represents an Input's relationship to the values

    Values:
      EXPRESSION_OPERATOR_UNSPECIFIED: Default enum type; should not be used.
      DOES_NOT_EXIST: Input does not exist.
      EQUALS: Input equals values.
      DOUBLE_EQUALS: Input double equals values.
      IN: Input is in values.
      NOT_EQUALS: Input does not equal values.
      NOT_IN: Input is not in values.
      EXISTS: Input exists.
      GREATER_THAN: Input is greater than values.
      LESS_THAN: Input is less than values.
    """
    EXPRESSION_OPERATOR_UNSPECIFIED = 0
    DOES_NOT_EXIST = 1
    EQUALS = 2
    DOUBLE_EQUALS = 3
    IN = 4
    NOT_EQUALS = 5
    NOT_IN = 6
    EXISTS = 7
    GREATER_THAN = 8
    LESS_THAN = 9

  expressionOperator = _messages.EnumField('ExpressionOperatorValueValuesEnum', 1)
  input = _messages.StringField(2)
  values = _messages.StringField(3, repeated=True)


class Workflow(_messages.Message):
  r"""Message describing Workflow object.

  Messages:
    AnnotationsValue: User annotations. See
      https://google.aip.dev/128#annotations
    LabelsValue: Map of key-value pairs of user-defined labels.

  Fields:
    annotations: User annotations. See https://google.aip.dev/128#annotations
    bundle: A Tekton Bundle is an OCI Image that Tekton understands. OCI is
      the spec for container images that docker and others (such as Tekton
      Bundles) follow.
    createTime: Output only. Server assigned timestamp for when the workflow
      was created.
    deleteTime: Output only. Server assigned timestamp for when the workflow
      was deleted.
    etag: Needed for declarative-friendly resources.
    labels: Map of key-value pairs of user-defined labels.
    name: Output only. Format:
      `projects/{project}/locations/{location}/workflows/{workflow}`
    options: Workflow runs can be modified through several Workflow options.
    params: List of parameters.
    pipelineSpec: Fields from both the Workflow and the PipelineSpec will be
      used to form the full PipelineRun.
    secrets: Pairs a secret environment variable with a SecretVersion in
      Secret Manager.
    serviceAccount: If omitted, the default Cloud Build Service Account is
      used instead. Format: `projects/{project}/locations/{location}/serviceAc
      counts/{serviceAccount}`
    uid: Output only. A unique identifier for the `Workflow`.
    updateTime: Output only. Server assigned timestamp for when the workflow
      was last updated.
    workspaces: Workspaces is a list of WorkspaceBindings from volumes to
      workspaces.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""User annotations. See https://google.aip.dev/128#annotations

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Map of key-value pairs of user-defined labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  bundle = _messages.StringField(2)
  createTime = _messages.StringField(3)
  deleteTime = _messages.StringField(4)
  etag = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  options = _messages.MessageField('WorkflowOptions', 8)
  params = _messages.MessageField('ParamSpec', 9, repeated=True)
  pipelineSpec = _messages.MessageField('PipelineSpec', 10)
  secrets = _messages.MessageField('GoogleDevtoolsCloudbuildV2SecretManagerSecret', 11, repeated=True)
  serviceAccount = _messages.StringField(12)
  uid = _messages.StringField(13)
  updateTime = _messages.StringField(14)
  workspaces = _messages.MessageField('WorkspaceBinding', 15, repeated=True)


class WorkflowOptions(_messages.Message):
  r"""Workflow runs can be modified through several Workflow options.

  Fields:
    executionEnvironment: Contains the workerpool.
    statusUpdateOptions: How/where status on the workflow is posted.
    timeout: Time after which the Workflow times out.
  """

  executionEnvironment = _messages.MessageField('ExecutionEnvironment', 1)
  statusUpdateOptions = _messages.MessageField('WorkflowStatusUpdateOptions', 2)
  timeout = _messages.StringField(3)


class WorkflowStatusUpdateOptions(_messages.Message):
  r"""Configure how/where status is posted.

  Fields:
    pubsubTopic: Controls which Pub/Sub topic is used to send status updates
      as a build progresses and terminates. Default: projects//pub-
      sub/topics/cloud-build
  """

  pubsubTopic = _messages.StringField(1)


class WorkspaceBinding(_messages.Message):
  r"""WorkspaceBinding maps a workspace to a Volume. PipelineRef can be used
  to refer to a specific instance of a Pipeline.

  Fields:
    emptyDir: EmptyDir represents a temporary directory that shares a Task's
      lifetime.
    name: Name of the workspace.
    volumeClaimTemplate: Template for a claim that will be created in the same
      namespace.
  """

  emptyDir = _messages.MessageField('EmptyDir', 1)
  name = _messages.StringField(2)
  volumeClaimTemplate = _messages.MessageField('PersistentVolumeClaim', 3)


class WorkspaceDeclaration(_messages.Message):
  r"""WorkspaceDeclaration is a declaration of a volume that a Task requires.

  Fields:
    description: Description is a human readable description of this volume.
    mountPath: MountPath overrides the directory that the volume will be made
      available at.
    name: Name is the name by which you can bind the volume at runtime.
    readOnly: ReadOnly dictates whether a mounted volume is writable.
  """

  description = _messages.StringField(1)
  mountPath = _messages.StringField(2)
  name = _messages.StringField(3)
  readOnly = _messages.BooleanField(4)


class WorkspacePipelineTaskBinding(_messages.Message):
  r"""WorkspacePipelineTaskBinding maps workspaces from the PipelineSpec to
  the workspaces declared in the Task.

  Fields:
    name: Name of the workspace as declared by the task.
    workspace: Name of the workspace declared by the pipeline.
  """

  name = _messages.StringField(1)
  workspace = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
