/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.path;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.cli.path.PathConsumerException;
import org.jboss.galleon.cli.path.PathParser;

public class FeatureContainerPathConsumer
implements PathParser.PathConsumer {
    public static final String FEATURES = "feature-specs";
    public static final String DEPENDENCIES = "dependencies";
    public static final String PACKAGES = "packages";
    public static final String CONFIGS = "configs";
    public static final String FINAL = "final";
    public static final String OPTIONS = "options";
    public static final String ROOT = "/";
    public static final Group EDIT_ROOT_GRP = Group.fromString("", "/");
    public static final Group EXPLORE_ROOT_GRP = Group.fromString("", "/");
    private static final Group PACKAGES_GRP = Group.fromString("", "packages");
    private static final Group FINAL_GRP = Group.fromString("", "final");
    private static final Group CONFIGS_GRP = Group.fromString("", "configs");
    private static final Group FEATURES_GRP = Group.fromString("", "feature-specs");
    private static final Group DEPENDENCIES_GRP = Group.fromString("", "dependencies");
    public static final String FINAL_CONFIGS_PATH = "/configs/final/";
    public static final String PACKAGES_PATH = "/packages/";
    public static final String FEATURES_PATH = "/feature-specs/";
    private static final Map<String, Group> EDIT_GROUPS = new HashMap<String, Group>();
    private static final Map<String, Group> EXPLORE_GROUPS = new HashMap<String, Group>();
    private State state = State.NOT_STARTED;
    private FeatureContainer info;
    private ConfigInfo config;
    private Group current;
    private String configModel;
    private String configName;
    private final boolean completion;
    private String packagesGav;
    private String featuresGav;
    private String dependencyGav;
    private Group rootGrp;
    private final Map<String, Group> groups;
    private boolean inError;
    private boolean edit;

    public FeatureContainerPathConsumer(FeatureContainer info, boolean completion) {
        this.info = info;
        this.completion = completion;
        this.edit = info.isEdit();
        this.rootGrp = this.edit ? EDIT_ROOT_GRP : EXPLORE_ROOT_GRP;
        this.groups = this.edit ? EDIT_GROUPS : EXPLORE_GROUPS;
    }

    public void enterConfigurationModel(String model) throws PathConsumerException {
        List<ConfigInfo> configs = this.info.getFinalConfigs().get(model);
        if (configs == null) {
            if (this.completion) {
                if (this.inError) {
                    throw new PathConsumerException("no config for model " + model);
                }
                this.inError = true;
            } else {
                throw new PathConsumerException("no config for model " + model);
            }
        }
        this.configModel = model;
    }

    public void enterConfigurationName(String name) throws PathConsumerException {
        List<ConfigInfo> configs = this.info.getFinalConfigs().get(this.configModel);
        for (ConfigInfo c : configs) {
            if (!c.getName().equals(name)) continue;
            this.config = c;
            break;
        }
        if (this.config == null) {
            if (this.completion) {
                if (this.inError) {
                    throw new PathConsumerException("no config for name " + name);
                }
                this.inError = true;
            } else {
                throw new PathConsumerException("no config for name " + name);
            }
        }
        this.configName = name;
        this.configModel = null;
    }

    @Override
    public void enterNode(PathParser.Node node) throws PathConsumerException {
        if (node == null) {
            return;
        }
        switch (this.state) {
            case UNKNOWN: {
                String n = node.getName();
                if (n.equals(CONFIGS)) {
                    this.state = State.FINAL;
                    break;
                }
                if (n.equals(FEATURES)) {
                    this.state = State.FEATURES_ORIGIN;
                    break;
                }
                if (n.equals(PACKAGES)) {
                    this.state = State.PACKAGES_ORIGIN;
                    break;
                }
                if (this.edit && n.equals(DEPENDENCIES)) {
                    this.state = State.DEPENDENCIES_ORIGIN;
                    break;
                }
                if (this.completion) {
                    if (this.inError) {
                        throw new PathConsumerException("Unknown " + n);
                    }
                    this.inError = true;
                    break;
                }
                throw new PathConsumerException("Unknown " + n);
            }
            case FINAL: {
                String n = node.getName();
                if (n.equals(FINAL)) {
                    this.state = State.CONFIG_MODEL;
                    break;
                }
                if (this.completion) {
                    if (this.inError) {
                        throw new PathConsumerException("Unknown " + n);
                    }
                    this.inError = true;
                    break;
                }
                throw new PathConsumerException("Unknown " + n);
            }
            case CONFIG_MODEL: {
                String n = node.getName();
                this.enterConfigurationModel(n);
                this.state = State.CONFIG_NAME;
                break;
            }
            case CONFIG_NAME: {
                String n = node.getName();
                this.enterConfigurationName(n);
                this.state = State.CONFIG_CONTENT;
                break;
            }
            case CONFIG_CONTENT: {
                this.enterContent(node);
                break;
            }
            case FEATURES_ORIGIN: {
                this.featuresGav = node.getName();
                this.state = State.FEATURES_CONTENT;
                break;
            }
            case FEATURES_CONTENT: {
                this.enterFeaturesContent(node);
                break;
            }
            case DEPENDENCIES_ORIGIN: {
                this.dependencyGav = node.getName();
                this.info = this.info.getFullDependencies().get(this.dependencyGav);
                if (this.info == null) {
                    throw new PathConsumerException("Unknown dependency " + this.dependencyGav);
                }
                this.rootGrp = EXPLORE_ROOT_GRP;
                this.state = State.UNKNOWN;
                break;
            }
            case PACKAGES_ORIGIN: {
                this.packagesGav = node.getName();
                this.state = State.PACKAGES_CONTENT;
                break;
            }
            case PACKAGES_CONTENT: {
                this.enterPackagesContent(node);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void enterPackagesContent(PathParser.Node node) throws PathConsumerException {
        Group next = null;
        if (this.current == null) {
            this.current = this.info.getPackages().get(this.packagesGav);
            if (this.current == null) {
                throw new PathConsumerException("no package in " + this.packagesGav);
            }
        }
        for (Group info : this.current.getGroups()) {
            if (!info.getIdentity().getName().equals(node.getName())) continue;
            next = info;
            break;
        }
        if (next == null) {
            if (!this.completion) throw new PathConsumerException("no node for name " + node.getName());
            if (this.inError) {
                throw new PathConsumerException("no node for name " + node.getName());
            }
            this.inError = true;
        } else {
            this.current = next;
        }
        this.packagesGav = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void enterFeaturesContent(PathParser.Node node) throws PathConsumerException {
        Group next = null;
        if (this.current == null) {
            this.current = this.info.getFeatureSpecs().get(this.featuresGav);
            if (this.current == null) {
                throw new PathConsumerException("no feature in " + this.featuresGav);
            }
        }
        for (Group info : this.current.getGroups()) {
            if (!info.getIdentity().getName().equals(node.getName())) continue;
            next = info;
            break;
        }
        if (next == null) {
            if (!this.completion) throw new PathConsumerException("no node for name " + node.getName());
            if (this.inError) {
                throw new PathConsumerException("no node for name " + node.getName());
            }
            this.inError = true;
        } else {
            this.current = next;
        }
        this.featuresGav = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void enterContent(PathParser.Node node) throws PathConsumerException {
        Group next = null;
        if (this.current == null) {
            this.current = this.config.getRoot();
            if (this.current == null) {
                throw new PathConsumerException("no content in config " + this.config.getName());
            }
        }
        for (Group info : this.current.getGroups()) {
            if (!info.getIdentity().getName().equals(node.getName())) continue;
            next = info;
            break;
        }
        if (next == null) {
            if (!this.completion) throw new PathConsumerException("no node for name " + node.getName());
            if (this.inError) {
                throw new PathConsumerException("no node for name " + node.getName());
            }
            this.inError = true;
            return;
        } else {
            this.current = next;
        }
    }

    @Override
    public void enterRoot() throws PathConsumerException {
        this.state = State.UNKNOWN;
    }

    public String getConfigModel() {
        return this.configModel;
    }

    public String getConfigName() {
        return this.configName;
    }

    public ConfigInfo getConfig() {
        return this.config;
    }

    public State getState() {
        return this.state;
    }

    public String getPackagesOrigin() {
        return this.packagesGav;
    }

    public List<String> getCandidates(String path) {
        ArrayList<String> candidates = new ArrayList<String>();
        boolean completePath = path.endsWith(ROOT);
        String chunk = completePath ? null : path.substring(path.lastIndexOf(ROOT) + 1);
        switch (this.state) {
            case UNKNOWN: {
                if (chunk != null) {
                    if (CONFIGS.equals(chunk) || FEATURES.equals(chunk) || PACKAGES.equals(chunk) || this.edit && DEPENDENCIES.equals(chunk)) {
                        candidates.add(chunk + '/');
                        break;
                    }
                    if (CONFIGS.startsWith(chunk)) {
                        candidates.add(CONFIGS);
                        break;
                    }
                    if (FEATURES.startsWith(chunk)) {
                        candidates.add(FEATURES);
                        break;
                    }
                    if (PACKAGES.startsWith(chunk)) {
                        candidates.add(PACKAGES);
                        break;
                    }
                    if (!this.edit || !DEPENDENCIES.startsWith(chunk)) break;
                    candidates.add(DEPENDENCIES);
                    break;
                }
                for (Group g : this.rootGrp.getGroups()) {
                    candidates.add(g.getIdentity().getName() + '/');
                }
                break;
            }
            case FINAL: {
                if (chunk != null) {
                    if (FINAL.equals(chunk)) {
                        candidates.add(chunk + '/');
                        break;
                    }
                    if (!FINAL.startsWith(chunk)) break;
                    candidates.add(FINAL);
                    break;
                }
                candidates.add("final/");
                break;
            }
            case CONFIG_MODEL: {
                if (chunk != null) {
                    for (String model : this.info.getFinalConfigs().keySet()) {
                        if (model.equals(chunk)) {
                            candidates.add(chunk + '/');
                            continue;
                        }
                        if (!model.startsWith(chunk)) continue;
                        candidates.add(model);
                    }
                } else {
                    for (String model : this.info.getFinalConfigs().keySet()) {
                        candidates.add(model + '/');
                    }
                }
                break;
            }
            case CONFIG_NAME: {
                if (chunk != null) {
                    for (ConfigInfo cf : this.info.getFinalConfigs().get(this.configModel)) {
                        if (cf.getName().equals(chunk)) {
                            candidates.add(chunk + '/');
                            continue;
                        }
                        if (!cf.getName().startsWith(chunk)) continue;
                        candidates.add(cf.getName());
                    }
                } else {
                    for (ConfigInfo cf : this.info.getFinalConfigs().get(this.configModel)) {
                        candidates.add(cf.getName() + '/');
                    }
                }
                break;
            }
            case FEATURES_ORIGIN: {
                if (chunk != null) {
                    for (String cf : this.info.getFeatureSpecs().keySet()) {
                        if (cf.equals(chunk)) {
                            candidates.add(chunk + '/');
                            continue;
                        }
                        if (!cf.startsWith(chunk)) continue;
                        candidates.add(cf);
                    }
                } else {
                    for (String cf : this.info.getFeatureSpecs().keySet()) {
                        candidates.add(cf + '/');
                    }
                }
                break;
            }
            case DEPENDENCIES_ORIGIN: {
                if (chunk != null) {
                    for (String cf : this.info.getFullDependencies().keySet()) {
                        if (cf.equals(chunk)) {
                            candidates.add(chunk + '/');
                            continue;
                        }
                        if (!cf.startsWith(chunk)) continue;
                        candidates.add(cf);
                    }
                } else {
                    for (String cf : this.info.getFullDependencies().keySet()) {
                        candidates.add(cf + '/');
                    }
                }
                break;
            }
            case PACKAGES_ORIGIN: {
                if (chunk != null) {
                    for (String cf : this.info.getPackages().keySet()) {
                        if (cf.equals(chunk)) {
                            candidates.add(chunk + '/');
                            continue;
                        }
                        if (!cf.startsWith(chunk)) continue;
                        candidates.add(cf);
                    }
                } else {
                    for (String cf : this.info.getPackages().keySet()) {
                        candidates.add(cf + '/');
                    }
                }
                break;
            }
            case PACKAGES_CONTENT: {
                if (this.current == null) {
                    this.current = this.info.getPackages().get(this.packagesGav);
                }
            }
            case FEATURES_CONTENT: {
                if (this.current == null) {
                    this.current = this.info.getFeatureSpecs().get(this.featuresGav);
                }
            }
            case CONFIG_CONTENT: {
                if (this.current == null) {
                    this.current = this.config.getRoot();
                }
                if (chunk != null) {
                    for (Group fg : this.current.getGroups()) {
                        if (fg.getIdentity().getName().equals(chunk)) {
                            if (!fg.getGroups().isEmpty()) {
                                candidates.add(chunk + '/');
                                continue;
                            }
                            candidates.add(fg.getIdentity().getName());
                            continue;
                        }
                        if (!fg.getIdentity().getName().startsWith(chunk)) continue;
                        candidates.add(fg.getIdentity().getName());
                    }
                } else {
                    for (Group fg : this.current.getGroups()) {
                        candidates.add(fg.getIdentity().getName() + (fg.getGroups().isEmpty() ? "" : Character.valueOf('/')));
                    }
                }
                break;
            }
        }
        return candidates;
    }

    @Override
    public boolean expectEndOfNode() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Group getCurrentNode(String path) throws PathConsumerException {
        boolean completePath = path.endsWith(ROOT);
        String chunk = completePath ? null : path.substring(path.lastIndexOf(ROOT) + 1);
        switch (this.state) {
            case UNKNOWN: {
                if (chunk != null) {
                    void var6_34;
                    Group grp = this.groups.get(chunk);
                    if (grp == null) {
                        throw new PathConsumerException("Unknown " + chunk);
                    }
                    String string = chunk;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 750867693: {
                            if (!string.equals(PACKAGES)) break;
                            boolean bl = false;
                            break;
                        }
                        case 1693384321: {
                            if (!string.equals(FEATURES)) break;
                            boolean bl = true;
                            break;
                        }
                        case 503774505: {
                            if (!string.equals(DEPENDENCIES)) break;
                            int n2 = 2;
                        }
                    }
                    switch (var6_34) {
                        case 0: {
                            grp = Group.fromString("", PACKAGES);
                            for (String cf : this.info.getPackages().keySet()) {
                                grp.getGroups().add(Group.fromString("", cf));
                            }
                            break;
                        }
                        case 1: {
                            grp = Group.fromString("", FEATURES);
                            for (String cf : this.info.getFeatureSpecs().keySet()) {
                                grp.getGroups().add(Group.fromString("", cf));
                            }
                            break;
                        }
                        case 2: {
                            grp = Group.fromString("", DEPENDENCIES);
                            for (String cf : this.info.getFullDependencies().keySet()) {
                                grp.getGroups().add(Group.fromString("", cf));
                            }
                            break;
                        }
                    }
                    return grp;
                }
                return this.rootGrp;
            }
            case FINAL: {
                if (chunk != null) {
                    if (FINAL.equals(chunk)) {
                        Group grp = Group.fromString("", FINAL);
                        for (String string : this.info.getFinalConfigs().keySet()) {
                            grp.addGroup(Group.fromString("", string));
                        }
                        return grp;
                    }
                    throw new PathConsumerException("Unknown " + chunk);
                }
                return CONFIGS_GRP;
            }
            case CONFIG_MODEL: {
                if (chunk != null) {
                    String m = null;
                    for (String string : this.info.getFinalConfigs().keySet()) {
                        if (!string.equals(chunk)) continue;
                        m = string;
                        break;
                    }
                    if (m == null) {
                        throw new PathConsumerException("Unknown " + chunk);
                    }
                    Group grp = Group.fromString("", m);
                    for (ConfigInfo cf : this.info.getFinalConfigs().get(m)) {
                        grp.addGroup(Group.fromString("", cf.getName()));
                    }
                    return grp;
                }
                Group grp = Group.fromString("", FINAL);
                for (String string : this.info.getFinalConfigs().keySet()) {
                    grp.getGroups().add(Group.fromString("", string));
                }
                return grp;
            }
            case CONFIG_NAME: {
                if (chunk != null) {
                    Object c = null;
                    for (ConfigInfo configInfo : this.info.getFinalConfigs().get(this.configModel)) {
                        if (!configInfo.getName().equals(chunk)) continue;
                        Group grp = Group.fromString("", configInfo.getName());
                        grp.getGroups().addAll(configInfo.getRoot().getGroups());
                        return grp;
                    }
                    throw new PathConsumerException("Unknown " + chunk);
                }
                Group grp = Group.fromString("", this.configModel);
                for (ConfigInfo configInfo : this.info.getFinalConfigs().get(this.configModel)) {
                    grp.getGroups().add(Group.fromString("", configInfo.getName()));
                }
                return grp;
            }
            case FEATURES_ORIGIN: {
                if (chunk != null) {
                    for (String cf : this.info.getFeatureSpecs().keySet()) {
                        if (!cf.equals(chunk)) continue;
                        Group group = Group.fromString("", cf);
                        group.getGroups().addAll(this.info.getFeatureSpecs().get(cf).getGroups());
                        return group;
                    }
                    throw new PathConsumerException("Unknown " + chunk);
                }
                Group grp = Group.fromString("", FEATURES);
                for (String string : this.info.getFeatureSpecs().keySet()) {
                    grp.getGroups().add(Group.fromString("", string));
                }
                return grp;
            }
            case DEPENDENCIES_ORIGIN: {
                if (chunk != null) {
                    for (String cf : this.info.getFullDependencies().keySet()) {
                        if (!cf.equals(chunk)) continue;
                        return EXPLORE_ROOT_GRP;
                    }
                    throw new PathConsumerException("Unknown " + chunk);
                }
                Group grp = Group.fromString("", DEPENDENCIES);
                for (String string : this.info.getFullDependencies().keySet()) {
                    grp.getGroups().add(Group.fromString("", string));
                }
                return grp;
            }
            case PACKAGES_ORIGIN: {
                if (chunk != null) {
                    for (String cf : this.info.getPackages().keySet()) {
                        if (!cf.equals(chunk)) continue;
                        Group group = Group.fromString("", cf);
                        group.getGroups().addAll(this.info.getPackages().get(cf).getGroups());
                        return group;
                    }
                    throw new PathConsumerException("Unknown " + chunk);
                }
                Group grp = Group.fromString("", PACKAGES);
                for (String string : this.info.getPackages().keySet()) {
                    grp.getGroups().add(Group.fromString("", string));
                }
                return grp;
            }
            case PACKAGES_CONTENT: {
                Group root;
                Group grp;
                if (this.current == null) {
                    grp = Group.fromString("", this.packagesGav);
                    root = this.info.getPackages().get(this.packagesGav);
                    if (root == null) {
                        throw new PathConsumerException("no package in " + this.packagesGav);
                    }
                    grp.getGroups().addAll(root.getGroups());
                    this.current = grp;
                }
            }
            case FEATURES_CONTENT: {
                Group root;
                Group grp;
                if (this.current == null) {
                    grp = Group.fromString("", this.featuresGav);
                    root = this.info.getFeatureSpecs().get(this.featuresGav);
                    if (root == null) {
                        throw new PathConsumerException("no feature in " + this.packagesGav);
                    }
                    grp.getGroups().addAll(root.getGroups());
                    this.current = grp;
                }
            }
            case CONFIG_CONTENT: {
                Group grp;
                if (this.current == null) {
                    grp = Group.fromString("", this.config.getName());
                    if (grp == null) {
                        throw new PathConsumerException("not a valid config " + this.config.getName());
                    }
                    grp.getGroups().addAll(this.config.getRoot().getGroups());
                    this.current = grp;
                }
                if (chunk != null) {
                    for (Group fg : this.current.getGroups()) {
                        if (!fg.getIdentity().getName().equals(chunk)) continue;
                        return fg;
                    }
                    throw new PathConsumerException("Unknown " + chunk);
                }
                return this.current;
            }
        }
        return null;
    }

    static {
        EDIT_ROOT_GRP.addGroup(PACKAGES_GRP);
        EDIT_ROOT_GRP.addGroup(FEATURES_GRP);
        EDIT_ROOT_GRP.addGroup(CONFIGS_GRP);
        EDIT_ROOT_GRP.addGroup(DEPENDENCIES_GRP);
        EXPLORE_ROOT_GRP.addGroup(PACKAGES_GRP);
        EXPLORE_ROOT_GRP.addGroup(FEATURES_GRP);
        EXPLORE_ROOT_GRP.addGroup(CONFIGS_GRP);
        CONFIGS_GRP.addGroup(FINAL_GRP);
        EDIT_GROUPS.put(PACKAGES, PACKAGES_GRP);
        EDIT_GROUPS.put(DEPENDENCIES, DEPENDENCIES_GRP);
        EDIT_GROUPS.put(CONFIGS, CONFIGS_GRP);
        EDIT_GROUPS.put(FEATURES, FEATURES_GRP);
        EXPLORE_GROUPS.put(PACKAGES, PACKAGES_GRP);
        EXPLORE_GROUPS.put(CONFIGS, CONFIGS_GRP);
        EXPLORE_GROUPS.put(FEATURES, FEATURES_GRP);
    }

    public static enum State {
        NOT_STARTED,
        UNKNOWN,
        FINAL,
        CONFIGS,
        DEPENDENCIES,
        DEPENDENCIES_ORIGIN,
        FEATURES,
        FEATURES_ORIGIN,
        FEATURES_CONTENT,
        PACKAGES_CONTENT,
        PACKAGES_ORIGIN,
        CONFIG_MODEL,
        CONFIG_NAME,
        CONFIG_CONTENT;

    }
}

