/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.path.PathTranslator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;

public class PluginParameterExpressionEvaluator
implements TypeAwareExpressionEvaluator {
    private MavenSession session;
    private MojoExecution mojoExecution;
    private MavenProject project;
    private String basedir;
    private Properties properties;

    @Deprecated
    public PluginParameterExpressionEvaluator(MavenSession session, MojoExecution mojoExecution, PathTranslator pathTranslator, Logger logger, MavenProject project, Properties properties) {
        this(session, mojoExecution);
    }

    public PluginParameterExpressionEvaluator(MavenSession session) {
        this(session, null);
    }

    public PluginParameterExpressionEvaluator(MavenSession session, MojoExecution mojoExecution) {
        File projectFile;
        this.session = session;
        this.mojoExecution = mojoExecution;
        this.properties = session.getExecutionProperties();
        this.project = session.getCurrentProject();
        String basedir = null;
        if (this.project != null && (projectFile = this.project.getBasedir()) != null) {
            basedir = projectFile.getAbsolutePath();
        }
        if (basedir == null) {
            basedir = session.getExecutionRootDirectory();
        }
        if (basedir == null) {
            basedir = System.getProperty("user.dir");
        }
        this.basedir = basedir;
    }

    @Override
    public Object evaluate(String expr) throws ExpressionEvaluationException {
        return this.evaluate(expr, null);
    }

    @Override
    public Object evaluate(String expr, Class<?> type) throws ExpressionEvaluationException {
        String val;
        int exprStartDelimiter;
        String pathExpression;
        int pathSeparator;
        Object value = null;
        if (expr == null) {
            return null;
        }
        String expression = this.stripTokens(expr);
        if (expression.equals(expr)) {
            int lastIndex;
            int index = expr.indexOf("${");
            if (index >= 0 && (lastIndex = expr.indexOf("}", index)) >= 0) {
                Object subResult;
                String retVal = expr.substring(0, index);
                retVal = index > 0 && expr.charAt(index - 1) == '$' ? retVal + expr.substring(index + 1, lastIndex + 1) : ((subResult = this.evaluate(expr.substring(index, lastIndex + 1))) != null ? retVal + subResult : retVal + "$" + expr.substring(index + 1, lastIndex + 1));
                retVal = retVal + this.evaluate(expr.substring(lastIndex + 1));
                return retVal;
            }
            if (expression.contains("$$")) {
                return expression.replaceAll("\\$\\$", "\\$");
            }
            return expression;
        }
        MojoDescriptor mojoDescriptor = this.mojoExecution.getMojoDescriptor();
        if ("localRepository".equals(expression)) {
            value = this.session.getLocalRepository();
        } else if ("session".equals(expression)) {
            value = this.session;
        } else if (expression.startsWith("session")) {
            try {
                pathSeparator = expression.indexOf("/");
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(1, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression, this.session);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), this.session);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if ("reactorProjects".equals(expression)) {
            value = this.session.getProjects();
        } else if ("mojoExecution".equals(expression)) {
            value = this.mojoExecution;
        } else if ("project".equals(expression)) {
            value = this.project;
        } else if ("executedProject".equals(expression)) {
            value = this.project.getExecutionProject();
        } else if (expression.startsWith("project") || expression.startsWith("pom")) {
            try {
                pathSeparator = expression.indexOf("/");
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(0, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression, this.project);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), this.project);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if (expression.equals("repositorySystemSession")) {
            value = this.session.getRepositorySession();
        } else if (expression.equals("mojo")) {
            value = this.mojoExecution;
        } else if (expression.startsWith("mojo")) {
            try {
                pathSeparator = expression.indexOf("/");
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(1, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression, this.mojoExecution);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), this.mojoExecution);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if (expression.equals("plugin")) {
            value = mojoDescriptor.getPluginDescriptor();
        } else if (expression.startsWith("plugin")) {
            try {
                pathSeparator = expression.indexOf("/");
                PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
                if (pathSeparator > 0) {
                    String pathExpression2 = expression.substring(1, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression2, pluginDescriptor);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), pluginDescriptor);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if ("settings".equals(expression)) {
            value = this.session.getSettings();
        } else if (expression.startsWith("settings")) {
            try {
                pathSeparator = expression.indexOf("/");
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(1, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression, this.session.getSettings());
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), this.session.getSettings());
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if ("basedir".equals(expression)) {
            value = this.basedir;
        } else if (expression.startsWith("basedir") && (pathSeparator = expression.indexOf("/")) > 0) {
            value = this.basedir + expression.substring(pathSeparator);
        }
        if (value != null && type != null && !(value instanceof String) && !PluginParameterExpressionEvaluator.isTypeCompatible(type, value)) {
            value = null;
        }
        if (value == null) {
            if (this.properties != null) {
                value = this.properties.getProperty(expression);
            }
            if (value == null && this.project != null && this.project.getProperties() != null) {
                value = this.project.getProperties().getProperty(expression);
            }
        }
        if (value instanceof String && (exprStartDelimiter = (val = (String)value).indexOf("${")) >= 0) {
            value = exprStartDelimiter > 0 ? val.substring(0, exprStartDelimiter) + this.evaluate(val.substring(exprStartDelimiter)) : this.evaluate(val.substring(exprStartDelimiter));
        }
        return value;
    }

    private static boolean isTypeCompatible(Class<?> type, Object value) {
        if (type.isInstance(value)) {
            return true;
        }
        return (type.isPrimitive() || type.getName().startsWith("java.lang.")) && value.getClass().getName().startsWith("java.lang.");
    }

    private String stripTokens(String expr) {
        if (expr.startsWith("${") && expr.indexOf("}") == expr.length() - 1) {
            expr = expr.substring(2, expr.length() - 1);
        }
        return expr;
    }

    @Override
    public File alignToBaseDirectory(File file) {
        if (file != null && !file.isAbsolute()) {
            file = file.getPath().startsWith(File.separator) ? file.getAbsoluteFile() : new File(new File(this.basedir, file.getPath()).toURI().normalize()).getAbsoluteFile();
        }
        return file;
    }
}

