/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.swingui.SPSUtils;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public abstract class AbstractArchitectAction
extends AbstractAction {
    protected final ArchitectFrame frame;
    private final PlayPen playpen;
    private final ArchitectSwingSession session;

    public AbstractArchitectAction(ArchitectSwingSession session, ArchitectFrame frame, PlayPen playpen, String actionName, String actionDescription, Icon icon) {
        super(actionName, icon);
        this.putValue("ShortDescription", actionDescription);
        this.session = session;
        if (session == null) {
            throw new NullPointerException("Null session");
        }
        this.frame = frame;
        if (frame == null) {
            throw new NullPointerException("Null parentFrame");
        }
        this.playpen = playpen;
        if (playpen == null) {
            throw new NullPointerException("Null playpen");
        }
    }

    public AbstractArchitectAction(ArchitectSwingSession session, PlayPen playpen, String actionName, String actionDescription, Icon icon) {
        this(session, session.getArchitectFrame(), playpen, actionName, actionDescription, icon);
    }

    public AbstractArchitectAction(ArchitectSwingSession session, ArchitectFrame frame, String actionName, String actionDescription, Icon icon) {
        super(actionName, icon);
        this.putValue("ShortDescription", actionDescription);
        this.frame = frame;
        this.session = session;
        this.playpen = null;
    }

    public AbstractArchitectAction(ArchitectFrame frame, String actionName, String actionDescription, Icon icon) {
        super(actionName, icon);
        this.putValue("ShortDescription", actionDescription);
        this.frame = frame;
        this.session = null;
        this.playpen = null;
    }

    public AbstractArchitectAction(ArchitectSwingSession session, ArchitectFrame frame, String actionName, String actionDescription, String iconResourceName) {
        this(session, frame, actionName, actionDescription, iconResourceName == null ? (Icon)null : SPSUtils.createIcon((String)iconResourceName, (String)actionName, (int)16));
    }

    public AbstractArchitectAction(ArchitectSwingSession session, String actionName, String actionDescription, String iconResourceName) {
        this(session, actionName, actionDescription, iconResourceName == null ? (Icon)null : SPSUtils.createIcon((String)iconResourceName, (String)actionName, (int)16));
    }

    public AbstractArchitectAction(ArchitectFrame frame, String actionName, String actionDescription, String iconResourceName) {
        this(frame, actionName, actionDescription, iconResourceName == null ? (Icon)null : SPSUtils.createIcon((String)iconResourceName, (String)actionName, (int)16));
    }

    public AbstractArchitectAction(ArchitectSwingSession session, PlayPen pp, String actionName, String actionDescription, String iconResourceName) {
        this(session, pp, actionName, actionDescription, iconResourceName == null ? (Icon)null : SPSUtils.createIcon((String)iconResourceName, (String)actionName, (int)16));
    }

    public AbstractArchitectAction(ArchitectSwingSession session, String actionName, String actionDescription, Icon icon) {
        this(session, session.getPlayPen(), actionName, actionDescription, icon);
    }

    public AbstractArchitectAction(ArchitectSwingSession session, String actionName, String actionDescription) {
        this(session, actionName, actionDescription, (Icon)null);
    }

    public AbstractArchitectAction(ArchitectFrame frame, String actionName, String actionDescription) {
        this(frame, actionName, actionDescription, (Icon)null);
    }

    protected ArchitectSwingSession getSession() {
        return this.session == null ? this.frame.getCurrentSession() : this.session;
    }

    protected PlayPen getPlaypen() {
        return this.playpen == null ? this.getSession().getPlayPen() : this.playpen;
    }
}

