/*
 * Decompiled with CFR 0.152.
 */
package tr.background.recurrence;

import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.openide.util.NbBundle;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.action.Recurrence;
import tr.model.project.Project;

final class RecurrenceTaskThread
extends Thread {
    private static final Logger LOG = Logger.getLogger("tr.recurrence");
    private static final String NAME = NbBundle.getMessage(RecurrenceTaskThread.class, (String)"recurrence.task");
    private List<Integer> done;

    public RecurrenceTaskThread() {
        super(NAME);
    }

    public void run() {
        LOG.info("Started.");
        this.process();
        LOG.info("Finished.");
    }

    private void process() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            LOG.severe("Data instance could not be obtained.");
            return;
        }
        this.done = new Vector<Integer>();
        for (Action action : data.getRootActions().getChildren(Action.class)) {
            this.process(action);
        }
        for (Project project : data.getRootProjects().getChildren(Project.class)) {
            this.process(project);
        }
    }

    private void process(Project project) {
        for (Project subproject : project.getChildren(Project.class)) {
            this.process(subproject);
        }
        for (Action action : project.getChildren(Action.class)) {
            this.process(action);
        }
    }

    private void process(Action action) {
        Recurrence recurrence = action.getRecurrence();
        if (recurrence == null) {
            return;
        }
        if (recurrence.getBasis() != Recurrence.Basis.START_DATE) {
            return;
        }
        if (this.done.contains(recurrence.getID())) {
            return;
        }
        recurrence.generateFromGenToDate();
        this.done.add(recurrence.getID());
    }
}

