/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.modules.favorites.Actions;
import org.netbeans.modules.favorites.Favorites;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class Tab
extends TopComponent
implements Runnable,
ExplorerManager.Provider {
    static final long serialVersionUID = -8178367548546385799L;
    private static final DataObject[] needToSelect = new DataObject[1];
    private static final Logger LOG = Logger.getLogger(Tab.class.getName());
    private static transient Tab DEFAULT;
    protected transient TreeView view;
    private transient PropertyChangeListener weakRcL;
    private transient NodeListener weakNRcL;
    private transient NodeListener rcListener;
    private transient boolean valid = true;
    private ExplorerManager manager = new ExplorerManager();

    private Tab() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)actionMap));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(Tab.class);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    protected String preferredID() {
        return "favorites";
    }

    protected void componentShowing() {
        super.componentShowing();
        if (this.view == null) {
            this.view = this.initGui();
            this.view.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Tab.class, (String)"ACSN_ExplorerBeanTree"));
            this.view.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Tab.class, (String)"ACSD_ExplorerBeanTree"));
        }
        this.run();
    }

    protected TreeView initGui() {
        BeanTreeView beanTreeView = new BeanTreeView();
        beanTreeView.setRootVisible(false);
        beanTreeView.setDragSource(true);
        this.setLayout(new BorderLayout());
        this.add((Component)beanTreeView);
        return beanTreeView;
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.view != null) {
            this.view.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        if (this.view != null) {
            return this.view.requestFocusInWindow();
        }
        return false;
    }

    public void setRootContext(Node node) {
        Node node2 = this.getExplorerManager().getRootContext();
        if (this.weakRcL != null) {
            node2.removePropertyChangeListener(this.weakRcL);
        }
        if (this.weakNRcL != null) {
            node2.removeNodeListener(this.weakNRcL);
        }
        this.getExplorerManager().setRootContext(node);
        this.initializeWithRootContext(node);
    }

    public Node getRootContext() {
        return this.getExplorerManager().getRootContext();
    }

    public void run() {
        if (!this.valid) {
            this.valid = true;
            this.validateRootContext();
        }
    }

    protected void updateTitle() {
        this.setName(this.getExplorerManager().getRootContext().getDisplayName());
    }

    private NodeListener rcListener() {
        if (this.rcListener == null) {
            this.rcListener = new RootContextListener();
        }
        return this.rcListener;
    }

    private void initializeWithRootContext(Node node) {
        this.setIcon(node.getIcon(1));
        this.setToolTipText(node.getDisplayName());
        this.setName(node.getDisplayName());
        this.updateTitle();
        if (this.weakRcL == null) {
            this.weakRcL = WeakListeners.propertyChange((PropertyChangeListener)this.rcListener(), (Object)node);
        }
        node.addPropertyChangeListener(this.weakRcL);
        if (this.weakNRcL == null) {
            this.weakNRcL = NodeOp.weakNodeListener((NodeListener)this.rcListener(), (Object)node);
        }
        node.addNodeListener(this.weakNRcL);
    }

    protected final void scheduleValidation() {
        this.valid = false;
        SwingUtilities.invokeLater(this);
    }

    public void setName(String string) {
        super.setName(string);
        if (this.view != null) {
            this.view.getAccessibleContext().setAccessibleName(string);
        }
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        if (this.view != null) {
            this.view.getAccessibleContext().setAccessibleDescription(string);
        }
    }

    public static synchronized Tab getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new Tab();
            DEFAULT.scheduleValidation();
        }
        return DEFAULT;
    }

    public static synchronized Tab findDefault() {
        if (DEFAULT == null) {
            TopComponent topComponent = WindowManager.getDefault().findTopComponent("favorites");
            if (DEFAULT == null) {
                Logger.getLogger(Tab.class.getName()).log(Level.WARNING, null, new IllegalStateException("Can not find project component for its ID. Returned " + topComponent));
                DEFAULT = new Tab();
                DEFAULT.scheduleValidation();
            }
        }
        return DEFAULT;
    }

    public int getPersistenceType() {
        return 0;
    }

    private static Node findClosestNode(DataObject dataObject, Node node, boolean bl) {
        Node node2;
        Node node3;
        DataObject dataObject2 = dataObject;
        Stack<DataObject> stack = new Stack<DataObject>();
        while (dataObject != null) {
            stack.push(dataObject);
            node3 = dataObject.getFolder();
            if (node3 == null) {
                FileObject fileObject = FileUtil.getArchiveFile((FileObject)dataObject.getPrimaryFile());
                if (fileObject != null) {
                    try {
                        dataObject = DataObject.find((FileObject)fileObject);
                        stack.pop();
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        dataObject = null;
                    }
                    continue;
                }
                dataObject = null;
                continue;
            }
            dataObject = node3;
        }
        node3 = node;
        int n = stack.size();
        int n2 = 0;
        while (n2 < n) {
            node2 = Tab.findDataObject(node3, (DataObject)stack.get(n2));
            if (node2 != null) {
                node3 = node2;
                n = n2;
                n2 = 0;
                continue;
            }
            ++n2;
        }
        if (!Tab.check(node3, dataObject2) && bl) {
            node2 = node3.getChildren().getNodes();
            for (int i = 0; i < ((Node[])node2).length; ++i) {
                Node node4 = node2[i];
                Node node5 = Tab.selectInLogicalViews(dataObject2, node4);
                if (!Tab.check(node5, dataObject2)) continue;
                node3 = node5;
                break;
            }
        }
        return node3;
    }

    private static Node selectInLogicalViews(DataObject dataObject, Node node) {
        return node;
    }

    private boolean selectNode(DataObject dataObject, Node node) {
        Node node2 = Tab.findClosestNode(dataObject, node, true);
        try {
            this.getExplorerManager().setSelectedNodes(new Node[]{node2});
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new IllegalStateException();
        }
        return Tab.check(node2, dataObject);
    }

    private static boolean check(Node node, DataObject dataObject) {
        DataObject dataObject2 = (DataObject)node.getLookup().lookup(DataObject.class);
        if (dataObject == dataObject2) {
            return true;
        }
        return dataObject2 instanceof DataShadow && dataObject == ((DataShadow)dataObject2).getOriginal();
    }

    private static Node findDataObject(Node node, DataObject dataObject) {
        Node[] nodeArray = node.getChildren().getNodes(true);
        for (int i = 0; i < nodeArray.length; ++i) {
            DataShadow dataShadow = (DataShadow)nodeArray[i].getCookie(DataShadow.class);
            if (dataShadow != null && dataObject == dataShadow.getOriginal()) {
                return nodeArray[i];
            }
            DataObject dataObject2 = (DataObject)nodeArray[i].getCookie(DataObject.class);
            if (dataObject2 == null || dataObject != dataObject2) continue;
            return nodeArray[i];
        }
        return null;
    }

    protected void validateRootContext() {
        Node node = Favorites.getNode();
        this.setRootContext(node);
    }

    protected boolean containsNode(DataObject dataObject) {
        Node node = Tab.findClosestNode(dataObject, this.getExplorerManager().getRootContext(), true);
        return Tab.check(node, dataObject);
    }

    protected void doSelectNode(DataObject dataObject) {
        if (dataObject == null) {
            return;
        }
        Node node = this.getExplorerManager().getRootContext();
        if (this.selectNode(dataObject, node)) {
            this.requestActive();
            StatusDisplayer.getDefault().setStatusText("");
        } else {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Tab.class, (String)"MSG_NodeNotFound"));
            FileObject fileObject = Tab.chooseFileObject(dataObject.getPrimaryFile());
            if (fileObject == null) {
                return;
            }
            try {
                Node[] nodeArray = new Node[]{DataObject.find((FileObject)fileObject).getNodeDelegate()};
                DataFolder dataFolder = Favorites.getFolder();
                DataObject[] dataObjectArray = dataFolder.getChildren();
                ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
                DataObject dataObject2 = null;
                dataObject2 = Actions.Add.createShadows(dataFolder, nodeArray, arrayList);
                Actions.Add.reorderAfterAddition(dataFolder, dataObjectArray, arrayList);
                Actions.Add.selectAfterAddition(dataObject2);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOG.log(Level.WARNING, null, dataObjectNotFoundException);
            }
        }
    }

    private static FileObject chooseFileObject(FileObject fileObject) {
        FileObject fileObject2 = null;
        File file = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setDialogTitle(NbBundle.getBundle(Actions.class).getString("CTL_DialogTitle"));
        jFileChooser.setApproveButtonText(NbBundle.getBundle(Actions.class).getString("CTL_ApproveButtonText"));
        jFileChooser.setSelectedFile(FileUtil.toFile((FileObject)fileObject));
        int n = jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
            File file2 = FileUtil.normalizeFile((File)file);
            if (!file2.exists() && file2.getParentFile() != null && file2.getParentFile().exists() && file2.getName().equals(file2.getParentFile().getName())) {
                file2 = file2.getParentFile();
            }
            if (!file2.exists()) {
                String string = NbBundle.getMessage(Actions.class, (String)"ERR_FileDoesNotExist", (Object)file2.getPath());
                String string2 = NbBundle.getMessage(Actions.class, (String)"ERR_FileDoesNotExistDlgTitle");
                DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)string, string2, -1, 1, new Object[]{NotifyDescriptor.CLOSED_OPTION}, NotifyDescriptor.OK_OPTION));
            } else {
                fileObject2 = FileUtil.toFileObject((File)file2);
                assert (fileObject2 != null);
            }
        }
        return fileObject2;
    }

    public Object readResolve() throws ObjectStreamException {
        Tab.getDefault().scheduleValidation();
        return Tab.getDefault();
    }

    private final class RootContextListener
    implements NodeListener {
        private RootContextListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getSource();
            Node node = (Node)object;
            if ("displayName".equals(string) || "name".equals(string)) {
                Tab.this.setName(node.getDisplayName());
            } else if ("icon".equals(string)) {
                Tab.this.setIcon(node.getIcon(1));
            } else if ("shortDescription".equals(string)) {
                Tab.this.setToolTipText(node.getShortDescription());
            }
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
            Tab.this.close();
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        }
    }
}

