/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.security.AccessController;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;

public final class HardlinkCopyDirectoryWrapper
extends FilterDirectory {
    public HardlinkCopyDirectoryWrapper(Directory in) {
        super(in);
    }

    public void copyFrom(Directory from, String srcFile, String destFile, IOContext context) throws IOException {
        Directory fromUnwrapped = FilterDirectory.unwrap((Directory)from);
        Directory toUnwrapped = FilterDirectory.unwrap((Directory)this);
        Exception suppressedException = null;
        boolean tryCopy = true;
        if (fromUnwrapped instanceof FSDirectory && toUnwrapped instanceof FSDirectory) {
            Path fromPath = ((FSDirectory)fromUnwrapped).getDirectory();
            Path toPath = ((FSDirectory)toUnwrapped).getDirectory();
            if (Files.isReadable(fromPath.resolve(srcFile)) && Files.isWritable(toPath)) {
                suppressedException = AccessController.doPrivileged(() -> {
                    try {
                        Files.createLink(toPath.resolve(destFile), fromPath.resolve(srcFile));
                    }
                    catch (FileNotFoundException | FileAlreadyExistsException | NoSuchFileException ex) {
                        return ex;
                    }
                    catch (IOException | SecurityException | UnsupportedOperationException ex) {
                        return ex;
                    }
                    return null;
                });
                boolean bl = tryCopy = suppressedException != null;
            }
        }
        if (tryCopy) {
            try {
                super.copyFrom(from, srcFile, destFile, context);
            }
            catch (Exception ex) {
                if (suppressedException != null) {
                    ex.addSuppressed(suppressedException);
                }
                throw ex;
            }
        }
    }
}

