/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.facet.FacetParser;
import org.apache.solr.search.facet.FacetRange;

class FacetRangeParser
extends FacetParser<FacetRange> {
    public FacetRangeParser(FacetParser parent, String key) {
        super(parent, key);
        this.facet = new FacetRange();
    }

    @Override
    public FacetRange parse(Object arg) throws SyntaxError {
        this.parseCommonParams(arg);
        if (!(arg instanceof Map)) {
            throw this.err("Missing range facet arguments");
        }
        Map m = (Map)arg;
        ((FacetRange)this.facet).field = this.getString(m, "field", null);
        ((FacetRange)this.facet).ranges = this.getVal(m, "ranges", false);
        boolean required = ((FacetRange)this.facet).ranges == null;
        ((FacetRange)this.facet).start = this.getVal(m, "start", required);
        ((FacetRange)this.facet).end = this.getVal(m, "end", required);
        ((FacetRange)this.facet).gap = this.getVal(m, "gap", required);
        ((FacetRange)this.facet).hardend = this.getBoolean(m, "hardend", ((FacetRange)this.facet).hardend);
        ((FacetRange)this.facet).mincount = this.getLong(m, "mincount", 0L);
        List<String> list = this.getStringList(m, "include", false);
        String[] includeList = null;
        if (list != null) {
            includeList = list.toArray(new String[list.size()]);
        }
        ((FacetRange)this.facet).include = FacetParams.FacetRangeInclude.parseParam(includeList);
        ((FacetRange)this.facet).others = EnumSet.noneOf(FacetParams.FacetRangeOther.class);
        List<String> other = this.getStringList(m, "other", false);
        if (other != null) {
            for (String otherStr : other) {
                ((FacetRange)this.facet).others.add(FacetParams.FacetRangeOther.get((String)otherStr));
            }
        }
        Object facetObj = m.get("facet");
        this.parseSubs(facetObj);
        return (FacetRange)this.facet;
    }
}

