/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.streamr;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.streamr.MultiSource;
import net.i2p.i2ptunnel.udp.Sink;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

public class Subscriber
implements Sink {
    private final I2PAppContext ctx = I2PAppContext.getGlobalContext();
    private final Log log = this.ctx.logManager().getLog(this.getClass());
    private final Map<Destination, Long> subscriptions;
    private final MultiSource multi;
    private final SimpleTimer2.TimedEvent timer;
    private volatile boolean timerRunning;
    private static final int MAX_SUBSCRIPTIONS = 10;
    private static final long EXPIRATION = 60000L;

    public Subscriber(MultiSource multi) {
        this.multi = multi;
        this.subscriptions = new ConcurrentHashMap<Destination, Long>();
        this.timer = new Expire();
    }

    @Override
    public void send(Destination dest, byte[] data) {
        if (dest == null || data.length < 1) {
            if (this.log.shouldWarn()) {
                this.log.warn("bad subscription from " + dest);
            }
        } else {
            byte ctrl = data[0];
            if (ctrl == 0) {
                if (this.subscriptions.put(dest, this.ctx.clock().now()) == null) {
                    if (this.subscriptions.size() > 10) {
                        this.subscriptions.remove(dest);
                        if (this.log.shouldWarn()) {
                            this.log.warn("Too many subscriptions, denying: " + dest.toBase32());
                        }
                        return;
                    }
                    if (this.log.shouldWarn()) {
                        this.log.warn("Add subscription: " + dest.toBase32());
                    }
                    this.multi.add(dest);
                    if (!this.timerRunning) {
                        this.timer.reschedule(60000L);
                        this.timerRunning = true;
                    }
                } else if (this.log.shouldInfo()) {
                    this.log.info("Continue subscription: " + dest.toBase32());
                }
            } else if (ctrl == 1) {
                if (this.log.shouldWarn()) {
                    this.log.warn("Remove subscription: " + dest.toBase32());
                }
                if (this.subscriptions.remove(dest) != null) {
                    this.multi.remove(dest);
                }
            } else if (this.log.shouldWarn()) {
                this.log.warn("bad subscription from " + dest);
            }
        }
    }

    private class Expire
    extends SimpleTimer2.TimedEvent {
        public Expire() {
            super(Subscriber.this.ctx.simpleTimer2());
        }

        @Override
        public void timeReached() {
            if (Subscriber.this.subscriptions.isEmpty()) {
                Subscriber.this.timerRunning = false;
                return;
            }
            long exp = Subscriber.this.ctx.clock().now() - 60000L;
            Iterator iter = Subscriber.this.subscriptions.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                long then = (Long)e.getValue();
                if (then >= exp) continue;
                Destination dest = (Destination)e.getKey();
                iter.remove();
                Subscriber.this.multi.remove(dest);
                if (!Subscriber.this.log.shouldWarn()) continue;
                Subscriber.this.log.warn("Expired subscription: " + dest.toBase32());
            }
            if (!Subscriber.this.subscriptions.isEmpty()) {
                this.schedule(60000L);
                Subscriber.this.timerRunning = true;
            } else {
                Subscriber.this.timerRunning = false;
            }
        }
    }
}

