/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import net.i2p.data.Hash;
import net.i2p.router.ProfileManager;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.DBHistory;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.util.Log;

public class ProfileManagerImpl
implements ProfileManager {
    private final Log _log;
    private final RouterContext _context;

    public ProfileManagerImpl(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(ProfileManagerImpl.class);
    }

    @Override
    public void messageSent(Hash peer, String transport, long msToSend, long bytesSent) {
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data == null) {
            return;
        }
        data.setLastSendSuccessful(this._context.clock().now());
    }

    @Override
    public void messageFailed(Hash peer, String transport) {
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data == null) {
            return;
        }
        data.setLastSendFailed(this._context.clock().now());
    }

    @Override
    public void messageFailed(Hash peer) {
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data == null) {
            return;
        }
        data.setLastSendFailed(this._context.clock().now());
    }

    @Override
    public void commErrorOccurred(Hash peer) {
        if (this._log.shouldLog(20)) {
            this._log.info("Comm error occurred for peer " + peer.toBase64(), new Exception("Comm error"));
        }
        PeerProfile data = this.getProfile(peer);
        data.setLastSendFailed(this._context.clock().now());
    }

    @Override
    public void tunnelJoined(Hash peer, long responseTimeMs) {
        PeerProfile data = this.getProfile(peer);
        data.getTunnelCreateResponseTime().addData(responseTimeMs, responseTimeMs);
        data.setLastHeardFrom(this._context.clock().now());
        data.getTunnelHistory().incrementAgreedTo();
    }

    @Override
    public void tunnelRejected(Hash peer, long responseTimeMs, int severity) {
        PeerProfile data = this.getProfile(peer);
        data.setLastHeardFrom(this._context.clock().now());
        data.getTunnelHistory().incrementRejected(severity);
    }

    @Override
    public void tunnelTimedOut(Hash peer) {
        PeerProfile data = this.getProfile(peer);
        data.getTunnelHistory().incrementRejected(30);
    }

    @Override
    public void tunnelTestSucceeded(Hash peer, long responseTimeMs) {
    }

    @Override
    public void tunnelDataPushed(Hash peer, long rtt, int size) {
        if (this._context.routerHash().equals(peer)) {
            return;
        }
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data != null) {
            data.dataPushed(size);
        }
    }

    @Override
    public void tunnelDataPushed1m(Hash peer, int size) {
        if (this._context.routerHash().equals(peer)) {
            return;
        }
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data != null) {
            data.dataPushed1m(size);
        }
    }

    @Override
    public void tunnelLifetimePushed(Hash peer, long lifetime, long size) {
        if (this._context.routerHash().equals(peer)) {
            return;
        }
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data != null) {
            data.tunnelDataTransferred(size);
        }
    }

    @Override
    public void tunnelFailed(Hash peer, int pct) {
        PeerProfile data = this.getProfile(peer);
        data.setLastHeardFrom(this._context.clock().now());
        data.getTunnelHistory().incrementFailed(pct);
    }

    @Override
    public void dbLookupSuccessful(Hash peer, long responseTimeMs) {
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data == null) {
            return;
        }
        data.setLastHeardFrom(this._context.clock().now());
        if (!data.getIsExpandedDB()) {
            data.expandDBProfile();
        }
        data.getDbResponseTime().addData(responseTimeMs, responseTimeMs);
        DBHistory hist = data.getDBHistory();
        hist.lookupSuccessful();
    }

    @Override
    public void dbLookupFailed(Hash peer) {
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data == null) {
            return;
        }
        if (!data.getIsExpandedDB()) {
            data.expandDBProfile();
        }
        DBHistory hist = data.getDBHistory();
        hist.lookupFailed();
    }

    @Override
    public void dbLookupReply(Hash peer, int newPeers, int oldPeers, int invalid, int duplicate, long responseTimeMs) {
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data == null) {
            return;
        }
        data.setLastHeardFrom(this._context.clock().now());
        if (!data.getIsExpandedDB()) {
            return;
        }
        data.getDbResponseTime().addData(responseTimeMs, responseTimeMs);
        data.getDbIntroduction().addData(newPeers, responseTimeMs);
        DBHistory hist = data.getDBHistory();
        hist.lookupReply(newPeers, oldPeers, invalid, duplicate);
    }

    @Override
    public void dbLookupReceived(Hash peer) {
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data == null) {
            return;
        }
        data.setLastHeardFrom(this._context.clock().now());
        if (!data.getIsExpandedDB()) {
            return;
        }
    }

    @Override
    public void dbStoreReceived(Hash peer, boolean wasNewKey) {
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data == null) {
            return;
        }
        data.setLastHeardFrom(this._context.clock().now());
        if (!data.getIsExpandedDB()) {
            return;
        }
        DBHistory hist = data.getDBHistory();
        hist.unpromptedStoreReceived(wasNewKey);
    }

    @Override
    public void dbStoreSent(Hash peer, long responseTimeMs) {
        PeerProfile data = this.getProfile(peer);
        long now = this._context.clock().now();
        data.setLastHeardFrom(now);
        data.setLastSendSuccessful(now);
    }

    @Override
    public void dbStoreSuccessful(Hash peer) {
        PeerProfile data = this.getProfile(peer);
        long now = this._context.clock().now();
        data.setLastHeardFrom(now);
        data.setLastSendSuccessful(now);
        if (!data.getIsExpandedDB()) {
            data.expandDBProfile();
        }
        DBHistory hist = data.getDBHistory();
        hist.storeSuccessful();
    }

    @Override
    public void dbStoreFailed(Hash peer) {
        PeerProfile data = this.getProfile(peer);
        if (!data.getIsExpandedDB()) {
            data.expandDBProfile();
        }
        DBHistory hist = data.getDBHistory();
        hist.storeFailed();
    }

    @Override
    public void heardAbout(Hash peer) {
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data == null) {
            return;
        }
        data.setLastHeardAbout(this._context.clock().now());
    }

    @Override
    public void heardAbout(Hash peer, long when) {
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data == null) {
            return;
        }
        data.setLastHeardAbout(when);
    }

    @Override
    public void messageReceived(Hash peer, String style, long msToReceive, int bytesRead) {
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data == null) {
            return;
        }
        data.setLastHeardFrom(this._context.clock().now());
    }

    private PeerProfile getProfile(Hash peer) {
        PeerProfile prof = this._context.profileOrganizer().getProfile(peer);
        if (prof == null) {
            prof = new PeerProfile(this._context, peer);
            this._context.profileOrganizer().addProfile(prof);
        }
        return prof;
    }

    private PeerProfile getProfileNonblocking(Hash peer) {
        return this._context.profileOrganizer().getOrCreateProfileNonblocking(peer);
    }
}

