'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) send.n 1.15 95/08/12 17:35:21
'\" 
.so STk-man.macros
.TH send n 3.1 STk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
send \- Execute a command in a different application
.SH SYNOPSIS
(\fBsend ?\fIoptions\fR? \fIapp cmd \fR?\fIarg arg ...\fR?)
.br
(\fBinhibit-send\fR)
.BE

.SH DESCRIPTION
.PP
This procedure arranges for \fIcmd\fR (and \fIarg\fRs) to be executed in the
application named by \fIapp\fR. It returns the result (converted to a string)
that procedure execution.
\fIApp\fR may be the name of any application whose main window is
on the display containing the sender's main window;  it need not
be within the same process.
If no \fIarg\fR arguments are present, then the procedure to be executed is
contained entirely within the \fIcmd\fR argument.  If one or
more \fIarg\fRs are present, they are concatenated to form the
procedure to be executed, just as for the \fBeval\fR procedure.
.PP
If the initial arguments of the procedure begin with ``\-''
they are treated as options.  The following options are
currently defined:
.TP
\fB:async\fR
Requests asynchronous invocation.  In this case the \fBsend\fR
procedure will complete immediately without waiting for \fIcmd\fR
to complete in the target application;  no result will be available
and errors in the sent procedure will be ignored.
If the target application is in the same process as the sending
application then the \fB\:async\fR option is ignored.
.TP
\fB:displayof\fR \fIwidget\-name\fR
Specifies that the target application's main window is on the display
of the window given by \fIwidget\-name\fR, instead of the display containing
the application's main window.
.TP
\fB:-\fR
Serves no purpose except to terminate the list of options.  This
option is needed only if \fIapp\fR could contain a leading ``\-''
character.

.SH "APPLICATION NAMES"
.PP
The name of an application is set initially from the name of the
program or script that created the application.
You can query and change the name of an application with the
\fBtk appname\fR procedure.

.SH "DISABLING SENDS"
.PP
The \fBsend\fR procedure can be removed from an application 
by calling the \fBinhibit-send\fI procedure.
If the \fBsend\fR procedure is removed then the application
will not respond to incoming send requests anymore,  nor will it
be able to issue outgoing requests.
Communication can be reenabled by invoking the \fBtk appname\fR
procedure.

.SH SECURITY
.PP
The \fBsend\fR procedure is potentially a serious security loophole,
since any application that can connect to your X server can send
scripts to your applications.
These incoming scripts can use STk to read and
write your files and invoke subprocesses under your name.
Host-based access control such as that provided by \fBxhost\fR
is particularly insecure, since it allows anyone with an account
on particular hosts to connect to your server, and if disabled it
allows anyone anywhere to connect to your server.
In order to provide at least a small amount of
security, Tk checks the access control being used by the server
and rejects incoming sends unless (a) \fBxhost\fR-style access control
is enabled (i.e. only certain hosts can establish connections) and (b) the
list of enabled hosts is empty.
This means that applications cannot connect to your server unless
they use some other form of authorization
such as that provide by \fBxauth\fR.

.SH SEE ALSO
tk