(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (not safe))
  (define std/actor/rpc/connection#rpc-server-connection
    (lambda (_rpc-server2923_
             _actors2924_
             _sock2925_
             _sa2926_
             _cliaddr2927_
             _proto-e2928_)
      (with-exception-catcher
       (lambda (_g29292931_)
         (if '#t
             (let ((_e2934_ _g29292931_))
               (std/actor/rpc/connection#rpc-connection-cleanup
                _rpc-server2923_
                _e2934_
                _sock2925_))
             (raise _g29292931_)))
       (lambda ()
         (std/actor/rpc/connection#rpc-set-nodelay!
          _sock2925_
          (std/os/_socket#sockaddr_family _sa2926_))
         (std/actor/rpc/connection#rpc-connection-loop
          _rpc-server2923_
          _actors2924_
          _sock2925_
          _cliaddr2927_
          _proto-e2928_)))))
  (define std/actor/rpc/connection#rpc-client-connection
    (lambda (_rpc-server2906_ _actors2907_ _address2908_ _proto-e2909_)
      (with-exception-catcher
       (lambda (_g29102912_)
         (if '#t
             (let ((_e2915_ _g29102912_))
               (std/actor/rpc/connection#rpc-connection-cleanup
                _rpc-server2906_
                _e2915_
                '#f))
             (raise _g29102912_)))
       (lambda ()
         (let* ((_sa2918_ (std/os/socket#socket-address _address2908_))
                (_cli2920_ (std/net/socket/api#ssocket-connect__0 _sa2918_)))
           (std/actor/rpc/connection#rpc-set-nodelay!
            _cli2920_
            (std/os/_socket#sockaddr_family _sa2918_))
           (std/actor/rpc/connection#rpc-connection-loop
            _rpc-server2906_
            _actors2907_
            _cli2920_
            _address2908_
            _proto-e2909_))))))
  (define std/actor/rpc/connection#rpc-set-nodelay!
    (lambda (_sock2900_ _safamily2901_)
      (if (or (eq? _safamily2901_ std/os/_socket#AF_INET)
              (eq? _safamily2901_ std/os/_socket#AF_INET6))
          (std/os/socket#socket-setsockopt
           (##direct-structure-ref
            _sock2900_
            '1
            std/net/socket/base#!socket::t
            '#f)
           std/os/_socket#IPPROTO_TCP
           std/os/_socket#TCP_NODELAY
           '1)
          '#!void)))
  (define std/actor/rpc/connection#rpc-keep-alive '60)
  (define std/actor/rpc/connection#set-rpc-keep-alive-interval!
    (lambda (_dt2895_)
      (if (or (not _dt2895_) (and (real? _dt2895_) (positive? _dt2895_)))
          (set! std/actor/rpc/connection#rpc-keep-alive _dt2895_)
          (error '"bad keep-alive; expected positive real or #f" _dt2895_))))
  (define std/actor/rpc/connection#rpc-idle-timeout '#f)
  (define std/actor/rpc/connection#set-rpc-idle-timeout!
    (lambda (_dt2890_)
      (if (or (not _dt2890_) (and (real? _dt2890_) (positive? _dt2890_)))
          (set! std/actor/rpc/connection#rpc-idle-timeout _dt2890_)
          (error '"bad idle interval; expected positive real or #f"
                 _dt2890_))))
  (define std/actor/rpc/connection#rpc-call-timeout '60)
  (define std/actor/rpc/connection#set-rpc-call-timeout!
    (lambda (_dt2888_)
      (if (and (real? _dt2888_) (positive? _dt2888_) (finite? _dt2888_))
          (set! std/actor/rpc/connection#rpc-call-timeout _dt2888_)
          (if (not _dt2888_)
              (set! std/actor/rpc/connection#rpc-call-timeout '#f)
              (error '"bad timeout; expected finite positive real or #f"
                     _dt2888_)))))
  (define std/actor/rpc/connection#continuation-table::t
    (make-struct-type
     'std/actor/rpc/connection#continuation-table::t
     '#f
     '6
     'continuation-table
     '((final: . #t))
     ':init!
     '(mx continuations
          stream-continuations
          stream-actors
          timeouts
          continuation-timeouts)))
  (define std/actor/rpc/connection#continuation-table?
    (make-struct-predicate std/actor/rpc/connection#continuation-table::t))
  (define std/actor/rpc/connection#make-continuation-table
    (lambda _$args2885_
      (apply make-struct-instance
             std/actor/rpc/connection#continuation-table::t
             _$args2885_)))
  (define std/actor/rpc/connection#continuation-table-mx
    (make-struct-field-accessor
     std/actor/rpc/connection#continuation-table::t
     '0))
  (define std/actor/rpc/connection#continuation-table-continuations
    (make-struct-field-accessor
     std/actor/rpc/connection#continuation-table::t
     '1))
  (define std/actor/rpc/connection#continuation-table-stream-continuations
    (make-struct-field-accessor
     std/actor/rpc/connection#continuation-table::t
     '2))
  (define std/actor/rpc/connection#continuation-table-stream-actors
    (make-struct-field-accessor
     std/actor/rpc/connection#continuation-table::t
     '3))
  (define std/actor/rpc/connection#continuation-table-timeouts
    (make-struct-field-accessor
     std/actor/rpc/connection#continuation-table::t
     '4))
  (define std/actor/rpc/connection#continuation-table-continuation-timeouts
    (make-struct-field-accessor
     std/actor/rpc/connection#continuation-table::t
     '5))
  (define std/actor/rpc/connection#continuation-table-mx-set!
    (make-struct-field-mutator
     std/actor/rpc/connection#continuation-table::t
     '0))
  (define std/actor/rpc/connection#continuation-table-continuations-set!
    (make-struct-field-mutator
     std/actor/rpc/connection#continuation-table::t
     '1))
  (define std/actor/rpc/connection#continuation-table-stream-continuations-set!
    (make-struct-field-mutator
     std/actor/rpc/connection#continuation-table::t
     '2))
  (define std/actor/rpc/connection#continuation-table-stream-actors-set!
    (make-struct-field-mutator
     std/actor/rpc/connection#continuation-table::t
     '3))
  (define std/actor/rpc/connection#continuation-table-timeouts-set!
    (make-struct-field-mutator
     std/actor/rpc/connection#continuation-table::t
     '4))
  (define std/actor/rpc/connection#continuation-table-continuation-timeouts-set!
    (make-struct-field-mutator
     std/actor/rpc/connection#continuation-table::t
     '5))
  (define std/actor/rpc/connection#&continuation-table-mx
    (make-struct-field-unchecked-accessor
     std/actor/rpc/connection#continuation-table::t
     '0))
  (define std/actor/rpc/connection#&continuation-table-continuations
    (make-struct-field-unchecked-accessor
     std/actor/rpc/connection#continuation-table::t
     '1))
  (define std/actor/rpc/connection#&continuation-table-stream-continuations
    (make-struct-field-unchecked-accessor
     std/actor/rpc/connection#continuation-table::t
     '2))
  (define std/actor/rpc/connection#&continuation-table-stream-actors
    (make-struct-field-unchecked-accessor
     std/actor/rpc/connection#continuation-table::t
     '3))
  (define std/actor/rpc/connection#&continuation-table-timeouts
    (make-struct-field-unchecked-accessor
     std/actor/rpc/connection#continuation-table::t
     '4))
  (define std/actor/rpc/connection#&continuation-table-continuation-timeouts
    (make-struct-field-unchecked-accessor
     std/actor/rpc/connection#continuation-table::t
     '5))
  (define std/actor/rpc/connection#&continuation-table-mx-set!
    (make-struct-field-unchecked-mutator
     std/actor/rpc/connection#continuation-table::t
     '0))
  (define std/actor/rpc/connection#&continuation-table-continuations-set!
    (make-struct-field-unchecked-mutator
     std/actor/rpc/connection#continuation-table::t
     '1))
  (define std/actor/rpc/connection#&continuation-table-stream-continuations-set!
    (make-struct-field-unchecked-mutator
     std/actor/rpc/connection#continuation-table::t
     '2))
  (define std/actor/rpc/connection#&continuation-table-stream-actors-set!
    (make-struct-field-unchecked-mutator
     std/actor/rpc/connection#continuation-table::t
     '3))
  (define std/actor/rpc/connection#&continuation-table-timeouts-set!
    (make-struct-field-unchecked-mutator
     std/actor/rpc/connection#continuation-table::t
     '4))
  (define std/actor/rpc/connection#&continuation-table-continuation-timeouts-set!
    (make-struct-field-unchecked-mutator
     std/actor/rpc/connection#continuation-table::t
     '5))
  (define std/actor/rpc/connection#continuation-table:::init!
    (lambda (_self2883_)
      (if (##fx< '6 (##vector-length _self2883_))
          (begin
            (##vector-set! _self2883_ '1 (make-mutex 'continuation-table))
            (##vector-set! _self2883_ '2 (make-table 'test: eqv?))
            (##vector-set! _self2883_ '3 (make-table 'test: eq?))
            (##vector-set! _self2883_ '4 (make-table 'test: eqv?))
            (##vector-set! _self2883_ '5 (make-table 'test: eq?))
            (##vector-set! _self2883_ '6 (make-table 'test: eqv?)))
          (error '"struct-instance-init!: too many arguments for struct"
                 _self2883_))))
  (bind-method!
   std/actor/rpc/connection#continuation-table::t
   ':init!
   std/actor/rpc/connection#continuation-table:::init!
   '#f)
  (define std/actor/rpc/connection#continuation-table-get
    (lambda (_cont-table2750_ _cont2751_)
      (let ((_mx2753_
             (##unchecked-structure-ref
              _cont-table2750_
              '1
              std/actor/rpc/connection#continuation-table::t
              '#f)))
        (mutex-lock! _mx2753_)
        (let ((_res2758_
               (let ((_ct2756_
                      (##unchecked-structure-ref
                       _cont-table2750_
                       '2
                       std/actor/rpc/connection#continuation-table::t
                       '#f)))
                 (table-ref _ct2756_ _cont2751_ '#f))))
          (mutex-unlock! _mx2753_)
          _res2758_))))
  (define std/actor/rpc/connection#continuation-table-remove!
    (lambda (_cont-table2688_ _cont2689_)
      (let ((_mx2691_
             (##unchecked-structure-ref
              _cont-table2688_
              '1
              std/actor/rpc/connection#continuation-table::t
              '#f)))
        (mutex-lock! _mx2691_)
        (let ((_res2747_
               (let* ((_ct2694_
                       (##unchecked-structure-ref
                        _cont-table2688_
                        '2
                        std/actor/rpc/connection#continuation-table::t
                        '#f))
                      (_continuation26952697_
                       (table-ref _ct2694_ _cont2689_ '#f)))
                 (if _continuation26952697_
                     (let ((_continuation2700_ _continuation26952697_))
                       (table-set! _ct2694_ _cont2689_)
                       (let* ((_continuation27012710_ _continuation2700_)
                              (_E27032714_
                               (lambda ()
                                 (error '"No clause matching"
                                        _continuation27012710_)))
                              (_K27042720_
                               (lambda (_stream?2717_ _k2718_)
                                 (if _stream?2717_
                                     (table-set!
                                      (##unchecked-structure-ref
                                       _cont-table2688_
                                       '3
                                       std/actor/rpc/connection#continuation-table::t
                                       '#f)
                                      _k2718_)
                                     '#!void))))
                         (if (##fx= (if (##values? _continuation27012710_)
                                        (##vector-length
                                         _continuation27012710_)
                                        '1)
                                    '4)
                             (let* ((_e27052723_
                                     (##vector-ref _continuation27012710_ '0))
                                    (_e27062726_
                                     (##vector-ref _continuation27012710_ '1))
                                    (_e27072729_
                                     (##vector-ref _continuation27012710_ '2))
                                    (_k2732_ _e27072729_)
                                    (_e27082734_
                                     (##vector-ref _continuation27012710_ '3))
                                    (_stream?2737_ _e27082734_))
                               (_K27042720_ _stream?2737_ _k2732_))
                             (_E27032714_)))
                       (let* ((_tt2739_
                               (##unchecked-structure-ref
                                _cont-table2688_
                                '6
                                std/actor/rpc/connection#continuation-table::t
                                '#f))
                              (_timeo27402742_
                               (table-ref _tt2739_ _cont2689_ '#f)))
                         (if _timeo27402742_
                             (let ((_timeo2745_ _timeo27402742_))
                               (table-set! _tt2739_ _cont2689_)
                               (table-set!
                                (##unchecked-structure-ref
                                 _cont-table2688_
                                 '5
                                 std/actor/rpc/connection#continuation-table::t
                                 '#f)
                                _timeo2745_))
                             '#f))
                       _continuation2700_)
                     '#f))))
          (mutex-unlock! _mx2691_)
          _res2747_))))
  (define std/actor/rpc/connection#continuation-table-get-stream-actor
    (lambda (_cont-table2677_ _cont2678_)
      (let ((_mx2680_
             (##unchecked-structure-ref
              _cont-table2677_
              '1
              std/actor/rpc/connection#continuation-table::t
              '#f)))
        (mutex-lock! _mx2680_)
        (let ((_res2685_
               (let ((_st2683_
                      (##unchecked-structure-ref
                       _cont-table2677_
                       '4
                       std/actor/rpc/connection#continuation-table::t
                       '#f)))
                 (table-ref _st2683_ _cont2678_ '#f))))
          (mutex-unlock! _mx2680_)
          _res2685_))))
  (define std/actor/rpc/connection#continuation-table-put-stream-actor!
    (lambda (_cont-table2665_ _cont2666_ _val2667_)
      (let ((_mx2669_
             (##unchecked-structure-ref
              _cont-table2665_
              '1
              std/actor/rpc/connection#continuation-table::t
              '#f)))
        (mutex-lock! _mx2669_)
        (let ((_res2674_
               (let ((_st2672_
                      (##unchecked-structure-ref
                       _cont-table2665_
                       '4
                       std/actor/rpc/connection#continuation-table::t
                       '#f)))
                 (table-set! _st2672_ _cont2666_ _val2667_))))
          (mutex-unlock! _mx2669_)
          _res2674_))))
  (define std/actor/rpc/connection#continuation-table-remove-stream-actor!
    (lambda (_cont-table2654_ _cont2655_)
      (let ((_mx2657_
             (##unchecked-structure-ref
              _cont-table2654_
              '1
              std/actor/rpc/connection#continuation-table::t
              '#f)))
        (mutex-lock! _mx2657_)
        (let ((_res2662_
               (let ((_st2660_
                      (##unchecked-structure-ref
                       _cont-table2654_
                       '4
                       std/actor/rpc/connection#continuation-table::t
                       '#f)))
                 (table-set! _st2660_ _cont2655_))))
          (mutex-unlock! _mx2657_)
          _res2662_))))
  (define std/actor/rpc/connection#continuation-table-get-stream-cont
    (lambda (_cont-table2643_ _k2644_)
      (let ((_mx2646_
             (##unchecked-structure-ref
              _cont-table2643_
              '1
              std/actor/rpc/connection#continuation-table::t
              '#f)))
        (mutex-lock! _mx2646_)
        (let ((_res2651_
               (let ((_sct2649_
                      (##unchecked-structure-ref
                       _cont-table2643_
                       '3
                       std/actor/rpc/connection#continuation-table::t
                       '#f)))
                 (table-ref _sct2649_ _k2644_ '#f))))
          (mutex-unlock! _mx2646_)
          _res2651_))))
  (define std/actor/rpc/connection#continuation-table-get-timeout
    (lambda (_cont-table2632_ _timeo2633_)
      (let ((_mx2635_
             (##unchecked-structure-ref
              _cont-table2632_
              '1
              std/actor/rpc/connection#continuation-table::t
              '#f)))
        (mutex-lock! _mx2635_)
        (let ((_res2640_
               (let ((_tt2638_
                      (##unchecked-structure-ref
                       _cont-table2632_
                       '5
                       std/actor/rpc/connection#continuation-table::t
                       '#f)))
                 (table-ref _tt2638_ _timeo2633_ '#f))))
          (mutex-unlock! _mx2635_)
          _res2640_))))
  (define std/actor/rpc/connection#continuation-table-dump!__%
    (lambda (_cont-table2506_ _port2507_)
      (call-with-parameters
       (lambda ()
         (let ((_mx2510_
                (##unchecked-structure-ref
                 _cont-table2506_
                 '1
                 std/actor/rpc/connection#continuation-table::t
                 '#f)))
           (mutex-lock! _mx2510_)
           (let* ((_cont-table25122523_ _cont-table2506_)
                  (_E25142527_
                   (lambda ()
                     (error '"No clause matching" _cont-table25122523_)))
                  (_K25152591_
                   (lambda (_ctmos2530_
                            _tmos2531_
                            _sactors2532_
                            _sconts2533_
                            _conts2534_)
                     (displayln '"continuations: " (table-length _conts2534_))
                     (table-for-each
                      (lambda (_wire-id2536_ _continuation2537_)
                        (let* ((_continuation25382547_ _continuation2537_)
                               (_E25402551_
                                (lambda ()
                                  (error '"No clause matching"
                                         _continuation25382547_)))
                               (_K25412559_
                                (lambda (_stream?2554_
                                         _k2555_
                                         _proto2556_
                                         _actor2557_)
                                  (displayln
                                   _wire-id2536_
                                   '" -> "
                                   (cons _actor2557_
                                         (cons _proto2556_
                                               (cons _k2555_
                                                     (cons _stream?2554_
                                                           '()))))))))
                          (if (##fx= (if (##values? _continuation25382547_)
                                         (##vector-length
                                          _continuation25382547_)
                                         '1)
                                     '4)
                              (let* ((_e25422562_
                                      (##vector-ref _continuation25382547_ '0))
                                     (_actor2565_ _e25422562_)
                                     (_e25432567_
                                      (##vector-ref _continuation25382547_ '1))
                                     (_proto2570_ _e25432567_)
                                     (_e25442572_
                                      (##vector-ref _continuation25382547_ '2))
                                     (_k2575_ _e25442572_)
                                     (_e25452577_
                                      (##vector-ref _continuation25382547_ '3))
                                     (_stream?2580_ _e25452577_))
                                (_K25412559_
                                 _stream?2580_
                                 _k2575_
                                 _proto2570_
                                 _actor2565_))
                              (_E25402551_))))
                      _conts2534_)
                     (displayln
                      '"stream-continuations: "
                      (table-length _sconts2533_))
                     (table-for-each
                      (lambda (_k2582_ _wire-id2583_)
                        (displayln _k2582_ '" -> " _wire-id2583_))
                      _sconts2533_)
                     (displayln
                      '"stream-actors: "
                      (table-length _sactors2532_))
                     (table-for-each
                      (lambda (_wire-id2585_ _sactor2586_)
                        (displayln _wire-id2585_ '" -> " _sactor2586_))
                      _sactors2532_)
                     (displayln '"timeouts: " (table-length _tmos2531_))
                     (table-for-each
                      (lambda (_tmo2588_ _wire-id2589_)
                        (displayln
                         (time->seconds _tmo2588_)
                         '" -> "
                         _wire-id2589_))
                      _tmos2531_))))
             (if (##structure-direct-instance-of?
                  _cont-table25122523_
                  'std/actor/rpc/connection#continuation-table::t)
                 (let* ((_e25162594_ (##vector-ref _cont-table25122523_ '1))
                        (_e25172597_ (##vector-ref _cont-table25122523_ '2))
                        (_conts2600_ _e25172597_)
                        (_e25182602_ (##vector-ref _cont-table25122523_ '3))
                        (_sconts2605_ _e25182602_)
                        (_e25192607_ (##vector-ref _cont-table25122523_ '4))
                        (_sactors2610_ _e25192607_)
                        (_e25202612_ (##vector-ref _cont-table25122523_ '5))
                        (_tmos2615_ _e25202612_)
                        (_e25212617_ (##vector-ref _cont-table25122523_ '6))
                        (_ctmos2620_ _e25212617_))
                   (_K25152591_
                    _ctmos2620_
                    _tmos2615_
                    _sactors2610_
                    _sconts2605_
                    _conts2600_))
                 (_E25142527_)))
           (mutex-unlock! _mx2510_)))
       current-output-port
       _port2507_)))
  (define std/actor/rpc/connection#continuation-table-dump!__0
    (lambda (_cont-table2625_)
      (let ((_port2627_ (current-error-port)))
        (std/actor/rpc/connection#continuation-table-dump!__%
         _cont-table2625_
         _port2627_))))
  (define std/actor/rpc/connection#continuation-table-dump!
    (lambda _g8233_
      (let ((_g8232_ (##length _g8233_)))
        (cond ((##fx= _g8232_ 1)
               (apply std/actor/rpc/connection#continuation-table-dump!__0
                      _g8233_))
              ((##fx= _g8232_ 2)
               (apply std/actor/rpc/connection#continuation-table-dump!__%
                      _g8233_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/actor/rpc/connection#continuation-table-dump!
                _g8233_))))))
  (define std/actor/rpc/connection#rpc-connection-loop
    (lambda (_rpc-server1456_
             _actors1457_
             _sock1458_
             _peer-address1459_
             _proto-e1460_)
      (letrec* ((_input-buffer1462_
                 (std/net/socket/buffer#open-ssocket-input-buffer__0
                  _sock1458_))
                (_output-buffer1463_
                 (std/net/socket/buffer#open-ssocket-output-buffer__0
                  _sock1458_))
                (_g8234_ (let ((_g8235_ (_proto-e1460_
                                         _input-buffer1462_
                                         _output-buffer1463_)))
                           (let ((_g8236_ (if (##values? _g8235_)
                                              (##vector-length _g8235_)
                                              1)))
                             (if (not (##fx= _g8236_ 2))
                                 (error "Context expects 2 values" _g8236_)))
                           _g8235_))
                (_read-e1464_ (##vector-ref _g8234_ 0))
                (_write-e1465_ (##vector-ref _g8234_ 1))
                (_cont-table1466_
                 (let ((__obj8229
                        (make-object
                         std/actor/rpc/connection#continuation-table::t
                         '6)))
                   (std/actor/rpc/connection#continuation-table:::init!
                    __obj8229)
                   __obj8229))
                (_next-timeout1467_ '#f)
                (_next-continuation-id1468_ '0)
                (_next-heartbeat1469_
                 (seconds->time (+ (##current-time-point) '60)))
                (_writer1470_
                 (gerbil/gambit/threads#spawn/name
                  'rpc-connection-writer
                  std/actor/rpc/connection#rpc-connection-writer
                  _output-buffer1463_
                  _write-e1465_))
                (_reader1471_
                 (gerbil/gambit/threads#spawn/name
                  'rpc-connection-reader
                  std/actor/rpc/connection#rpc-connection-reader
                  (current-thread)
                  _peer-address1459_
                  _input-buffer1462_
                  _actors1457_
                  _cont-table1466_
                  _writer1470_
                  _read-e1464_))
                (_close-connection1472_
                 (lambda ()
                   (std/net/socket/api#ssocket-close _sock1458_)
                   (thread-send _writer1470_ 'exit)
                   (let ((_mx2423_
                          (##unchecked-structure-ref
                           _cont-table1466_
                           '1
                           std/actor/rpc/connection#continuation-table::t
                           '#f)))
                     (mutex-lock! _mx2423_)
                     (table-for-each
                      (lambda (_wire-id2426_ _cont2427_)
                        (let* ((_cont24282437_ _cont2427_)
                               (_E24302441_
                                (lambda ()
                                  (error '"No clause matching"
                                         _cont24282437_)))
                               (_K24312449_
                                (lambda (_stream?2444_
                                         _k2445_
                                         _proto2446_
                                         _actor2447_)
                                  (std/actor/message#send-message__%
                                   _actor2447_
                                   (##structure
                                    std/actor/proto#!error::t
                                    (make-struct-instance
                                     std/actor/proto#rpc-error::t
                                     'rpc
                                     '"connection error")
                                    _k2445_)
                                   '#f
                                   '#f))))
                          (if (##fx= (if (##values? _cont24282437_)
                                         (##vector-length _cont24282437_)
                                         '1)
                                     '4)
                              (let* ((_e24322452_
                                      (##vector-ref _cont24282437_ '0))
                                     (_actor2455_ _e24322452_)
                                     (_e24332457_
                                      (##vector-ref _cont24282437_ '1))
                                     (_proto2460_ _e24332457_)
                                     (_e24342462_
                                      (##vector-ref _cont24282437_ '2))
                                     (_k2465_ _e24342462_)
                                     (_e24352467_
                                      (##vector-ref _cont24282437_ '3))
                                     (_stream?2470_ _e24352467_))
                                (_K24312449_
                                 _stream?2470_
                                 _k2465_
                                 _proto2460_
                                 _actor2455_))
                              (_E24302441_))))
                      (##unchecked-structure-ref
                       _cont-table1466_
                       '2
                       std/actor/rpc/connection#continuation-table::t
                       '#f))
                     (table-for-each
                      (lambda (_wire-id2472_ _stream2473_)
                        (let* ((_stream24742481_ _stream2473_)
                               (_E24762485_
                                (lambda ()
                                  (error '"No clause matching"
                                         _stream24742481_)))
                               (_K24772493_
                                (lambda (_dest2488_ _actor2489_)
                                  (let ((_abort2491_
                                         (##structure
                                          std/actor/message#message::t
                                          (##structure
                                           std/actor/proto#!abort::t
                                           _wire-id2472_)
                                          _dest2488_
                                          _actor2489_
                                          '#f)))
                                    (std/actor/message#send__0
                                     _actor2489_
                                     _abort2491_)))))
                          (if (##pair? _stream24742481_)
                              (let ((_hd24782496_ (##car _stream24742481_))
                                    (_tl24792498_ (##cdr _stream24742481_)))
                                (let* ((_actor2501_ _hd24782496_)
                                       (_dest2503_ _tl24792498_))
                                  (_K24772493_ _dest2503_ _actor2501_)))
                              (_E24762485_))))
                      (##unchecked-structure-ref
                       _cont-table1466_
                       '4
                       std/actor/rpc/connection#continuation-table::t
                       '#f))
                     (mutex-unlock! _mx2423_))
                   (std/actor/rpc/connection#rpc-connection-shutdown
                    _rpc-server1456_)
                   (raise 'shutdown)))
                (_write-message1473_
                 (lambda (_msg2170_)
                   (let* ((_msg21712180_ _msg2170_)
                          (_E21732184_
                           (lambda ()
                             (error '"No clause matching" _msg21712180_)))
                          (_K21742399_
                           (lambda (_opts2187_
                                    _dest2188_
                                    _src2189_
                                    _content2190_)
                             (if (##structure-direct-instance-of?
                                  _dest2188_
                                  'std/actor/proto#remote::t)
                                 (let* ((_dest21912200_ _dest2188_)
                                        (_E21932204_
                                         (lambda ()
                                           (error '"No clause matching"
                                                  _dest21912200_)))
                                        (_K21942378_
                                         (lambda (_proto2207_
                                                  _address2208_
                                                  _uuid2209_)
                                           (##direct-structure-set!
                                            _msg2170_
                                            _uuid2209_
                                            '3
                                            std/actor/message#message::t
                                            '#f)
                                           (let* ((_content22102236_
                                                   _content2190_)
                                                  (_else22182244_
                                                   (lambda ()
                                                     (_marshal-and-write1475_
                                                      _msg2170_
                                                      _proto2207_
                                                      '#t))))
                                             (let ((_K22322367_
                                                    (lambda (_k2354_)
                                                      (let ((_wire-id2356_
                                                             (_next-continuation-id!1474_)))
                                                        (let ((_mx2358_
                                                               (##unchecked-structure-ref
                                                                _cont-table1466_
                                                                '1
                                                                std/actor/rpc/connection#continuation-table::t
                                                                '#f)))
                                                          (mutex-lock!
                                                           _mx2358_)
                                                          (table-set!
                                                           (##unchecked-structure-ref
                                                            _cont-table1466_
                                                            '2
                                                            std/actor/rpc/connection#continuation-table::t
                                                            '#f)
                                                           _wire-id2356_
                                                           (values _src2189_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           _proto2207_
                           _k2354_
                           '#f))
                  (let ((_timeo23602362_
                         (std/actor/rpc/connection#rpc-options-timeout
                          _opts2187_
                          std/actor/rpc/connection#rpc-call-timeout)))
                    (if _timeo23602362_
                        (let ((_timeo2365_ _timeo23602362_))
                          (table-set!
                           (##unchecked-structure-ref
                            _cont-table1466_
                            '5
                            std/actor/rpc/connection#continuation-table::t
                            '#f)
                           _timeo2365_
                           _wire-id2356_)
                          (table-set!
                           (##unchecked-structure-ref
                            _cont-table1466_
                            '6
                            std/actor/rpc/connection#continuation-table::t
                            '#f)
                           _wire-id2356_
                           _timeo2365_)
                          (_set-timeout!1480_ _timeo2365_))
                        '#f))
                  (mutex-unlock! _mx2358_))
                (##direct-structure-set!
                 _content2190_
                 _wire-id2356_
                 '2
                 std/actor/proto#!call::t
                 '#f)
                (_marshal-and-write1475_ _msg2170_ _proto2207_ '#t))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   (_K22292340_
                                                    (lambda (_k2327_)
                                                      (let ((_wire-id2329_
                                                             (_next-continuation-id!1474_)))
                                                        (let ((_mx2331_
                                                               (##unchecked-structure-ref
                                                                _cont-table1466_
                                                                '1
                                                                std/actor/rpc/connection#continuation-table::t
                                                                '#f)))
                                                          (mutex-lock!
                                                           _mx2331_)
                                                          (table-set!
                                                           (##unchecked-structure-ref
                                                            _cont-table1466_
                                                            '2
                                                            std/actor/rpc/connection#continuation-table::t
                                                            '#f)
                                                           _wire-id2329_
                                                           (values _src2189_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           _proto2207_
                           _k2327_
                           '#t))
                  (table-set!
                   (##unchecked-structure-ref
                    _cont-table1466_
                    '3
                    std/actor/rpc/connection#continuation-table::t
                    '#f)
                   _k2327_
                   _wire-id2329_)
                  (let ((_timeo23332335_
                         (std/actor/rpc/connection#rpc-options-timeout
                          _opts2187_
                          '#f)))
                    (if _timeo23332335_
                        (let ((_timeo2338_ _timeo23332335_))
                          (table-set!
                           (##unchecked-structure-ref
                            _cont-table1466_
                            '5
                            std/actor/rpc/connection#continuation-table::t
                            '#f)
                           _timeo2338_
                           _wire-id2329_)
                          (table-set!
                           (##unchecked-structure-ref
                            _cont-table1466_
                            '6
                            std/actor/rpc/connection#continuation-table::t
                            '#f)
                           _wire-id2329_
                           _timeo2338_)
                          (_set-timeout!1480_ _timeo2338_))
                        '#f))
                  (mutex-unlock! _mx2331_))
                (##direct-structure-set!
                 _content2190_
                 _wire-id2329_
                 '2
                 std/actor/proto#!stream::t
                 '#f)
                (_marshal-and-write1475_ _msg2170_ _proto2207_ '#t))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   (_K22282311_
                                                    (lambda ()
                                                      (_marshal-and-write1475_
                                                       _msg2170_
                                                       _proto2207_
                                                       '#t)))
                                                   (_K22262298_
                                                    (lambda (_wire-id2296_)
                                                      (std/actor/rpc/connection#continuation-table-put-stream-actor!
                                                       _cont-table1466_
                                                       _wire-id2296_
                                                       (cons _src2189_
                                                             _dest2188_))
                                                      (_marshal-and-write1475_
                                                       _msg2170_
                                                       _proto2207_
                                                       '#t)))
                                                   (_K22242284_
                                                    (lambda (_k2280_)
                                                      (let ((_wire-id2282_
                                                             (std/actor/rpc/connection#continuation-table-get-stream-cont
                                                              _cont-table1466_
                                                              _k2280_)))
                                                        (if _wire-id2282_
                                                            (begin
                                                              (##direct-structure-set!
                                                               _content2190_
                                                               _wire-id2282_
                                                               '1
                                                               std/actor/proto#!continue::t
                                                               '#f)
                                                              (_marshal-and-write1475_
                                                               _msg2170_
                                                               _proto2207_
                                                               '#t))
                                                            (std/logger#warning
                                                             '"bad continue; unknown stream ~a"
                                                             _k2280_)))))
                                                   (_K22222268_
                                                    (lambda (_k2264_)
                                                      (let ((_wire-id2266_
                                                             (std/actor/rpc/connection#continuation-table-get-stream-cont
                                                              _cont-table1466_
                                                              _k2264_)))
                                                        (if _wire-id2266_
                                                            (begin
                                                              (##direct-structure-set!
                                                               _content2190_
                                                               _wire-id2266_
                                                               '1
                                                               std/actor/proto#!close::t
                                                               '#f)
                                                              (_marshal-and-write1475_
                                                               _msg2170_
                                                               _proto2207_
                                                               '#t))
                                                            (std/logger#warning
                                                             '"bad close; unknown stream ~a"
                                                             _k2264_)))))
                                                   (_K22202252_
                                                    (lambda (_k2248_)
                                                      (let ((_wire-id2250_
                                                             (std/actor/rpc/connection#continuation-table-get-stream-cont
                                                              _cont-table1466_
                                                              _k2248_)))
                                                        (if _wire-id2250_
                                                            (begin
                                                              (##direct-structure-set!
                                                               _content2190_
                                                               _wire-id2250_
                                                               '1
                                                               std/actor/proto#!abort::t
                                                               '#f)
                                                              (std/actor/rpc/connection#continuation-table-remove!
                                                               _cont-table1466_
                                                               _wire-id2250_)
                                                              (_marshal-and-write1475_
                                                               _msg2170_
                                                               _proto2207_
                                                               '#t))
                                                            (std/logger#warning
                                                             '"bad abort; unknown stream ~a"
                                                             _k2248_))))))
                                               (let* ((_try-match22172260_
                                                       (lambda ()
                                                         (if (##structure-direct-instance-of?
                                                              _content22102236_
                                                              'std/actor/proto#!abort::t)
                                                             (let* ((_e22212255_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                             (##vector-ref _content22102236_ '1))
                            (_k2258_ _e22212255_))
                       (_K22202252_ _k2258_))
                     (_else22182244_))))
              (_try-match22162276_
               (lambda ()
                 (if (##structure-direct-instance-of?
                      _content22102236_
                      'std/actor/proto#!close::t)
                     (let* ((_e22232271_ (##vector-ref _content22102236_ '1))
                            (_k2274_ _e22232271_))
                       (_K22222268_ _k2274_))
                     (_try-match22172260_))))
              (_try-match22152292_
               (lambda ()
                 (if (##structure-direct-instance-of?
                      _content22102236_
                      'std/actor/proto#!continue::t)
                     (let* ((_e22252287_ (##vector-ref _content22102236_ '1))
                            (_k2290_ _e22252287_))
                       (_K22242284_ _k2290_))
                     (_try-match22162276_))))
              (_try-match22142306_
               (lambda ()
                 (if (##structure-direct-instance-of?
                      _content22102236_
                      'std/actor/proto#!sync::t)
                     (let* ((_e22272301_ (##vector-ref _content22102236_ '1))
                            (_wire-id2304_ _e22272301_))
                       (_K22262298_ _wire-id2304_))
                     (_try-match22152292_))))
              (_try-match22132323_
               (lambda ()
                 (if (or (##structure-direct-instance-of?
                          _content22102236_
                          'std/actor/proto#!value::t)
                         (##structure-direct-instance-of?
                          _content22102236_
                          'std/actor/proto#!yield::t)
                         (##structure-direct-instance-of?
                          _content22102236_
                          'std/actor/proto#!error::t)
                         (##structure-direct-instance-of?
                          _content22102236_
                          'std/actor/proto#!end::t))
                     (_K22282311_)
                     (_try-match22142306_))))
              (_try-match22122351_
               (lambda ()
                 (if (##structure-direct-instance-of?
                      _content22102236_
                      'std/actor/proto#!stream::t)
                     (let* ((_e22302343_ (##vector-ref _content22102236_ '1))
                            (_e22312346_ (##vector-ref _content22102236_ '2))
                            (_k2349_ _e22312346_))
                       (_K22292340_ _k2349_))
                     (_try-match22132323_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                 (if (##structure-direct-instance-of?
                                                      _content22102236_
                                                      'std/actor/proto#!call::t)
                                                     (let* ((_e22332370_
                                                             (##vector-ref
                                                              _content22102236_
                                                              '1))
                                                            (_e22342373_
                                                             (##vector-ref
                                                              _content22102236_
                                                              '2))
                                                            (_k2376_ _e22342373_))
                                                       (_K22322367_ _k2376_))
                                                     (_try-match22122351_))))))))
                                   (if (##structure-direct-instance-of?
                                        _dest21912200_
                                        'std/actor/proto#remote::t)
                                       (let* ((_e21952381_
                                               (##vector-ref
                                                _dest21912200_
                                                '1))
                                              (_e21962384_
                                               (##vector-ref
                                                _dest21912200_
                                                '2))
                                              (_uuid2387_ _e21962384_)
                                              (_e21972389_
                                               (##vector-ref
                                                _dest21912200_
                                                '3))
                                              (_address2392_ _e21972389_)
                                              (_e21982394_
                                               (##vector-ref
                                                _dest21912200_
                                                '4))
                                              (_proto2397_ _e21982394_))
                                         (_K21942378_
                                          _proto2397_
                                          _address2392_
                                          _uuid2387_))
                                       (_E21932204_)))
                                 (std/logger#warning
                                  '"bad handle; no protocol ~a ~a"
                                  _dest2188_
                                  _msg2170_)))))
                     (if (##structure-direct-instance-of?
                          _msg21712180_
                          'std/actor/message#message::t)
                         (let* ((_e21752402_ (##vector-ref _msg21712180_ '1))
                                (_content2405_ _e21752402_)
                                (_e21762407_ (##vector-ref _msg21712180_ '2))
                                (_src2410_ _e21762407_)
                                (_e21772412_ (##vector-ref _msg21712180_ '3))
                                (_dest2415_ _e21772412_)
                                (_e21782417_ (##vector-ref _msg21712180_ '4))
                                (_opts2420_ _e21782417_))
                           (_K21742399_
                            _opts2420_
                            _dest2415_
                            _src2410_
                            _content2405_))
                         (_E21732184_)))))
                (_next-continuation-id!1474_
                 (lambda ()
                   (let ((_next2168_ _next-continuation-id1468_))
                     (set! _next-continuation-id1468_ (+ _next2168_ '1))
                     _next2168_)))
                (_marshal-and-write1475_
                 (lambda (_msg1811_ _proto1812_ _dispatch-marshal-error?1813_)
                   (let ((_e1898_ (with-exception-catcher
                                   (lambda (_g18871889_)
                                     (if ((lambda (_$obj1892_)
                                            (exception? _$obj1892_))
                                          _g18871889_)
                                         (let ((_e1895_ _g18871889_)) _e1895_)
                                         (raise _g18871889_)))
                                   (lambda ()
                                     (std/actor/rpc/proto/message#rpc-proto-marshal-message
                                      _msg1811_
                                      _proto1812_)))))
                     (if (u8vector? _e1898_)
                         (if (fx<= (u8vector-length _e1898_)
                                   std/actor/rpc/proto/message#rpc-proto-message-max-length)
                             (thread-send _writer1470_ _e1898_)
                             (begin
                               (std/logger#warning
                                '"message too large; not sending %d bytes"
                                (u8vector-length _e1898_))
                               (let ((_content1900_
                                      (##direct-structure-ref
                                       _msg1811_
                                       '1
                                       std/actor/message#message::t
                                       '#f))
                                     (_dest1902_
                                      (##direct-structure-ref
                                       _msg1811_
                                       '3
                                       std/actor/message#message::t
                                       '#f)))
                                 (let* ((_content19041920_ _content1900_)
                                        (_else19071928_ (lambda () '#!void)))
                                   (let ((_K19141966_
                                          (lambda (_wire-id1963_ _e1964_)
                                            (_dispatch-error1476_
                                             _wire-id1963_
                                             '"message too large")))
                                         (_K19091937_
                                          (lambda (_wire-id1932_ _e1934_)
                                            (if _dispatch-marshal-error?1813_
                                                (_dispatch-remote-error1477_
                                                 (##structure
                                                  std/actor/proto#!error::t
                                                  '"message too large"
                                                  _wire-id1932_)
                                                 _dest1902_)
                                                '#!void))))
                                     (let* ((___match80818082_
                                             (lambda ()
                                               (if (##structure-direct-instance-of?
                                                    _content19041920_
                                                    'std/actor/proto#!yield::t)
                                                   (let* ((_e19101950_
                                                           (##vector-ref
                                                            _content19041920_
                                                            '1))
                                                          (_e19111955_
                                                           (##vector-ref
                                                            _content19041920_
                                                            '2)))
                                                     (let ((_e1953_ _e19101950_)
                                                           (_wire-id1958_
                                                            _e19111955_))
                                                       (_K19091937_
                                                        _wire-id1958_
                                                        _e1953_)))
                                                   '#!void)))
                                            (_try-match19061960_
                                             (lambda ()
                                               (if (##structure-direct-instance-of?
                                                    _content19041920_
                                                    'std/actor/proto#!error::t)
                                                   (let* ((_e19121940_
                                                           (##vector-ref
                                                            _content19041920_
                                                            '1))
                                                          (_e19131945_
                                                           (##vector-ref
                                                            _content19041920_
                                                            '2)))
                                                     (let ((_e1943_ _e19121940_)
                                                           (_wire-id1948_
                                                            _e19131945_))
                                                       (_K19091937_
                                                        _wire-id1948_
                                                        _e1943_)))
                                                   (___match80818082_))))
                                            (___match80678068_
                                             (lambda ()
                                               (if (##structure-direct-instance-of?
                                                    _content19041920_
                                                    'std/actor/proto#!stream::t)
                                                   (let* ((_e19151979_
                                                           (##vector-ref
                                                            _content19041920_
                                                            '1))
                                                          (_e19161984_
                                                           (##vector-ref
                                                            _content19041920_
                                                            '2)))
                                                     (let ((_e1982_ _e19151979_)
                                                           (_wire-id1987_
                                                            _e19161984_))
                                                       (_K19141966_
                                                        _wire-id1987_
                                                        _e1982_)))
                                                   (_try-match19061960_)))))
                                       (if (##structure-direct-instance-of?
                                            _content19041920_
                                            'std/actor/proto#!call::t)
                                           (let* ((_e19171969_
                                                   (##vector-ref
                                                    _content19041920_
                                                    '1))
                                                  (_e19181974_
                                                   (##vector-ref
                                                    _content19041920_
                                                    '2)))
                                             (let ((_e1972_ _e19171969_)
                                                   (_wire-id1977_ _e19181974_))
                                               (_K19141966_
                                                _wire-id1977_
                                                _e1972_)))
                                           (___match80678068_))))))))
                         (if (##structure-instance-of?
                              _e1898_
                              'std/net/bio/buffer#chunked-output-buffer::t)
                             (if (fx<= (std/net/bio/buffer#chunked-output-length
                                        _e1898_)
                                       std/actor/rpc/proto/message#rpc-proto-message-max-length)
                                 (thread-send _writer1470_ _e1898_)
                                 (begin
                                   (std/logger#warning
                                    '"message too large; not sending %d bytes"
                                    (std/net/bio/buffer#chunked-output-length
                                     _e1898_))
                                   (let ((_content1989_
                                          (##direct-structure-ref
                                           _msg1811_
                                           '1
                                           std/actor/message#message::t
                                           '#f))
                                         (_dest1991_
                                          (##direct-structure-ref
                                           _msg1811_
                                           '3
                                           std/actor/message#message::t
                                           '#f)))
                                     (let* ((_content19932009_ _content1989_)
                                            (_else19962017_
                                             (lambda () '#!void)))
                                       (let ((_K20032055_
                                              (lambda (_wire-id2052_ _e2053_)
                                                (_dispatch-error1476_
                                                 _wire-id2052_
                                                 '"message too large")))
                                             (_K19982026_
                                              (lambda (_wire-id2021_ _e2023_)
                                                (if _dispatch-marshal-error?1813_
                                                    (_dispatch-remote-error1477_
                                                     (##structure
                                                      std/actor/proto#!error::t
                                                      '"message too large"
                                                      _wire-id2021_)
                                                     _dest1991_)
                                                    '#!void))))
                                         (let* ((___match81108111_
                                                 (lambda ()
                                                   (if (##structure-direct-instance-of?
                                                        _content19932009_
                                                        'std/actor/proto#!yield::t)
                                                       (let* ((_e19992039_
                                                               (##vector-ref
                                                                _content19932009_
                                                                '1))
                                                              (_e20002044_
                                                               (##vector-ref
                                                                _content19932009_
                                                                '2)))
                                                         (let ((_e2042_ _e19992039_)
                                                               (_wire-id2047_
                                                                _e20002044_))
                                                           (_K19982026_
                                                            _wire-id2047_
                                                            _e2042_)))
                                                       '#!void)))
                                                (_try-match19952049_
                                                 (lambda ()
                                                   (if (##structure-direct-instance-of?
                                                        _content19932009_
                                                        'std/actor/proto#!error::t)
                                                       (let* ((_e20012029_
                                                               (##vector-ref
                                                                _content19932009_
                                                                '1))
                                                              (_e20022034_
                                                               (##vector-ref
                                                                _content19932009_
                                                                '2)))
                                                         (let ((_e2032_ _e20012029_)
                                                               (_wire-id2037_
                                                                _e20022034_))
                                                           (_K19982026_
                                                            _wire-id2037_
                                                            _e2032_)))
                                                       (___match81108111_))))
                                                (___match80968097_
                                                 (lambda ()
                                                   (if (##structure-direct-instance-of?
                                                        _content19932009_
                                                        'std/actor/proto#!stream::t)
                                                       (let* ((_e20042068_
                                                               (##vector-ref
                                                                _content19932009_
                                                                '1))
                                                              (_e20052073_
                                                               (##vector-ref
                                                                _content19932009_
                                                                '2)))
                                                         (let ((_e2071_ _e20042068_)
                                                               (_wire-id2076_
                                                                _e20052073_))
                                                           (_K20032055_
                                                            _wire-id2076_
                                                            _e2071_)))
                                                       (_try-match19952049_)))))
                                           (if (##structure-direct-instance-of?
                                                _content19932009_
                                                'std/actor/proto#!call::t)
                                               (let* ((_e20062058_
                                                       (##vector-ref
                                                        _content19932009_
                                                        '1))
                                                      (_e20072063_
                                                       (##vector-ref
                                                        _content19932009_
                                                        '2)))
                                                 (let ((_e2061_ _e20062058_)
                                                       (_wire-id2066_
                                                        _e20072063_))
                                                   (_K20032055_
                                                    _wire-id2066_
                                                    _e2061_)))
                                               (___match80968097_))))))))
                             (if _dispatch-marshal-error?1813_
                                 (begin
                                   (std/logger#log-error
                                    '"marshal error"
                                    _e1898_)
                                   (let ((_content2078_
                                          (##direct-structure-ref
                                           _msg1811_
                                           '1
                                           std/actor/message#message::t
                                           '#f))
                                         (_dest2080_
                                          (##direct-structure-ref
                                           _msg1811_
                                           '3
                                           std/actor/message#message::t
                                           '#f)))
                                     (let* ((_content20822098_ _content2078_)
                                            (_else20852106_
                                             (lambda () '#!void)))
                                       (let ((_K20922144_
                                              (lambda (_wire-id2141_ _e2142_)
                                                (_dispatch-error1476_
                                                 _wire-id2141_
                                                 '"marshal error")))
                                             (_K20872115_
                                              (lambda (_wire-id2110_ _e2112_)
                                                (if _dispatch-marshal-error?1813_
                                                    (_dispatch-remote-error1477_
                                                     (##structure
                                                      std/actor/proto#!error::t
                                                      '"marshal error"
                                                      _wire-id2110_)
                                                     _dest2080_)
                                                    '#!void))))
                                         (let* ((___match81398140_
                                                 (lambda ()
                                                   (if (##structure-direct-instance-of?
                                                        _content20822098_
                                                        'std/actor/proto#!yield::t)
                                                       (let* ((_e20882128_
                                                               (##vector-ref
                                                                _content20822098_
                                                                '1))
                                                              (_e20892133_
                                                               (##vector-ref
                                                                _content20822098_
                                                                '2)))
                                                         (let ((_e2131_ _e20882128_)
                                                               (_wire-id2136_
                                                                _e20892133_))
                                                           (_K20872115_
                                                            _wire-id2136_
                                                            _e2131_)))
                                                       '#!void)))
                                                (_try-match20842138_
                                                 (lambda ()
                                                   (if (##structure-direct-instance-of?
                                                        _content20822098_
                                                        'std/actor/proto#!error::t)
                                                       (let* ((_e20902118_
                                                               (##vector-ref
                                                                _content20822098_
                                                                '1))
                                                              (_e20912123_
                                                               (##vector-ref
                                                                _content20822098_
                                                                '2)))
                                                         (let ((_e2121_ _e20902118_)
                                                               (_wire-id2126_
                                                                _e20912123_))
                                                           (_K20872115_
                                                            _wire-id2126_
                                                            _e2121_)))
                                                       (___match81398140_))))
                                                (___match81258126_
                                                 (lambda ()
                                                   (if (##structure-direct-instance-of?
                                                        _content20822098_
                                                        'std/actor/proto#!stream::t)
                                                       (let* ((_e20932157_
                                                               (##vector-ref
                                                                _content20822098_
                                                                '1))
                                                              (_e20942162_
                                                               (##vector-ref
                                                                _content20822098_
                                                                '2)))
                                                         (let ((_e2160_ _e20932157_)
                                                               (_wire-id2165_
                                                                _e20942162_))
                                                           (_K20922144_
                                                            _wire-id2165_
                                                            _e2160_)))
                                                       (_try-match20842138_)))))
                                           (if (##structure-direct-instance-of?
                                                _content20822098_
                                                'std/actor/proto#!call::t)
                                               (let* ((_e20952147_
                                                       (##vector-ref
                                                        _content20822098_
                                                        '1))
                                                      (_e20962152_
                                                       (##vector-ref
                                                        _content20822098_
                                                        '2)))
                                                 (let ((_e2150_ _e20952147_)
                                                       (_wire-id2155_
                                                        _e20962152_))
                                                   (_K20922144_
                                                    _wire-id2155_
                                                    _e2150_)))
                                               (___match81258126_)))))))
                                 (std/logger#log-error
                                  '"marshal error"
                                  _e1898_)))))))
                (_dispatch-error1476_
                 (lambda (_wire-id1760_ _what1761_)
                   (let* ((_g17621772_
                           (std/actor/rpc/connection#continuation-table-remove!
                            _cont-table1466_
                            _wire-id1760_))
                          (_else17641780_ (lambda () '#!void))
                          (_K17661788_
                           (lambda (_stream?1783_
                                    _k1784_
                                    _proto1785_
                                    _actor1786_)
                             (std/actor/message#send-message__%
                              _actor1786_
                              (##structure
                               std/actor/proto#!error::t
                               (make-struct-instance
                                std/actor/proto#rpc-error::t
                                'rpc
                                _what1761_)
                               _k1784_)
                              '#f
                              '#f))))
                     (if (##fx= (if (##values? _g17621772_)
                                    (##vector-length _g17621772_)
                                    '1)
                                '4)
                         (let* ((_e17671791_ (##vector-ref _g17621772_ '0))
                                (_actor1794_ _e17671791_)
                                (_e17681796_ (##vector-ref _g17621772_ '1))
                                (_proto1799_ _e17681796_)
                                (_e17691801_ (##vector-ref _g17621772_ '2))
                                (_k1804_ _e17691801_)
                                (_e17701806_ (##vector-ref _g17621772_ '3))
                                (_stream?1809_ _e17701806_))
                           (_K17661788_
                            _stream?1809_
                            _k1804_
                            _proto1799_
                            _actor1794_))
                         '#!void))))
                (_dispatch-remote-error1477_
                 (lambda (_what1757_ _dest1758_)
                   (_marshal-and-write1475_
                    (##structure
                     std/actor/message#message::t
                     _what1757_
                     '#!void
                     _dest1758_
                     '#f)
                    '#f
                    '#f)))
                (_dispatch-timeout1478_
                 (lambda (_timeo1750_)
                   (set! _next-timeout1467_ '#f)
                   (let ((_$e1752_
                          (std/actor/rpc/connection#continuation-table-get-timeout
                           _cont-table1466_
                           _timeo1750_)))
                     (if _$e1752_
                         ((lambda (_wire-id1755_)
                            (_dispatch-error1476_ _wire-id1755_ '"timeout"))
                          _$e1752_)
                         '#!void))))
                (_timeout<1479_
                 (lambda (_a1747_ _b1748_)
                   (< (time->seconds _a1747_) (time->seconds _b1748_))))
                (_set-timeout!1480_
                 (lambda (_timeo1742_)
                   (if (or (not _next-timeout1467_)
                           (_timeout<1479_ _timeo1742_ _next-timeout1467_))
                       (set! _next-timeout1467_ _timeo1742_)
                       '#!void)))
                (_timeout-event1481_
                 (lambda ()
                   (if _next-timeout1467_
                       '#!void
                       (let ((_mx1735_
                              (##unchecked-structure-ref
                               _cont-table1466_
                               '1
                               std/actor/rpc/connection#continuation-table::t
                               '#f)))
                         (mutex-lock! _mx1735_)
                         (let ((_timeouts1738_
                                (##unchecked-structure-ref
                                 _cont-table1466_
                                 '5
                                 std/actor/rpc/connection#continuation-table::t
                                 '#f)))
                           (if (fxzero? (table-length _timeouts1738_))
                               '#!void
                               (table-for-each
                                (lambda (_timeo1740_ _g8237_)
                                  (_set-timeout!1480_ _timeo1740_))
                                _timeouts1738_)))
                         (mutex-unlock! _mx1735_)))
                   _next-timeout1467_))
                (_heartbeat!1482_
                 (lambda ()
                   (let ((_dead-continuations1682_
                          (let ((_mx1638_
                                 (##unchecked-structure-ref
                                  _cont-table1466_
                                  '1
                                  std/actor/rpc/connection#continuation-table::t
                                  '#f)))
                            (mutex-lock! _mx1638_)
                            (let ((_res1679_
                                   (hash-fold
                                    (lambda (_wire-id1641_
                                             _continuation1642_
                                             _r1643_)
                                      (let* ((_continuation16441653_
                                              _continuation1642_)
                                             (_E16461657_
                                              (lambda ()
                                                (error '"No clause matching"
                                                       _continuation16441653_)))
                                             (_K16471662_
                                              (lambda (_actor1660_)
                                                (if (and (thread? _actor1660_)
                                                         (std/misc/threads#thread-dead?
                                                          _actor1660_))
                                                    (cons _wire-id1641_
                                                          _r1643_)
                                                    _r1643_))))
                                        (if (##fx= (if (##values?
                                                        _continuation16441653_)
                                                       (##vector-length
                                                        _continuation16441653_)
                                                       '1)
                                                   '4)
                                            (let* ((_e16481665_
                                                    (##vector-ref
                                                     _continuation16441653_
                                                     '0))
                                                   (_actor1668_ _e16481665_)
                                                   (_e16491670_
                                                    (##vector-ref
                                                     _continuation16441653_
                                                     '1))
                                                   (_e16501673_
                                                    (##vector-ref
                                                     _continuation16441653_
                                                     '2))
                                                   (_e16511676_
                                                    (##vector-ref
                                                     _continuation16441653_
                                                     '3)))
                                              (_K16471662_ _actor1668_))
                                            (_E16461657_))))
                                    '()
                                    (##unchecked-structure-ref
                                     _cont-table1466_
                                     '2
                                     std/actor/rpc/connection#continuation-table::t
                                     '#f))))
                              (mutex-unlock! _mx1638_)
                              _res1679_))))
                     (for-each
                      (lambda (_wire-id1684_)
                        (let* ((_g16851695_
                                (std/actor/rpc/connection#continuation-table-remove!
                                 _cont-table1466_
                                 _wire-id1684_))
                               (_else16871703_ (lambda () '#!void))
                               (_K16891711_
                                (lambda (_stream?1706_
                                         _k1707_
                                         _proto1708_
                                         _actor1709_)
                                  (std/logger#debug
                                   '"removing continuation ~a for dead actor ~a"
                                   _wire-id1684_
                                   _actor1709_)
                                  (if _stream?1706_
                                      (_dispatch-remote-error1477_
                                       (##structure
                                        std/actor/proto#!abort::t
                                        _wire-id1684_)
                                       std/actor/rpc/base#null-uuid)
                                      '#!void))))
                          (if (##fx= (if (##values? _g16851695_)
                                         (##vector-length _g16851695_)
                                         '1)
                                     '4)
                              (let* ((_e16901714_
                                      (##vector-ref _g16851695_ '0))
                                     (_actor1717_ _e16901714_)
                                     (_e16911719_
                                      (##vector-ref _g16851695_ '1))
                                     (_proto1722_ _e16911719_)
                                     (_e16921724_
                                      (##vector-ref _g16851695_ '2))
                                     (_k1727_ _e16921724_)
                                     (_e16931729_
                                      (##vector-ref _g16851695_ '3))
                                     (_stream?1732_ _e16931729_))
                                (_K16891711_
                                 _stream?1732_
                                 _k1727_
                                 _proto1722_
                                 _actor1717_))
                              '#!void)))
                      _dead-continuations1682_))
                   (set! _next-heartbeat1469_
                         (seconds->time (+ (##current-time-point) '60)))))
                (_dump!1483_
                 (lambda (_port1634_)
                   (call-with-parameters
                    (lambda ()
                      (displayln '"=== rpc-connection ===")
                      (displayln '"peer-address: " _peer-address1459_)
                      (displayln
                       '"next-continuation-id: "
                       _next-continuation-id1468_)
                      (displayln
                       '"next-timeout: "
                       (if _next-timeout1467_
                           (time->seconds _next-timeout1467_)
                           '#f)))
                    current-output-port
                    _port1634_)
                   (std/actor/rpc/connection#continuation-table-dump!__%
                    _cont-table1466_
                    _port1634_)))
                (_loop1484_
                 (lambda ()
                   (let ((_g8238_ (std/actor/message#receive-timeout
                                   (_timeout-event1481_)
                                   _dispatch-timeout1478_
                                   _next-heartbeat1469_
                                   (lambda (_$e1498_) (_heartbeat!1482_)))))
                     (begin
                       (let ((_g8239_ (if (##values? _g8238_)
                                          (##vector-length _g8238_)
                                          1)))
                         (if (not (##fx= _g8239_ 2))
                             (error "Context expects 2 values" _g8239_)))
                       (let ((_timeo1501_ (##vector-ref _g8238_ 0))
                             (_K1503_ (##vector-ref _g8238_ 1)))
                         (let _loop14961506_ ()
                           (let ((_next1510_
                                  (thread-mailbox-next
                                   _timeo1501_
                                   std/actor/message#mailbox-timeout)))
                             (if (eq? _next1510_
                                      std/actor/message#mailbox-timeout)
                                 (begin
                                   (thread-mailbox-rewind)
                                   (_K1503_ _timeo1501_))
                                 ((lambda (_msg1513_)
                                    (let* ((_msg15151537_ _msg1513_)
                                           (_else15231545_
                                            (lambda () (_loop14961506_))))
                                      (let ((_K15351629_
                                             (lambda (_msg1627_)
                                               (thread-mailbox-extract-and-rewind)
                                               (_write-message1473_
                                                _msg1627_)))
                                            (_K15341621_
                                             (lambda ()
                                               (thread-mailbox-extract-and-rewind)
                                               (_close-connection1472_)))
                                            (_K15331613_
                                             (lambda ()
                                               (thread-mailbox-extract-and-rewind)
                                               (_close-connection1472_)))
                                            (_K15321603_
                                             (lambda (_thread1589_)
                                               (thread-mailbox-extract-and-rewind)
                                               (with-exception-catcher
                                                (lambda (_g15901592_)
                                                  (if ((lambda (_$obj1595_)
                                                         (uncaught-exception?
                                                          _$obj1595_))
                                                       _g15901592_)
                                                      (let ((_e1598_ _g15901592_))
                                                        (std/logger#log-error
                                                         '"connection error"
                                                         (uncaught-exception-reason
                                                          _e1598_)))
                                                      (if '#t
                                                          (let ((_e1600_ _g15901592_))
                                                            (std/logger#log-error
                                                             '"connection error"
                                                             _e1600_))
                                                          (raise _g15901592_))))
                                                (lambda ()
                                                  (thread-join! _thread1589_)
                                                  (std/logger#warning
                                                   '"connection error: i/o thread ~a exited unexpectedly"
                                                   (thread-name
                                                    _thread1589_))))
                                               (_close-connection1472_)))
                                            (_K15311582_
                                             (lambda ()
                                               (thread-mailbox-extract-and-rewind)
                                               (_dump!1483_
                                                (current-error-port))))
                                            (_K15261562_
                                             (lambda (_port1560_)
                                               (thread-mailbox-extract-and-rewind)
                                               (_dump!1483_ _port1560_)))
                                            (_K15251551_
                                             (lambda (_bogus1549_)
                                               (thread-mailbox-extract-and-rewind)
                                               (std/logger#warning
                                                '"unexpected message ~a"
                                                _bogus1549_))))
                                        (let* ((_try-match15211577_
                                                (lambda ()
                                                  (if (##pair? _msg15151537_)
                                                      (let ((_tl15281567_
                                                             (##cdr _msg15151537_))
                                                            (_hd15271565_
                                                             (##car _msg15151537_)))
                                                        (if (##eq? _hd15271565_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           'dump)
                    (if (##pair? _tl15281567_)
                        (let ((_tl15301572_ (##cdr _tl15281567_))
                              (_hd15291570_ (##car _tl15281567_)))
                          (if (##null? _tl15301572_)
                              (let ((_port1575_ _hd15291570_))
                                (_K15261562_ _port1575_))
                              (let ((_bogus1554_ _msg15151537_))
                                (_K15251551_ _bogus1554_))))
                        (let ((_bogus1554_ _msg15151537_))
                          (_K15251551_ _bogus1554_)))
                    (let ((_bogus1554_ _msg15151537_))
                      (_K15251551_ _bogus1554_))))
              (let ((_bogus1554_ _msg15151537_)) (_K15251551_ _bogus1554_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                               (_try-match15201585_
                                                (lambda ()
                                                  (if (##eq? _msg15151537_
                                                             'dump)
                                                      (_K15311582_)
                                                      (_try-match15211577_))))
                                               (_try-match15191608_
                                                (lambda ()
                                                  (if (thread? _msg15151537_)
                                                      (let ((_thread1606_
                                                             _msg15151537_))
                                                        (_K15321603_
                                                         _thread1606_))
                                                      (_try-match15201585_))))
                                               (_try-match15181616_
                                                (lambda ()
                                                  (if (##eq? _msg15151537_
                                                             'shutdown)
                                                      (_K15331613_)
                                                      (_try-match15191608_))))
                                               (_try-match15171624_
                                                (lambda ()
                                                  (if (eof-object?
                                                       _msg15151537_)
                                                      (_K15341621_)
                                                      (_try-match15181616_)))))
                                          (if (##structure-direct-instance-of?
                                               _msg15151537_
                                               'std/actor/message#message::t)
                                              (let ((_msg1632_ _msg15151537_))
                                                (_K15351629_ _msg1632_))
                                              (_try-match15171624_))))))
                                  _next1510_)))))))
                   (_loop1484_)))
                (_run1485_
                 (lambda ()
                   (call-with-parameters
                    (lambda () (_loop1484_))
                    std/actor/xdr#current-xdr-type-registry
                    std/actor/xdr#+xdr-default-type-registry+))))
        (begin
          (std/actor/rpc/base#rpc-monitor__0 _reader1471_)
          (std/actor/rpc/base#rpc-monitor__0 _writer1470_)
          (with-exception-catcher
           (lambda (_g14861488_)
             (if '#t
                 (let ((_e1491_ _g14861488_))
                   (if (eq? 'shutdown _e1491_)
                       '#!void
                       (begin
                         (std/logger#log-error '"unhandled exception" _e1491_)
                         (with-exception-catcher
                          void
                          _close-connection1472_))))
                 (raise _g14861488_)))
           (lambda () (_run1485_)))))))
  (define std/actor/rpc/connection#rpc-connection-writer
    (lambda (_sockbuf1365_ _write-e1366_)
      (letrec ((_loop1368_
                (lambda ()
                  (let ((_g8240_ (std/actor/message#receive-timeout
                                  std/actor/rpc/connection#rpc-keep-alive
                                  (lambda (_$e1379_)
                                    (_write-e1366_ _sockbuf1365_ '#!void)
                                    (_loop1368_)))))
                    (begin
                      (let ((_g8241_ (if (##values? _g8240_)
                                         (##vector-length _g8240_)
                                         1)))
                        (if (not (##fx= _g8241_ 2))
                            (error "Context expects 2 values" _g8241_)))
                      (let ((_timeo1382_ (##vector-ref _g8240_ 0))
                            (_K1384_ (##vector-ref _g8240_ 1)))
                        (let _loop13771387_ ()
                          (let ((_next1391_
                                 (thread-mailbox-next
                                  _timeo1382_
                                  std/actor/message#mailbox-timeout)))
                            (if (eq? _next1391_
                                     std/actor/message#mailbox-timeout)
                                (begin
                                  (thread-mailbox-rewind)
                                  (_K1384_ _timeo1382_))
                                ((lambda (_msg1394_)
                                   (let* ((_msg13961408_ _msg1394_)
                                          (_else14011416_
                                           (lambda () (_loop13771387_))))
                                     (let ((_K14061451_
                                            (lambda (_buf1449_)
                                              (thread-mailbox-extract-and-rewind)
                                              (_write-e1366_
                                               _sockbuf1365_
                                               _buf1449_)
                                              (_loop1368_)))
                                           (_K14051441_
                                            (lambda (_data1439_)
                                              (thread-mailbox-extract-and-rewind)
                                              (_write-e1366_
                                               _sockbuf1365_
                                               _data1439_)
                                              (_loop1368_)))
                                           (_K14041432_
                                            (lambda ()
                                              (thread-mailbox-extract-and-rewind)
                                              '#!void))
                                           (_K14031422_
                                            (lambda (_bogus1420_)
                                              (thread-mailbox-extract-and-rewind)
                                              (std/logger#warning
                                               '"unexpected message ~a"
                                               _bogus1420_)
                                              (_loop1368_))))
                                       (let* ((_try-match13991435_
                                               (lambda ()
                                                 (if (##eq? _msg13961408_
                                                            'exit)
                                                     (_K14041432_)
                                                     (let ((_bogus1425_
                                                            _msg13961408_))
                                                       (_K14031422_
                                                        _bogus1425_)))))
                                              (_try-match13981446_
                                               (lambda ()
                                                 (if (u8vector? _msg13961408_)
                                                     (let ((_data1444_
                                                            _msg13961408_))
                                                       (_K14051441_
                                                        _data1444_))
                                                     (_try-match13991435_)))))
                                         (if (##structure-instance-of?
                                              _msg13961408_
                                              'std/net/bio/output#output-buffer::t)
                                             (let ((_buf1454_ _msg13961408_))
                                               (_K14061451_ _buf1454_))
                                             (_try-match13981446_))))))
                                 _next1391_))))))))))
        (with-exception-catcher
         (lambda (_g13691371_)
           (if '#t
               (let ((_e1374_ _g13691371_))
                 (std/logger#log-error '"unhandled exception" _e1374_))
               (raise _g13691371_)))
         (lambda () (_loop1368_))))))
  (define std/actor/rpc/connection#rpc-connection-reader
    (lambda (_conn944_
             _connaddr945_
             _sockbuf946_
             _actor-table947_
             _cont-table948_
             _writer949_
             _read-e950_)
      (letrec ((_loop952_
                (lambda (_u8buf1205_)
                  (let* ((_g12061219_ (_read-e950_ _sockbuf946_ _u8buf1205_))
                         (_E12111223_
                          (lambda ()
                            (error '"No clause matching" _g12061219_))))
                    (let ((_K12151352_
                           (lambda (_count1253_ _u8buf1254_)
                             (let* ((_buffer1256_
                                     (std/net/bio/buffer#open-input-buffer__%
                                      _u8buf1254_
                                      '0
                                      _count1253_))
                                    (_msg1258_
                                     (_read-envelope959_ _buffer1256_)))
                               (let* ((_msg12601267_ _msg1258_)
                                      (_else12621275_ (lambda () '#!void))
                                      (_K12641344_
                                       (lambda (_content1278_)
                                         (let* ((_content12791289_
                                                 _content1278_)
                                                (_else12831297_
                                                 (lambda ()
                                                   (_dispatch-call953_
                                                    _msg1258_
                                                    _buffer1256_))))
                                           (let ((_K12871335_
                                                  (lambda ()
                                                    (_dispatch-call953_
                                                     _msg1258_
                                                     _buffer1256_)))
                                                 (_K12861316_
                                                  (lambda ()
                                                    (_dispatch-value954_
                                                     _msg1258_
                                                     _buffer1256_)))
                                                 (_K12851302_
                                                  (lambda ()
                                                    (_dispatch-control955_
                                                     _msg1258_
                                                     _buffer1256_))))
                                             (let* ((_try-match12821311_
                                                     (lambda ()
                                                       (if (or (##structure-direct-instance-of?
                                                                _content12791289_
                                                                'std/actor/proto#!continue::t)
                                                               (##structure-direct-instance-of?
                                                                _content12791289_
                                                                'std/actor/proto#!close::t)
                                                               (##structure-direct-instance-of?
                                                                _content12791289_
                                                                'std/actor/proto#!abort::t))
                                                           (_K12851302_)
                                                           (_else12831297_))))
                                                    (_try-match12811331_
                                                     (lambda ()
                                                       (if (or (##structure-direct-instance-of?
                                                                _content12791289_
                                                                'std/actor/proto#!value::t)
                                                               (##structure-direct-instance-of?
                                                                _content12791289_
                                                                'std/actor/proto#!error::t)
                                                               (##structure-direct-instance-of?
                                                                _content12791289_
                                                                'std/actor/proto#!yield::t)
                                                               (##structure-direct-instance-of?
                                                                _content12791289_
                                                                'std/actor/proto#!end::t)
                                                               (##structure-direct-instance-of?
                                                                _content12791289_
                                                                'std/actor/proto#!sync::t))
                                                           (_K12861316_)
                                                           (_try-match12821311_)))))
                                               (if (or (##structure-direct-instance-of?
                                                        _content12791289_
                                                        'std/actor/proto#!call::t)
                                                       (##structure-direct-instance-of?
                                                        _content12791289_
                                                        'std/actor/proto#!event::t)
                                                       (##structure-direct-instance-of?
                                                        _content12791289_
                                                        'std/actor/proto#!stream::t))
                                                   (_K12871335_)
                                                   (_try-match12811331_))))))))
                                 (if (##structure-direct-instance-of?
                                      _msg12601267_
                                      'std/actor/message#message::t)
                                     (let* ((_e12651347_
                                             (##vector-ref _msg12601267_ '1))
                                            (_content1350_ _e12651347_))
                                       (_K12641344_ _content1350_))
                                     '#!void))
                               (_loop952_ _u8buf1254_))))
                          (_K12141247_ (lambda () (_loop952_ _u8buf1205_)))
                          (_K12131239_
                           (lambda () (thread-send _conn944_ '#!eof)))
                          (_K12121229_
                           (lambda (_unexpected1227_)
                             (error '"read unexpected object"
                                    _unexpected1227_))))
                      (let* ((_try-match12091242_
                              (lambda ()
                                (if (eof-object? _g12061219_)
                                    (_K12131239_)
                                    (let ((_unexpected1232_ _g12061219_))
                                      (_K12121229_ _unexpected1232_)))))
                             (_try-match12081250_
                              (lambda ()
                                (if (eq? _g12061219_ '#!void)
                                    (_K12141247_)
                                    (_try-match12091242_)))))
                        (if (##fx= (if (##values? _g12061219_)
                                       (##vector-length _g12061219_)
                                       '1)
                                   '2)
                            (let* ((_e12161355_ (##vector-ref _g12061219_ '0))
                                   (_e12171360_ (##vector-ref _g12061219_ '1)))
                              (let ((_u8buf1358_ _e12161355_)
                                    (_count1363_ _e12171360_))
                                (_K12151352_ _count1363_ _u8buf1358_)))
                            (_try-match12081250_)))))))
               (_dispatch-call953_
                (lambda (_msg1115_ _buffer1116_)
                  (let* ((_uuid1118_
                          (##direct-structure-ref
                           _msg1115_
                           '3
                           std/actor/message#message::t
                           '#f))
                         (_$e1120_
                          (std/misc/sync#sync-hash-get
                           _actor-table947_
                           _uuid1118_)))
                    (if _$e1120_
                        ((lambda (_e11221124_)
                           (let* ((_g11261133_ _e11221124_)
                                  (_E11281137_
                                   (lambda ()
                                     (error '"No clause matching"
                                            _g11261133_)))
                                  (_K11291151_
                                   (lambda (_proto1140_ _actor1141_)
                                     (if (_read-payload!960_
                                          _msg1115_
                                          _buffer1116_
                                          _proto1140_)
                                         (begin
                                           (##direct-structure-set!
                                            _msg1115_
                                            _actor1141_
                                            '3
                                            std/actor/message#message::t
                                            '#f)
                                           (##direct-structure-set!
                                            _msg1115_
                                            (let ((__obj8230
                                                   (make-object
                                                    std/actor/proto#remote::t
                                                    '4)))
                                              (std/actor/proto#remote:::init!
                                               __obj8230
                                               _conn944_
                                               _uuid1118_
                                               _connaddr945_
                                               _proto1140_)
                                              __obj8230)
                                            '2
                                            std/actor/message#message::t
                                            '#f)
                                           (std/actor/message#send__0
                                            _actor1141_
                                            _msg1115_))
                                         (if (or (##structure-direct-instance-of?
                                                  (##direct-structure-ref
                                                   _msg1115_
                                                   '1
                                                   std/actor/message#message::t
                                                   '#f)
                                                  'std/actor/proto#!call::t)
                                                 (##structure-direct-instance-of?
                                                  (##direct-structure-ref
                                                   _msg1115_
                                                   '1
                                                   std/actor/message#message::t
                                                   '#f)
                                                  'std/actor/proto#!stream::t))
                                             (let* ((_content1146_
                                                     (##direct-structure-ref
                                                      _msg1115_
                                                      '1
                                                      std/actor/message#message::t
                                                      '#f))
                                                    (_k1148_ (if (##structure-direct-instance-of?
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          _content1146_
                          'std/actor/proto#!call::t)
                         (##direct-structure-ref
                          _content1146_
                          '2
                          std/actor/proto#!call::t
                          '#f)
                         (##direct-structure-ref
                          _content1146_
                          '2
                          std/actor/proto#!stream::t
                          '#f))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                               (_dispatch-remote-error958_
                                                (##structure
                                                 std/actor/proto#!error::t
                                                 '"unmarshal error"
                                                 _k1148_)
                                                _uuid1118_))
                                             '#!void)))))
                             (if (##fx= (if (##values? _g11261133_)
                                            (##vector-length _g11261133_)
                                            '1)
                                        '2)
                                 (let* ((_e11301154_
                                         (##vector-ref _g11261133_ '0))
                                        (_actor1157_ _e11301154_)
                                        (_e11311159_
                                         (##vector-ref _g11261133_ '1))
                                        (_proto1162_ _e11311159_))
                                   (_K11291151_ _proto1162_ _actor1157_))
                                 (_E11281137_))))
                         _$e1120_)
                        (begin
                          (std/logger#warning
                           '"cannot route message; no actor binding ~a"
                           (std/misc/uuid#uuid->string _uuid1118_))
                          (let* ((_g11631173_
                                  (##direct-structure-ref
                                   _msg1115_
                                   '1
                                   std/actor/message#message::t
                                   '#f))
                                 (_else11651181_ (lambda () '#!void))
                                 (_K11671186_
                                  (lambda (_k1184_)
                                    (_dispatch-remote-error958_
                                     (##structure
                                      std/actor/proto#!error::t
                                      '"no binding"
                                      _k1184_)
                                     _uuid1118_))))
                            (if (##structure-direct-instance-of?
                                 _g11631173_
                                 'std/actor/proto#!call::t)
                                (let* ((_e11701189_
                                        (##vector-ref _g11631173_ '1))
                                       (_e11711192_
                                        (##vector-ref _g11631173_ '2))
                                       (_k1195_ _e11711192_))
                                  (_K11671186_ _k1195_))
                                (if (##structure-direct-instance-of?
                                     _g11631173_
                                     'std/actor/proto#!stream::t)
                                    (let* ((_e11681197_
                                            (##vector-ref _g11631173_ '1))
                                           (_e11691200_
                                            (##vector-ref _g11631173_ '2))
                                           (_k1203_ _e11691200_))
                                      (_K11671186_ _k1203_))
                                    '#!void))))))))
               (_dispatch-value954_
                (lambda (_msg1046_ _buffer1047_)
                  (let* ((_content1049_
                          (##direct-structure-ref
                           _msg1046_
                           '1
                           std/actor/message#message::t
                           '#f))
                         (_cont1051_ (_value-k956_ _content1049_)))
                    (let ((_$e1054_
                           (std/actor/rpc/connection#continuation-table-get
                            _cont-table948_
                            _cont1051_)))
                      (if _$e1054_
                          ((lambda (_e10561058_)
                             (let* ((_g10601069_ _e10561058_)
                                    (_E10621073_
                                     (lambda ()
                                       (error '"No clause matching"
                                              _g10601069_)))
                                    (_K10631092_
                                     (lambda (_stream?1076_
                                              _k1077_
                                              _proto1078_
                                              _actor1079_)
                                       (if (_read-payload!960_
                                            _msg1046_
                                            _buffer1047_
                                            _proto1078_)
                                           (begin
                                             (_value-k-set!957_
                                              _content1049_
                                              _k1077_)
                                             (##direct-structure-set!
                                              _msg1046_
                                              (let ((__obj8231
                                                     (make-object
                                                      std/actor/proto#remote::t
                                                      '4)))
                                                (std/actor/proto#remote:::init!
                                                 __obj8231
                                                 _conn944_
                                                 (##direct-structure-ref
                                                  _msg1046_
                                                  '3
                                                  std/actor/message#message::t
                                                  '#f)
                                                 _connaddr945_
                                                 _proto1078_)
                                                __obj8231)
                                              '2
                                              std/actor/message#message::t
                                              '#f)
                                             (if (or (##structure-direct-instance-of?
                                                      _content1049_
                                                      'std/actor/proto#!yield::t)
                                                     (##structure-direct-instance-of?
                                                      _content1049_
                                                      'std/actor/proto#!sync::t))
                                                 (let ((_ok1090_
                                                        (let ((_mx1084_
                                                               (##unchecked-structure-ref
                                                                _cont-table948_
                                                                '1
                                                                std/actor/rpc/connection#continuation-table::t
                                                                '#f)))
                                                          (mutex-lock!
                                                           _mx1084_)
                                                          (let ((_res1087_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         (if (table-ref
                              (##unchecked-structure-ref
                               _cont-table948_
                               '2
                               std/actor/rpc/connection#continuation-table::t
                               '#f)
                              _cont1051_
                              '#f)
                             (begin
                               (std/actor/message#send__0
                                _actor1079_
                                _msg1046_)
                               '#t)
                             '#f)))
                    (mutex-unlock! _mx1084_)
                    _res1087_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   (if _ok1090_
                                                       '#!void
                                                       (if (##structure-direct-instance-of?
                                                            _content1049_
                                                            'std/actor/proto#!sync::t)
                                                           (_dispatch-remote-error958_
                                                            (##structure
                                                             std/actor/proto#!abort::t
                                                             _cont1051_)
                                                            (##direct-structure-ref
                                                             _msg1046_
                                                             '3
                                                             std/actor/message#message::t
                                                             '#f))
                                                           '#!void)))
                                                 (if (std/actor/rpc/connection#continuation-table-remove!
                                                      _cont-table948_
                                                      _cont1051_)
                                                     (std/actor/message#send__0
                                                      _actor1079_
                                                      _msg1046_)
                                                     '#!void)))
                                           (begin
                                             (if (std/actor/rpc/connection#continuation-table-remove!
                                                  _cont-table948_
                                                  _cont1051_)
                                                 (std/actor/message#send-message__%
                                                  _actor1079_
                                                  (##structure
                                                   std/actor/proto#!error::t
                                                   (make-struct-instance
                                                    std/actor/proto#rpc-error::t
                                                    'rpc
                                                    '"unmarshal error")
                                                   _k1077_)
                                                  '#f
                                                  '#f)
                                                 '#!void)
                                             (if (##structure-direct-instance-of?
                                                  _content1049_
                                                  'std/actor/proto#!sync::t)
                                                 (_dispatch-remote-error958_
                                                  (##structure
                                                   std/actor/proto#!abort::t
                                                   _cont1051_)
                                                  (##direct-structure-ref
                                                   _msg1046_
                                                   '3
                                                   std/actor/message#message::t
                                                   '#f))
                                                 '#!void))))))
                               (if (##fx= (if (##values? _g10601069_)
                                              (##vector-length _g10601069_)
                                              '1)
                                          '4)
                                   (let* ((_e10641095_
                                           (##vector-ref _g10601069_ '0))
                                          (_actor1098_ _e10641095_)
                                          (_e10651100_
                                           (##vector-ref _g10601069_ '1))
                                          (_proto1103_ _e10651100_)
                                          (_e10661105_
                                           (##vector-ref _g10601069_ '2))
                                          (_k1108_ _e10661105_)
                                          (_e10671110_
                                           (##vector-ref _g10601069_ '3))
                                          (_stream?1113_ _e10671110_))
                                     (_K10631092_
                                      _stream?1113_
                                      _k1108_
                                      _proto1103_
                                      _actor1098_))
                                   (_E10621073_))))
                           _$e1054_)
                          (begin
                            (std/logger#warning
                             '"cannot route message; unknown continuation ~a"
                             _cont1051_)
                            (if (##structure-direct-instance-of?
                                 _content1049_
                                 'std/actor/proto#!sync::t)
                                (_dispatch-remote-error958_
                                 (##structure
                                  std/actor/proto#!abort::t
                                  _cont1051_)
                                 (##direct-structure-ref
                                  _msg1046_
                                  '3
                                  std/actor/message#message::t
                                  '#f))
                                '#!void)))))))
               (_dispatch-control955_
                (lambda (_msg1008_ _buffer1009_)
                  (let* ((_content1011_
                          (##direct-structure-ref
                           _msg1008_
                           '1
                           std/actor/message#message::t
                           '#f))
                         (_cont1013_ (_value-k956_ _content1011_))
                         (_stream1015_
                          (std/actor/rpc/connection#continuation-table-get-stream-actor
                           _cont-table948_
                           _cont1013_)))
                    (if _stream1015_
                        (let* ((_stream10171024_ _stream1015_)
                               (_E10191028_
                                (lambda ()
                                  (error '"No clause matching"
                                         _stream10171024_)))
                               (_K10201034_
                                (lambda (_dest1031_ _actor1032_)
                                  (##direct-structure-set!
                                   _msg1008_
                                   _dest1031_
                                   '2
                                   std/actor/message#message::t
                                   '#f)
                                  (std/actor/message#send__0
                                   _actor1032_
                                   _msg1008_)
                                  (std/actor/rpc/connection#continuation-table-remove-stream-actor!
                                   _cont-table948_
                                   _cont1013_))))
                          (if (##pair? _stream10171024_)
                              (let ((_hd10211037_ (##car _stream10171024_))
                                    (_tl10221039_ (##cdr _stream10171024_)))
                                (let* ((_actor1042_ _hd10211037_)
                                       (_dest1044_ _tl10221039_))
                                  (_K10201034_ _dest1044_ _actor1042_)))
                              (_E10191028_)))
                        (begin
                          (std/logger#warning
                           '"unexpected control message; unknown stream ~a"
                           _cont1013_)
                          (if (##structure-direct-instance-of?
                               _content1011_
                               'std/actor/proto#!abort::t)
                              '#!void
                              (_dispatch-remote-error958_
                               (##structure
                                std/actor/proto#!error::t
                                '"uknown stream"
                                _cont1013_)
                               (##direct-structure-ref
                                _msg1008_
                                '3
                                std/actor/message#message::t
                                '#f))))))))
               (_value-k956_
                (lambda (_obj1006_)
                  (##vector-ref
                   _obj1006_
                   (fx- (##vector-length _obj1006_) '1))))
               (_value-k-set!957_
                (lambda (_obj1003_ _k1004_)
                  (##vector-set!
                   _obj1003_
                   (fx- (##vector-length _obj1003_) '1)
                   _k1004_)))
               (_dispatch-remote-error958_
                (lambda (_err995_ _dest996_)
                  (let* ((_msg998_
                          (##structure
                           std/actor/message#message::t
                           _err995_
                           '#!void
                           _dest996_
                           '#f))
                         (_data1000_
                          (std/actor/rpc/proto/message#rpc-proto-marshal-message
                           _msg998_
                           '#f)))
                    (thread-send _writer949_ _data1000_))))
               (_read-envelope959_
                (lambda (_buffer983_)
                  (with-exception-catcher
                   (lambda (_g984986_)
                     (if ((lambda (_$obj989_) (exception? _$obj989_))
                          _g984986_)
                         (let ((_e992_ _g984986_))
                           (std/logger#log-error '"read error" _e992_)
                           _e992_)
                         (raise _g984986_)))
                   (lambda ()
                     (std/actor/rpc/proto/message#rpc-proto-read-envelope
                      _buffer983_)))))
               (_read-payload!960_
                (lambda (_msg972_ _buffer973_ _proto974_)
                  (with-exception-catcher
                   (lambda (_g975977_)
                     (if '#t
                         (let ((_e980_ _g975977_))
                           (std/logger#log-error '"unmarshal error" _e980_)
                           '#f)
                         (raise _g975977_)))
                   (lambda ()
                     (std/actor/rpc/proto/message#rpc-proto-read-payload!
                      _msg972_
                      _buffer973_
                      _proto974_)))))
               (_run961_
                (lambda ()
                  (call-with-parameters
                   (lambda () (_loop952_ (make-u8vector '4096)))
                   std/actor/xdr#current-xdr-type-registry
                   std/actor/xdr#+xdr-default-type-registry+))))
        (with-exception-catcher
         (lambda (_g962964_)
           (if '#t
               (let ((_e967_ _g962964_))
                 (std/logger#log-error '"unhandled exception" _e967_))
               (raise _g962964_)))
         (lambda () (_run961_))))))
  (define std/actor/rpc/connection#rpc-options-timeout
    (lambda (_opts931_ _default932_)
      (letrec ((_timeout934_
                (lambda (_dt941_ _default942_)
                  (if (real? _dt941_)
                      (seconds->time (+ (##current-time-point) _dt941_))
                      (if (time? _dt941_)
                          _dt941_
                          (if (not _dt941_)
                              _dt941_
                              (_timeout934_ _default942_ '#f)))))))
        (let ((_$e936_ (if _opts931_ (memq 'timeout: _opts931_) '#f)))
          (if _$e936_
              ((lambda (_plist939_)
                 (_timeout934_ (cadr _plist939_) _default932_))
               _$e936_)
              (_timeout934_ _default932_ '#f))))))
  (define std/actor/rpc/connection#rpc-connection-shutdown
    (lambda (_rpc-server833_)
      (std/actor/message#send-message__0
       _rpc-server833_
       (##structure
        std/actor/proto#!event::t
        (##structure std/actor/rpc/base#rpc.connection-shutdown::t)))
      (let _lp835_ ()
        (let _loop837839_ ()
          (let ((_next843_ (thread-mailbox-next)))
            ((lambda (_msg846_)
               (let* ((_msg848856_ _msg846_)
                      (_else851864_ (lambda () (_loop837839_))))
                 (let ((_K854926_
                        (lambda (_msg878_)
                          (thread-mailbox-extract-and-rewind)
                          (let* ((_msg879885_ _msg878_)
                                 (_E881889_
                                  (lambda ()
                                    (error '"No clause matching" _msg879885_)))
                                 (_K882918_
                                  (lambda (_content892_)
                                    (let* ((_content893900_ _content892_)
                                           (_else895908_
                                            (lambda ()
                                              (std/actor/rpc/connection#rpc-send-error-response
                                               _msg878_
                                               '"connection error")
                                              (_lp835_)))
                                           (_K897912_
                                            (lambda ()
                                              (std/actor/rpc/connection#rpc-send-error-responses
                                               '"connection error"))))
                                      (if (##structure-direct-instance-of?
                                           _content893900_
                                           'std/actor/proto#!event::t)
                                          (let ((_e898915_
                                                 (##vector-ref
                                                  _content893900_
                                                  '1)))
                                            (if (##structure-direct-instance-of?
                                                 _e898915_
                                                 'std/actor#rpc.connection-close::t)
                                                (_K897912_)
                                                (_else895908_)))
                                          (_else895908_))))))
                            (if (##structure-direct-instance-of?
                                 _msg879885_
                                 'std/actor/message#message::t)
                                (let* ((_e883921_
                                        (##vector-ref _msg879885_ '1))
                                       (_content924_ _e883921_))
                                  (_K882918_ _content924_))
                                (_E881889_)))))
                       (_K853870_
                        (lambda (_ignore868_)
                          (thread-mailbox-extract-and-rewind)
                          (_lp835_))))
                   (if (##structure-direct-instance-of?
                        _msg848856_
                        'std/actor/message#message::t)
                       (let ((_msg929_ _msg848856_)) (_K854926_ _msg929_))
                       (let ((_ignore873_ _msg848856_))
                         (_K853870_ _ignore873_))))))
             _next843_))))))
  (define std/actor/rpc/connection#rpc-connection-cleanup
    (lambda (_rpc-server829_ _exn830_ _sock831_)
      (std/logger#log-error '"connection error" _exn830_)
      (if _sock831_ (std/net/socket/api#ssocket-close _sock831_) '#!void)
      (std/actor/rpc/connection#rpc-connection-shutdown _rpc-server829_)))
  (define std/actor/rpc/connection#rpc-send-error-response
    (lambda (_msg730_ _what731_)
      (if (##structure-direct-instance-of?
           _msg730_
           'std/actor/message#message::t)
          (let* ((_msg732740_ _msg730_)
                 (_E734744_
                  (lambda () (error '"No clause matching" _msg732740_)))
                 (_K735811_
                  (lambda (_dest747_ _src748_ _content749_)
                    (let* ((_content750763_ _content749_)
                           (_else753771_ (lambda () '#!void)))
                      (let ((_K757792_
                             (lambda (_k790_)
                               (std/actor/message#send-message__%
                                (##direct-structure-ref
                                 _msg730_
                                 '2
                                 std/actor/message#message::t
                                 '#f)
                                (##structure
                                 std/actor/proto#!error::t
                                 (make-struct-instance
                                  std/actor/proto#rpc-error::t
                                  'rpc
                                  _what731_)
                                 _k790_)
                                '#f
                                '#f)))
                            (_K755779_
                             (lambda (_k775_)
                               (let ((_abort777_
                                      (##structure
                                       std/actor/message#message::t
                                       (##structure
                                        std/actor/proto#!abort::t
                                        _k775_)
                                       _dest747_
                                       _src748_
                                       '#f)))
                                 (std/actor/message#send__0
                                  _src748_
                                  _abort777_)))))
                        (let* ((_try-match752787_
                                (lambda ()
                                  (if (##structure-direct-instance-of?
                                       _content750763_
                                       'std/actor/proto#!yield::t)
                                      (let* ((_e756782_
                                              (##vector-ref
                                               _content750763_
                                               '1))
                                             (_k785_ _e756782_))
                                        (_K755779_ _k785_))
                                      '#!void)))
                               (___match82108211_
                                (lambda ()
                                  (if (##structure-direct-instance-of?
                                       _content750763_
                                       'std/actor/proto#!stream::t)
                                      (let* ((_e758803_
                                              (##vector-ref
                                               _content750763_
                                               '1))
                                             (_e759806_
                                              (##vector-ref
                                               _content750763_
                                               '2))
                                             (_k809_ _e759806_))
                                        (_K757792_ _k809_))
                                      (_try-match752787_)))))
                          (if (##structure-direct-instance-of?
                               _content750763_
                               'std/actor/proto#!call::t)
                              (let* ((_e760795_
                                      (##vector-ref _content750763_ '1))
                                     (_e761798_
                                      (##vector-ref _content750763_ '2))
                                     (_k801_ _e761798_))
                                (_K757792_ _k801_))
                              (___match82108211_))))))))
            (if (##structure-direct-instance-of?
                 _msg732740_
                 'std/actor/message#message::t)
                (let* ((_e736814_ (##vector-ref _msg732740_ '1))
                       (_content817_ _e736814_)
                       (_e737819_ (##vector-ref _msg732740_ '2))
                       (_src822_ _e737819_)
                       (_e738824_ (##vector-ref _msg732740_ '3))
                       (_dest827_ _e738824_))
                  (_K735811_ _dest827_ _src822_ _content817_))
                (_E734744_)))
          '#!void)))
  (define std/actor/rpc/connection#rpc-send-error-responses
    (lambda (_what677_)
      (let _lp679_ ()
        (let _loop681683_ ()
          (let ((_next687_ (std/actor/message#mailbox-next)))
            (if (eq? _next687_ std/actor/message#mailbox-empty)
                ((lambda () (thread-mailbox-rewind) '#!void))
                ((lambda (_msg691_)
                   (let* ((_msg693701_ _msg691_)
                          (_else696709_ (lambda () (_loop681683_))))
                     (let ((_K699725_
                            (lambda (_msg723_)
                              (thread-mailbox-extract-and-rewind)
                              (std/actor/rpc/connection#rpc-send-error-response
                               _msg723_
                               _what677_)
                              (_lp679_)))
                           (_K698715_
                            (lambda (_ignore713_)
                              (thread-mailbox-extract-and-rewind)
                              (_lp679_))))
                       (if (##structure-direct-instance-of?
                            _msg693701_
                            'std/actor/message#message::t)
                           (let ((_msg728_ _msg693701_)) (_K699725_ _msg728_))
                           (let ((_ignore718_ _msg693701_))
                             (_K698715_ _ignore718_))))))
                 _next687_))))))))
