/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.CommandThread;
import jalview.FormatAdapter;
import jalview.ProgressFrame;
import jalview.Sequence;
import jalview.TextAreaPrintStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Random;

public class ClustalwThread
extends CommandThread {
    String inFile;
    String outFile;
    PrintStream ps;

    public ClustalwThread(String string, String string2) {
        super((String)null);
        this.inFile = string;
        this.outFile = string2;
        new File(string);
        new File(string2);
        System.out.println("OS = " + System.getProperty("os.name"));
        if (System.getProperty("os.name").equals("Windows 95")) {
            this.command = "clustalw /inFile=" + string + " /outFile=" + string2 + " /outorder=input";
            return;
        }
        this.command = "clustalw -inFile=" + string + " -outFile=" + string2 + " /outorder=input";
    }

    public ClustalwThread(Sequence[] sequenceArray) {
        try {
            String string;
            long l = 12L;
            Random random = new Random(l);
            File file = null;
            File file2 = null;
            String string2 = "";
            if (System.getProperty("os.name").equals("Windows 95")) {
                string2 = "c:\\windows\\temp\\";
            }
            do {
                int n;
                if ((n = random.nextInt()) < 0) {
                    n = -n;
                }
                if ((string = String.valueOf(n)).length() > 4) {
                    string = string.substring(0, 4);
                }
                this.inFile = String.valueOf(string2) + "pog" + string + ".msf";
                this.outFile = String.valueOf(string2) + "pog" + string + ".aln";
                file = new File(this.inFile);
                file2 = new File(this.outFile);
            } while (file.exists() || file2.exists());
            System.out.println(this.inFile);
            System.out.println(this.outFile);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.inFile));
            string = FormatAdapter.get("MSF", sequenceArray);
            byte[] byArray = string.getBytes();
            int n = 0;
            while (n < byArray.length) {
                bufferedOutputStream.write(byArray[n]);
                ++n;
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            System.out.println("OS = " + System.getProperty("os.name"));
            this.command = System.getProperty("os.name").equals("Windows 95") ? "clustalw /inFile=" + this.inFile + " /outFile=" + this.outFile + " /outorder=input" : "clustalw -inFile=" + this.inFile + " -outFile=" + this.outFile + " -outorder=input";
            System.out.println("Command = " + this.command);
            ProgressFrame progressFrame = new ProgressFrame("Clustalw progress", this, null);
            TextAreaPrintStream textAreaPrintStream = new TextAreaPrintStream((OutputStream)System.out, progressFrame.ta);
            this.ps = textAreaPrintStream;
            progressFrame.show();
            Thread thread = new Thread(progressFrame.pp);
            progressFrame.pp.ct = this;
            thread.start();
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception in clustalwThread " + exception);
            return;
        }
    }

    public void run() {
        System.out.println("Running command: " + this.command);
        try {
            this.p = Runtime.getRuntime().exec(this.command);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.p.getInputStream());
            int n = 0;
            byte[] byArray = new byte[1000];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                String string = new String(byArray, 0, 0, n);
                if (string.indexOf("CLUSTAL-Alignment file created") >= 0) break;
                System.out.println(string);
                this.ps.print(string);
            }
            System.out.println("Command thread is done");
        }
        catch (EOFException eOFException) {
            System.out.println("Exception : " + eOFException);
        }
        catch (IOException iOException) {
            System.out.println("Exception : " + iOException);
        }
        this.done = true;
    }
}

