/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.tomcat.dbcp.dbcp2.ListException;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSource;

abstract class InstanceKeyDataSourceFactory
implements ObjectFactory {
    private static final Map<String, InstanceKeyDataSource> instanceMap = new ConcurrentHashMap<String, InstanceKeyDataSource>();

    InstanceKeyDataSourceFactory() {
    }

    static synchronized String registerNewInstance(InstanceKeyDataSource ds) {
        int max = 0;
        for (String s : instanceMap.keySet()) {
            if (s == null) continue;
            try {
                max = Math.max(max, Integer.parseInt(s));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String instanceKey = String.valueOf(max + 1);
        instanceMap.put(instanceKey, ds);
        return instanceKey;
    }

    static void removeInstance(String key) {
        if (key != null) {
            instanceMap.remove(key);
        }
    }

    public static void closeAll() throws Exception {
        ArrayList<Throwable> exceptionList = new ArrayList<Throwable>(instanceMap.size());
        for (Map.Entry<String, InstanceKeyDataSource> next : instanceMap.entrySet()) {
            InstanceKeyDataSource value;
            if (next == null || (value = next.getValue()) == null) continue;
            try {
                value.close();
            }
            catch (Exception e) {
                exceptionList.add(e);
            }
        }
        instanceMap.clear();
        if (!exceptionList.isEmpty()) {
            throw new ListException("Could not close all InstanceKeyDataSource instances.", exceptionList);
        }
    }

    @Override
    public Object getObjectInstance(Object refObj, Name name, Context context, Hashtable<?, ?> env) throws IOException, ClassNotFoundException {
        Reference ref;
        InstanceKeyDataSource obj = null;
        if (refObj instanceof Reference && this.isCorrectClass((ref = (Reference)refObj).getClassName())) {
            RefAddr refAddr = ref.get("instanceKey");
            if (refAddr != null && refAddr.getContent() != null) {
                obj = instanceMap.get(refAddr.getContent());
            } else {
                String key = null;
                if (name != null) {
                    key = name.toString();
                    obj = instanceMap.get(key);
                }
                if (obj == null) {
                    InstanceKeyDataSource ds = this.getNewInstance(ref);
                    this.setCommonProperties(ref, ds);
                    obj = ds;
                    if (key != null) {
                        instanceMap.put(key, ds);
                    }
                }
            }
        }
        return obj;
    }

    private void setCommonProperties(Reference ref, InstanceKeyDataSource ikds) throws IOException, ClassNotFoundException {
        RefAddr refAddr = ref.get("dataSourceName");
        if (refAddr != null && refAddr.getContent() != null) {
            ikds.setDataSourceName(refAddr.getContent().toString());
        }
        if ((refAddr = ref.get("description")) != null && refAddr.getContent() != null) {
            ikds.setDescription(refAddr.getContent().toString());
        }
        if ((refAddr = ref.get("jndiEnvironment")) != null && refAddr.getContent() != null) {
            byte[] serialized = (byte[])refAddr.getContent();
            ikds.setJndiEnvironment((Properties)InstanceKeyDataSourceFactory.deserialize(serialized));
        }
        if ((refAddr = ref.get("loginTimeout")) != null && refAddr.getContent() != null) {
            ikds.setLoginTimeout(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("blockWhenExhausted")) != null && refAddr.getContent() != null) {
            ikds.setDefaultBlockWhenExhausted(Boolean.parseBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("evictionPolicyClassName")) != null && refAddr.getContent() != null) {
            ikds.setDefaultEvictionPolicyClassName(refAddr.getContent().toString());
        }
        if ((refAddr = ref.get("lifo")) != null && refAddr.getContent() != null) {
            ikds.setDefaultLifo(Boolean.parseBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("maxIdlePerKey")) != null && refAddr.getContent() != null) {
            ikds.setDefaultMaxIdle(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("maxTotalPerKey")) != null && refAddr.getContent() != null) {
            ikds.setDefaultMaxTotal(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("maxWaitMillis")) != null && refAddr.getContent() != null) {
            ikds.setDefaultMaxWaitMillis(Long.parseLong(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("minEvictableIdleTimeMillis")) != null && refAddr.getContent() != null) {
            ikds.setDefaultMinEvictableIdleTimeMillis(Long.parseLong(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("minIdlePerKey")) != null && refAddr.getContent() != null) {
            ikds.setDefaultMinIdle(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("numTestsPerEvictionRun")) != null && refAddr.getContent() != null) {
            ikds.setDefaultNumTestsPerEvictionRun(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("softMinEvictableIdleTimeMillis")) != null && refAddr.getContent() != null) {
            ikds.setDefaultSoftMinEvictableIdleTimeMillis(Long.parseLong(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("testOnCreate")) != null && refAddr.getContent() != null) {
            ikds.setDefaultTestOnCreate(Boolean.parseBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("testOnBorrow")) != null && refAddr.getContent() != null) {
            ikds.setDefaultTestOnBorrow(Boolean.parseBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("testOnReturn")) != null && refAddr.getContent() != null) {
            ikds.setDefaultTestOnReturn(Boolean.parseBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("testWhileIdle")) != null && refAddr.getContent() != null) {
            ikds.setDefaultTestWhileIdle(Boolean.parseBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("timeBetweenEvictionRunsMillis")) != null && refAddr.getContent() != null) {
            ikds.setDefaultTimeBetweenEvictionRunsMillis(Long.parseLong(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("validationQuery")) != null && refAddr.getContent() != null) {
            ikds.setValidationQuery(refAddr.getContent().toString());
        }
        if ((refAddr = ref.get("validationQueryTimeout")) != null && refAddr.getContent() != null) {
            ikds.setValidationQueryTimeout(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("rollbackAfterValidation")) != null && refAddr.getContent() != null) {
            ikds.setRollbackAfterValidation(Boolean.parseBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("maxConnLifetimeMillis")) != null && refAddr.getContent() != null) {
            ikds.setMaxConnLifetimeMillis(Long.parseLong(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("defaultAutoCommit")) != null && refAddr.getContent() != null) {
            ikds.setDefaultAutoCommit(Boolean.valueOf(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("defaultTransactionIsolation")) != null && refAddr.getContent() != null) {
            ikds.setDefaultTransactionIsolation(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = ref.get("defaultReadOnly")) != null && refAddr.getContent() != null) {
            ikds.setDefaultReadOnly(Boolean.valueOf(refAddr.getContent().toString()));
        }
    }

    protected abstract boolean isCorrectClass(String var1);

    protected abstract InstanceKeyDataSource getNewInstance(Reference var1) throws IOException, ClassNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final Object deserialize(byte[] data) throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(data));
            Object object = in.readObject();
            return object;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

