/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.tokenbinding;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.PRFAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.PseudoRandomFunction;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;

public class TokenCalculator {
    public static byte[] calculateEKM(Chooser chooser, int length) throws CryptoException {
        byte[] masterSecret = chooser.getMasterSecret();
        String label = "EXPORTER-Token-Binding";
        byte[] clientServerRandom = ArrayConverter.concatenate((byte[][])new byte[][]{chooser.getClientRandom(), chooser.getServerRandom()});
        PRFAlgorithm algorithm = AlgorithmResolver.getPRFAlgorithm(chooser.getSelectedProtocolVersion(), chooser.getSelectedCipherSuite());
        return PseudoRandomFunction.compute(algorithm, masterSecret, label, clientServerRandom, length);
    }

    private TokenCalculator() {
    }
}

