/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ClientCertificateType;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.protocol.handler.CertificateRequestHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignatureAndHashAlgorithmsExtensionMessage;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement
public class CertificateRequestMessage
extends HandshakeMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.COUNT)
    private ModifiableInteger clientCertificateTypesCount;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray clientCertificateTypes;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger signatureHashAlgorithmsLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray signatureHashAlgorithms;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger distinguishedNamesLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray distinguishedNames;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger certificateRequestContextLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray certificateRequestContext;

    public CertificateRequestMessage() {
        super(HandshakeMessageType.CERTIFICATE_REQUEST);
    }

    public CertificateRequestMessage(Config tlsConfig) {
        super(tlsConfig, HandshakeMessageType.CERTIFICATE_REQUEST);
        if (tlsConfig.getHighestProtocolVersion().isTLS13()) {
            this.setExtensions(new LinkedList<ExtensionMessage>());
            this.addExtension(new SignatureAndHashAlgorithmsExtensionMessage());
        }
    }

    public ModifiableInteger getClientCertificateTypesCount() {
        return this.clientCertificateTypesCount;
    }

    public void setClientCertificateTypesCount(ModifiableInteger clientCertificateTypesCount) {
        this.clientCertificateTypesCount = clientCertificateTypesCount;
    }

    public void setClientCertificateTypesCount(int clientCertificateTypesCount) {
        this.clientCertificateTypesCount = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.clientCertificateTypesCount, (Integer)clientCertificateTypesCount);
    }

    public ModifiableByteArray getClientCertificateTypes() {
        return this.clientCertificateTypes;
    }

    public void setClientCertificateTypes(ModifiableByteArray clientCertificateTypes) {
        this.clientCertificateTypes = clientCertificateTypes;
    }

    public void setClientCertificateTypes(byte[] clientCertificateTypes) {
        this.clientCertificateTypes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.clientCertificateTypes, (byte[])clientCertificateTypes);
    }

    public ModifiableInteger getSignatureHashAlgorithmsLength() {
        return this.signatureHashAlgorithmsLength;
    }

    public void setSignatureHashAlgorithmsLength(ModifiableInteger signatureHashAlgorithmsLength) {
        this.signatureHashAlgorithmsLength = signatureHashAlgorithmsLength;
    }

    public void setSignatureHashAlgorithmsLength(int signatureHashAlgorithmsLength) {
        this.signatureHashAlgorithmsLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.signatureHashAlgorithmsLength, (Integer)signatureHashAlgorithmsLength);
    }

    public ModifiableByteArray getSignatureHashAlgorithms() {
        return this.signatureHashAlgorithms;
    }

    public void setSignatureHashAlgorithms(ModifiableByteArray signatureHashAlgorithms) {
        this.signatureHashAlgorithms = signatureHashAlgorithms;
    }

    public void setSignatureHashAlgorithms(byte[] signatureHashAlgorithms) {
        this.signatureHashAlgorithms = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.signatureHashAlgorithms, (byte[])signatureHashAlgorithms);
    }

    public ModifiableInteger getDistinguishedNamesLength() {
        return this.distinguishedNamesLength;
    }

    public void setDistinguishedNamesLength(ModifiableInteger distinguishedNamesLength) {
        this.distinguishedNamesLength = distinguishedNamesLength;
    }

    public void setDistinguishedNamesLength(int distinguishedNamesLength) {
        this.distinguishedNamesLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.distinguishedNamesLength, (Integer)distinguishedNamesLength);
    }

    public ModifiableByteArray getDistinguishedNames() {
        return this.distinguishedNames;
    }

    public void setDistinguishedNames(ModifiableByteArray distinguishedNames) {
        this.distinguishedNames = distinguishedNames;
    }

    public void setDistinguishedNames(byte[] distinguishedNames) {
        this.distinguishedNames = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.distinguishedNames, (byte[])distinguishedNames);
    }

    public ModifiableInteger getCertificateRequestContextLength() {
        return this.certificateRequestContextLength;
    }

    public void setCertificateRequestContextLength(ModifiableInteger certificateRequestContextLength) {
        this.certificateRequestContextLength = certificateRequestContextLength;
    }

    public void setCertificateRequestContextLength(int certificateRequestContextLength) {
        this.certificateRequestContextLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.certificateRequestContextLength, (Integer)certificateRequestContextLength);
    }

    public ModifiableByteArray getCertificateRequestContext() {
        return this.certificateRequestContext;
    }

    public void setCertificateRequestContext(ModifiableByteArray certificateRequestContext) {
        this.certificateRequestContext = certificateRequestContext;
    }

    public void setCertificateRequestContext(byte[] certificateRequestContext) {
        this.certificateRequestContext = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.certificateRequestContext, (byte[])certificateRequestContext);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CertificateRequestMessage:");
        sb.append("\n  Certificate Types Count: ");
        if (this.clientCertificateTypesCount != null && this.clientCertificateTypesCount.getValue() != null) {
            sb.append(this.clientCertificateTypesCount.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  Certificate Types: ");
        if (this.clientCertificateTypes != null && this.clientCertificateTypes.getValue() != null) {
            for (int i = 0; i < ((byte[])this.clientCertificateTypes.getValue()).length; ++i) {
                sb.append((Object)ClientCertificateType.getClientCertificateType(((byte[])this.clientCertificateTypes.getValue())[i])).append(", ");
            }
        } else {
            sb.append("null");
        }
        sb.append("\n  Signature Hash Algorithms Length: ");
        if (this.signatureHashAlgorithmsLength != null && this.signatureHashAlgorithmsLength.getValue() != null) {
            sb.append(this.signatureHashAlgorithmsLength.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  Signature Hash Algorithms: ");
        if (this.signatureHashAlgorithms != null && this.signatureHashAlgorithms.getValue() != null) {
            try {
                List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms = SignatureAndHashAlgorithm.getSignatureAndHashAlgorithms((byte[])this.signatureHashAlgorithms.getValue());
                for (SignatureAndHashAlgorithm algo : signatureAndHashAlgorithms) {
                    sb.append(algo.name());
                }
            }
            catch (Exception E) {
                LOGGER.debug((Object)E);
                LOGGER.debug("Signature and HashAlgorithms contain unparseable Algorithms:" + ArrayConverter.bytesToHexString((ModifiableByteArray)this.signatureHashAlgorithms));
            }
        } else {
            sb.append("null");
        }
        sb.append("\n  Distinguished Names Length: ");
        if (this.distinguishedNamesLength != null && this.distinguishedNamesLength.getValue() != null) {
            sb.append(this.distinguishedNamesLength.getValue());
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public ProtocolMessageHandler getHandler(TlsContext context) {
        return new CertificateRequestHandler(context);
    }
}

