/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.LBSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.HttpShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.util.tracing.GlobalTracer;
import org.apache.solr.util.tracing.SolrRequestCarrier;
import org.slf4j.MDC;

class ShardRequestor
implements Callable<ShardResponse> {
    private final ShardRequest sreq;
    private final String shard;
    private final ModifiableSolrParams params;
    private final Tracer tracer;
    private final Span span;
    private final List<String> urls;
    private final HttpShardHandler httpShardHandler;
    private Map<String, List<String>> shardToURLs = new HashMap<String, List<String>>();

    public ShardRequestor(ShardRequest sreq, String shard, ModifiableSolrParams params, HttpShardHandler httpShardHandler) {
        this.sreq = sreq;
        this.shard = shard;
        this.params = params;
        this.httpShardHandler = httpShardHandler;
        this.urls = this.getURLs(shard);
        this.tracer = GlobalTracer.getTracer();
        this.span = this.tracer != null ? this.tracer.activeSpan() : null;
    }

    private List<String> getURLs(String shard) {
        List<String> urls = this.shardToURLs.get(shard);
        if (urls == null) {
            urls = this.httpShardHandler.httpShardHandlerFactory.buildURLList(shard);
            this.shardToURLs.put(shard, urls);
        }
        return urls;
    }

    void init() {
        if (this.shard != null) {
            MDC.put((String)"ShardRequest.shards", (String)this.shard);
        }
        if (this.urls != null && !this.urls.isEmpty()) {
            MDC.put((String)"ShardRequest.urlList", (String)this.urls.toString());
        }
    }

    void end() {
        MDC.remove((String)"ShardRequest.shards");
        MDC.remove((String)"ShardRequest.urlList");
    }

    @Override
    public ShardResponse call() throws Exception {
        ShardResponse srsp = new ShardResponse();
        if (this.sreq.nodeName != null) {
            srsp.setNodeName(this.sreq.nodeName);
        }
        srsp.setShardRequest(this.sreq);
        srsp.setShard(this.shard);
        SimpleSolrResponse ssr = new SimpleSolrResponse();
        srsp.setSolrResponse(ssr);
        long startTime = System.nanoTime();
        try {
            this.params.remove("wt");
            this.params.remove("version");
            QueryRequest req = this.httpShardHandler.makeQueryRequest(this.sreq, this.params, this.shard);
            if (this.tracer != null && this.span != null) {
                this.tracer.inject(this.span.context(), Format.Builtin.HTTP_HEADERS, (Object)new SolrRequestCarrier((SolrRequest)req));
            }
            req.setMethod(SolrRequest.METHOD.POST);
            SolrRequestInfo requestInfo = SolrRequestInfo.getRequestInfo();
            if (requestInfo != null) {
                req.setUserPrincipal(requestInfo.getReq().getUserPrincipal());
            }
            if (this.urls.size() == 0) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "no servers hosting shard: " + this.shard);
            }
            if (this.urls.size() <= 1) {
                String url = this.urls.get(0);
                srsp.setShardAddress(url);
                ssr.nl = this.httpShardHandler.request(url, (SolrRequest)req);
            } else {
                LBSolrClient.Rsp rsp = this.httpShardHandler.httpShardHandlerFactory.makeLoadBalancedRequest(req, this.urls);
                ssr.nl = rsp.getResponse();
                srsp.setShardAddress(rsp.getServer());
            }
        }
        catch (ConnectException cex) {
            srsp.setException(cex);
        }
        catch (Exception th) {
            srsp.setException(th);
            if (th instanceof SolrException) {
                srsp.setResponseCode(((SolrException)((Object)th)).code());
            }
            srsp.setResponseCode(-1);
        }
        ssr.elapsedTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        return this.httpShardHandler.transfomResponse(this.sreq, srsp, this.shard);
    }

    static class SimpleSolrResponse
    extends SolrResponse {
        long elapsedTime;
        NamedList<Object> nl;

        SimpleSolrResponse() {
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }

        public NamedList<Object> getResponse() {
            return this.nl;
        }

        public void setResponse(NamedList<Object> rsp) {
            this.nl = rsp;
        }

        public void setElapsedTime(long elapsedTime) {
            this.elapsedTime = elapsedTime;
        }
    }
}

