/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projectlibre1.dialog.AbstractDialog;
import com.projectlibre1.dialog.util.ComponentFactory;
import com.projectlibre1.dialog.util.ExtDateField;
import com.projectlibre1.options.CalendarOption;
import com.projectlibre1.strings.Messages;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public class UpdateProjectDialogBox
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private Form form;
    boolean hasTasksSelected;
    JRadioButton entireProject;
    JRadioButton selectedTask;
    ButtonGroup projectOrTask;
    JRadioButton update;
    JRadioButton reschedule;
    ButtonGroup updateOrReschedule;
    ExtDateField updateDateChooser;
    ExtDateField rescheduleDateChooser;
    JRadioButton progress;
    JRadioButton completeOrNotOnly;
    ButtonGroup progressCalculationType;

    public static UpdateProjectDialogBox getInstance(Frame frame, Form form, boolean bl) {
        return new UpdateProjectDialogBox(frame, form, bl);
    }

    private UpdateProjectDialogBox(Frame frame, Form form, boolean bl) {
        super(frame, Messages.getString("UpdateProjectDialogBox.UpdateProject"), true);
        this.addDocHelp("Update_Project");
        this.hasTasksSelected = bl;
        this.form = form != null ? form : new Form();
    }

    protected void initControls() {
        this.entireProject = new JRadioButton(Messages.getString("UpdateProjectDialogBox.EntireProject"));
        this.entireProject.setSelected(true);
        this.selectedTask = new JRadioButton(Messages.getString("UpdateProjectDialogBox.SelectedTasks"));
        if (!this.hasTasksSelected) {
            this.selectedTask.setEnabled(false);
        }
        this.projectOrTask = new ButtonGroup();
        this.projectOrTask.add(this.entireProject);
        this.projectOrTask.add(this.selectedTask);
        this.update = new JRadioButton();
        this.update.setSelected(true);
        this.reschedule = new JRadioButton();
        this.updateOrReschedule = new ButtonGroup();
        this.updateOrReschedule.add(this.update);
        this.updateOrReschedule.add(this.reschedule);
        this.updateDateChooser = ComponentFactory.createDateField();
        this.rescheduleDateChooser = ComponentFactory.createDateField();
        this.rescheduleDateChooser.setEnabled(false);
        this.progress = new JRadioButton(Messages.getString("UpdateProjectDialogBox.SetZeroHundred"));
        this.progress.setSelected(true);
        this.completeOrNotOnly = new JRadioButton(Messages.getString("UpdateProjectDialogBox.SetZeroOrHundredOnly"));
        this.progressCalculationType = new ButtonGroup();
        this.progressCalculationType.add(this.progress);
        this.progressCalculationType.add(this.completeOrNotOnly);
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateProjectDialogBox.this.progress.setEnabled(true);
                UpdateProjectDialogBox.this.completeOrNotOnly.setEnabled(true);
                UpdateProjectDialogBox.this.updateDateChooser.setEnabled(true);
                UpdateProjectDialogBox.this.rescheduleDateChooser.setEnabled(false);
            }
        });
        this.reschedule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateProjectDialogBox.this.progress.setEnabled(false);
                UpdateProjectDialogBox.this.completeOrNotOnly.setEnabled(false);
                UpdateProjectDialogBox.this.updateDateChooser.setEnabled(false);
                UpdateProjectDialogBox.this.rescheduleDateChooser.setEnabled(true);
            }
        });
    }

    @Override
    protected boolean bind(boolean bl) {
        if (this.form == null) {
            return false;
        }
        if (bl) {
            this.entireProject.setSelected(this.form.getEntireProject());
            this.update.setSelected(this.form.getUpdate());
            this.progress.setSelected(this.form.getProgress());
            this.updateDateChooser.setValue(this.form.getUpdateDate());
            this.rescheduleDateChooser.setValue(this.form.getRescheduleDate());
        } else {
            Boolean bl2 = new Boolean(this.entireProject.isSelected());
            this.form.setEntireProject(bl2);
            Boolean bl3 = new Boolean(this.update.isSelected());
            this.form.setUpdate(bl3);
            Boolean bl4 = new Boolean(this.progress.isSelected());
            this.form.setProgress(bl4);
            long l = this.updateDateChooser.getDateValue().getTime();
            l = CalendarOption.getInstance().makeValidStart(l, true);
            this.form.setUpdateDate(new Date(l));
            long l2 = this.rescheduleDateChooser.getDateValue().getTime();
            l2 = CalendarOption.getInstance().makeValidStart(l2, true);
            this.form.setRescheduleDate(new Date(l2));
        }
        return true;
    }

    @Override
    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("20dlu,3dlu,p, 3dlu,75dlu,3dlu,30dlu ", "p,1dlu,p,1dlu,p,10dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.append(this.update);
        defaultFormBuilder.append(Messages.getString("UpdateProjectDialogBox.UpdateWorkAsCompleteThrough"));
        defaultFormBuilder.append(this.updateDateChooser);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.nextColumn(2);
        defaultFormBuilder.add((Component)this.progress, cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 5));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.nextColumn(2);
        defaultFormBuilder.add((Component)this.completeOrNotOnly, cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 5));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.reschedule);
        defaultFormBuilder.append(Messages.getString("UpdateProjectDialogBox.RescheduleCompletedWorkToStartAfter"));
        defaultFormBuilder.append(this.rescheduleDateChooser);
        defaultFormBuilder.nextLine(8);
        defaultFormBuilder.addSeparator("");
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("UpdateProjectDialogBox.For"));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.nextColumn(2);
        defaultFormBuilder.append(this.entireProject);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.nextColumn(2);
        defaultFormBuilder.append(this.selectedTask);
        return defaultFormBuilder.getPanel();
    }

    public Form getForm() {
        return this.form;
    }

    @Override
    public Object getBean() {
        return this.form;
    }

    public static class Form {
        Boolean update;
        Boolean progress;
        Boolean entireProject;
        Date updateDate = new Date(CalendarOption.getInstance().makeValidStart(System.currentTimeMillis(), true));
        Date rescheduleDate = new Date(CalendarOption.getInstance().makeValidStart(System.currentTimeMillis(), true));

        public Date getActiveDate() {
            return this.update != false ? this.updateDate : this.rescheduleDate;
        }

        public Boolean getEntireProject() {
            return this.entireProject;
        }

        public void setEntireProject(Boolean bl) {
            this.entireProject = bl;
        }

        public Boolean getProgress() {
            return this.progress;
        }

        public void setProgress(Boolean bl) {
            this.progress = bl;
        }

        public Date getRescheduleDate() {
            return this.rescheduleDate;
        }

        public void setRescheduleDate(Date date) {
            this.rescheduleDate = date;
        }

        public Boolean getUpdate() {
            return this.update;
        }

        public void setUpdate(Boolean bl) {
            this.update = bl;
        }

        public Date getUpdateDate() {
            return this.updateDate;
        }

        public void setUpdateDate(Date date) {
            this.updateDate = date;
        }
    }
}

