/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.dialogs;

import de.escape.quincunx.dxf.TemporaryPainter;
import de.escape.quincunx.dxf.dialogs.PaperFormatPanel;
import de.escape.quincunx.dxf.dialogs.PostScriptOutputInfo;
import de.escape.quincunx.gimmicks.BasicPaperFormat;
import de.escape.quincunx.gimmicks.LowerArea;
import de.escape.quincunx.i18n.I18n;
import de.escape.quincunx.i18n.RButton;
import de.escape.quincunx.i18n.RCheckbox;
import de.escape.quincunx.i18n.RPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;

public class SavePostScriptDialog
extends Dialog {
    private static final Color INVALID_BACKGROUND;
    private TextField filenameField;
    private Button selectFileButton;
    private Checkbox saveToFile;
    private TextField commandField;
    private Button selectCommandButton;
    private Checkbox pipeToCommand;
    private PostScriptOutputInfo tmpInfo;
    private Color defaultBG;
    private PaperFormatPanel paperFormatPanel;

    public SavePostScriptDialog(Frame parent, PostScriptOutputInfo info) {
        super(parent, "Save as Postscript", true);
        RButton ok = new RButton("Ok");
        this.tmpInfo = new PostScriptOutputInfo(info);
        this.setLayout(new BorderLayout());
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        RPanel north = new RPanel(gbl);
        this.add("North", new LowerArea(north));
        CheckboxGroup grp = new CheckboxGroup();
        this.saveToFile = new RCheckbox("Save to file:", grp, !info.isRunningCommand());
        c.anchor = 17;
        c.weightx = 0.0;
        c.fill = 0;
        c.gridwidth = 1;
        gbl.setConstraints(this.saveToFile, c);
        north.add(this.saveToFile);
        this.saveToFile.addItemListener(new 1(ok, this));
        this.filenameField = new TextField(info.getOutputPath());
        this.defaultBG = ((Component)this.filenameField).getBackground();
        c.anchor = 10;
        c.weightx = 1.0;
        c.fill = 2;
        gbl.setConstraints(this.filenameField, c);
        north.add(this.filenameField);
        this.filenameField.setEnabled(!info.isRunningCommand());
        this.filenameField.addTextListener(new 2(ok, this));
        this.selectFileButton = new RButton("Select...");
        c.weightx = 0.0;
        c.fill = 0;
        c.gridwidth = 0;
        gbl.setConstraints(this.selectFileButton, c);
        north.add(this.selectFileButton);
        this.selectFileButton.setEnabled(!info.isRunningCommand());
        this.selectFileButton.addActionListener(new 3(parent, this));
        this.pipeToCommand = new RCheckbox("Pipe to command:", grp, info.isRunningCommand());
        c.anchor = 17;
        c.weightx = 0.0;
        c.fill = 0;
        c.gridwidth = 1;
        gbl.setConstraints(this.pipeToCommand, c);
        north.add(this.pipeToCommand);
        this.pipeToCommand.addItemListener(new 4(ok, this));
        this.commandField = new TextField(info.getCommandPath());
        c.anchor = 10;
        c.weightx = 1.0;
        c.fill = 2;
        gbl.setConstraints(this.commandField, c);
        north.add(this.commandField);
        this.commandField.setEnabled(info.isRunningCommand());
        this.commandField.addTextListener(new 5(ok, this));
        this.selectCommandButton = new RButton("Select...");
        c.weightx = 0.0;
        c.fill = 0;
        c.gridwidth = 0;
        gbl.setConstraints(this.selectCommandButton, c);
        north.add(this.selectCommandButton);
        this.selectCommandButton.setEnabled(info.isRunningCommand());
        this.selectCommandButton.addActionListener(new 6(parent, this));
        RPanel middle = new RPanel(new BorderLayout());
        this.add("Center", new LowerArea(middle));
        this.paperFormatPanel = new PaperFormatPanel(this.tmpInfo);
        this.paperFormatPanel.addValidityListener(new 7(ok, this));
        middle.add(new LowerArea(this.paperFormatPanel));
        RPanel south = new RPanel(new FlowLayout());
        RPanel buttons = new RPanel(new GridLayout(1, 0, 10, 10));
        ok.addActionListener(new 8());
        this.setOkState(ok);
        RButton cancel = new RButton("Cancel");
        cancel.addActionListener(new 9());
        this.add("South", south);
        south.add(buttons);
        buttons.add(ok);
        buttons.add(cancel);
        this.addWindowListener(new 10());
        this.pack();
    }

    private void setOkState(Button okButton) {
        boolean state;
        if (this.saveToFile.getState()) {
            state = !"".equals(this.filenameField.getText().trim());
            ((Component)this.filenameField).setBackground(state ? this.defaultBG : INVALID_BACKGROUND);
            ((Component)this.commandField).setBackground(this.defaultBG);
        } else {
            File cmd;
            String path = this.commandField.getText().trim();
            state = "".equals(path) ? false : (cmd = new File(path)).isFile() && cmd.canRead();
            ((Component)this.commandField).setBackground(state ? this.defaultBG : INVALID_BACKGROUND);
            ((Component)this.filenameField).setBackground(this.defaultBG);
        }
        if (state) {
            state = this.paperFormatPanel.isValid();
        }
        okButton.setEnabled(state);
    }

    public PostScriptOutputInfo getOutputInfo() {
        return this.tmpInfo;
    }

    public static void main(String[] args) {
        11 tp = new 11();
        PostScriptOutputInfo info = new PostScriptOutputInfo();
        info.setTemporaryPainter(tp);
        info.setPaperFormat(BasicPaperFormat.A4_PAPER_PORTRAIT);
        info.setAspectRatio(1.4);
        new SavePostScriptDialog(new Frame(), info).show();
        System.exit(0);
    }

    static {
        I18n.addAppResourceBase("de.escape.quincunx.dxf.dialogs.DialogsResourceBundle");
        INVALID_BACKGROUND = new Color(255, 128, 128);
    }

    private static final class 1
    implements ItemListener {
        private final /* synthetic */ Button val$ok;
        private final /* synthetic */ SavePostScriptDialog this$0;

        public void itemStateChanged(ItemEvent e) {
            if (this.this$0.saveToFile.getState()) {
                this.this$0.filenameField.setEnabled(true);
                this.this$0.selectFileButton.setEnabled(true);
                this.this$0.commandField.setEnabled(false);
                this.this$0.selectCommandButton.setEnabled(false);
                String path = this.this$0.filenameField.getText().trim();
                this.this$0.tmpInfo.setRunningCommand(false);
            } else {
                this.this$0.filenameField.setEnabled(false);
                this.this$0.selectFileButton.setEnabled(false);
                this.this$0.commandField.setEnabled(true);
                this.this$0.selectCommandButton.setEnabled(true);
                String path = this.this$0.commandField.getText().trim();
                this.this$0.tmpInfo.setRunningCommand(true);
            }
            this.this$0.setOkState(this.val$ok);
        }

        /* synthetic */ 1(Button val$ok, SavePostScriptDialog this$0) {
            this.val$ok = val$ok;
            this.this$0 = this$0;
        }
    }

    private static final class 2
    implements TextListener {
        private final /* synthetic */ Button val$ok;
        private final /* synthetic */ SavePostScriptDialog this$0;

        public void textValueChanged(TextEvent e) {
            String path = this.this$0.filenameField.getText().trim();
            if (!"".equals(path)) {
                this.this$0.tmpInfo.setOutputPath(path);
                ((Component)this.this$0.filenameField).setBackground(this.this$0.defaultBG);
            } else {
                ((Component)this.this$0.filenameField).setBackground(INVALID_BACKGROUND);
            }
            this.this$0.setOkState(this.val$ok);
        }

        /* synthetic */ 2(Button val$ok, SavePostScriptDialog this$0) {
            this.val$ok = val$ok;
            this.this$0 = this$0;
        }
    }

    private static final class 3
    implements ActionListener {
        private final /* synthetic */ SavePostScriptDialog this$0;
        private final /* synthetic */ Frame val$parent;

        public void actionPerformed(ActionEvent e) {
            FileDialog dialog = new FileDialog(this.val$parent, I18n.getString("Select output file"), 1);
            dialog.setFile(this.this$0.filenameField.getText());
            dialog.setModal(true);
            dialog.show();
            String file = dialog.getFile();
            if (file != null) {
                ((TextComponent)this.this$0.filenameField).setText(String.valueOf(dialog.getDirectory()) + file);
            }
        }

        /* synthetic */ 3(Frame val$parent, SavePostScriptDialog this$0) {
            this.val$parent = val$parent;
            this.this$0 = this$0;
        }
    }

    private static final class 4
    implements ItemListener {
        private final /* synthetic */ Button val$ok;
        private final /* synthetic */ SavePostScriptDialog this$0;

        public void itemStateChanged(ItemEvent e) {
            if (this.this$0.pipeToCommand.getState()) {
                this.this$0.filenameField.setEnabled(false);
                this.this$0.selectFileButton.setEnabled(false);
                this.this$0.commandField.setEnabled(true);
                this.this$0.selectCommandButton.setEnabled(true);
                String path = this.this$0.commandField.getText().trim();
                this.this$0.tmpInfo.setRunningCommand(true);
            } else {
                this.this$0.filenameField.setEnabled(true);
                this.this$0.selectFileButton.setEnabled(true);
                this.this$0.commandField.setEnabled(false);
                this.this$0.selectCommandButton.setEnabled(false);
                String path = this.this$0.filenameField.getText().trim();
                this.this$0.tmpInfo.setRunningCommand(false);
            }
            this.this$0.setOkState(this.val$ok);
        }

        /* synthetic */ 4(Button val$ok, SavePostScriptDialog this$0) {
            this.val$ok = val$ok;
            this.this$0 = this$0;
        }
    }

    private static final class 5
    implements TextListener {
        private final /* synthetic */ Button val$ok;
        private final /* synthetic */ SavePostScriptDialog this$0;

        public void textValueChanged(TextEvent e) {
            File cmd;
            String path = this.this$0.commandField.getText().trim();
            if (!"".equals(path) && (cmd = new File(path)).isFile() && cmd.canRead()) {
                this.this$0.tmpInfo.setCommandPath(path);
            }
            this.this$0.setOkState(this.val$ok);
        }

        /* synthetic */ 5(Button val$ok, SavePostScriptDialog this$0) {
            this.val$ok = val$ok;
            this.this$0 = this$0;
        }
    }

    private static final class 6
    implements ActionListener {
        private final /* synthetic */ SavePostScriptDialog this$0;
        private final /* synthetic */ Frame val$parent;

        public void actionPerformed(ActionEvent e) {
            FileDialog dialog = new FileDialog(this.val$parent, I18n.getString("Select command"), 0);
            dialog.setFile(this.this$0.commandField.getText());
            dialog.setModal(true);
            dialog.show();
            String file = dialog.getFile();
            if (file != null) {
                ((TextComponent)this.this$0.commandField).setText(String.valueOf(dialog.getDirectory()) + file);
            }
        }

        /* synthetic */ 6(Frame val$parent, SavePostScriptDialog this$0) {
            this.val$parent = val$parent;
            this.this$0 = this$0;
        }
    }

    private static final class 7
    implements PropertyChangeListener {
        private final /* synthetic */ SavePostScriptDialog this$0;
        private final /* synthetic */ Button val$ok;

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("VALIDITY")) {
                this.this$0.setOkState(this.val$ok);
            }
        }

        /* synthetic */ 7(Button val$ok, SavePostScriptDialog this$0) {
            this.val$ok = val$ok;
            this.this$0 = this$0;
        }
    }

    private final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            SavePostScriptDialog.this.dispose();
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            SavePostScriptDialog.this.tmpInfo = null;
            SavePostScriptDialog.this.dispose();
        }

        /* synthetic */ 9() {
        }
    }

    private final class 10
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            SavePostScriptDialog.this.tmpInfo = null;
            SavePostScriptDialog.this.dispose();
        }

        /* synthetic */ 10() {
        }
    }

    private final class 11
    implements TemporaryPainter {
        public boolean paintTemporary(Graphics g, Dimension size, boolean rotate, boolean exchangeBW, boolean monochrome, int numberLines) {
            g.setColor(Color.black);
            g.drawOval(0, 0, size.width - 1, size.height - 1);
            return true;
        }

        /* synthetic */ 11() {
        }
    }
}

