/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import org.gradle.internal.file.FileType;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.watch.registry.impl.WatchableHierarchies;

public class CheckIfNonEmptySnapshotVisitor
implements SnapshotHierarchy.SnapshotVisitor {
    private final WatchableHierarchies watchableHierarchies;
    private boolean empty = true;
    private boolean onlyMissing = true;

    public CheckIfNonEmptySnapshotVisitor(WatchableHierarchies watchableHierarchies) {
        this.watchableHierarchies = watchableHierarchies;
    }

    public void visitSnapshotRoot(CompleteFileSystemLocationSnapshot rootSnapshot) {
        if (!this.watchableHierarchies.ignoredForWatching(rootSnapshot)) {
            this.empty = false;
            if (rootSnapshot.getType() != FileType.Missing) {
                this.onlyMissing = false;
            }
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean containsOnlyMissingFiles() {
        return this.onlyMissing;
    }
}

