/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.bin;

import java.io.IOException;
import java.math.BigInteger;
import software.amazon.ion.Decimal;
import software.amazon.ion.IonDatagram;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonType;
import software.amazon.ion.IonValue;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.Timestamp;
import software.amazon.ion.impl.PrivateByteTransferReader;
import software.amazon.ion.impl.PrivateByteTransferSink;
import software.amazon.ion.impl.PrivateIonWriter;
import software.amazon.ion.impl.PrivateSymtabExtendsCache;
import software.amazon.ion.impl.PrivateUtils;

abstract class AbstractIonWriter
implements PrivateIonWriter,
PrivateByteTransferSink {
    private final PrivateSymtabExtendsCache symtabExtendsCache;

    AbstractIonWriter(WriteValueOptimization optimization) {
        this.symtabExtendsCache = optimization == WriteValueOptimization.COPY_OPTIMIZED ? new PrivateSymtabExtendsCache() : null;
    }

    public final void writeValue(IonValue value) throws IOException {
        if (value != null) {
            if (value instanceof IonDatagram) {
                this.finish();
            }
            value.writeTo(this);
        }
    }

    public final void writeValue(IonReader reader2) throws IOException {
        PrivateByteTransferReader transferReader;
        IonType type2 = reader2.getType();
        if (this.isStreamCopyOptimized() && (transferReader = reader2.asFacet(PrivateByteTransferReader.class)) != null && (PrivateUtils.isNonSymbolScalar(type2) || this.symtabExtendsCache.symtabsCompat(this.getSymbolTable(), reader2.getSymbolTable()))) {
            transferReader.transferCurrentValue(this);
            return;
        }
        this.writeValueRecursive(reader2);
    }

    public final void writeValueRecursive(IonReader reader2) throws IOException {
        SymbolToken[] annotations;
        IonType type2 = reader2.getType();
        SymbolToken fieldName = reader2.getFieldNameSymbol();
        if (fieldName != null && !this.isFieldNameSet() && this.isInStruct()) {
            this.setFieldNameSymbol(fieldName);
        }
        if ((annotations = reader2.getTypeAnnotationSymbols()).length > 0) {
            this.setTypeAnnotationSymbols(annotations);
        }
        if (reader2.isNullValue()) {
            this.writeNull(type2);
            return;
        }
        block0 : switch (type2) {
            case BOOL: {
                boolean booleanValue = reader2.booleanValue();
                this.writeBool(booleanValue);
                break;
            }
            case INT: {
                switch (reader2.getIntegerSize()) {
                    case INT: {
                        int intValue = reader2.intValue();
                        this.writeInt(intValue);
                        break block0;
                    }
                    case LONG: {
                        long longValue = reader2.longValue();
                        this.writeInt(longValue);
                        break block0;
                    }
                    case BIG_INTEGER: {
                        BigInteger bigIntegerValue = reader2.bigIntegerValue();
                        this.writeInt(bigIntegerValue);
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case FLOAT: {
                double doubleValue = reader2.doubleValue();
                this.writeFloat(doubleValue);
                break;
            }
            case DECIMAL: {
                Decimal decimalValue = reader2.decimalValue();
                this.writeDecimal(decimalValue);
                break;
            }
            case TIMESTAMP: {
                Timestamp timestampValue = reader2.timestampValue();
                this.writeTimestamp(timestampValue);
                break;
            }
            case SYMBOL: {
                SymbolToken symbolValue = reader2.symbolValue();
                this.writeSymbolToken(symbolValue);
                break;
            }
            case STRING: {
                String stringValue = reader2.stringValue();
                this.writeString(stringValue);
                break;
            }
            case CLOB: {
                byte[] clobValue = reader2.newBytes();
                this.writeClob(clobValue);
                break;
            }
            case BLOB: {
                byte[] blobValue = reader2.newBytes();
                this.writeBlob(blobValue);
                break;
            }
            case LIST: 
            case SEXP: 
            case STRUCT: {
                reader2.stepIn();
                this.stepIn(type2);
                while (reader2.next() != null) {
                    this.writeValue(reader2);
                }
                this.stepOut();
                reader2.stepOut();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type: " + (Object)((Object)type2));
            }
        }
    }

    public final void writeValues(IonReader reader2) throws IOException {
        if (reader2.getType() != null) {
            this.writeValue(reader2);
        }
        while (reader2.next() != null) {
            this.writeValue(reader2);
        }
    }

    public final boolean isStreamCopyOptimized() {
        return this.symtabExtendsCache != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum WriteValueOptimization {
        NONE,
        COPY_OPTIMIZED;

    }
}

