/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.svg;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css3.CssColor;
import org.w3c.css.properties.svg.CssFill;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssStopColor
extends org.w3c.css.properties.css.CssStopColor {
    public static final CssIdent currentColor = CssIdent.getIdent("currentColor");

    public CssStopColor() {
        this.value = initial;
    }

    public CssStopColor(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.value = CssStopColor.parseColor(ac, expression, check, this);
    }

    public CssStopColor(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static CssValue parseColor(ApplContext ac, CssExpression expression, boolean check, CssProperty property) throws InvalidParamException {
        property.setByUser();
        if (check && expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue value = null;
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        boolean gotColor = false;
        boolean gotIccColor = false;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 0: {
                    if (inherit.equals(val)) {
                        value = inherit;
                        if (expression.getCount() > 1) {
                            throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                        }
                    }
                    if (currentColor.equals(val)) {
                        if (expression.getCount() > 1) {
                            throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                        }
                        values.add(currentColor);
                    }
                    if (expression.getCount() > 1) {
                        throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                    }
                    if (gotColor) {
                        throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                    }
                    CssExpression nex = new CssExpression();
                    nex.addValue(val);
                    switch (ac.getCssVersion()) {
                        case CSS1: {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        case CSS2: 
                        case CSS21: {
                            values.add(new org.w3c.css.properties.css21.CssColor(ac, nex, check).getColor());
                            break;
                        }
                        default: {
                            values.add(new CssColor(ac, nex, check).getColor());
                        }
                    }
                    gotColor = true;
                    break;
                }
                case 15: {
                    if (gotColor) {
                        throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                    }
                    org.w3c.css.values.CssColor c = new org.w3c.css.values.CssColor();
                    c.setShortRGBColor(ac, val.toString());
                    gotColor = true;
                    values.add(c);
                    break;
                }
                case 3: {
                    if (gotColor) {
                        throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                    }
                    gotColor = true;
                    values.add(val);
                    break;
                }
                case 11: {
                    CssFunction f = (CssFunction)val;
                    if (gotColor || gotIccColor) {
                        throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                    }
                    if ("icc-color".equals(f.getName())) {
                        values.add(CssFill.parseIccColor(ac, f, check));
                        gotIccColor = true;
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", new Character(op).toString(), ac);
            }
            expression.next();
        }
        if (!values.isEmpty()) {
            value = values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
        }
        return value;
    }
}

