/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class TeltonikaProtocolDecoder
extends BaseProtocolDecoder {
    private static final int IMAGE_PACKET_MAX = 2048;
    private final boolean connectionless;
    private boolean extended;
    private final Map<Long, ByteBuf> photos = new HashMap<Long, ByteBuf>();
    public static final int CODEC_GH3000 = 7;
    public static final int CODEC_8 = 8;
    public static final int CODEC_8_EXT = 142;
    public static final int CODEC_12 = 12;
    public static final int CODEC_13 = 13;
    public static final int CODEC_16 = 16;

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public TeltonikaProtocolDecoder(Protocol protocol, boolean connectionless) {
        super(protocol);
        this.connectionless = connectionless;
        this.extended = Context.getConfig().getBoolean(Keys.PROTOCOL_EXTENDED.withPrefix(this.getProtocolName()));
    }

    private void parseIdentification(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        int length = buf.readUnsignedShort();
        String imei = buf.toString(buf.readerIndex(), length, StandardCharsets.US_ASCII);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (channel != null) {
            ByteBuf response = Unpooled.buffer((int)1);
            if (deviceSession != null) {
                response.writeByte(1);
            } else {
                response.writeByte(0);
            }
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private void sendImageRequest(Channel channel, SocketAddress remoteAddress, long id, int offset, int size) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeInt(0);
            response.writeShort(0);
            response.writeShort(19);
            response.writeByte(12);
            response.writeByte(1);
            response.writeByte(13);
            response.writeInt(11);
            response.writeByte(2);
            response.writeInt((int)id);
            response.writeInt(offset);
            response.writeShort(size);
            response.writeByte(1);
            response.writeShort(0);
            response.writeShort(Checksum.crc16(Checksum.CRC16_IBM, response.nioBuffer(8, response.readableBytes() - 10)));
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private boolean isPrintable(ByteBuf buf, int length) {
        boolean printable = true;
        for (int i = 0; i < length; ++i) {
            byte b = buf.getByte(buf.readerIndex() + i);
            if (b >= 32 || b == 13 || b == 10) continue;
            printable = false;
            break;
        }
        return printable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeSerial(Channel channel, SocketAddress remoteAddress, Position position, ByteBuf buf) {
        this.getLastLocation(position, null);
        short type = buf.readUnsignedByte();
        if (type == 13) {
            buf.readInt();
            short subtype = buf.readUnsignedByte();
            if (subtype == 1) {
                long photoId = buf.readUnsignedInt();
                ByteBuf photo = Unpooled.buffer((int)buf.readInt());
                this.photos.put(photoId, photo);
                this.sendImageRequest(channel, remoteAddress, photoId, 0, Math.min(2048, photo.capacity()));
            } else if (subtype == 2) {
                long photoId = buf.readUnsignedInt();
                buf.readInt();
                ByteBuf photo = this.photos.get(photoId);
                photo.writeBytes(buf, buf.readUnsignedShort());
                if (photo.writableBytes() > 0) {
                    this.sendImageRequest(channel, remoteAddress, photoId, photo.writerIndex(), Math.min(2048, photo.writableBytes()));
                } else {
                    String uniqueId = Context.getIdentityManager().getById(position.getDeviceId()).getUniqueId();
                    this.photos.remove(photoId);
                    try {
                        position.set("image", Context.getMediaManager().writeFile(uniqueId, photo, "jpg"));
                    }
                    finally {
                        photo.release();
                    }
                }
            }
        } else {
            position.set("type", Integer.valueOf(type));
            int length = buf.readInt();
            if (this.isPrintable(buf, length)) {
                String data = buf.readSlice(length).toString(StandardCharsets.US_ASCII).trim();
                if (data.startsWith("UUUUww") && data.endsWith("SSS")) {
                    String[] values = data.substring(6, data.length() - 4).split(";");
                    for (int i = 0; i < 8; ++i) {
                        position.set("axle" + (i + 1), Double.parseDouble(values[i]));
                    }
                    position.set("loadTruck", Double.parseDouble(values[8]));
                    position.set("loadTrailer", Double.parseDouble(values[9]));
                    position.set("totalTruck", Double.parseDouble(values[10]));
                    position.set("totalTrailer", Double.parseDouble(values[11]));
                } else {
                    position.set("result", data);
                }
            } else {
                position.set("result", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(length)));
            }
        }
    }

    private long readValue(ByteBuf buf, int length, boolean signed) {
        switch (length) {
            case 1: {
                return signed ? (long)buf.readByte() : (long)buf.readUnsignedByte();
            }
            case 2: {
                return signed ? (long)buf.readShort() : (long)buf.readUnsignedShort();
            }
            case 4: {
                return signed ? (long)buf.readInt() : buf.readUnsignedInt();
            }
        }
        return buf.readLong();
    }

    private void decodeOtherParameter(Position position, int id, ByteBuf buf, int length) {
        block0 : switch (id) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                position.set("di" + id, this.readValue(buf, length, false));
                break;
            }
            case 9: {
                position.set("adc1", this.readValue(buf, length, false));
                break;
            }
            case 10: {
                position.set("adc2", this.readValue(buf, length, false));
                break;
            }
            case 16: {
                position.set("odometer", this.readValue(buf, length, false));
                break;
            }
            case 17: {
                position.set("axisX", this.readValue(buf, length, true));
                break;
            }
            case 18: {
                position.set("axisY", this.readValue(buf, length, true));
                break;
            }
            case 19: {
                position.set("axisZ", this.readValue(buf, length, true));
                break;
            }
            case 21: {
                position.set("rssi", this.readValue(buf, length, false));
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                position.set("temp" + (id - 24 + 4), (double)this.readValue(buf, length, true) * 0.1);
                break;
            }
            case 66: {
                position.set("power", (double)this.readValue(buf, length, false) * 0.001);
                break;
            }
            case 67: {
                position.set("battery", (double)this.readValue(buf, length, false) * 0.001);
                break;
            }
            case 69: {
                position.set("gpsStatus", this.readValue(buf, length, false));
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                position.set("temp" + (id - 71), (double)this.readValue(buf, length, true) * 0.1);
                break;
            }
            case 78: {
                long driverUniqueId = this.readValue(buf, length, false);
                if (driverUniqueId == 0L) break;
                position.set("driverUniqueId", String.format("%016X", driverUniqueId));
                break;
            }
            case 80: {
                position.set("workMode", this.readValue(buf, length, false));
                break;
            }
            case 90: {
                position.set("door", this.readValue(buf, length, false));
                break;
            }
            case 115: {
                position.set("coolantTemp", (double)this.readValue(buf, length, true) * 0.1);
                break;
            }
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: {
                String driver = id == 129 || id == 132 ? "" : position.getString("driver1");
                position.set("driver" + (id >= 132 ? 2 : 1), driver + buf.readSlice(length).toString(StandardCharsets.US_ASCII).trim());
                break;
            }
            case 179: {
                position.set("out1", this.readValue(buf, length, false) == 1L);
                break;
            }
            case 180: {
                position.set("out2", this.readValue(buf, length, false) == 1L);
                break;
            }
            case 181: {
                position.set("pdop", (double)this.readValue(buf, length, false) * 0.1);
                break;
            }
            case 182: {
                position.set("hdop", (double)this.readValue(buf, length, false) * 0.1);
                break;
            }
            case 199: {
                position.set("tripOdometer", this.readValue(buf, length, false));
                break;
            }
            case 236: {
                if (this.readValue(buf, length, false) != 1L) break;
                position.set("alarm", "general");
                break;
            }
            case 239: {
                position.set("ignition", this.readValue(buf, length, false) == 1L);
                break;
            }
            case 240: {
                position.set("motion", this.readValue(buf, length, false) == 1L);
                break;
            }
            case 241: {
                position.set("operator", this.readValue(buf, length, false));
                break;
            }
            case 253: {
                switch ((int)this.readValue(buf, length, false)) {
                    case 1: {
                        position.set("alarm", "hardAcceleration");
                        break block0;
                    }
                    case 2: {
                        position.set("alarm", "hardBraking");
                        break block0;
                    }
                    case 3: {
                        position.set("alarm", "hardCornering");
                        break block0;
                    }
                }
                break;
            }
            case 389: {
                if (BitUtil.between(this.readValue(buf, length, false), 4, 8) != 1L) break;
                position.set("alarm", "sos");
                break;
            }
            default: {
                position.set("io" + id, this.readValue(buf, length, false));
            }
        }
    }

    private void decodeGh3000Parameter(Position position, int id, ByteBuf buf, int length) {
        switch (id) {
            case 1: {
                position.set("batteryLevel", this.readValue(buf, length, false));
                break;
            }
            case 2: {
                position.set("usbConnected", this.readValue(buf, length, false) == 1L);
                break;
            }
            case 5: {
                position.set("uptime", this.readValue(buf, length, false));
                break;
            }
            case 20: {
                position.set("hdop", (double)this.readValue(buf, length, false) * 0.1);
                break;
            }
            case 21: {
                position.set("vdop", (double)this.readValue(buf, length, false) * 0.1);
                break;
            }
            case 22: {
                position.set("pdop", (double)this.readValue(buf, length, false) * 0.1);
                break;
            }
            case 67: {
                position.set("battery", (double)this.readValue(buf, length, false) * 0.001);
                break;
            }
            case 221: {
                position.set("button", this.readValue(buf, length, false));
                break;
            }
            case 222: {
                if (this.readValue(buf, length, false) != 1L) break;
                position.set("alarm", "sos");
                break;
            }
            case 240: {
                position.set("motion", this.readValue(buf, length, false) == 1L);
                break;
            }
            case 244: {
                position.set("roaming", this.readValue(buf, length, false) == 1L);
                break;
            }
            default: {
                position.set("io" + id, this.readValue(buf, length, false));
            }
        }
    }

    private void decodeParameter(Position position, int id, ByteBuf buf, int length, int codec) {
        if (codec == 7) {
            this.decodeGh3000Parameter(position, id, buf, length);
        } else {
            this.decodeOtherParameter(position, id, buf, length);
        }
    }

    private void decodeNetwork(Position position) {
        long cid = position.getLong("io205");
        int lac = position.getInteger("io206");
        if (cid != 0L && lac != 0) {
            CellTower cellTower = CellTower.fromLacCid(lac, cid);
            long operator = position.getInteger("operator");
            if (operator != 0L) {
                cellTower.setOperator(operator);
            }
            position.setNetwork(new Network(cellTower));
        }
    }

    private int readExtByte(ByteBuf buf, int codec, int ... codecs) {
        boolean ext = false;
        for (int c : codecs) {
            if (codec != c) continue;
            ext = true;
            break;
        }
        if (ext) {
            return buf.readUnsignedShort();
        }
        return buf.readUnsignedByte();
    }

    private void decodeLocation(Position position, ByteBuf buf, int codec) {
        int id;
        int j;
        int globalMask = 15;
        if (codec == 7) {
            long time = buf.readUnsignedInt() & 0x3FFFFFFFL;
            time += 1167609600L;
            globalMask = buf.readUnsignedByte();
            if (BitUtil.check(globalMask, 0)) {
                position.setTime(new Date(time * 1000L));
                short locationMask = buf.readUnsignedByte();
                if (BitUtil.check(locationMask, 0)) {
                    position.setLatitude(buf.readFloat());
                    position.setLongitude(buf.readFloat());
                }
                if (BitUtil.check(locationMask, 1)) {
                    position.setAltitude(buf.readUnsignedShort());
                }
                if (BitUtil.check(locationMask, 2)) {
                    position.setCourse((double)buf.readUnsignedByte() * 360.0 / 256.0);
                }
                if (BitUtil.check(locationMask, 3)) {
                    position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
                }
                if (BitUtil.check(locationMask, 4)) {
                    position.set("sat", buf.readUnsignedByte());
                }
                if (BitUtil.check(locationMask, 5)) {
                    CellTower cellTower = CellTower.fromLacCid(buf.readUnsignedShort(), buf.readUnsignedShort());
                    if (BitUtil.check(locationMask, 6)) {
                        cellTower.setSignalStrength(Integer.valueOf(buf.readUnsignedByte()));
                    }
                    if (BitUtil.check(locationMask, 7)) {
                        cellTower.setOperator(buf.readUnsignedInt());
                    }
                    position.setNetwork(new Network(cellTower));
                } else {
                    if (BitUtil.check(locationMask, 6)) {
                        position.set("rssi", buf.readUnsignedByte());
                    }
                    if (BitUtil.check(locationMask, 7)) {
                        position.set("operator", buf.readUnsignedInt());
                    }
                }
            } else {
                this.getLastLocation(position, new Date(time * 1000L));
            }
        } else {
            position.setTime(new Date(buf.readLong()));
            position.set("priority", buf.readUnsignedByte());
            position.setLongitude((double)buf.readInt() / 1.0E7);
            position.setLatitude((double)buf.readInt() / 1.0E7);
            position.setAltitude(buf.readShort());
            position.setCourse(buf.readUnsignedShort());
            short satellites = buf.readUnsignedByte();
            position.set("sat", Integer.valueOf(satellites));
            position.setValid(satellites != 0);
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShort()));
            position.set("event", this.readExtByte(buf, codec, 142, 16));
            if (codec == 16) {
                buf.readUnsignedByte();
            }
            this.readExtByte(buf, codec, 142);
        }
        if (BitUtil.check(globalMask, 1)) {
            int cnt = this.readExtByte(buf, codec, 142);
            for (j = 0; j < cnt; ++j) {
                this.decodeParameter(position, this.readExtByte(buf, codec, 142, 16), buf, 1, codec);
            }
        }
        if (BitUtil.check(globalMask, 2)) {
            int cnt = this.readExtByte(buf, codec, 142);
            for (j = 0; j < cnt; ++j) {
                this.decodeParameter(position, this.readExtByte(buf, codec, 142, 16), buf, 2, codec);
            }
        }
        if (BitUtil.check(globalMask, 3)) {
            int cnt = this.readExtByte(buf, codec, 142);
            for (j = 0; j < cnt; ++j) {
                this.decodeParameter(position, this.readExtByte(buf, codec, 142, 16), buf, 4, codec);
            }
        }
        if (codec == 8 || codec == 142 || codec == 16) {
            int cnt = this.readExtByte(buf, codec, 142);
            for (j = 0; j < cnt; ++j) {
                this.decodeOtherParameter(position, this.readExtByte(buf, codec, 142, 16), buf, 8);
            }
        }
        if (this.extended) {
            int cnt = this.readExtByte(buf, codec, 142);
            for (j = 0; j < cnt; ++j) {
                id = this.readExtByte(buf, codec, 142, 16);
                position.set("io" + id, ByteBufUtil.hexDump((ByteBuf)buf.readSlice(16)));
            }
        }
        if (codec == 142) {
            int cnt = buf.readUnsignedShort();
            for (j = 0; j < cnt; ++j) {
                id = buf.readUnsignedShort();
                int length = buf.readUnsignedShort();
                if (id == 256) {
                    position.set("vin", buf.readSlice(length).toString(StandardCharsets.US_ASCII));
                    continue;
                }
                if (id == 281) {
                    position.set("dtcs", buf.readSlice(length).toString(StandardCharsets.US_ASCII).replace(',', ' '));
                    continue;
                }
                if (id == 385) {
                    ByteBuf data = buf.readSlice(length);
                    data.readUnsignedByte();
                    int index = 1;
                    while (data.isReadable()) {
                        short flags = data.readUnsignedByte();
                        if (BitUtil.from(flags, 4) > 0) {
                            position.set("beacon" + index + "Uuid", ByteBufUtil.hexDump((ByteBuf)data.readSlice(16)));
                            position.set("beacon" + index + "Major", data.readUnsignedShort());
                            position.set("beacon" + index + "Minor", data.readUnsignedShort());
                        } else {
                            position.set("beacon" + index + "Namespace", ByteBufUtil.hexDump((ByteBuf)data.readSlice(10)));
                            position.set("beacon" + index + "Instance", ByteBufUtil.hexDump((ByteBuf)data.readSlice(6)));
                        }
                        position.set("beacon" + index + "Rssi", Integer.valueOf(data.readByte()));
                        if (BitUtil.check(flags, 1)) {
                            position.set("beacon" + index + "Battery", (double)data.readUnsignedShort() * 0.01);
                        }
                        if (BitUtil.check(flags, 2)) {
                            position.set("beacon" + index + "Temp", data.readUnsignedShort());
                        }
                        ++index;
                    }
                    continue;
                }
                position.set("io" + id, ByteBufUtil.hexDump((ByteBuf)buf.readSlice(length)));
            }
        }
        this.decodeNetwork(position);
    }

    private List<Position> parseData(Channel channel, SocketAddress remoteAddress, ByteBuf buf, int locationPacketId, String ... imei) {
        LinkedList<Position> positions = new LinkedList<Position>();
        if (!this.connectionless) {
            buf.readUnsignedInt();
        }
        short codec = buf.readUnsignedByte();
        int count = buf.readUnsignedByte();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        for (int i = 0; i < count; ++i) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setValid(true);
            if (codec == 13) {
                buf.readUnsignedByte();
                int length = buf.readInt() - 4;
                this.getLastLocation(position, new Date(buf.readUnsignedInt() * 1000L));
                if (this.isPrintable(buf, length)) {
                    position.set("result", buf.readCharSequence(length, StandardCharsets.US_ASCII).toString().trim());
                } else {
                    position.set("result", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(length)));
                }
            } else if (codec == 12) {
                this.decodeSerial(channel, remoteAddress, position, buf);
            } else {
                this.decodeLocation(position, buf, codec);
            }
            if (position.getOutdated() && position.getAttributes().isEmpty()) continue;
            positions.add(position);
        }
        if (channel != null && codec != 12 && codec != 13) {
            ByteBuf response = Unpooled.buffer();
            if (this.connectionless) {
                response.writeShort(5);
                response.writeShort(0);
                response.writeByte(1);
                response.writeByte(locationPacketId);
                response.writeByte(count);
            } else {
                response.writeInt(count);
            }
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
        return positions.isEmpty() ? null : positions;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (this.connectionless) {
            return this.decodeUdp(channel, remoteAddress, buf);
        }
        return this.decodeTcp(channel, remoteAddress, buf);
    }

    private Object decodeTcp(Channel channel, SocketAddress remoteAddress, ByteBuf buf) throws Exception {
        if (buf.getUnsignedShort(0) <= 0) {
            buf.skipBytes(4);
            return this.parseData(channel, remoteAddress, buf, 0, new String[0]);
        }
        this.parseIdentification(channel, remoteAddress, buf);
        return null;
    }

    private Object decodeUdp(Channel channel, SocketAddress remoteAddress, ByteBuf buf) throws Exception {
        buf.readUnsignedShort();
        buf.readUnsignedShort();
        buf.readUnsignedByte();
        short locationPacketId = buf.readUnsignedByte();
        String imei = buf.readSlice(buf.readUnsignedShort()).toString(StandardCharsets.US_ASCII);
        return this.parseData(channel, remoteAddress, buf, locationPacketId, imei);
    }
}

