/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;

public class Stl060ProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().any().text("$1,").number("(d+),").text("D001,").expression("[^,]*,").number("(dd)/(dd)/(dd),").number("(dd):(dd):(dd),").number("(dd)(dd).?(d+)([NS]),").number("(ddd)(dd).?(d+)([EW]),").number("(d+.?d*),").number("(d+.?d*),").groupBegin().number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").or().expression("([01]),").expression("([01]),").expression("0,0,").number("(d+),").expression("([^,]+),").number("(d+),").number("(d+),").number("(d+),").expression("([01]),").expression("([01]),").expression("([01]),").groupEnd().expression("([AV])").any().compile();

    public Stl060ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN_HEM));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN_HEM));
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        if (parser.hasNext(5)) {
            position.set("odometer", parser.nextInt(0));
            position.set("ignition", parser.nextInt(0) == 1);
            position.set("input", parser.nextInt(0) + parser.nextInt(0) << 1);
            position.set("fuel", parser.nextInt(0));
        }
        if (parser.hasNext(10)) {
            position.set("charge", parser.nextInt(0) == 1);
            position.set("ignition", parser.nextInt(0) == 1);
            position.set("input", parser.nextInt(0));
            position.set("driverUniqueId", parser.next());
            position.set("odometer", parser.nextInt(0));
            position.set("temp1", parser.nextInt(0));
            position.set("fuel", parser.nextInt(0));
            position.set("acceleration", parser.nextInt(0) == 1);
            position.set("output", parser.nextInt(0) + parser.nextInt(0) << 1);
        }
        position.setValid(parser.next().equals("A"));
        return position;
    }
}

