/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystem;
import com.google.cloud.storage.contrib.nio.CloudStorageUtil;
import com.google.cloud.storage.contrib.nio.UnixPath;
import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CloudStoragePath
implements Path {
    private static final Pattern EXTRA_SLASHES_OR_DOT_DIRS_PATTERN = Pattern.compile("^\\.\\.?/|//|/\\.\\.?/|/\\.\\.?$");
    private final CloudStorageFileSystem fileSystem;
    private final UnixPath path;

    private CloudStoragePath(CloudStorageFileSystem fileSystem, UnixPath path) {
        this.fileSystem = fileSystem;
        this.path = path;
    }

    static CloudStoragePath getPath(CloudStorageFileSystem fileSystem, String path, String ... more) {
        return new CloudStoragePath(fileSystem, UnixPath.getPath(fileSystem.config().permitEmptyPathComponents(), path, more));
    }

    public String bucket() {
        return this.fileSystem.bucket();
    }

    BlobId getBlobId() {
        Preconditions.checkArgument((!this.path.toString().isEmpty() ? 1 : 0) != 0, (Object)"Object names cannot be empty.");
        return BlobId.of((String)this.bucket(), (String)this.toRealPath((LinkOption[])new LinkOption[0]).path.toString());
    }

    boolean seemsLikeADirectory() {
        return this.path.seemsLikeADirectory();
    }

    boolean seemsLikeADirectoryAndUsePseudoDirectories(Storage storage) {
        if (!this.fileSystem.config().usePseudoDirectories()) {
            return false;
        }
        if (this.path.seemsLikeADirectory()) {
            return true;
        }
        if (storage == null) {
            return false;
        }
        String prefix = this.path.removeBeginningSeparator().toString();
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        String userProject = this.fileSystem.config().userProject();
        Page list = null;
        list = userProject != null ? storage.list(this.bucket(), new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)prefix), Storage.BlobListOption.pageSize((long)1L), Storage.BlobListOption.userProject((String)userProject)}) : storage.list(this.bucket(), new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)prefix), Storage.BlobListOption.pageSize((long)1L)});
        for (Blob b : list.getValues()) {
            String name;
            if (b.getBlobId() == null || (name = b.getBlobId().getName()) == null || !("/" + name).startsWith(this.path.toAbsolutePath() + "/")) continue;
            return true;
        }
        return false;
    }

    @Override
    public CloudStorageFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    @Nullable
    public CloudStoragePath getRoot() {
        return this.newPath(this.path.getRoot());
    }

    @Override
    public boolean isAbsolute() {
        return this.path.isAbsolute();
    }

    @Override
    public CloudStoragePath toAbsolutePath() {
        return this.newPath(this.path.toAbsolutePath(this.getWorkingDirectory()));
    }

    @Override
    public CloudStoragePath toRealPath(LinkOption ... options) {
        CloudStorageUtil.checkNotNullArray(options);
        return this.newPath(this.toRealPathInternal(true));
    }

    private UnixPath toRealPathInternal(boolean errorCheck) {
        UnixPath objectName = this.path.toAbsolutePath(this.getWorkingDirectory());
        if (errorCheck && !this.fileSystem.config().permitEmptyPathComponents()) {
            Preconditions.checkArgument((!EXTRA_SLASHES_OR_DOT_DIRS_PATTERN.matcher(objectName).find() ? 1 : 0) != 0, (String)"I/O not allowed on dot-dirs or extra slashes when !permitEmptyPathComponents: %s", (Object)objectName);
        }
        if (this.fileSystem.config().stripPrefixSlash()) {
            objectName = objectName.removeBeginningSeparator();
        }
        return objectName;
    }

    @Override
    public CloudStoragePath normalize() {
        return this.newPath(this.path.normalize());
    }

    @Override
    public CloudStoragePath resolve(Path object) {
        return this.newPath(this.path.resolve(CloudStorageUtil.checkPath((Path)object).path));
    }

    @Override
    public CloudStoragePath resolve(String other) {
        return this.newPath(this.path.resolve(this.getUnixPath(other)));
    }

    @Override
    public CloudStoragePath resolveSibling(Path other) {
        return this.newPath(this.path.resolveSibling(CloudStorageUtil.checkPath((Path)other).path));
    }

    @Override
    public CloudStoragePath resolveSibling(String other) {
        return this.newPath(this.path.resolveSibling(this.getUnixPath(other)));
    }

    @Override
    public CloudStoragePath relativize(Path object) {
        return this.newPath(this.path.relativize(CloudStorageUtil.checkPath((Path)object).path));
    }

    @Override
    @Nullable
    public CloudStoragePath getParent() {
        return this.newPath(this.path.getParent());
    }

    @Override
    @Nullable
    public CloudStoragePath getFileName() {
        return this.newPath(this.path.getFileName());
    }

    @Override
    public CloudStoragePath subpath(int beginIndex, int endIndex) {
        return this.newPath(this.path.subpath(beginIndex, endIndex));
    }

    @Override
    public int getNameCount() {
        return this.path.getNameCount();
    }

    @Override
    public CloudStoragePath getName(int index) {
        return this.newPath(this.path.getName(index));
    }

    @Override
    public boolean startsWith(Path other) {
        if (!(Preconditions.checkNotNull((Object)other) instanceof CloudStoragePath)) {
            return false;
        }
        CloudStoragePath that = (CloudStoragePath)other;
        if (!this.bucket().equals(that.bucket())) {
            return false;
        }
        return this.path.startsWith(that.path);
    }

    @Override
    public boolean startsWith(String other) {
        return this.path.startsWith(this.getUnixPath(other));
    }

    @Override
    public boolean endsWith(Path other) {
        if (!(Preconditions.checkNotNull((Object)other) instanceof CloudStoragePath)) {
            return false;
        }
        CloudStoragePath that = (CloudStoragePath)other;
        if (!this.bucket().equals(that.bucket())) {
            return false;
        }
        return this.path.endsWith(that.path);
    }

    @Override
    public boolean endsWith(String other) {
        return this.path.endsWith(this.getUnixPath(other));
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) {
        throw new UnsupportedOperationException();
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("GCS objects aren't available locally");
    }

    @Override
    public Iterator<Path> iterator() {
        if (this.path.isEmpty()) {
            return Collections.singleton(this).iterator();
        }
        if (this.path.isRoot()) {
            return Collections.emptyIterator();
        }
        return new PathIterator();
    }

    @Override
    public int compareTo(Path other) {
        CloudStoragePath that = (CloudStoragePath)other;
        int res = this.bucket().compareTo(that.bucket());
        if (res != 0) {
            return res;
        }
        return this.toRealPathInternal(false).compareTo(that.toRealPathInternal(false));
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof CloudStoragePath && Objects.equals(this.bucket(), ((CloudStoragePath)other).bucket()) && Objects.equals(this.toRealPathInternal(false), ((CloudStoragePath)other).toRealPathInternal(false));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.bucket(), this.toRealPathInternal(false));
    }

    @Override
    public String toString() {
        return this.path.toString();
    }

    @Override
    public URI toUri() {
        try {
            return new URI("gs", this.bucket(), this.path.toAbsolutePath().toString(), null);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Nullable
    private CloudStoragePath newPath(@Nullable UnixPath newPath) {
        if (newPath == this.path) {
            return this;
        }
        if (newPath != null) {
            return new CloudStoragePath(this.fileSystem, newPath);
        }
        return null;
    }

    private UnixPath getUnixPath(String newPath) {
        return UnixPath.getPath(this.fileSystem.config().permitEmptyPathComponents(), newPath);
    }

    private UnixPath getWorkingDirectory() {
        return this.getUnixPath(this.fileSystem.config().workingDirectory());
    }

    private final class PathIterator
    extends UnmodifiableIterator<Path> {
        private final Iterator<String> delegate;

        private PathIterator() {
            this.delegate = CloudStoragePath.this.path.split();
        }

        public Path next() {
            return CloudStoragePath.this.newPath(CloudStoragePath.this.getUnixPath(this.delegate.next()));
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }
    }
}

