/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Date;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.RawArgs;
import org.eclipse.jetty.start.UsageException;
import org.eclipse.jetty.start.config.CommandLineConfigSource;

public class StartLog {
    private static final PrintStream stdout = System.out;
    private static final PrintStream stderr = System.err;
    private static volatile PrintStream out = System.out;
    private static volatile PrintStream err = System.err;
    private static volatile PrintStream logStream = System.err;
    private static final StartLog INSTANCE = new StartLog();
    private boolean trace = false;
    private boolean debug = false;

    public static void debug(String format, Object ... args) {
        if (StartLog.INSTANCE.debug) {
            out.printf(format + "%n", args);
        }
    }

    public static void trace(String format, Object ... args) {
        if (StartLog.INSTANCE.trace) {
            out.printf("TRACE " + format + "%n", args);
        }
    }

    public static void debug(Throwable t) {
        if (StartLog.INSTANCE.debug) {
            t.printStackTrace(out);
        }
    }

    public static StartLog getInstance() {
        return INSTANCE;
    }

    public static void log(String type, String msg) {
        logStream.printf("%-6s: %s%n", type, msg);
    }

    public static void log(String type, String format, Object ... args) {
        StartLog.log(type, String.format(format, args));
    }

    public static void info(String format, Object ... args) {
        StartLog.log("INFO", format, args);
    }

    public static void warn(String format, Object ... args) {
        StartLog.log("WARN", format, args);
    }

    public static void error(String format, Object ... args) {
        StartLog.log("ERROR", format, args);
    }

    public static void warn(Throwable t) {
        t.printStackTrace(logStream);
    }

    public static boolean isDebugEnabled() {
        return StartLog.INSTANCE.debug;
    }

    public void initialize(BaseHome baseHome, CommandLineConfigSource cmdLineSource) throws IOException {
        String dbgProp = cmdLineSource.getProperty("debug");
        if (dbgProp != null) {
            this.debug = Boolean.parseBoolean(dbgProp);
        }
        String logFileName = cmdLineSource.getProperty("start-log-file");
        for (RawArgs.Entry arg : cmdLineSource.getArgs()) {
            if ("--debug".equals(arg.getLine())) {
                this.debug = true;
                continue;
            }
            if (!arg.startsWith("--start-log-file")) continue;
            logFileName = Props.getValue(arg.getLine());
        }
        if (logFileName != null) {
            Path logfile = baseHome.getPath(logFileName);
            logfile = logfile.toAbsolutePath();
            this.initLogFile(logfile);
        }
    }

    public void initLogFile(Path logfile) throws IOException {
        if (logfile != null) {
            try {
                PrintStream logger;
                Path logDir = logfile.getParent();
                FS.ensureDirectoryWritable(logDir);
                Path startLog = logfile;
                if (!FS.exists(startLog) && !FS.createNewFile(startLog)) {
                    throw new UsageException(-1, (Throwable)new IOException("Unable to create: " + startLog.toAbsolutePath()));
                }
                if (!FS.canWrite(startLog)) {
                    throw new UsageException(-1, (Throwable)new IOException("Unable to write to: " + startLog.toAbsolutePath()));
                }
                err.println("StartLog to " + logfile);
                OutputStream fileout = Files.newOutputStream(startLog, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                out = logger = new PrintStream(fileout, true);
                err = logger;
                StartLog.setStream(logger);
                System.setErr(logger);
                System.setOut(logger);
                err.println("StartLog Establishing " + logfile + " on " + new Date());
            }
            catch (IOException e) {
                throw new UsageException(-1, (Throwable)e);
            }
        }
    }

    public static void enableDebug() {
        StartLog.getInstance().debug = true;
    }

    public static void endStartLog() {
        if (stderr != err && StartLog.getInstance().debug) {
            err.println("StartLog ended");
            stderr.println("StartLog ended");
        }
        StartLog.setStream(stderr);
        System.setErr(stderr);
        System.setOut(stdout);
    }

    public static PrintStream getStream() {
        return logStream;
    }

    public static PrintStream setStream(PrintStream stream) {
        PrintStream ret = logStream;
        logStream = stream;
        return ret;
    }
}

