/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.function.UnaryOperator;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.OrdinalFunction;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.function.reduction.data.SortedListCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;

class StringOrdinalFunction
extends StringValue.AbstractStringValue
implements ReductionFunction {
    private SortedListCollector.SortedStringListCollector collector;
    private int ordinal;
    public static final String name = "ordinal";
    private final String exprStr;

    public StringOrdinalFunction(StringValueStream param, int ordinal) {
        this.collector = new SortedListCollector.SortedStringListCollector(param);
        this.ordinal = ordinal;
        this.exprStr = OrdinalFunction.createOrdinalExpressionString(param, ordinal);
    }

    @Override
    public String getString() {
        int size = this.collector.size();
        if (this.ordinal > 0) {
            return this.ordinal <= size ? (String)this.collector.get(this.ordinal - 1) : null;
        }
        return this.ordinal * -1 <= size ? (String)this.collector.get(size + this.ordinal) : null;
    }

    @Override
    public boolean exists() {
        return (this.ordinal > 0 ? this.ordinal : this.ordinal * -1) <= this.collector.size();
    }

    @Override
    public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
        this.collector = (SortedListCollector.SortedStringListCollector)sync.apply(this.collector);
        this.collector.calcOrdinal(this.ordinal);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.REDUCTION;
    }
}

