/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.LittleEndian;

public final class VBAInfoAtom
extends RecordAtom {
    private static final long _type = RecordTypes.VBAInfoAtom.typeID;
    private byte[] _header = new byte[8];
    private long persistIdRef;
    private boolean hasMacros;
    private long version;

    private VBAInfoAtom() {
        LittleEndian.putUInt((byte[])this._header, (int)0, (long)_type);
        this.persistIdRef = 0L;
        this.hasMacros = true;
        this.version = 2L;
    }

    public VBAInfoAtom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this.persistIdRef = LittleEndian.getUInt((byte[])source, (int)(start + 8));
        this.hasMacros = LittleEndian.getUInt((byte[])source, (int)(start + 12)) == 1L;
        this.version = LittleEndian.getUInt((byte[])source, (int)(start + 16));
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        LittleEndian.putUInt((long)this.persistIdRef, (OutputStream)out);
        LittleEndian.putUInt((long)(this.hasMacros ? 1L : 0L), (OutputStream)out);
        LittleEndian.putUInt((long)this.version, (OutputStream)out);
    }

    public long getPersistIdRef() {
        return this.persistIdRef;
    }

    public void setPersistIdRef(long persistIdRef) {
        this.persistIdRef = persistIdRef;
    }

    public boolean isHasMacros() {
        return this.hasMacros;
    }

    public void setHasMacros(boolean hasMacros) {
        this.hasMacros = hasMacros;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties((String)"persistIdRef", this::getPersistIdRef, (String)"hasMacros", this::isHasMacros, (String)"version", this::getVersion);
    }
}

