/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPhysicalDeviceMemoryProperties;

public class VkPhysicalDeviceMemoryProperties2
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORYPROPERTIES;

    public VkPhysicalDeviceMemoryProperties2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPhysicalDeviceMemoryProperties2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceMemoryProperties2.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceMemoryProperties2.npNext(this.address());
    }

    public VkPhysicalDeviceMemoryProperties memoryProperties() {
        return VkPhysicalDeviceMemoryProperties2.nmemoryProperties(this.address());
    }

    public VkPhysicalDeviceMemoryProperties2 sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceMemoryProperties2.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceMemoryProperties2 pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceMemoryProperties2.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceMemoryProperties2 set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceMemoryProperties2 set(VkPhysicalDeviceMemoryProperties2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceMemoryProperties2 malloc() {
        return (VkPhysicalDeviceMemoryProperties2)VkPhysicalDeviceMemoryProperties2.wrap(VkPhysicalDeviceMemoryProperties2.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPhysicalDeviceMemoryProperties2 calloc() {
        return (VkPhysicalDeviceMemoryProperties2)VkPhysicalDeviceMemoryProperties2.wrap(VkPhysicalDeviceMemoryProperties2.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPhysicalDeviceMemoryProperties2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPhysicalDeviceMemoryProperties2)VkPhysicalDeviceMemoryProperties2.wrap(VkPhysicalDeviceMemoryProperties2.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPhysicalDeviceMemoryProperties2 create(long address) {
        return (VkPhysicalDeviceMemoryProperties2)VkPhysicalDeviceMemoryProperties2.wrap(VkPhysicalDeviceMemoryProperties2.class, (long)address);
    }

    @Nullable
    public static VkPhysicalDeviceMemoryProperties2 createSafe(long address) {
        return address == 0L ? null : (VkPhysicalDeviceMemoryProperties2)VkPhysicalDeviceMemoryProperties2.wrap(VkPhysicalDeviceMemoryProperties2.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPhysicalDeviceMemoryProperties2.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPhysicalDeviceMemoryProperties2.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPhysicalDeviceMemoryProperties2.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceMemoryProperties2.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPhysicalDeviceMemoryProperties2.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPhysicalDeviceMemoryProperties2.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPhysicalDeviceMemoryProperties2.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkPhysicalDeviceMemoryProperties2 mallocStack() {
        return VkPhysicalDeviceMemoryProperties2.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceMemoryProperties2 callocStack() {
        return VkPhysicalDeviceMemoryProperties2.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceMemoryProperties2 mallocStack(MemoryStack stack) {
        return (VkPhysicalDeviceMemoryProperties2)VkPhysicalDeviceMemoryProperties2.wrap(VkPhysicalDeviceMemoryProperties2.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceMemoryProperties2 callocStack(MemoryStack stack) {
        return (VkPhysicalDeviceMemoryProperties2)VkPhysicalDeviceMemoryProperties2.wrap(VkPhysicalDeviceMemoryProperties2.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceMemoryProperties2.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceMemoryProperties2.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceMemoryProperties2.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceMemoryProperties2.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static VkPhysicalDeviceMemoryProperties nmemoryProperties(long struct) {
        return VkPhysicalDeviceMemoryProperties.create(struct + (long)MEMORYPROPERTIES);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceMemoryProperties2.__struct((Struct.Member[])new Struct.Member[]{VkPhysicalDeviceMemoryProperties2.__member((int)4), VkPhysicalDeviceMemoryProperties2.__member((int)POINTER_SIZE), VkPhysicalDeviceMemoryProperties2.__member((int)VkPhysicalDeviceMemoryProperties.SIZEOF, (int)VkPhysicalDeviceMemoryProperties.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORYPROPERTIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceMemoryProperties2, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceMemoryProperties2 ELEMENT_FACTORY = VkPhysicalDeviceMemoryProperties2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPhysicalDeviceMemoryProperties2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceMemoryProperties2.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceMemoryProperties2.npNext(this.address());
        }

        public VkPhysicalDeviceMemoryProperties memoryProperties() {
            return VkPhysicalDeviceMemoryProperties2.nmemoryProperties(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceMemoryProperties2.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceMemoryProperties2.npNext(this.address(), value);
            return this;
        }
    }
}

