/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDrawIndexedIndirectCommand
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INDEXCOUNT;
    public static final int INSTANCECOUNT;
    public static final int FIRSTINDEX;
    public static final int VERTEXOFFSET;
    public static final int FIRSTINSTANCE;

    public VkDrawIndexedIndirectCommand(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDrawIndexedIndirectCommand.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int indexCount() {
        return VkDrawIndexedIndirectCommand.nindexCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int instanceCount() {
        return VkDrawIndexedIndirectCommand.ninstanceCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int firstIndex() {
        return VkDrawIndexedIndirectCommand.nfirstIndex(this.address());
    }

    @NativeType(value="int32_t")
    public int vertexOffset() {
        return VkDrawIndexedIndirectCommand.nvertexOffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int firstInstance() {
        return VkDrawIndexedIndirectCommand.nfirstInstance(this.address());
    }

    public VkDrawIndexedIndirectCommand indexCount(@NativeType(value="uint32_t") int value) {
        VkDrawIndexedIndirectCommand.nindexCount(this.address(), value);
        return this;
    }

    public VkDrawIndexedIndirectCommand instanceCount(@NativeType(value="uint32_t") int value) {
        VkDrawIndexedIndirectCommand.ninstanceCount(this.address(), value);
        return this;
    }

    public VkDrawIndexedIndirectCommand firstIndex(@NativeType(value="uint32_t") int value) {
        VkDrawIndexedIndirectCommand.nfirstIndex(this.address(), value);
        return this;
    }

    public VkDrawIndexedIndirectCommand vertexOffset(@NativeType(value="int32_t") int value) {
        VkDrawIndexedIndirectCommand.nvertexOffset(this.address(), value);
        return this;
    }

    public VkDrawIndexedIndirectCommand firstInstance(@NativeType(value="uint32_t") int value) {
        VkDrawIndexedIndirectCommand.nfirstInstance(this.address(), value);
        return this;
    }

    public VkDrawIndexedIndirectCommand set(int indexCount, int instanceCount, int firstIndex, int vertexOffset, int firstInstance) {
        this.indexCount(indexCount);
        this.instanceCount(instanceCount);
        this.firstIndex(firstIndex);
        this.vertexOffset(vertexOffset);
        this.firstInstance(firstInstance);
        return this;
    }

    public VkDrawIndexedIndirectCommand set(VkDrawIndexedIndirectCommand src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDrawIndexedIndirectCommand malloc() {
        return (VkDrawIndexedIndirectCommand)VkDrawIndexedIndirectCommand.wrap(VkDrawIndexedIndirectCommand.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDrawIndexedIndirectCommand calloc() {
        return (VkDrawIndexedIndirectCommand)VkDrawIndexedIndirectCommand.wrap(VkDrawIndexedIndirectCommand.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDrawIndexedIndirectCommand create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDrawIndexedIndirectCommand)VkDrawIndexedIndirectCommand.wrap(VkDrawIndexedIndirectCommand.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDrawIndexedIndirectCommand create(long address) {
        return (VkDrawIndexedIndirectCommand)VkDrawIndexedIndirectCommand.wrap(VkDrawIndexedIndirectCommand.class, (long)address);
    }

    @Nullable
    public static VkDrawIndexedIndirectCommand createSafe(long address) {
        return address == 0L ? null : (VkDrawIndexedIndirectCommand)VkDrawIndexedIndirectCommand.wrap(VkDrawIndexedIndirectCommand.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDrawIndexedIndirectCommand.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDrawIndexedIndirectCommand.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDrawIndexedIndirectCommand.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDrawIndexedIndirectCommand.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDrawIndexedIndirectCommand.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDrawIndexedIndirectCommand.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDrawIndexedIndirectCommand.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkDrawIndexedIndirectCommand mallocStack() {
        return VkDrawIndexedIndirectCommand.mallocStack(MemoryStack.stackGet());
    }

    public static VkDrawIndexedIndirectCommand callocStack() {
        return VkDrawIndexedIndirectCommand.callocStack(MemoryStack.stackGet());
    }

    public static VkDrawIndexedIndirectCommand mallocStack(MemoryStack stack) {
        return (VkDrawIndexedIndirectCommand)VkDrawIndexedIndirectCommand.wrap(VkDrawIndexedIndirectCommand.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDrawIndexedIndirectCommand callocStack(MemoryStack stack) {
        return (VkDrawIndexedIndirectCommand)VkDrawIndexedIndirectCommand.wrap(VkDrawIndexedIndirectCommand.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDrawIndexedIndirectCommand.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDrawIndexedIndirectCommand.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDrawIndexedIndirectCommand.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDrawIndexedIndirectCommand.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nindexCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)INDEXCOUNT);
    }

    public static int ninstanceCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)INSTANCECOUNT);
    }

    public static int nfirstIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)FIRSTINDEX);
    }

    public static int nvertexOffset(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEXOFFSET);
    }

    public static int nfirstInstance(long struct) {
        return UNSAFE.getInt(null, struct + (long)FIRSTINSTANCE);
    }

    public static void nindexCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INDEXCOUNT, value);
    }

    public static void ninstanceCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INSTANCECOUNT, value);
    }

    public static void nfirstIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FIRSTINDEX, value);
    }

    public static void nvertexOffset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERTEXOFFSET, value);
    }

    public static void nfirstInstance(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FIRSTINSTANCE, value);
    }

    static {
        Struct.Layout layout = VkDrawIndexedIndirectCommand.__struct((Struct.Member[])new Struct.Member[]{VkDrawIndexedIndirectCommand.__member((int)4), VkDrawIndexedIndirectCommand.__member((int)4), VkDrawIndexedIndirectCommand.__member((int)4), VkDrawIndexedIndirectCommand.__member((int)4), VkDrawIndexedIndirectCommand.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INDEXCOUNT = layout.offsetof(0);
        INSTANCECOUNT = layout.offsetof(1);
        FIRSTINDEX = layout.offsetof(2);
        VERTEXOFFSET = layout.offsetof(3);
        FIRSTINSTANCE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDrawIndexedIndirectCommand, Buffer>
    implements NativeResource {
        private static final VkDrawIndexedIndirectCommand ELEMENT_FACTORY = VkDrawIndexedIndirectCommand.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDrawIndexedIndirectCommand getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int indexCount() {
            return VkDrawIndexedIndirectCommand.nindexCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int instanceCount() {
            return VkDrawIndexedIndirectCommand.ninstanceCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int firstIndex() {
            return VkDrawIndexedIndirectCommand.nfirstIndex(this.address());
        }

        @NativeType(value="int32_t")
        public int vertexOffset() {
            return VkDrawIndexedIndirectCommand.nvertexOffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int firstInstance() {
            return VkDrawIndexedIndirectCommand.nfirstInstance(this.address());
        }

        public Buffer indexCount(@NativeType(value="uint32_t") int value) {
            VkDrawIndexedIndirectCommand.nindexCount(this.address(), value);
            return this;
        }

        public Buffer instanceCount(@NativeType(value="uint32_t") int value) {
            VkDrawIndexedIndirectCommand.ninstanceCount(this.address(), value);
            return this;
        }

        public Buffer firstIndex(@NativeType(value="uint32_t") int value) {
            VkDrawIndexedIndirectCommand.nfirstIndex(this.address(), value);
            return this;
        }

        public Buffer vertexOffset(@NativeType(value="int32_t") int value) {
            VkDrawIndexedIndirectCommand.nvertexOffset(this.address(), value);
            return this;
        }

        public Buffer firstInstance(@NativeType(value="uint32_t") int value) {
            VkDrawIndexedIndirectCommand.nfirstInstance(this.address(), value);
            return this;
        }
    }
}

